/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.SqlUtil;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.dao.TmCustomerDao;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBgDetailEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerDelExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerSearchExtendService;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.service.TmRCustPosBgDetailService;
import com.biz.eisp.mdm.customer.transformer.TmCustomerVoToTmCustomerEntity;
import com.biz.eisp.mdm.customer.util.CustomerLogMsgUtil;
import com.biz.eisp.mdm.customer.vo.QueryTmCustomerVo;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmCustomerService")
@Transactional
public class TmCustomerServiceImpl
extends BaseServiceImpl
implements TmCustomerService {
    @Autowired
    private TmCustomerDao tmCustomerDao;
    @Autowired
    private TmRCustPosBgDetailService tmRCustPosBgDetailService;
    @Autowired(required=false)
    private TmCustomerSearchExtendService tmCustomerSearchExtendService;
    @Autowired(required=false)
    private TmCustomerExtendService tmCustomerExtendService;
    @Autowired(required=false)
    private TmCustomerDelExtendService tmCustomerDelExtendService;

    public List<TmCustomerVo> findTmCustomerList(TmCustomerVo customerVo, Page page) {
        String ids;
        List vos;
        String sql = "";
        if (this.tmCustomerSearchExtendService != null) {
            sql = this.tmCustomerSearchExtendService.buildSearchSql(customerVo);
            if (StringUtil.isEmpty((String)sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, (Object)customerVo);
                sql = this.tmCustomerSearchExtendService.extendSearchSql(customerVo, sql);
            }
            return this.tmCustomerDao.findTmCustomerList(customerVo, page, sql);
        }
        sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.Table_CUSTOMER, (Object)customerVo);
        List results = this.tmCustomerDao.findTmCustomerList(customerVo, page, sql = this.appendCustomerCondition(sql, customerVo));
        if (CollectionUtil.listNotEmptyNotSizeZero((List)results) && CollectionUtil.listNotEmptyNotSizeZero((List)(vos = this.tmCustomerDao.findTmCustomerListChildren(SqlUtil.setSqlIn((String[])(ids = results.stream().collect(Collectors.mapping(TmCustomerVo::getId, Collectors.joining(",")))).split(","), (String)"t1.customer_id", (boolean)true, (String)""), this.appendCustomerConditionSplit())))) {
            Map<String, List<TmCustomerVo>> map = vos.stream().collect(Collectors.groupingBy(TmCustomerVo::getId));
            results.stream().map(u -> this.toCustomer((List)map.get(u.getId()), u)).collect(Collectors.toList());
        }
        return results;
    }

    private TmCustomerVo toCustomer(List<TmCustomerVo> customers, TmCustomerVo result) {
        if (CollectionUtil.listNotEmptyNotSizeZero(customers)) {
            result.setPositionId(customers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getPositionId())).collect(Collectors.mapping(TmCustomerVo::getPositionId, Collectors.joining(","))));
            result.setBusinessGroup(customers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getBusinessGroup())).collect(Collectors.mapping(TmCustomerVo::getBusinessGroup, Collectors.joining(","))));
            result.setDockUserName(customers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDockUserName())).collect(Collectors.mapping(TmCustomerVo::getDockUserName, Collectors.joining(","))));
            result.setDockPosition(customers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getDockPosition())).collect(Collectors.mapping(TmCustomerVo::getDockPosition, Collectors.joining(","))));
        }
        return result;
    }

    public String appendCustomerCondition(String sql, TmCustomerVo customerVo) {
        String sqlJoin = "";
        String sqlOn = "";
        String sqlWhere = "";
        if (StringUtil.isNotEmpty((String)customerVo.getId())) {
            sqlWhere = " and (t.id='" + customerVo.getId() + "'";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getId()) || StringUtil.isNotEmpty((String)customerVo.getDockUserName()) || StringUtil.isNotEmpty((String)customerVo.getDockPosition()) || StringUtil.isNotEmpty((String)customerVo.getBusinessGroup())) {
            sqlWhere = " and exists(select 1 from TM_CUSTOMER t2 left join  TM_R_CUST_POS_BG t3 on t3.customer_id=t2.id  left join tm_r_user_position up on up.position_id=t3.position_id left join tm_user tu on tu.id=up.user_id left join tm_position t4 on t4.id = t3.position_id where t2.id=t.id ";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getDockUserName())) {
            sqlWhere = sqlWhere + " and  (tu.username like '%" + customerVo.getDockUserName() + "%' or tu.fullname like '%" + customerVo.getDockUserName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getDockPosition())) {
            sqlWhere = sqlWhere + "and (t4.position_name like '%" + customerVo.getDockPosition() + "%' or t4.position_code like '%" + customerVo.getDockPosition() + "%')";
        }
        if (StringUtil.isNotEmpty((String)customerVo.getBusinessGroup())) {
            sqlWhere = sqlWhere + " and t3.businessGroup like '%" + customerVo.getBusinessGroup() + "%'";
        }
        sqlWhere = sqlWhere + ")";
        if (StringUtil.isEmpty((String)customerVo.getId()) && StringUtil.isEmpty((String)customerVo.getDockUserName()) && StringUtil.isEmpty((String)customerVo.getDockPosition()) && StringUtil.isEmpty((String)customerVo.getBusinessGroup())) {
            sqlWhere = "";
        }
        String orderSql = " order by t.customerCode asc";
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, sqlJoin, sqlOn, sqlWhere, orderSql);
    }

    public String appendCustomerConditionSplit() {
        String sql = "select t1.customer_id id, t1.position_id,t2.position_name dockPosition,t2.position_code position_code,t1.business_group businessGroup,tu.username username,tu.fullname dockUserName  from TM_R_CUST_POS_BG t1 left join tm_position t2 on t2.id = t1.position_id  left join tm_r_user_position up on up.position_id=t1.position_id  left join tm_user tu on tu.id=up.user_id where ${customerId} group by t1.customer_id";
        return sql;
    }

    public void saveTmCustomer(TmCustomerVo customerVo, Page page) {
        ArrayList addBusinessGroupVoList = new ArrayList();
        ArrayList deleteBusinessGroupVoList = new ArrayList();
        TmCustomerEntity tmCustomerEntity = null;
        String customerId = "";
        if (StringUtil.isNotEmpty((Object)this.tmCustomerExtendService)) {
            try {
                this.tmCustomerExtendService.validate(customerVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(customerVo, page);
        }
        if (StringUtil.isEmpty(tmCustomerEntity)) {
            tmCustomerEntity = new TmCustomerVoToTmCustomerEntity((TmCustomerService)this, this.tmRCustPosBgDetailService, addBusinessGroupVoList, deleteBusinessGroupVoList).apply(customerVo);
            customerId = tmCustomerEntity.getId();
        }
        if (StringUtil.isNotEmpty((Object)this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.saveBefore(tmCustomerEntity, customerVo, page);
        }
        this.saveOrUpdate(tmCustomerEntity);
        if (tmCustomerEntity.getCooperative().equals("end")) {
            this.disableCustomerUser(tmCustomerEntity.getId());
        }
        this.executeSql("DELETE FROM TM_R_CUST_POS_BG WHERE CUSTOMER_ID IS NULL", new Object[0]);
        this.getSession().flush();
        this.saveBusinessGroupInfo(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
        if (StringUtil.isNotEmpty((Object)this.tmCustomerExtendService)) {
            tmCustomerEntity = this.tmCustomerExtendService.savePost(tmCustomerEntity, customerVo, page);
        }
    }

    private void saveBusinessGroupInfo(TmCustomerEntity tmCustomerEntity, List<TmBusinessGroupVo> addBusinessGroupVoList, List<TmBusinessGroupVo> deleteBusinessGroupVoList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteBusinessGroupVoList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (TmBusinessGroupVo vo : deleteBusinessGroupVoList) {
                map.put(vo.getBusinessGroup(), vo.getBusinessGroup());
            }
            String deleteSql = "delete from tm_r_cust_pos_bg_detail where business_group = ?";
            Set keyset = map.keySet();
            for (String key : keyset) {
                this.executeSql(deleteSql, new Object[]{key});
            }
        }
        this.getSession().flush();
        if (CollectionUtil.listNotEmptyNotSizeZero(addBusinessGroupVoList)) {
            for (TmBusinessGroupVo vo : addBusinessGroupVoList) {
                if (vo.getTypeCode() == "orgCode" || vo.getTypeCode() == "positionCode") continue;
                TmRCustPosBgDetailEntity entity = new TmRCustPosBgDetailEntity();
                entity.setBusinessGroup(vo.getBusinessGroup());
                entity.setDetailCode(vo.getDetailCode());
                entity.setDetailName(vo.getDetailName());
                entity.setTypeCode(vo.getTypeCode());
                entity.setTypeName(vo.getTypeName());
                this.save((Object)entity);
            }
        }
        this.getSession().flush();
        this.saveBusinessGroupLog(tmCustomerEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
    }

    private void saveBusinessGroupLog(TmCustomerEntity tmCustomerEntity, List<TmBusinessGroupVo> newBusinessGroupVoList, List<TmBusinessGroupVo> oldBusinessGroupVoList) {
        Map oldMap = this.buildMapByBusinessGroup(oldBusinessGroupVoList);
        Map newMap = this.buildMapByBusinessGroup(newBusinessGroupVoList);
        Set oldKeySet = oldMap.keySet();
        String updateMsg = "";
        String deleteMsg = "";
        String addMsg = "";
        for (String oldKey : oldKeySet) {
            if (newMap.containsKey(oldKey)) {
                updateMsg = updateMsg + CustomerLogMsgUtil.buildUpdateMsg((List)((List)newMap.get(oldKey)), (List)((List)oldMap.get(oldKey))) + "<hr>";
                newMap.remove(oldKey);
                continue;
            }
            deleteMsg = deleteMsg + CustomerLogMsgUtil.buildDeleteMsg((List)((List)oldMap.get(oldKey))) + "<hr>";
        }
        if (StringUtils.isNotBlank((CharSequence)(addMsg = addMsg + this.buildAddMsg(tmCustomerEntity, newMap)))) {
            this.addLog(OperationType.INSERT, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), addMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)deleteMsg)) {
            this.addLog(OperationType.DELETE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), deleteMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)updateMsg)) {
            this.addLog(OperationType.UPDATE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmCustomerEntity.getId(), updateMsg);
        }
    }

    private Map<String, List<TmBusinessGroupVo>> buildMapByBusinessGroup(List<TmBusinessGroupVo> voList) {
        HashMap<String, List<TmBusinessGroupVo>> map = new HashMap<String, List<TmBusinessGroupVo>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
            for (TmBusinessGroupVo oldBusinessGroupVo : voList) {
                if (map.containsKey(oldBusinessGroupVo.getBusinessGroup())) {
                    ((List)map.get(oldBusinessGroupVo.getBusinessGroup())).add(oldBusinessGroupVo);
                    continue;
                }
                ArrayList<TmBusinessGroupVo> list = new ArrayList<TmBusinessGroupVo>();
                list.add(oldBusinessGroupVo);
                map.put(oldBusinessGroupVo.getBusinessGroup(), list);
            }
        }
        return map;
    }

    private String buildAddMsg(TmCustomerEntity tmCustomerEntity, Map<String, List<TmBusinessGroupVo>> newMap) {
        Set<String> keySet = newMap.keySet();
        String msg = "";
        for (String key : keySet) {
            msg = msg + CustomerLogMsgUtil.buildAddMsg(newMap.get(key));
            msg = msg + "<hr>";
        }
        return msg;
    }

    private void disableCustomerUser(String customerId) {
        String sql = "UPDATE tm_user SET enable_status = '003' WHERE ID in (SELECT user_id FROM tm_r_user_customer WHERE customer_id = ?)";
        this.executeSql(sql, new Object[]{customerId});
    }

    public void deleteTmCustomer(String ids, Page page) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] customerIds;
            for (String customerId : customerIds = ids.split(",")) {
                TmCustomerEntity tmCustomerEntity = (TmCustomerEntity)this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
                if (this.tmCustomerDelExtendService != null) {
                    this.tmCustomerDelExtendService.validate(tmCustomerEntity, page);
                    this.tmCustomerDelExtendService.delBefore(tmCustomerEntity, page);
                }
                if (tmCustomerEntity == null || !StringUtil.isNotEmpty((String)tmCustomerEntity.getId())) continue;
                this.delete((Object)tmCustomerEntity);
                if (this.tmCustomerDelExtendService == null) continue;
                this.tmCustomerDelExtendService.delPost(tmCustomerEntity, page);
            }
        }
    }

    public TmCustomerVo getTmCustomerVoById(TmCustomerVo customerVo, Page page) {
        List list = this.findTmCustomerList(customerVo, null);
        return list.size() > 0 ? (TmCustomerVo)list.get(0) : new TmCustomerVo();
    }

    public List<TmCustomerVo> findTmCustomerByPosList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTmCustomerByPosList(customerVo, page);
    }

    public List<TmCustomerVo> findTmCustTomerByAllPossible(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByAllPossible(queryTmCustomerVo, page);
    }

    public List<TmCustomerVo> findTpmCustomerList(TmCustomerVo customerVo, Page page) {
        return this.tmCustomerDao.findTpmCustomerList(customerVo, page);
    }

    public List<TmLogVo> findCustomerLogList(TmLogVo tmLogVo, Page page) {
        return this.tmCustomerDao.findCustomerLogList(tmLogVo, page);
    }

    public List<TmCustomerVo> findTmCustTomerByOrgAndCustType(QueryTmCustomerVo queryTmCustomerVo, Page page) {
        return this.tmCustomerDao.findTmCustTomerByOrgAndCustType(queryTmCustomerVo, page);
    }

    public List<ComboBox> findCustomerComboBoxByPosId(String positionId) {
        String sql = "SELECT DISTINCT TC.ID AS ID,TC.CUSTOMER_NAME AS TEXT,TC.CUSTOMER_CODE AS VALUE FROM TM_CUSTOMER TC JOIN TM_R_CUST_POS_BG TRCP ON TC.ID = TRCP.CUSTOMER_ID WHERE TRCP.POSITION_ID=?";
        return this.findBySql(ComboBox.class, sql, new Object[]{positionId});
    }

    public List<TmCustomerVo> findCustomer(String settlementCode, String customerType, String contractCode, String orgId) {
        return this.tmCustomerDao.findCustomer(settlementCode, customerType, contractCode, orgId);
    }

    public TmCustomerVo findSapCustomer(String code) {
        List customerVoList = this.tmCustomerDao.findSapCustomer(code);
        return customerVoList != null && customerVoList.size() > 0 ? (TmCustomerVo)customerVoList.get(0) : new TmCustomerVo();
    }

    public List<TmCustomerVo> findTmCustomerListByOrgMain(TmCustomerVo customerVo, Page page) {
        List voList = this.tmCustomerDao.findTmCustomerListByOrgMain(customerVo, page);
        return voList;
    }

    public AjaxJson changeCustomerForOrg(TmOrgVo tmOrgVo) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((String)tmOrgVo.getCustomerIds())) {
            String[] customerIds;
            TmCustomerEntity tmCustomerEntity = null;
            TmOrgEntity tmOrgEntity = null;
            for (String posId : customerIds = tmOrgVo.getCustomerIds().split(",")) {
                tmCustomerEntity = (TmCustomerEntity)this.get(TmCustomerEntity.class, (Serializable)((Object)posId));
                if (!StringUtil.isNotEmpty((Object)tmCustomerEntity)) continue;
                tmOrgEntity = (TmOrgEntity)this.get(TmOrgEntity.class, (Serializable)((Object)tmOrgVo.getOrgId()));
                tmCustomerEntity.setTmOrg(tmOrgEntity);
                this.saveOrUpdate((Object)tmCustomerEntity);
            }
            j.setMsg("\u8c03\u6574\u5173\u7cfb\u6210\u529f");
        } else {
            j.setSuccess(false);
            j.setMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        return j;
    }

    public AjaxJson startOrStop(TmCustomerVo tmCustomerVo) {
        AjaxJson j = new AjaxJson();
        TmCustomerEntity tmCustomerEntity = (TmCustomerEntity)this.get(TmCustomerEntity.class, (Serializable)((Object)tmCustomerVo.getId()));
        if (StringUtil.isNotEmpty((Object)tmCustomerEntity)) {
            if (tmCustomerEntity.getEnableStatus().toString().equals(tmCustomerVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmCustomerVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmCustomerEntity.setEnableStatus(tmCustomerVo.getEnableStatus());
                this.updateEntity((Object)tmCustomerEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }
}

