/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.dict.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.base.utils.AppcenterUtil;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.dict.util.HttpsClientRequestFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class DictUtil {
    private static RedisService redisService;
    private static RestTemplate restTemplate;
    private static final String getDictByParamListUrl;
    private static final String getDictByParamObj;
    private static final String getDictListByParentId;

    private static void initRest() {
        if (restTemplate == null) {
            String url = ResourceUtil.getSysConfigProperty((String)"dictFlag");
            restTemplate = url.contains("https") ? new RestTemplate((ClientHttpRequestFactory)new HttpsClientRequestFactory()) : new RestTemplate();
        }
    }

    private static List<KnlDictDataEntity> getDictByParamList(String dictTypeCode) {
        try {
            HttpHeaders requestHeaders = new HttpHeaders();
            String loginUserToken = AppcenterUtil.getUserKey();
            loginUserToken = StringUtil.isNotEmpty((String)loginUserToken) ? loginUserToken : "";
            ArrayList<String> cookieList = new ArrayList<String>();
            cookieList.add("loginUserToken=" + loginUserToken);
            requestHeaders.put("Cookie", cookieList);
            requestHeaders.add("loginUserToken", loginUserToken);
            LinkedMultiValueMap postParameters = new LinkedMultiValueMap();
            HttpEntity request = new HttpEntity((Object)postParameters, (MultiValueMap)requestHeaders);
            postParameters.add((Object)"dictTypeCode", (Object)dictTypeCode);
            ResponseEntity responseEntity = restTemplate.postForEntity(getDictByParamListUrl, (Object)request, String.class, new Object[0]);
            String json = (String)responseEntity.getBody();
            if (StringUtil.isNotEmpty((String)json)) {
                String success;
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String string = success = jsonObject.get((Object)"success") == null ? "false" : jsonObject.get((Object)"success").toString();
                if (StringUtil.equals((String)"true", (String)success)) {
                    JSONArray jsonArray = jsonObject.getJSONArray("objList");
                    List list = JSONArray.parseArray((String)jsonArray.toJSONString(), KnlDictDataEntity.class);
                    return list;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<KnlDictDataEntity>();
        }
        return new ArrayList<KnlDictDataEntity>();
    }

    private static List<KnlDictDataEntity> getDictListByParentId(String parentId) {
        try {
            HttpHeaders requestHeaders = new HttpHeaders();
            String loginUserToken = AppcenterUtil.getUserKey();
            loginUserToken = StringUtil.isNotEmpty((String)loginUserToken) ? loginUserToken : "";
            ArrayList<String> cookieList = new ArrayList<String>();
            cookieList.add("loginUserToken=" + loginUserToken);
            requestHeaders.put("Cookie", cookieList);
            requestHeaders.add("loginUserToken", loginUserToken);
            LinkedMultiValueMap postParameters = new LinkedMultiValueMap();
            HttpEntity request = new HttpEntity((Object)postParameters, (MultiValueMap)requestHeaders);
            postParameters.add((Object)"parentId", (Object)parentId);
            ResponseEntity responseEntity = restTemplate.postForEntity(getDictListByParentId, (Object)request, String.class, new Object[0]);
            String json = (String)responseEntity.getBody();
            if (StringUtil.isNotEmpty((String)json)) {
                String success;
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String string = success = jsonObject.get((Object)"success") == null ? "false" : jsonObject.get((Object)"success").toString();
                if (StringUtil.equals((String)"true", (String)success)) {
                    JSONArray jsonArray = jsonObject.getJSONArray("objList");
                    List list = JSONArray.parseArray((String)jsonArray.toJSONString(), KnlDictDataEntity.class);
                    return list;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<KnlDictDataEntity>();
        }
        return new ArrayList<KnlDictDataEntity>();
    }

    private static KnlDictDataEntity getDictByParamObj(String dictTypeCode, String dictCode) {
        try {
            HttpHeaders requestHeaders = new HttpHeaders();
            String loginUserToken = AppcenterUtil.getUserKey();
            loginUserToken = StringUtil.isNotEmpty((String)loginUserToken) ? loginUserToken : "";
            ArrayList<String> cookieList = new ArrayList<String>();
            cookieList.add("loginUserToken=" + loginUserToken);
            requestHeaders.put("Cookie", cookieList);
            requestHeaders.add("loginUserToken", loginUserToken);
            LinkedMultiValueMap postParameters = new LinkedMultiValueMap();
            HttpEntity request = new HttpEntity((Object)postParameters, (MultiValueMap)requestHeaders);
            postParameters.add((Object)"dictTypeCode", (Object)dictTypeCode);
            postParameters.add((Object)"dictCode", (Object)dictCode);
            ResponseEntity responseEntity = restTemplate.postForEntity(getDictByParamObj, (Object)request, String.class, new Object[0]);
            String json = (String)responseEntity.getBody();
            if (StringUtil.isNotEmpty((String)json)) {
                String success;
                JSONObject jsonObject = JSONObject.parseObject((String)json);
                String string = success = jsonObject.get((Object)"success") == null ? "false" : jsonObject.get((Object)"success").toString();
                if (StringUtil.equals((String)"true", (String)success)) {
                    JSONObject object = jsonObject.getJSONObject("obj");
                    return (KnlDictDataEntity)JSONObject.toJavaObject((JSON)object, KnlDictDataEntity.class);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    private static void getRedisService() {
        if (redisService == null) {
            redisService = RedisUtils.getRedisService();
        }
        DictUtil.initRest();
    }

    public static Map<Object, Object> getDictMap(String typeCode) {
        DictUtil.getRedisService();
        Map map = null;
        try {
            List list;
            map = redisService.hmget("DICT_DATA_" + typeCode);
            if ((map == null || map.isEmpty()) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = DictUtil.getDictByParamList((String)typeCode)))) {
                HashMap<Object, Object> map_ = new HashMap<Object, Object>();
                list.forEach(item -> map_.put(item.getDictCode(), item));
                return map_;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static KnlDictDataEntity getDicData(String typeCode, String dataCode) {
        KnlDictDataEntity data = null;
        DictUtil.getRedisService();
        Object object = redisService.hget("DICT_DATA_" + typeCode, dataCode);
        if (object == null) {
            return DictUtil.getDictByParamObj((String)typeCode, (String)dataCode);
        }
        data = (KnlDictDataEntity)object;
        return data;
    }

    public static String getDicDataValByCode(String typeCode, String dataCode) {
        Object data = null;
        DictUtil.getRedisService();
        Map map = DictUtil.getDictMap((String)typeCode);
        for (Map.Entry tempMap : map.entrySet()) {
            KnlDictDataEntity knlDictDataEntity;
            String code;
            if (tempMap.getValue() == null || !(code = (knlDictDataEntity = (KnlDictDataEntity)tempMap.getValue()).getDictCode()).equals(dataCode)) continue;
            return knlDictDataEntity.getDictValue();
        }
        return null;
    }

    public static String getDicDataCodeByVal(String typeCode, String dataVal) {
        Object data = null;
        DictUtil.getRedisService();
        AtomicReference<String> dataCode = new AtomicReference<String>("");
        Map map = DictUtil.getDictMap((String)typeCode);
        if (map != null && map.size() > 0) {
            map.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                if (entity.getDictValue().equals(dataVal)) {
                    dataCode.set(entity.getDictCode());
                }
            });
        }
        return dataCode.get();
    }

    public static String getDicDataValByVal(String typeCode, String dataVal) {
        return dataVal;
    }

    public static List<KnlDictDataEntity> getDictList(String dictType) {
        ArrayList<KnlDictDataEntity> list = new ArrayList<KnlDictDataEntity>();
        Map map = DictUtil.getDictMap((String)dictType);
        if (map != null && map.size() > 0) {
            map.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                list.add(entity);
            });
        }
        return list;
    }

    public static List<KnlDictDataEntity> getDictByParentId(String parentId) {
        List list = DictUtil.getDictListByParentId((String)parentId);
        return list;
    }

    static {
        getDictByParamListUrl = ResourceUtil.getSysConfigProperty((String)"dictFlag") + "getDictByParamList";
        getDictByParamObj = ResourceUtil.getSysConfigProperty((String)"dictFlag") + "getDictByParamObj";
        getDictListByParentId = ResourceUtil.getSysConfigProperty((String)"dictFlag") + "getDictListByParentId";
    }
}

