<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<script type="text/javascript">
//流程对象
var process = workflow.process;
process.listenerClass='${listenerClass}';
process.tableName='${tableName}';
process.redirectUrl='${redirectUrl}';
//属性表格定义
rows = [
         { "name": "ID", "group": "流程", "value": process.id,"field": "id", "editor": "text" },
         { "name": "名称", "group": "流程", "value": process.name, "field": "name", "editor": "text" },
         { "name": "命名空间", "group": "流程", "value": process.category, "field": "category", "editor": "text" },
         { "name": "描述", "group": "流程", "value": process.documentation, "field": "documentation", "editor": "text" }, 
         { "name": "监听器类", "group": "流程", "value": process.listenerClass, "field": "listenerClass", "editor": "text" },
         { "name": "业务表", "group": "流程", "value": process.tableName, "field": "tableName", "editor": "text" },
         { "name": "重定向url", "group": "流程", "value": process.redirectUrl, "field": "redirectUrl", "editor": "text" } 
       ];
 //保存属性
function saveProcessProperties(){
	process.id=rows[0].value;
	process.name=rows[1].value;
	process.category=rows[2].value;
	process.documentation=rows[3].value;
	process.listenerClass=rows[4].value;
	process.tableName=rows[5].value;
	process.redirectUrl=rows[6].value;
}
 //构建属性表格数据
function populateProcessProperites(){
	rows[0].value=process.id;
	rows[1].value=process.name;
	rows[2].value=process.category;
	rows[3].value=process.documentation;
	rows[4].value=process.listenerClass;
	rows[5].value=process.tableName;
	rows[6].value=process.redirectUrl;
	propertygrid();
} 
 //加载属性表格数据
function propertygrid(){
	$('#general-properties').propertygrid('loadData', rows);
	}
$(function(){
//创建属性表格
$('#general-properties').propertygrid({
  width: 'auto',
  height: 'auto',
  showGroup: false,
  scrollbarSize: 0,
  border:0,
  columns: [[
          { field: 'name', title: '属性名', width: 30, resizable: false },
          { field: 'value', title: '属性值', width: 100, resizable: false }
  ]],
  onAfterEdit:function(){  
  	saveProcessProperties();//自动保存
   }
});
propertygrid();

// 修正当未处于流程属性界面上执行保存时丢失类型的问题.
process.typeid_ = $("#typeid").val();
$("#typeid").on('change', function() {
	process.typeid_ = $('#typeid').val();
	console.log("process typeid changed: " + process.typeid_);
});
});
</script>

<%--流程属性页面 --%>
<script type="text/javascript">
	//获取监听器id
	function getOldListenerIds(){
		var listeners=process.listeners;
		  var listenersIds=new Array();
		  for(var i=0;i<listeners.getSize();i++){
			var listener = listeners.get(i);
			listenersIds.push(listener.getId());
		  }
		return listenersIds.join(",");
	}
	//添加监听器
	function addListener(id,event,serviceType,value){
		var ls=process.getListener(id);
		if(!ls){
			var listener = new draw2d.Process.Listener();
			listener.id=id;
			listener.event = event;
			listener.serviceType=serviceType;
			listener.serviceClass = value;
			listener.serviceExpression = value;
			process.addListener(listener);
		}
	}
	//删除监听器
	function removeListener(id){
		process.deleteListener(id);
	}
</script>
<div id="process-properties-layout" class="easyui-layout" fit="true">
 <div id="process-properties-panel" region="center" border="true">
  <div id="task-properties-accordion" class="easyui-accordion" fit="true" border="false">
   <div id="general" title="流程属性面板" class="properties-menu">
    <table id="general-properties">
    </table>
   </div>
   
   <div id="listeners" title="任务监听器" style="overflow: hidden;padding:1px;">
    <t:datagrid title="添加删除操作,需点击保存" name="listenerList" fitColumns="true" actionUrl="taListenerController.do?findSelectedListenerList" 
    	extendParams="queryParams:{ids:getOldListenerIds()}" pagination="false" idField="id">
	 <t:dgCol title="id" hidden="true" field="id"></t:dgCol>
	 <t:dgCol title="名称" field="listenerName" width="30"></t:dgCol>
	 <t:dgCol title="事件" field="listenerEvent" width="30"></t:dgCol>
	 <t:dgCol title="类型" field="listenerType" width="30"></t:dgCol>
	 <t:dgCol title="执行内容" field="listenerValue" width="50"></t:dgCol>
	 <t:dgCol title="操作" field="opt" width="30"></t:dgCol>
	 <t:dgFunOpt funname="delRow(id)" title="删除"></t:dgFunOpt>
	</t:datagrid>
    
    <div id="listenerListtb" style="padding:3px; height: 25px;">
     <div style="float: left;">
      <div class="form">
       <input name="listenerId" type="hidden" id="listenerId">
       <input name="listenerName" type="hidden" id="listenerName">
       <input name="listenerEvent" type="hidden" id="listenerEvent">
       <input name="listenerType" type="hidden" id="listenerType">
       <input name="listenerValue" type="hidden" id="listenerValue">
       <t:choose hiddenName="listenerId" hiddenid="id" fun="saveProcessListener" url="taListenerController.do?goListenerListPage&typeId=1" 
       	textname="listenerName,listenerEvent,listenerType,listenerValue" name="listenerList" icon="icon-add" title="监听列表"></t:choose>
      </div>
     </div>
    </div>
    
   </div>
  </div>
 </div>
</div>
<script type="text/javascript">
//保存监听
	function saveProcessListener(obj) {
		var listenerIds = obj.listenerId;
		var listenerEvents = obj.listenerEvent;
		var listenerTypes = obj.listenerType;
		var listenerValues = obj.listenerValue;
		var listenerNames = obj.listenerName;
		
		for(var i=0;i<listenerIds.length;i++){ 
			var ls=process.getListener(listenerIds[i]);
			addListener(listenerIds[i], listenerEvents[i], listenerTypes[i], listenerValues[i]);
			if(!ls){
				$('#listenerList').datagrid('appendRow',{
					id:listenerIds[i],
					listenerName:listenerNames[i],
					listenerEvent:listenerEvents[i],
					listenerType:listenerTypes[i],
					listenerValue:listenerValues[i]
				});
			}
		}
	}

 function setProcessListener(index)
 {
	  var row = $('#eventlistenerList').datagrid('getRows')[index];
	  $.ajax({
	   url : "processController.do?setProcessListener",
	   type : 'POST',
	   data : {
	    id :row.id
	   },
	   dataType : 'json',
	   success : function(data) {
	    if (data.success) {
	     var listener = new draw2d.Process.Listener();
	     listener.event=row.TPListerer_listenereven;
	     listener.id=row.id;
	     listener.serviceType = row.TPListerer_listenertype;
	     if(row.TPListerer_listenertype=="javaClass")
	     {
	      listener.serviceClass= row.TPListerer_listenervalue;
	     }
	     else
	     {
	       listener.serviceExpression=row.TPListerer_listenervalue;
	     }
	     
	      process.listeners.add(listener);
	    }
	    else
	    {
	      process.deleteListener(row.id);
	    }
	    reloadeventlistenerList();
	   }
	  });
 }
//删除流程监听
function delRow(rowid, idx) {
	$('#listenerList').datagrid('deleteRow', idx);
	removeListener(rowid);
}
</script>
