<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools"></t:base>
<div class="easyui-layout" fit="true">
<div region="center" style="padding: 1px;">
<t:datagrid name="processInstanceList" title="流程实例列表" actionUrl="taProcessInstanceController.do?findProcessInstanceList" fitColumns="true"
	idField="id" fit="true" queryMode="group">
	<t:dgCol title="编号" field="id" query="true"></t:dgCol>
	<t:dgCol title="流程Key" field="processDefinitionKey" query="true"   width="80"></t:dgCol>
	<t:dgCol title="流程名称" field="processDefinitionName" query="true"   width="80"></t:dgCol>
	<t:dgCol title="流程标题" field="processTitle" query="true" width="120"></t:dgCol>
	<t:dgCol title="流程实例ID" field="processInstanceId" hidden="true"  width="120"></t:dgCol>
	<t:dgCol title="发起人" field="startFullName" width="90" query="true"></t:dgCol>
	<t:dgCol title="当前任务名称" field="activityName" width="120"></t:dgCol>
	<t:dgCol title="当前任务处理人" field="activityUser" width="90"></t:dgCol>
	<t:dgCol title="开始时间" field="startTime" formatter="yyyy-MM-dd hh:mm:ss" width="120" query="true"></t:dgCol>
	<t:dgCol title="结束时间" field="endTime" formatter="yyyy-MM-dd hh:mm:ss" width="120" query="true"></t:dgCol>
	<t:dgCol title="耗时" field="spendTimes"  width="100"></t:dgCol>
	<t:dgCol title="任务Id" field="taskId" hidden="true"></t:dgCol>
	<t:dgCol title="状态" sortable="false" field="isSuspended"  width="80" query="true" replace="已结束_finished,启动_false,暂停_true" style="background:red;_true"></t:dgCol>
	<t:dgToolBar operationCode="stop" icon="icon-stop" id="stopId" url="taProcessInstanceController.do?suspend" exp="isSuspended#ne#'true'&&isSuspended#ne#'finished'" funname="systemConfirm" params="processInstanceId" title="暂停"></t:dgToolBar>
	<t:dgToolBar operationCode="start" icon="icon-start" id="startId" url="taProcessInstanceController.do?restart" exp="isSuspended#ne#'false'&&isSuspended#ne#'finished'" funname="systemConfirm" params="processInstanceId" title="启动"></t:dgToolBar>
	<t:dgToolBar operationCode="close" icon="icon-remove" id="closeId" url="taProcessInstanceController.do?closeProcessInstance" exp="isSuspended#ne#'finished'" funname="systemConfirm" params="processInstanceId" title="关闭"></t:dgToolBar>
	<t:dgToolBar operationCode="checkBack" icon="icon-check_back" url="taTaskController.do?goReassignForm&view=false" exp="isSuspended#ne#'true'&&isSuspended#ne#'finished'" funname="add" params="taskId" title="委派"></t:dgToolBar>
	<t:dgToolBar operationCode="view" icon="icon-look" id="processView" url="taTaskController.do?goInstanceHandleTabForm&isView=true&isReadFlag=false" funname="view" params="processInstanceId" title="查看"></t:dgToolBar>
	<t:dgToolBar operationCode="copyView" icon="icon-look" id="copyView" url="taCarbonCopyController.do?goCopyPersonInfoMain" funname="view" params="processInstanceId" title="查看抄送" width="600" height="400"></t:dgToolBar>
</t:datagrid>
</div>
</div>
<script type="text/javascript">
    //日期格式查询条件 开始日期
    $("input[name='startTime']").attr("class","Wdate").click(function(){ WdatePicker({dateFmt:'yyyy-MM-dd'}); });
    //日期格式查询条件 结束日期
    $("input[name='endTime']").attr("class","Wdate").click(function(){ WdatePicker({dateFmt:'yyyy-MM-dd'}); });
</script>