<%@ page language="java" import="java.util.*" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>Excel导入</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        body {
            overflow: scroll !important;
        }

        .dtci_bottom {
            padding: 20px;
            box-sizing: border-box;
            position: relative;
        }

        #uploadifive-file_upload {
            width: 100%;
            border: 2px dashed #898989;
            box-sizing: border-box;
            height: 100px;
        }

        .file-picker {
            text-align: center;
        }

        .file-picker > span {
            font-size: 35px;
            color: #2290FE;
            display: inline-block;
        }

        .file-picker > p {
            color: #696969;
            cursor: pointer;
            margin: 0;
        }
        #filediv{
            height: 80px;
            box-sizing: border-box;
        }
        .biz-uploader-info {
            width: 100%;
            height: 170px;
            border: 1px solid #dddddd;
            overflow-y: auto;
            padding: 0 5px;
            box-sizing: border-box;
            border-radius: 5px;
            background: #ffffff;
        }
        .uploadifive-span input{
            height: 100%!important;
            width: 100%!important;
        }
        .uploadifive-queue-item{
            border-bottom: 0!important;
        }
        .uploadifive-queue-item .progress{
            height: 5px!important;
            border-radius: 100px;
        }
        .uploadifive-queue-item .progress-bar{
            background-color: #1890ff!important;
            height: 5px!important;
            border-radius: 100px;
        }
    </style>
</head>
<body style="overflow-y: hidden" scroll="no">
<input type="hidden" id="impName" value="${impName }"/>
<input type="hidden" id="key" value="<%=new Date().getTime() %>"/>
<input type="hidden" name="sId" id="sId" value="${sId}"/>
<input type="hidden" id="test" value="0"/>
<form action="" method="post" style="padding: 0;margin: 0;overflow: hidden;">
    <div class="dtci_bottom">
        <t:uploadH5 name="fiels" multi="false" dialog="false" onUploadSuccess="successCallback" buttonText="选择文件"
                    uploader="importController.do?save&type=xls" extend="application/vnd.ms-excel" id="file_upload"
                    formData="{impName:'${param.impName }',key:'${key }',test:0,sId:'${sId}'}"></t:uploadH5>
        <div id="filediv">

        </div>
        <div class="biz-uploader-info">
            <p>处理结果：</p>
            <div class="upload-info-show"></div>
        </div>
    </div>
</form>
</body>
</html>
<script type="text/javascript">
    var interval = null; //定时器

    function successCallback(d, file, response) {
        d = JSON.parse(d);
        if (d.success) {
            interval = setInterval("showImportInfo('" + d.message + "')", 2000); //启动定时器，每2秒执行showImportInfo方法一次
        } else {
            W.tip("导入失败");
        }
    }

    //显示导入详情
    function showImportInfo(key) {
        $.ajax({
            async: false,
            cache: false,
            type: 'POST',
            data: {"keyname": key},
            url: "importController.do?info",// 请求的action路径
            error: function () {// 请求失败处理函数

            },
            success: function (data) {
                var result = data;
                var msg = result.msg;
                if (msg != '') {
                    $(".upload-info-show").html(msg);
                } else {
                    window.clearInterval(interval)
                }
            }
        });
    }

    //下载模板
    function downTemplete() {
        var impName = $("#impName").val();
        window.location.href = "importController.do?save&template=1&impName=" + impName;
    }

    //上传
    function upload() {
        var sId = $("#sId").val();
        var key = $("#key").val();
        var impName = $("#impName").val();
        $('#file_upload').data('uploadifive').settings.formData = {
            "sId": sId,
            "key": key,
            "impName": impName,
            "test": 0
        };
        var count = $('#file_upload').data('uploadifive').uploads.count;
        if(count===0){
            $(".upload-info-show").html("请先选择...");
        }else{
            $("#file_upload").uploadifive("upload");
            $(".upload-info-show").html("正在处理...");
        }

        return false;
    }

    //测试上传
    function testUpload() {
        var sId = $("#sId").val();
        var key = $("#key").val();
        var impName = $("#impName").val();

        $('#file_upload').data('uploadifive').settings.formData = {
            "sId": sId,
            "key": key,
            "impName": impName,
            "test": 1
        };
        $("#file_upload").uploadifive("upload");
        return false;
    }
</script>