<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>

<div id="system_function_functionList" class="easyui-layout" fit="true">
<div region="center">
    <t:datagrid name="functionList" title="菜单管理" queryMode="group"
                actionUrl="functionController.do?functionGrid"  idField="id" treegrid="true" fit="true"  fitColumns="false" pagination="false">
        <t:dgCol title="主键" field="id" treefield="id" hidden="true"></t:dgCol>
        <t:dgCol title="菜单名称" field="functionName" width="150" treefield="text"></t:dgCol>
        <t:dgCol title="菜单地址" field="functionUrl"  width="250" treefield="src"></t:dgCol>
        <t:dgCol title="菜单图标" field="tmIcon_iconPath" treefield="icon" image="true"></t:dgCol>
        <t:dgCol title="菜单排序" field="functionOrder"  width="60"  treefield="order"></t:dgCol>
        <t:dgCol title="操作" field="opt" width="160"></t:dgCol>
        <t:dgDelOpt url="functionController.do?deleteFunction&functionId={id}" title="删除"></t:dgDelOpt>
        <t:dgFunOpt funname="operationDetail(id)" title="按钮设置"></t:dgFunOpt>
        <t:dgFunOpt funname="authDetail(id)" title="权限对象"></t:dgFunOpt>
        <t:dgToolBar title="添加菜单"  icon="icon-add" url="functionController.do?goFunctionForm" funname="add"  width="400" height="320"></t:dgToolBar>
        <t:dgToolBar title="修改菜单"  icon="icon-edit" url="functionController.do?goFunctionForm" funname="updateFun" width="400" height="320"></t:dgToolBar>
    </t:datagrid>
</div>
<%--操作按钮窗口显示控制--%>
<div data-options="region:'east',
	collapsed:true,
	split:true,
	border:false,
	onExpand : function(){
		li_east = 1;
	},
	onCollapse : function() {
	    li_east = 0;
	}"
	style="width: 500px; overflow: hidden;">
	<div class="easyui-panel" fit="true" border="false" id="operationDetailpanel"></div>
</div>
</div>

<script type="text/javascript">

	<%--按钮权限控制--%>
	$(function() {
		var li_east = 0;
	});
	
	//数据权限
	function  authDetail(functionId){
		if(li_east == 0){
		   $('#system_function_functionList').layout('expand','east'); 
		}
		$('#operationDetailpanel').panel("refresh", "funAuthController.do?funAuth&functionId=" +functionId);
	}
	
	function operationDetail(functionId)
	{
		if(li_east == 0){
		   $('#system_function_functionList').layout('expand','east'); 
		}
		$('#operationDetailpanel').panel("refresh", "operationController.do?operationList&functionId=" +functionId);
	}
	
	<%-- 菜单录入代入父菜单--%>
	function updateFun(title,url, id,width,height) {
		var rowData = $('#'+id).datagrid('getSelected');
		if (rowData) {
			url += '&functionId='+rowData.id;
		}
		update(title,url,'functionList',width,height);
	}

</script>

