<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="system_org_orgList" class="easyui-layout" fit="true">
    <div region="center" style="margin: auto 0 ">
        <t:datagrid name="orgList" title="企业组织管理" actionUrl="tmOrgController.do?findOrgMainList" queryMode="group"
                    extendTableName="${extendTableName}" idField="id" treegrid="true" fit="true" fitColumns="false"
                    pagination="false">
            <t:dgToolBar title="新增" operationCode="add" icon="icon-add" url="tmOrgController.do?goOrgAddForm&optype=0"
                         funname="add" width="380" height="250"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" url="tmOrgController.do?goOrgAddForm&optype=1"
                         funname="update" width="380" height="250"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmOrgController.do?delOrg"
                         funname="deleteALLSelect1"></t:dgToolBar>
            <t:dgToolBar title="启用" operationCode="start" icon="icon-start" url="tmOrgController.do?startOrStopTmuser"
                         funname="startTmuser"></t:dgToolBar>
            <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="tmOrgController.do?startOrStopTmuser"
                         funname="stopTmuser"></t:dgToolBar>
            <t:dgToolBar title="关联职位" operationCode="positionRel" icon="icon-stores_group"
                         url="tmPositionController.do?findTmPositionList" funname="relPosition"></t:dgToolBar>
            <t:dgToolBar title="组织-职位关系维护" operationCode="positionRelMaintain" icon="icon-stores_group"
                         url="tmPositionController.do?findTmPositionList" funname="relPositionMaintain"></t:dgToolBar>
            <t:dgToolBar title="组织-客户关系查看" operationCode="positionRelCust" icon="icon-stores_group"
                         url="tmPositionController.do?findTmCustomerListByOrgMain" funname="relCust"></t:dgToolBar>
            <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn"
                         onclick="importDataByXml({impName:'tmOrg', gridName:'orgList'})"></t:dgToolBar>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="tmLogController.do?goTmLogDetailMain"
                         funname="detailLog" width="1200" height="460"></t:dgToolBar>

        </t:datagrid>
    </div>

    <%-- 关联窗口显示控制（职位，客户关系维护）--%>
    <div data-options="region:'east',
	collapsed:true,
	split:true,
	border:false,
	onBeforeExpand(){
	  var rows = $('#orgList').datagrid('getSelections');
		if (rows.length == 0) {
  		tip(`请选择要查看的数据！`);
        return false;
        }
        if(rows.length > 1){
        tip(`请选择一条数据！`);
        return false;
        }
        if(!isClicked){
            openPanel()
            return false
        }
	},
	onExpand : function(){
        li_east = 1;
	},
	onCollapse : function() {
	    li_east = 0;
	}"
         style="width: 500px; overflow: hidden;">
        <div class="easyui-panel" fit="true" border="false" id="relPanel"></div>
    </div>
</div>

<c:if test="${not empty includeJSP}">
    <jsp:include page="${includeJSP}" flush="true"></jsp:include>
</c:if>
<script type="text/javascript">
    var isClicked = false
  $(function (){
    var li_east = 0;
  });

  //删除组织
  function deleteALLSelect1(title, url){
    var ids = [];
    var rows = $('#orgList').datagrid('getSelections');
    if (rows.length > 0) {
      if (rows[0].parentId == "" || rows[0].parentId == null) {
        tip("顶级组织不能被删除");
        return;
      }
      $.dialog.confirm('是否删除选中数据？', function (r){
        if (r) {
          for (var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
          }
          $.ajax({
            url: url,
            type: 'post',
            data: {
              ids: ids.join(',')
            },
            cache: false,
            success: function (data){
              var d = data;
              var msg = d.msg;
              if (d.success) {
                tip(msg);
                for (var i = 0; i < rows.length; i++) {
                  $("#orgList").treegrid('remove', rows[i].id);
                }
                ids = '';
              } else {
                tip(msg);
                return;
              }
            }
          });
        }
      });
    } else {
      tip("请选择要删除的数据！");
    }
  }

  function openPanel(){
    $.dialog({content:'请选择要查看的内容',
      lock : true,
      button:[{
        name:'组织-职位关系维护',
        callback:function(){
          relPositionMaintain()
        }
      },{
        name:'组织-客户关系查看',
        callback:function(){
          relCust()
        }
      }]})
  }

  //关联职位
  function relPosition(){
    var rows = $('#orgList').datagrid('getSelections');
    if (rows.length == 0) {
      tip("请选择要查看的数据！");
      return false;
    }
    if (rows.length > 1) {
      tip("请选择一条数据！");
      return false;
    }
    var orgId = rows[0].id;
    if (li_east == 0) {
      $('#system_org_orgList').layout('expand', 'east');
    }
    $('#relPanel').panel("refresh", "tmPositionController.do?goTmPositionByOrgMain&isView=Y&orgId=" + orgId);
  }

  //组织-职位关系维护
  function relPositionMaintain(){
    var rows = $('#orgList').datagrid('getSelections');
    if (rows.length == 0) {
      tip("请选择要查看的数据！");
      return false;
    }
    if (rows.length > 1) {
      tip("请选择一条数据！");
      return false;
    }
    isClicked = true
    var orgId = rows[0].id;
    if (li_east == 0) {
      $('#system_org_orgList').layout('expand', 'east').layout({ title: '测试' });
    }
    $('#relPanel').panel("refresh", "tmPositionController.do?goTmPositionByOrgMain&isView=N&orgId=" + orgId);
  }


  //关联客户
  function relCust(){
    var rows = $('#orgList').datagrid('getSelections');
    if (rows.length == 0) {
      tip("请选择要查看的数据！");
      return false;
    }
    if (rows.length > 1) {
      tip("请选择一条数据！");
      return false;
    }
    isClicked = true
    var orgId = rows[0].id;
    if (li_east == 0) {
      $('#system_org_orgList').layout('expand', 'east');
    }
    $('#relPanel').panel("refresh", "tmCustomerController.do?goTmCustomerByOrgMain&orgId=" + orgId);
  }

  //新增或者编辑之后触发搜索操作
  function handleSuccess(data){
    $("#orgListtb_r").find("input[name='orgCode']").val(data.attributes.orgCode);
    $("#orgListtb_r").find("input[name='text']").val(data.attributes.orgName);
    orgListsearch();
  }

  //启用
  function startTmuser(){
    startOrStopTmuser('009');
  }

  //停用
  function stopTmuser(){
    startOrStopTmuser('003');
  }

  //启用停用
  function startOrStopTmuser(flag){
    var rows = $('#orgList').datagrid('getSelections');
    if (rows.length == 0 || rows == null) {
      tip("请选择一条要操作的数据");
      return;
    }
    if (rows.length > 1) {
      tip("请选择一条要操作的数据");
      return;
    }
    var tipmMsg = "";
    if (flag == "009") {
      tipmMsg = "确定要启用该数据吗?"
    } else {
      tipmMsg = "确定要停用该数据吗?"
    }
    $.messager.confirm('操作提示', tipmMsg, function (r){
      if (r) {
        $.ajax({
          type: "POST",
          url: "tmOrgController.do?startOrStopTmuser",
          data: {
            "id": rows[0].id,
            "enableStatus": flag
          },
          dataType: "json",
          success: function (data){
            tip(data.msg);
            orgListsearch();
          },
          error: function (){
            tip("服务器异常，请稍后再试");
          }
        });
      }
    });
  }

</script>

