<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>

<div id="tmPositionCheck" class="easyui-layout" fit="true">
	<div region="center">
	    <t:datagrid name="tmPositionCheckList" fitColumns="true" title="已选职位" singleSelect="false" pagination="false"
	        actionUrl="tmPositionController.do?findTmPositionList&userId=${userId}" idField="id" onLoadSuccess="loadElecteGrid">
	        <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
	        <t:dgCol title="职位编码" hidden="true" field="positionCode"></t:dgCol>
	        <t:dgCol title="职位名称" field="positionName"></t:dgCol>
	        <t:dgCol title="是否当前职位" field="isMain" replace="是_0,否_1"></t:dgCol>
	        <t:dgCol title="所属组织" field="orgName"></t:dgCol>
	        <t:dgCol title="上级职位" field="parentName"></t:dgCol>
	        <t:dgCol title="上级组织" field="parentOrgName"></t:dgCol>
	        <t:dgCol title="关系值" field="tmRPositionUserId" hidden="true"></t:dgCol>
	        <t:dgCol title="职位级别" hidden="true" dictionary="position_level" field="positionLevel"></t:dgCol>
	   	    <t:dgToolBar title="设为当前职位" icon="icon-user_unlock" url="" funname="setMainTmposition"></t:dgToolBar>
	   	    <t:dgToolBar title="移除" icon="icon-user_lock" url="" funname="removeTmposition"></t:dgToolBar>
	    </t:datagrid>
	</div>
</div>
<script type="text/javascript">
$(document).ready(function(){
	$("input[name='orgName']").combotree({    
	    url: 'tmOrgController.do?getParentOrg'
	});  
});
//设置为主职位
function setMainTmposition(){
	var checkListTarget =  $("#tmPositionCheckList").datagrid("getSelections");
	var allTarget = $("#tmPositionCheckList").datagrid("getRows");
	if(checkListTarget==null || checkListTarget== ""){
		tip("请选择一条数据");
		return false;
	}
	if(checkListTarget.length != 1){
		tip("请选择一条数据");
		return false;
	}
	
	if(checkListTarget.length == 1){
		var tgCheck = checkListTarget[0];
		if(tgCheck.isMain==0){
			tip("该职位已经为当前职位状态");
			return false;
		}
	}
	
	for (var i = 0; i < allTarget.length; i++) {
		var checkRows = checkListTarget[0];
		if(allTarget[i].id == checkRows.id){
			allTarget[i].isMain = 0;
		}else{
			allTarget[i].isMain = 1;
		}
		var checkRowIndex = $("#tmPositionCheckList").datagrid("getRowIndex",allTarget[i]);
		//刷新行
		$("#tmPositionCheckList").datagrid("updateRow",{
				index: checkRowIndex,
				row: allTarget[i]
		});
	}
}
//移除
function removeTmposition(){
	var checkListTarget =  $("#tmPositionCheckList").datagrid("getSelections");
	if(checkListTarget==null || checkListTarget==""){
		tip("请至少选择一条数据");
		return false;
	}
	var selectRows = [];
	//选中数据加入数组
	for (var i = 0; i < checkListTarget.length; i++) {
		var checkRows = checkListTarget[i];
		selectRows.push(checkRows);
	}
	//移除
	for (var i = 0; i < selectRows.length; i++) {
		var checkRowIndex = $("#tmPositionCheckList").datagrid("getRowIndex",selectRows[i]);
		//移除该数据
		$("#tmPositionCheckList").datagrid("deleteRow",checkRowIndex);
	}
	loadElecteGrid(selectRows);
}
//加载待选列表
function loadElecteGrid(selectTarget){
	var id = "-1";//默认一个值
	var excludeId = "'-1'";//默认一个值 做待选id除外用
	var checkedTarget = $("#tmPositionCheckList").datagrid("getRows");
	//not in
	if(checkedTarget != null){
		id = "";
		for(var i = 0;i<checkedTarget.length;i++){
			if(id != ""){
				id+=",";
			}
			id += "'"+checkedTarget[i].id+"'";
		}
	}
	//排除在外的
	if(selectTarget != "undefined" && selectTarget !=null && selectTarget.length > 0){
		excludeId = "";
		for(var i = 0;i<selectTarget.length;i++){
			if(excludeId != ""){
				excludeId+=",";
			}
			excludeId += "'"+selectTarget[i].id+"'";
		}
	}
	$('#tmPositionList').datagrid({
		queryParams: {
			notInId: id,
			excludeId: excludeId
		}
	});
}
</script>

