<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools"></t:base>
<div id="tmPositionMain" class="easyui-layout" fit="true">
	<div region="center">
	    <t:datagrid name="tmPositionList" fitColumns="true" title="待选职位" queryMode = "group" singleSelect="false"
	     idField="id" actionUrl="tmPositionController.do?findTmPositionForUserList">
	        <t:dgCol title="主键" hidden="true" field="id" ></t:dgCol>
	        <t:dgCol title="职位编码" hidden="true" field="positionCode"></t:dgCol>
	        <t:dgCol title="职位名称" field="positionName" query="true"></t:dgCol>
	        <t:dgCol title="所属组织" field="orgName"></t:dgCol>
	        <t:dgCol title="所属组织" field="orgId" hidden="true" query="true"  ></t:dgCol>
	        <t:dgCol title="上级职位" field="parentName"></t:dgCol>
	        <t:dgCol title="上级组织" field="parentOrgName"></t:dgCol>
	        <t:dgCol title="关系值" field="tmRPositionUserId" hidden="true"></t:dgCol>
	        <t:dgCol title="职位级别" hidden="true" dictionary="position_level" field="positionLevel"></t:dgCol>
	    	<t:dgToolBar title="添加" icon="icon-add" url="" funname="addPosition"></t:dgToolBar>
	    </t:datagrid>
	</div>
	<div data-options="region:'east',
		collapsed:true,
		split:true,
		border:false,
		onExpand : function(){
			li_east = 1;
		},
		onCollapse : function() {
		    li_east = 0;
		}"
		style="width: 500px; overflow: hidden;">
		<div class="easyui-panel" fit="true" border="false" id="checkedPosGrid"></div>
	</div>
</div>

<script type="text/javascript">
	$(function(){
		$("#tmPositionMain").layout("expand","east");
		$("input[name='orgId']").combotree({    
		    url: 'tmOrgController.do?getParentOrg'
		});  
		checkedGrid();
	});
	
	function checkedGrid(){
		$("#checkedPosGrid").panel("refresh","tmPositionController.do?goTmPositionCheckedMain&userId=${userId}");
	}
	//静态添加
	function addPosition(){
		var seletctTarget =  $("#tmPositionList").datagrid("getSelections");
		if(seletctTarget==null || seletctTarget==""){
			tip("请至少选择一条数据");
			return false;
		}
		//添加
		for (var i = 0; i < seletctTarget.length; i++) {
			var rows = seletctTarget[i];
			if (i == 0) {
				rows.isMain = 0;//静态添加第一个为主职位，其他为兼职
			}else{
				rows.isMain = 1;
			}
			$("#tmPositionCheckList").datagrid("insertRow",{row:rows});
		}
		//添加之后刷新本身
		loadElecteGrid();
	}
</script> 