<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>

<div id="terminal" class="easyui-layout" fit="true">
    <div region="center">
        <t:datagrid name="terminalList" title="终端管理" queryMode="group"  actionUrl="tmTerminalController.do?findTmTerminalList"
                    extendTableName="${extendTableName}"   idField="id" fit="true"  fitColumns="false" pagination="true">

            <!--自定义非显示的查询条件 begin-->
            <t:dgCol title="对接人职位" field="dockPosition"  columnOrder="16" query="true"  hidden="false"  ></t:dgCol>
            <t:dgCol title="对接人姓名" field="dockUserName" columnOrder="17" query="true"  hidden="false"  ></t:dgCol>
            <t:dgCol title="业务组" field="businessGroup"   columnOrder="18"  dictionary="business_group"  hidden="true"  ></t:dgCol>
            <t:dgCol title="上级客户" field="customerName" columnOrder="19" query="true"  hidden="false"  ></t:dgCol>
            <!--自定义非显示的查询条件 end-->

            <!-- 工具栏操作  begin -->
            <t:dgToolBar title="新增" operationCode="add" icon="icon-add" url="tmTerminalController.do?goTmTerminal&optype=0" funname="add"  width="1300" height="400"></t:dgToolBar>
            <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" url="tmTerminalController.do?goTmTerminal&optype=1" funname="update" width="1300" height="400"></t:dgToolBar>
            <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmTerminalController.do?deleteTmTerminal" funname="deleteALLSelect"></t:dgToolBar>
            <t:dgToolBar title="启用" operationCode="edit" icon="icon-start" url="tmTerminalController.do?startOrStop" funname="startOrStop('009')"></t:dgToolBar>
            <t:dgToolBar title="停用" operationCode="edit" icon="icon-stop" url="tmTerminalController.do?startOrStop" funname="startOrStop('003')"></t:dgToolBar>
            <t:dgToolBar title="查看" operationCode="priview" icon="icon-look" url="tmTerminalController.do?goTmTerminal&optype=2" funname="detail" width="1300" height="400"></t:dgToolBar>
            <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmTerminal', gridName:'terminalList'})" ></t:dgToolBar>
            <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" url="tmTerminalController.do?exportXls" funname="excelExport" ></t:dgToolBar>
            <t:dgToolBar title="终端-客户关系导入" operationCode="termCustImp" icon="icon-dataIn" onclick="importDataByXml({impName:'tmTermCustRel', gridName:'terminalList'})"></t:dgToolBar>
            <%--<t:dgToolBar title="提交审批" operationCode="ok" icon="icon-ok"  onclick="approvalSubmission()" ></t:dgToolBar>--%>
            <%--<t:dgToolBar title="审批进度" operationCode="checkSche" icon="icon-check_sche"  funname="detail" url="tmTerminalController.do?goAppravalDetail&optype=2"></t:dgToolBar>--%>
            <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="tmTerminalController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
            <!-- 工具栏操作  begin -->

        </t:datagrid>
    </div>
</div>
<c:if test="${not empty includeJsp}">
    <jsp:include page="${includeJsp}" flush="true"></jsp:include>
</c:if>
<script type="text/javascript">
    //提交按钮单击事件
    function approvalSubmission(){
        var rowsData = $('#terminalList').datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择要提交的数据');
            return;
        }

        var ids = [];
        var rows = $('#terminalList').datagrid('getSelections');
        $.dialog.confirm('是否提交所选中数据？',function(r){
            if(r){
                var flag=false;
                for(var i = 0; i < rows.length; i++){
                    if(rows[i].bpmStatus!=null&&(rows[i].bpmStatus!=-1&&rows[i].bpmStatus!=2)){
                        flag=true;
                        tip('包含已提交的数据');
                        return;
                    }
                    ids.push(rows[i].id);
                }
                if(flag){
                    return;
                }
                $.ajax({
                    url:"tmTerminalController.do?doApprovalTerminal",
                    type:'post',
                    data:{
                        ids:ids.join(',')
                    },
                    cache:false,
                    success:function(data){
                        var d = $.parseJSON(data);
                        var msg = d.msg;
                        if(d.success){
                            tip(msg);
                            ids='';
                        }else{
                            tip(msg);
                            return;
                        }
                    }
                });
            }
        });
    }

    //启用停用
    function startOrStop(flag){
        var target = $("#terminalList").datagrid('getSelected');
        if(target == null){
            tip("请选择一条要操作的数据");
            return;
        }
        var tipmMsg = "";
        if(flag == "009"){
            tipmMsg = "确定要启用该数据吗?"
        }else{
            tipmMsg = "确定要停用该数据吗?"
        }
        $.messager.confirm('操作提示',tipmMsg,function(r){
            if (r){
                $.ajax({
                    type : "POST",
                    url : "tmTerminalController.do?startOrStop",
                    data : {
                        "id" : target.id,
                        "enableStatus": flag
                    },
                    dataType : "json",
                    success : function(data) {
                        tip(data.msg);
                        $("#terminalList").datagrid('reload');
                    },
                    error:function(){
                        tip("服务器异常，请稍后再试");
                    }
                });
            }
        });
    }

</script>