<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="system_roleList" class="easyui-layout" fit="true">
	<div region="center">
	    <t:datagrid name="tmUserList" fitColumns="true"  extendTableName="${extendTableName}"
	   				 actionUrl="tmUserController.do?findTmUserList" idField="id" queryMode = "group">
			 
			<t:dgCol title="所属组织" field="orgName" width="150"  columnOrder="8"></t:dgCol>
  		    <t:dgCol title="职位名称" field="positionName" width="200"   columnOrder="8"></t:dgCol>
			<t:dgCol title="职位编码" field="positionCode" width="100"   columnOrder="8"></t:dgCol>
	        <%--<t:dgCol title="职位级别" field="positionLevel" width="100"  dictionary="position_level" columnOrder="8"></t:dgCol>--%>
	   		<%--<t:dgCol title="上级职位名称" field="parentPositionName" width="200"  query="true" columnOrder="8"></t:dgCol>--%>
	        <t:dgCol title="上级用户名" field="parentUserName" width="200"   columnOrder="8"></t:dgCol>
	      
	        <t:dgToolBar title="新增" operationCode="add" icon="icon-add" url="tmUserController.do?goTmUserForm&optype=0" funname="add" width="380" height="400"></t:dgToolBar>
	        <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" url="tmUserController.do?goTmUserForm&optype=1" funname="update" width="380" height="400"></t:dgToolBar>
	        <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmUserController.do?deleteTmUser" funname="deleteALLSelect"></t:dgToolBar>
	        <t:dgToolBar title="启用" operationCode="start" icon="icon-start" url="tmUserController.do?startOrStopTmuser" funname="startOrStopTmuser('009')"></t:dgToolBar>
	        <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="tmUserController.do?startOrStopTmuser" funname="startOrStopTmuser('003')"></t:dgToolBar>
	        <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmUser', gridName:'tmUserList'})"></t:dgToolBar>
	        <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" url="tmUserController.do?exportXls" funname="excelExport"></t:dgToolBar>
	        <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="tmCustUserController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
	    </t:datagrid>
	</div>
</div>
<c:if test="${not empty includeJsp}">
	<jsp:include page="${includeJsp}" flush="true"></jsp:include>
</c:if>
<script type="text/javascript">

	$(document).ready(function(){
		$("input[name='createDate']").datetimebox({
			showSeconds:true
		});  
	});

	//启用停用
	function startOrStopTmuser(flag){
		var tmUseTarget = $("#tmUserList").datagrid('getSelected');
		if(tmUseTarget == null){
			tip("请选择一条要操作的数据");
			return;
		}
		var tipmMsg = "";
		if(flag == "009"){
			tipmMsg = "确定要启用该数据吗?"
		}else{
			tipmMsg = "确定要停用该数据吗?"
		}
		$.messager.confirm('操作提示',tipmMsg,function(r){ 
		    if (r){
		    	$.ajax({
		        	type : "POST",
		        	url : "tmUserController.do?startOrStopTmuser",
		        	data : {
		            	"id" : tmUseTarget.id,
		            	"enableStatus": flag
		        	},
		        	dataType : "json",
		        	success : function(data) {
		        		tip(data.msg);
		        		$("#tmUserList").datagrid('reload');
		        	},
		        	error:function(){
		        		tip("服务器异常，请稍后再试");
		        	}
			   });
		    }
		});
	}
	
</script>

