/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.tag.bean;

import com.biz.eisp.base.common.tag.bean.Expression;
import com.biz.eisp.base.common.util.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DataGridUrl {
    private String id;
    private String url;
    private String title;
    private String icon;
    private String value;
    private String width;
    private String height;
    private String type;
    private String isbtn;
    private String message;
    private List<Expression> exps;
    private String funname;
    private boolean isRadio;
    private String onclick;
    private String functionname;
    private String param;
    private String params;

    public String getFunctionname() {
        return this.functionname;
    }

    public void setFunctionname(String functionname) {
        this.functionname = functionname;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getOnclick() {
        return this.onclick;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public void setRadio(boolean isRadio) {
        this.isRadio = isRadio;
    }

    public String getFunname() {
        return this.funname;
    }

    public void setFunname(String funname) {
        this.setFunctionname(this.getFunction(funname));
        this.setParam(this.getFunParams(funname));
        this.funname = funname;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Expression> getExps() {
        return this.exps;
    }

    public void setExps(List<Expression> exps) {
        this.exps = exps;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getIsbtn() {
        return this.isbtn;
    }

    public void setIsbtn(String isbtn) {
        this.isbtn = isbtn;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (StringUtil.isNotEmpty((String)url)) {
            url = this.formatUrl(url);
        }
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isRadio() {
        return this.isRadio;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    private String formatUrl() {
        String url = this.getUrl();
        MessageFormat formatter = new MessageFormat("");
        if (this.getValue() != null) {
            String[] testvalue = this.getValue().split(",");
            ArrayList<String> value = new ArrayList<String>();
            String[] stringArray = testvalue;
            int n = testvalue.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                value.add("\"+rec." + string + " +\"");
                ++n2;
            }
            url = MessageFormat.format(url, value.toArray());
        }
        if (url != null && this.getValue() == null) {
            url = this.formatUrl(url);
        }
        return url;
    }

    private String formatUrl(String url) {
        MessageFormat formatter = new MessageFormat("");
        String parurlvalue = "";
        if (url.indexOf("&") >= 0) {
            String beforeurl = url.substring(0, url.indexOf("&"));
            String parurl = url.substring(url.indexOf("&") + 1, url.length());
            String[] pras = parurl.split("&");
            ArrayList<String> value = new ArrayList<String>();
            int j = 0;
            int i = 0;
            while (i < pras.length) {
                if (pras[i].indexOf("{") >= 0 || pras[i].indexOf("#") >= 0) {
                    String field = pras[i].substring(pras[i].indexOf("{") + 1, pras[i].lastIndexOf("}"));
                    parurlvalue = String.valueOf(parurlvalue) + "&" + pras[i].replace("{" + field + "}", "{" + j + "}");
                    value.add("\"+rec." + field + " +\"");
                    ++j;
                } else {
                    parurlvalue = String.valueOf(parurlvalue) + "&" + pras[i];
                }
                ++i;
            }
            url = MessageFormat.format(String.valueOf(beforeurl) + parurlvalue, value.toArray());
        }
        return url;
    }

    private String getFunction(String functionname) {
        if (StringUtils.isNotBlank((String)functionname)) {
            int index = functionname.indexOf("(");
            if (index == -1) {
                return functionname;
            }
            return functionname.substring(0, functionname.indexOf("("));
        }
        return functionname;
    }

    private String getFunParams(String functionname) {
        String param = "";
        if (StringUtils.isNotBlank((String)functionname)) {
            String testparam;
            int index = functionname.indexOf("(");
            if (index != -1 && StringUtil.isNotEmpty((String)(testparam = functionname.substring(functionname.indexOf("(") + 1, functionname.length() - 1)))) {
                String[] params;
                String[] stringArray = params = testparam.split(",");
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    param = String.valueOf(param) + (string.indexOf("{") != -1 ? "'\"+" + string.substring(1, string.length() - 1) + "+\"'," : "'\"+rec." + string + "+\"',");
                    ++n2;
                }
            }
            param = String.valueOf(param) + "'\"+index+\"'";
        }
        return param;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }
}

