/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.exporter;

import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.exporter.ExcelExportOfTemplateUtil;
import com.biz.eisp.base.exporter.ExcelPublicUtil;
import com.biz.eisp.base.exporter.annotation.Excel;
import com.biz.eisp.base.exporter.annotation.ExcelCollection;
import com.biz.eisp.base.exporter.annotation.ExcelTarget;
import com.biz.eisp.base.exporter.entity.ComparatorExcelField;
import com.biz.eisp.base.exporter.entity.ExcelExportEntity;
import com.biz.eisp.base.exporter.entity.ExcelTitle;
import com.biz.eisp.base.exporter.entity.TemplateExportParams;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.bean.ExportExcelConfig;
import com.biz.eisp.mdm.config.service.DynamicExportFieldService;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public final class ExcelExportUtil {
    private static DynamicExportFieldService dynamicExportFieldService = (DynamicExportFieldService)ApplicationContextUtils.getContext().getBean("dynamicExportFieldService");

    public static HSSFWorkbook exportExcel(List<Map<String, Object>> list) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        for (Map<String, Object> map : list) {
            ExcelExportUtil.createSheetInUserModel2File(workbook, (ExcelTitle)map.get("title"), (Class)map.get("entity"), (Collection)map.get("data"));
        }
        return workbook;
    }

    public static HSSFWorkbook exportExcel(ExcelTitle entity, Class<?> pojoClass, Collection<?> dataSet) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        ExcelExportUtil.createSheetInUserModel2File(workbook, entity, pojoClass, dataSet);
        return workbook;
    }

    public static Workbook exportExcel(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        return ExcelExportOfTemplateUtil.exportExcel(params, pojoClass, dataSet, map);
    }

    public static Workbook exportExcel(TemplateExportParams params, Map<String, Object> map) {
        return ExcelExportOfTemplateUtil.exportExcel(params, null, null, map);
    }

    public static void createSheetInUserModel2File(HSSFWorkbook workbook, ExcelTitle entity, Class<?> pojoClass, Collection<?> dataSet) {
        try {
            HSSFSheet sheet = workbook.createSheet(entity.getSheetName());
            Map<String, HSSFCellStyle> styles = ExcelExportUtil.createStyles(workbook);
            Drawing patriarch = sheet.createDrawingPatriarch();
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            Field[] fileds = ExcelPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            String targetId = null;
            if (etarget != null) {
                targetId = etarget.id();
            }
            ExcelExportUtil.getAllExcelField(targetId, fileds, excelParams, pojoClass, null);
            ExcelExportUtil.sortAllParams(excelParams);
            int index = 0;
            int feildWidth = ExcelExportUtil.getFieldWidth(excelParams);
            if (entity.getTitle() != null) {
                int i = ExcelExportUtil.createHeaderRow(entity, (Sheet)sheet, workbook, feildWidth);
                sheet.createFreezePane(0, 2 + i, 0, 2 + i);
                index += i;
            } else {
                sheet.createFreezePane(0, 2, 0, 2);
            }
            ExcelExportUtil.createTitleRow(entity, (Sheet)sheet, workbook, index, excelParams);
            index += 2;
            ExcelExportUtil.setCellWith(excelParams, (Sheet)sheet);
            for (Object t : dataSet) {
                index += ExcelExportUtil.createCells(patriarch, index, t, excelParams, (Sheet)sheet, workbook, styles);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sortAllParams(List<ExcelExportEntity> excelParams) {
        Collections.sort(excelParams, new ComparatorExcelField());
        for (ExcelExportEntity entity : excelParams) {
            if (entity.getList() == null) continue;
            Collections.sort(entity.getList(), new ComparatorExcelField());
        }
    }

    private static int createCells(Drawing patriarch, int index, Object t, List<ExcelExportEntity> excelParams, Sheet sheet, HSSFWorkbook workbook, Map<String, HSSFCellStyle> styles) throws Exception {
        ExcelExportEntity entity;
        Row row = sheet.createRow(index);
        row.setHeight((short)350);
        int maxHeight = 1;
        int cellNum = 0;
        int k = 0;
        int paramSize = excelParams.size();
        while (k < paramSize) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                Collection list = (Collection)entity.getGetMethod().invoke(t, new Object[0]);
                int listC = 0;
                for (Object obj : list) {
                    ExcelExportUtil.createListCells(patriarch, index + listC, cellNum, obj, entity.getList(), sheet, workbook, styles);
                    ++listC;
                }
                cellNum += entity.getList().size();
                if (list != null && list.size() > maxHeight) {
                    maxHeight = list.size();
                }
            } else {
                Object value = ExcelExportUtil.getCellValue(entity, t);
                if (entity.getType() == 1) {
                    ExcelExportUtil.createStringCell(row, cellNum++, value == null ? "" : value.toString(), index % 2 == 0 ? ExcelExportUtil.getStyles(styles, false, entity.isWrap()) : ExcelExportUtil.getStyles(styles, true, entity.isWrap()), entity);
                } else {
                    ExcelExportUtil.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), t);
                }
            }
            ++k;
        }
        cellNum = 0;
        k = 0;
        paramSize = excelParams.size();
        while (k < paramSize) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                cellNum += entity.getList().size();
            } else if (entity.isNeedMerge()) {
                sheet.addMergedRegion(new CellRangeAddress(index, index + maxHeight - 1, cellNum, cellNum));
                ++cellNum;
            }
            ++k;
        }
        return maxHeight;
    }

    private static Object getCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Object value;
        Object object = value = entity.getGetMethods() != null ? ExcelExportUtil.getFieldBySomeMethod(entity.getGetMethods(), obj) : entity.getGetMethod().invoke(obj, new Object[0]);
        if (StringUtils.isNotEmpty((String)entity.getExportFormat())) {
            SimpleDateFormat format;
            Date temp = null;
            if (value instanceof String) {
                format = new SimpleDateFormat(entity.getDatabaseFormat());
                temp = format.parse(value.toString());
            } else if (value instanceof Date) {
                temp = (Date)value;
            }
            if (temp != null) {
                format = new SimpleDateFormat(entity.getExportFormat());
                value = format.format(temp);
            }
        }
        if (StringUtil.isNotEmpty(value) && entity.getDictMap() != null && entity.getDictMap().size() > 0) {
            return entity.getDictMap().get(String.valueOf(value));
        }
        return value == null ? "" : value.toString();
    }

    private static void createListCells(Drawing patriarch, int index, int cellNum, Object obj, List<ExcelExportEntity> excelParams, Sheet sheet, HSSFWorkbook workbook, Map<String, HSSFCellStyle> styles) throws Exception {
        Row row;
        if (sheet.getRow(index) == null) {
            row = sheet.createRow(index);
            row.setHeight((short)350);
        } else {
            row = sheet.getRow(index);
        }
        int k = 0;
        int paramSize = excelParams.size();
        while (k < paramSize) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = ExcelExportUtil.getCellValue(entity, obj);
            if (entity.getType() == 1) {
                ExcelExportUtil.createStringCell(row, cellNum++, value == null ? "" : value.toString(), row.getRowNum() % 2 == 0 ? ExcelExportUtil.getStyles(styles, false, entity.isWrap()) : ExcelExportUtil.getStyles(styles, true, entity.isWrap()), entity);
            } else {
                ExcelExportUtil.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), obj);
            }
            ++k;
        }
    }

    private static Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        for (Method m : list) {
            if (t == null) {
                t = "";
                break;
            }
            t = m.invoke(t, new Object[0]);
        }
        return t;
    }

    private static void setCellWith(List<ExcelExportEntity> excelParams, Sheet sheet) {
        int index = 0;
        int i = 0;
        while (i < excelParams.size()) {
            if (excelParams.get(i).getList() != null) {
                List<ExcelExportEntity> list = excelParams.get(i).getList();
                int j = 0;
                while (j < list.size()) {
                    sheet.setColumnWidth(index, 256 * list.get(j).getWidth());
                    ++index;
                    ++j;
                }
            } else {
                sheet.setColumnWidth(index, 256 * excelParams.get(i).getWidth());
                ++index;
            }
            ++i;
        }
    }

    private static void createTitleRow(ExcelTitle title, Sheet sheet, HSSFWorkbook workbook, int index, List<ExcelExportEntity> excelParams) {
        Row row = sheet.createRow(index);
        Row row1 = sheet.createRow(index + 1);
        row.setHeight((short)450);
        int cellIndex = 0;
        HSSFCellStyle titleStyle = ExcelExportUtil.getTitleStyle(workbook, title);
        int i = 0;
        int exportFieldTitleSize = excelParams.size();
        while (i < exportFieldTitleSize) {
            ExcelExportEntity entity = excelParams.get(i);
            ExcelExportUtil.createStringCell(row, cellIndex, entity.getName(), (CellStyle)titleStyle, entity);
            if (entity.getList() != null) {
                List<ExcelExportEntity> sTitel = entity.getList();
                sheet.addMergedRegion(new CellRangeAddress(index, index, cellIndex, cellIndex + sTitel.size() - 1));
                int j = 0;
                int size = sTitel.size();
                while (j < size) {
                    ExcelExportUtil.createStringCell(row1, cellIndex, sTitel.get(j).getName(), (CellStyle)titleStyle, entity);
                    ++cellIndex;
                    ++j;
                }
            } else {
                sheet.addMergedRegion(new CellRangeAddress(index, index + 1, cellIndex, cellIndex));
                ++cellIndex;
            }
            ++i;
        }
    }

    private static void createStringCell(Row row, int index, String text, CellStyle style, ExcelExportEntity entity) {
        Cell cell = row.createCell(index);
        HSSFRichTextString Rtext = new HSSFRichTextString(text);
        cell.setCellValue((RichTextString)Rtext);
        cell.setCellStyle(style);
    }

    private static void createImageCell(Drawing patriarch, ExcelExportEntity entity, Row row, int i, String string, Object obj) throws Exception {
        row.setHeight((short)(50 * entity.getHeight()));
        row.createCell(i);
        HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)i, row.getRowNum(), (short)(i + 1), row.getRowNum() + 1);
        if (StringUtils.isEmpty((String)string)) {
            return;
        }
        if (entity.getExportImageType() == 1) {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            try {
                String path = String.valueOf(ContextHolderUtils.getRequest().getSession().getServletContext().getRealPath("\\")) + string;
                path = path.replace("WEB-INF/classes/", "");
                path = path.replace("file:/", "");
                BufferedImage bufferImg = ImageIO.read(new File(path));
                ImageIO.write((RenderedImage)bufferImg, string.substring(string.indexOf(".") + 1, string.length()), byteArrayOut);
                byte[] value = byteArrayOut.toByteArray();
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, ExcelExportUtil.getImageType(value)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            byte[] value = (byte[])(entity.getGetMethods() != null ? ExcelExportUtil.getFieldBySomeMethod(entity.getGetMethods(), obj) : entity.getGetMethod().invoke(obj, new Object[0]));
            if (value != null) {
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, ExcelExportUtil.getImageType(value)));
            }
        }
    }

    private static int getImageType(byte[] value) {
        String type = ExcelPublicUtil.getFileExtendName(value);
        if (type.equalsIgnoreCase("JPG")) {
            return 5;
        }
        if (type.equalsIgnoreCase("PNG")) {
            return 6;
        }
        return 5;
    }

    private static int createHeaderRow(ExcelTitle entity, Sheet sheet, HSSFWorkbook workbook, int feildWidth) {
        Row row = sheet.createRow(0);
        row.setHeight((short)900);
        ExcelExportUtil.createStringCell(row, 0, entity.getTitle(), (CellStyle)ExcelExportUtil.getHeaderStyle(workbook, entity), null);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, feildWidth));
        if (entity.getSecondTitle() != null) {
            row = sheet.createRow(1);
            HSSFCellStyle style = workbook.createCellStyle();
            style.setAlignment((short)3);
            ExcelExportUtil.createStringCell(row, 0, entity.getSecondTitle(), (CellStyle)style, null);
            sheet.addMergedRegion(new CellRangeAddress(1, 1, 0, feildWidth));
            return 2;
        }
        return 1;
    }

    private static int getFieldWidth(List<ExcelExportEntity> excelParams) {
        int length = -1;
        for (ExcelExportEntity entity : excelParams) {
            length += entity.getList() != null ? entity.getList().size() : 1;
        }
        return length;
    }

    private static void getAllExcelField(String targetId, Field[] fields, List<ExcelExportEntity> excelParams, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!ExcelPublicUtil.isNotUserExcelUserThis(field, targetId)) {
                String tableName;
                ExportExcelConfig excelConfig = null;
                Excel cs = field.getAnnotation(Excel.class);
                if (!StringUtil.isNotEmpty(cs) || !StringUtil.isNotEmpty((String)cs.tableName()) || dynamicExportFieldService.judgeIsExport(excelConfig = dynamicExportFieldService.getExportExcelConfig(tableName = cs.tableName(), field.getName()))) {
                    ExcelExportEntity excelEntity;
                    Annotation excel;
                    if (ExcelPublicUtil.isCollection(field.getType())) {
                        excel = field.getAnnotation(ExcelCollection.class);
                        ParameterizedType pt = (ParameterizedType)field.getGenericType();
                        Class clz = (Class)pt.getActualTypeArguments()[0];
                        ArrayList<ExcelExportEntity> list = new ArrayList<ExcelExportEntity>();
                        ExcelExportUtil.getExcelFieldList(targetId, ExcelPublicUtil.getClassFields(clz), clz, list, null);
                        excelEntity = new ExcelExportEntity();
                        String name = null;
                        Integer order = null;
                        if (StringUtil.isNotEmpty(excelConfig)) {
                            name = excelConfig.getExportName();
                            order = Integer.parseInt(excelConfig.getExprotOrder());
                        } else {
                            name = ExcelExportUtil.getExcelName(excel.exportName(), targetId);
                            order = ExcelExportUtil.getCellOrder(excel.orderNum(), targetId);
                        }
                        excelEntity.setName(name);
                        excelEntity.setOrderNum(order);
                        excelEntity.setGetMethod(ExcelPublicUtil.getMethod(field.getName(), pojoClass));
                        excelEntity.setList(list);
                        excelParams.add(excelEntity);
                    } else if (ExcelPublicUtil.isJavaClass(field)) {
                        excel = field.getAnnotation(Excel.class);
                        excelEntity = new ExcelExportEntity();
                        excelEntity.setType(excel.exportType());
                        ExcelExportUtil.getExcelField(targetId, field, excelEntity, (Excel)excel, pojoClass, excelConfig);
                        if (getMethods != null) {
                            ArrayList<Method> newMethods = new ArrayList<Method>();
                            newMethods.addAll(getMethods);
                            newMethods.add(excelEntity.getGetMethod());
                            excelEntity.setGetMethods(newMethods);
                        }
                        excelParams.add(excelEntity);
                    } else {
                        ArrayList<Method> newMethods = new ArrayList<Method>();
                        if (getMethods != null) {
                            newMethods.addAll(getMethods);
                        }
                        newMethods.add(ExcelPublicUtil.getMethod(field.getName(), pojoClass));
                        ExcelExportUtil.getAllExcelField(targetId, ExcelPublicUtil.getClassFields(field.getType()), excelParams, field.getType(), newMethods);
                    }
                }
            }
            ++i;
        }
    }

    private static String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf(",") < 0) {
            return exportName;
        }
        String[] stringArray = arr = exportName.split(",");
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.indexOf(targetId) != -1) {
                return str.split("_")[0];
            }
            ++n2;
        }
        return null;
    }

    private static int getCellOrder(String orderNum, String targetId) {
        String[] arr;
        if (ExcelExportUtil.isInteger(orderNum) || targetId == null) {
            return Integer.valueOf(orderNum);
        }
        String[] stringArray = arr = orderNum.split(",");
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.indexOf(targetId) != -1) {
                return Integer.valueOf(str.split("_")[0]);
            }
            ++n2;
        }
        return 0;
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static void getExcelFieldList(String targetId, Field[] fields, Class<?> pojoClass, List<ExcelExportEntity> list, List<Method> getMethods) throws Exception {
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (!ExcelPublicUtil.isNotUserExcelUserThis(field, targetId)) {
                if (ExcelPublicUtil.isJavaClass(field)) {
                    Excel excel = field.getAnnotation(Excel.class);
                    ExcelExportEntity excelEntity = new ExcelExportEntity();
                    ExcelExportUtil.getExcelField(targetId, field, excelEntity, excel, pojoClass, null);
                    excelEntity.setType(excel.exportType());
                    if (getMethods != null) {
                        ArrayList<Method> newMethods = new ArrayList<Method>();
                        newMethods.addAll(getMethods);
                        newMethods.add(excelEntity.getGetMethod());
                        excelEntity.setGetMethods(newMethods);
                    }
                    list.add(excelEntity);
                } else {
                    ArrayList<Method> newMethods = new ArrayList<Method>();
                    if (getMethods != null) {
                        newMethods.addAll(getMethods);
                    }
                    newMethods.add(ExcelPublicUtil.getMethod(field.getName(), pojoClass));
                    ExcelExportUtil.getExcelFieldList(targetId, ExcelPublicUtil.getClassFields(field.getType()), field.getType(), list, newMethods);
                }
            }
            ++i;
        }
    }

    public static void getExcelField(String targetId, Field field, ExcelExportEntity excelEntity, Excel excel, Class<?> pojoClass, ExportExcelConfig excelConfig) throws Exception {
        String name = null;
        Integer order = null;
        if (StringUtil.isNotEmpty(excelConfig)) {
            name = excelConfig.getExportName();
            order = Integer.parseInt(excelConfig.getExprotOrder());
        } else {
            name = ExcelExportUtil.getExcelName(excel.exportName(), targetId);
            order = ExcelExportUtil.getCellOrder(excel.orderNum(), targetId);
        }
        excelEntity.setName(name);
        excelEntity.setOrderNum(order);
        excelEntity.setWidth(excel.exportFieldWidth());
        excelEntity.setHeight(excel.exportFieldHeight());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setExportFormat(StringUtils.isNotEmpty((String)excel.exportFormat()) ? excel.exportFormat() : excel.imExFormat());
        String fieldname = field.getName();
        excelEntity.setGetMethod(ExcelPublicUtil.getMethod(fieldname, pojoClass));
        if (excel.exportConvertSign() == 1 || excel.imExConvert() == 1) {
            StringBuffer getConvertMethodName = new StringBuffer("convertGet");
            getConvertMethodName.append(fieldname.substring(0, 1).toUpperCase());
            getConvertMethodName.append(fieldname.substring(1));
            Method getConvertMethod = pojoClass.getMethod(getConvertMethodName.toString(), new Class[0]);
            excelEntity.setGetMethod(getConvertMethod);
        }
        if (StringUtils.isNotEmpty((String)excel.dicCode())) {
            List<TmDictDataEntity> dictList = DictUtil.allDictData.get(excel.dicCode());
            HashMap<String, String> dictMap = new HashMap<String, String>();
            for (TmDictDataEntity dictEntity : dictList) {
                dictMap.put(dictEntity.getDictCode(), dictEntity.getDictValue());
            }
            excelEntity.setDictMap(dictMap);
        }
    }

    public static HSSFCellStyle getTitleStyle(HSSFWorkbook workbook, ExcelTitle entity) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        titleStyle.setFillForegroundColor(entity.getHeaderColor());
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        titleStyle.setFillPattern((short)1);
        titleStyle.setWrapText(true);
        return titleStyle;
    }

    public static HSSFCellStyle getHeaderStyle(HSSFWorkbook workbook, ExcelTitle entity) {
        HSSFCellStyle titleStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setFontHeightInPoints((short)24);
        titleStyle.setFont((Font)font);
        titleStyle.setFillForegroundColor(entity.getColor());
        titleStyle.setAlignment((short)2);
        titleStyle.setVerticalAlignment((short)1);
        return titleStyle;
    }

    public static HSSFCellStyle getTwoStyle(HSSFWorkbook workbook, boolean isWarp) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setFillForegroundColor((short)41);
        style.setFillPattern((short)1);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        if (isWarp) {
            style.setWrapText(true);
        }
        return style;
    }

    public static HSSFCellStyle getOneStyle(HSSFWorkbook workbook, boolean isWarp) {
        HSSFCellStyle style = workbook.createCellStyle();
        style.setBorderLeft((short)1);
        style.setBorderRight((short)1);
        style.setBorderBottom((short)1);
        style.setBorderTop((short)1);
        style.setAlignment((short)2);
        style.setVerticalAlignment((short)1);
        if (isWarp) {
            style.setWrapText(true);
        }
        return style;
    }

    private static Map<String, HSSFCellStyle> createStyles(HSSFWorkbook workbook) {
        HashMap<String, HSSFCellStyle> map = new HashMap<String, HSSFCellStyle>();
        map.put("one", ExcelExportUtil.getOneStyle(workbook, false));
        map.put("oneWrap", ExcelExportUtil.getOneStyle(workbook, true));
        map.put("two", ExcelExportUtil.getTwoStyle(workbook, false));
        map.put("twoWrap", ExcelExportUtil.getTwoStyle(workbook, true));
        return map;
    }

    private static CellStyle getStyles(Map<String, HSSFCellStyle> map, boolean needOne, boolean isWrap) {
        if (needOne && isWrap) {
            return (CellStyle)map.get("oneWrap");
        }
        if (needOne) {
            return (CellStyle)map.get("one");
        }
        if (!needOne && isWrap) {
            return (CellStyle)map.get("twoWrap");
        }
        return (CellStyle)map.get("two");
    }
}

