/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer.iterator;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.mdm.dict.util.DictUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2007DataIterator
implements DataIterator {
    private XSSFSheet sheet;
    private int rows = -1;
    private int index;
    private List<DataField> dataFieldList;
    private DataFormatter dataFormatter = new DataFormatter();
    private XSSFCellStyle dateStyle;

    public Excel2007DataIterator(InputStream is, int sheetIndex, List<DataField> dataFieldList) throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook(is);
        this.sheet = wb.getSheetAt(sheetIndex);
        this.rows = this.sheet.getLastRowNum() + 1;
        this.index = 0;
        this.dataFieldList = dataFieldList;
        XSSFDataFormat format = wb.createDataFormat();
        this.dateStyle = wb.createCellStyle();
        this.dateStyle.setDataFormat(format.getFormat("yyyy-MM-dd HH:mm:ss"));
    }

    @Override
    public boolean hasNext() {
        return this.index < this.rows;
    }

    @Override
    public Map<String, Object> next() {
        XSSFRow cells = this.sheet.getRow(this.index++);
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        if (cells == null) {
            return rowMap;
        }
        int cellIdx = 0;
        while (cellIdx < cells.getLastCellNum()) {
            String dictCode;
            String valueStr;
            XSSFCell cell = cells.getCell(cellIdx);
            String value = "";
            if (cell != null) {
                if (cell.getCellType() == 0 && DateUtil.isCellDateFormatted((Cell)cell) && cell.getCellStyle() != null) {
                    cell.setCellStyle((CellStyle)this.dateStyle);
                }
                value = cell.getCellType() == 5 ? cell.toString() : this.dataFormatter.formatCellValue((Cell)cell).trim();
            }
            StringBuilder idx = new StringBuilder();
            idx.append(cellIdx + 1);
            DataField dataField = this.dataFieldList.get(cellIdx);
            if (StringUtil.isNotEmpty((String)value) && dataField != null && StringUtil.isNotEmpty((String)dataField.getDictCode()) && StringUtil.isNotEmpty((String)(valueStr = DictUtil.getDictCodeByValue(dictCode = dataField.getDictCode(), value)))) {
                value = valueStr;
            }
            if (StringUtil.isNotEmpty((String)dataField.getFormat())) {
                rowMap.put(dataField.getCode(), DateUtils.parse(value, dataField.getFormat()));
            } else {
                rowMap.put(dataField.getCode(), value);
            }
            ++cellIdx;
        }
        return rowMap;
    }

    @Override
    public void remove() {
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getRowNumber() {
        return this.index;
    }

    @Override
    public int getSize() {
        return this.rows;
    }
}

