/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.org.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.util.oConvertUtils;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ComboxTreeUtil;
import com.biz.eisp.base.common.util.FastJsonFilter;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgFormExtendService;
import com.biz.eisp.mdm.org.service.TmOrgMainExtendService;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.org.transform.TmOrgEntityToTmOrgVo;
import com.biz.eisp.mdm.org.vo.QueryTmOrgVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmOrgController"})
public class TmOrgController
extends BaseController {
    @Autowired
    private TmOrgService tmOrgService;
    @Autowired(required=false)
    private TmOrgMainExtendService tmOrgMainExtendService;
    @Autowired(required=false)
    private TmOrgFormExtendService tmOrgFormExtendService;

    @RequestMapping(params={"goOrgMain"})
    public ModelAndView goOrgMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_ORG);
        if (this.tmOrgMainExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmOrgMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmOrg/tmOrgMain");
    }

    @RequestMapping(params={"goOrgSelectMain"})
    public ModelAndView goOrgSelectMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmOrg/tmOrgSelectMain");
    }

    @RequestMapping(params={"goOrgCustSelectMain"})
    public ModelAndView goOrgCustSelectMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmOrg/tmOrgCustSelectMain");
    }

    @RequestMapping(params={"findOrgMainGrid"})
    @ResponseBody
    public Object findOrgMainGrid(HttpServletRequest request, TreeGrid treeGrid, TmOrgVo orgVo) {
        List<TreeGrid> orgGris = TreeGridUtil.buildTree(this.tmOrgService.findOrgMainGrid(request, treeGrid, orgVo));
        String jsonString = JSON.toJSONString(orgGris, (SerializeFilter)new FastJsonFilter(), (SerializerFeature[])new SerializerFeature[0]);
        Object object = JSONArray.parse((String)jsonString);
        return object;
    }

    @RequestMapping(params={"findOrgMainList"})
    @ResponseBody
    public List<TmOrgVo> findOrgMainList(HttpServletRequest request, TmOrgVo orgVo) {
        List<TmOrgVo> orgList = this.tmOrgService.findOrgMainList(orgVo);
        return orgList;
    }

    @RequestMapping(params={"findAuthOrgMainList"})
    @ResponseBody
    public List<TmOrgVo> findAuthOrgMainList(HttpServletRequest request, String parentId, TmOrgVo orgVo) {
        if (StringUtils.isNotBlank((CharSequence)parentId) && StringUtil.isBlank((String)orgVo.getId())) {
            orgVo.setId(parentId);
        }
        List<TmOrgVo> orgList = this.tmOrgService.findOrgMainList(orgVo);
        return orgList;
    }

    @RequestMapping(params={"findSelectOrgMainGrid"})
    @ResponseBody
    public Object findSelectOrgMainGrid(HttpServletRequest request, TreeGrid treeGrid, TmOrgVo orgVo) {
        List<TreeGrid> orgGris = this.tmOrgService.findOrgMainGrid(request, treeGrid, orgVo);
        JSONArray jsonArray = new JSONArray();
        for (TreeGrid tg : orgGris) {
            jsonArray.add(JSON.parse((String)tg.toJson()));
        }
        return jsonArray;
    }

    @RequestMapping(params={"goOrgMainSelectToPosGrid"})
    public ModelAndView goSelectOrgMainGrid(HttpServletRequest request, TmOrgVo orgVo) {
        request.setAttribute("positionIds", (Object)orgVo.getPositionIds());
        request.setAttribute("orgId", (Object)orgVo.getOrgId());
        return new ModelAndView("com/biz/eisp/mdm/tmOrg/OrgSelectMainGrid");
    }

    @RequestMapping(params={"goOrgMainSelectToCustomerGrid"})
    public ModelAndView goOrgMainSelectToCustomerGrid(HttpServletRequest request, TmOrgVo orgVo) {
        request.setAttribute("customerIds", (Object)orgVo.getCustomerIds());
        request.setAttribute("orgId", (Object)orgVo.getOrgId());
        return new ModelAndView("com/biz/eisp/mdm/tmOrg/orgSelectMainToCustomerGrid");
    }

    @RequestMapping(params={"findOrgSelectGrid"})
    public void findOrgSelectGrid(HttpServletRequest request, HttpServletResponse response, TmOrgVo orgVo) {
        try {
            EuPage page = new EuPage(request);
            List<TmOrgVo> list = this.tmOrgService.findOrgSelectGrid(orgVo, page);
            this.datagridReturn(response, list, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868\u5931\u8d25");
        }
    }

    @RequestMapping(params={"findOrgCustSelectGrid"})
    public void findOrgCustSelectGrid(HttpServletRequest request, HttpServletResponse response, TmCustomerOrgVo orgVo) {
        try {
            EuPage page = new EuPage(request);
            List<TmCustomerOrgVo> list = this.tmOrgService.findOrgCustSelectGrid(orgVo, page);
            this.datagridReturn(response, list, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u7ec4\u7ec7\u5217\u8868\u5931\u8d25");
        }
    }

    @RequestMapping(params={"goOrgAddForm"})
    public ModelAndView goOrgAddForm(HttpServletRequest request, TmOrgVo orgVo) {
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        if (StringUtil.isNotEmpty((String)orgVo.getId())) {
            TmOrgEntity orgEntity = this.tmOrgService.get(TmOrgEntity.class, (Serializable)((Object)orgVo.getId()));
            orgVo = new TmOrgEntityToTmOrgVo(this.tmOrgService).apply(orgEntity);
            request.setAttribute("org", (Object)orgVo);
        }
        request.setAttribute("extendTableName", (Object)Globals.TABLE_ORG);
        if (this.tmOrgFormExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmOrgFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmOrg/tmOrgForm");
    }

    @RequestMapping(params={"getParentOrg"})
    @ResponseBody
    public List<ComboTree> getParentOrg(HttpServletRequest request, ComboTree comboTree, TmOrgVo orgVo) {
        if (orgVo != null && StringUtils.isBlank((CharSequence)orgVo.getPid()) || orgVo == null) {
            TmOrgEntity og = ResourceUtil.getCurrOrg();
            if (og != null) {
                TmOrgVo org = new TmOrgVo();
                org.setPid(og.getId());
                return this.tmOrgService.getParentOrg(orgVo, comboTree, request);
            }
            return new ArrayList<ComboTree>();
        }
        return this.tmOrgService.getParentOrg(orgVo, comboTree, request);
    }

    @RequestMapping(params={"getOrgTree"})
    @ResponseBody
    public List<ComboTree> getOrgTree(HttpServletRequest request) {
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "orgName", "tmOrgList");
        List<Object> comboTreesreturn = new ArrayList();
        String opOrgId = oConvertUtils.getString(request.getParameter("id"));
        if (StringUtil.isNotEmpty((String)opOrgId)) {
            TmOrgEntity tdepart = this.tmOrgService.get(TmOrgEntity.class, (Serializable)((Object)opOrgId));
            if (tdepart != null) {
                List<ComboTree> comboTrees = ComboxTreeUtil.getComboTrees();
                comboTreesreturn = ComboxTreeUtil.getComboxByObj(comboTrees, comboTreeModel, tdepart);
            }
        } else {
            String userId = ResourceUtil.getSessionUserName().getId();
            String userName = ResourceUtil.getSessionUserName().getUserName();
            if (userName.equalsIgnoreCase("admin")) {
                comboTreesreturn = ComboxTreeUtil.getComboTrees();
            } else {
                QueryTmOrgVo queryTmOrgVo = new QueryTmOrgVo();
                queryTmOrgVo.setUserId(userId);
                List<TmOrgVo> ups = this.tmOrgService.findTmOrgByAllPossible(queryTmOrgVo, null);
                if (!CollectionUtils.isEmpty(ups)) {
                    List<ComboTree> comboTrees = ComboxTreeUtil.getComboTrees();
                    for (TmOrgVo org : ups) {
                        comboTreesreturn.addAll(ComboxTreeUtil.getComboxByObj(comboTrees, comboTreeModel, org));
                    }
                }
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(comboTreesreturn)) {
            comboTreesreturn.sort((ord1, ord2) -> ord2.getId().compareTo(ord1.getId()));
        }
        return comboTreesreturn;
    }

    @RequestMapping(params={"getSalesArae"})
    @ResponseBody
    public List<ComboBox> getSalesArae(HttpServletRequest request, TmOrgVo orgVo) {
        return this.tmOrgService.getSalesArae(orgVo);
    }

    @RequestMapping(params={"getSalesAraeOrgCode"})
    @ResponseBody
    public List<ComboBox> getSalesAraeOrgCode(HttpServletRequest request, TmOrgVo orgVo) {
        return this.tmOrgService.getSalesAraeOrgCode(orgVo);
    }

    @RequestMapping(params={"saveOrUpdateOrg"})
    @ResponseBody
    public AjaxJson saveOrUpdateOrg(HttpServletRequest request, TmOrgVo orgVo) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.tmOrgService.saveOrUpdateOrg(orgVo, page);
            this.tmOrgService.updateIsLeafColumn(Globals.TABLE_ORG);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            j.setAttributes(attributes);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"delOrg"})
    @ResponseBody
    public AjaxJson delOrg(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmOrgService.delOrg(ids);
            this.tmOrgService.updateIsLeafColumn(Globals.TABLE_ORG);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"startOrStopTmuser"})
    @ResponseBody
    public AjaxJson startOrStopTmuser(TmOrgVo orgVo) {
        AjaxJson json = new AjaxJson();
        try {
            if (StringUtil.isEmpty(orgVo.getId())) {
                json.setMsg("\u8bf7\u9009\u62e9\u4e00\u6761\u8981\u64cd\u4f5c\u7684\u6570\u636e");
                json.setSuccess(false);
                return json;
            }
            json = this.tmOrgService.startOrStopTmuser(orgVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return json;
    }

    @RequestMapping(params={"validateOrg"})
    @ResponseBody
    public ValidForm validateOrg(TmOrgVo orgVo, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        SimpleExpression cr1 = Restrictions.eq((String)"orgName", (Object)param);
        SimpleExpression cr3 = Restrictions.eq((String)"orgCode", (Object)param);
        SimpleExpression cr4 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)orgVo.getId())) {
            List<TmOrgEntity> tmOrgs;
            List<TmOrgEntity> tmOrgByCodes;
            Criterion cr2 = Restrictions.not((Criterion)Restrictions.eq((String)"id", (Object)orgVo.getId()));
            if ("0".equals(orgVo.getType()) && !CollectionUtils.isEmpty(tmOrgByCodes = this.tmOrgService.findByCriteria(TmOrgEntity.class, new Criterion[]{cr3, cr2, cr4}))) {
                validForm.setStatus("n");
                validForm.setInfo("\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
            }
            if ("1".equals(orgVo.getType()) && !CollectionUtils.isEmpty(tmOrgs = this.tmOrgService.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2, cr4}))) {
                validForm.setStatus("n");
                validForm.setInfo("\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
            }
        } else {
            List<TmOrgEntity> tmOrgs;
            List<TmOrgEntity> tmOrgByCodes;
            if ("0".equals(orgVo.getType()) && !CollectionUtils.isEmpty(tmOrgByCodes = this.tmOrgService.findByCriteria(TmOrgEntity.class, new Criterion[]{cr3, cr4}))) {
                validForm.setStatus("n");
                validForm.setInfo("\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
            }
            if ("1".equals(orgVo.getType()) && !CollectionUtils.isEmpty(tmOrgs = this.tmOrgService.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr4}))) {
                validForm.setStatus("n");
                validForm.setInfo("\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }

    @RequestMapping(params={"goOptionalOrgMain"})
    public ModelAndView goOptionalOrgMain(String orgCodes, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmOrg/tmOptionalOrgMain");
        view.addObject("orgCodes", (Object)orgCodes);
        return view;
    }

    @RequestMapping(params={"findOptionalOrgSelectList"})
    @ResponseBody
    public DataGrid findOptionalOrgSelectList(TmOrgVo TmOrgApiVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        ArrayList<TmOrgVo> TmOrgApiVos = new ArrayList<TmOrgVo>();
        try {
            TmOrgApiVos.addAll(this.tmOrgService.findOptionalOrgSelectList(TmOrgApiVo, page));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u5f85\u9009\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25," + e.getMessage());
        }
        return new DataGrid(TmOrgApiVos, page);
    }

    @RequestMapping(params={"findOptionalOrgAlreadyList"})
    @ResponseBody
    public DataGrid findOptionalOrgAlreadyList(TmOrgVo TmOrgApiVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        ArrayList<TmOrgVo> TmOrgApiVos = new ArrayList<TmOrgVo>();
        try {
            TmOrgApiVos.addAll(this.tmOrgService.findOptionalOrgAlreadyList(TmOrgApiVo));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u5f85\u9009\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25," + e.getMessage());
        }
        return new DataGrid(TmOrgApiVos, page);
    }
}

