/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.dao.TaActRoleDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaRoleExtendService;
import com.biz.eisp.activiti.designer.processconf.service.TaRoleService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaActRoleEntityToTaActRoleVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaActRoleVoToTaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaActRoleVo;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.web.pojo.Client;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.RepositoryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="taRoleService")
@Transactional
public class TaRoleServcieImpl
extends BaseServiceImpl
implements TaRoleService {
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaActRoleDao taActRoleDao;
    @Autowired(required=false)
    private TaRoleExtendService taRoleExtendService;
    private static final int VALIDATE_ROLECODE = 0;
    private static final int VALIDATE_ROLENAME = 1;

    @Override
    public List<TaActRoleEntity> getRoleListByCurrentPosId(TaActRoleVo taActRoleVo, Page page) throws BusinessException {
        return this.taActRoleDao.getActRoleListByCurrentPosId(taActRoleVo, page);
    }

    @Override
    public List<TaActRoleVo> findActRoleList(TaActRoleVo taActRoleVo, Page page) {
        String hql = "from TaActRoleEntity t where 1=1 ";
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)taActRoleVo.getRoleCode())) {
            hql = hql + " and t.roleCode like ?";
            params.add("%" + taActRoleVo.getRoleCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)taActRoleVo.getRoleName())) {
            hql = hql + " and t.roleName like ?";
            params.add("%" + taActRoleVo.getRoleName() + "%");
        }
        hql = hql + " order by t.roleCode";
        List entityList = this.findByHql(hql, page, params.toArray());
        List voList = Lists.transform(entityList, (Function)new TaActRoleEntityToTaActRoleVo());
        return voList;
    }

    @Override
    public void createTmRole(TaActRoleVo taActRoleVo, Page page) throws BusinessException {
        TaActRoleEntity taActRoleEntity = null;
        if (StringUtil.isNotEmpty(this.taRoleExtendService)) {
            try {
                this.taRoleExtendService.validate(taActRoleVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            taActRoleEntity = this.taRoleExtendService.saveBefore(taActRoleVo, page);
        }
        if (StringUtil.isEmpty(taActRoleEntity)) {
            taActRoleEntity = new TaActRoleVoToTaActRoleEntity(this).apply(taActRoleVo);
        }
        if (StringUtil.isNotEmpty(this.taRoleExtendService)) {
            taActRoleEntity = this.taRoleExtendService.saveBefore(taActRoleEntity, taActRoleVo, page);
        }
        this.saveOrUpdate(taActRoleEntity);
        if (StringUtil.isNotEmpty(this.taRoleExtendService)) {
            taActRoleEntity = this.taRoleExtendService.savePost(taActRoleEntity, taActRoleVo, page);
        }
    }

    @Override
    public boolean deleteTmRole(String id) throws SQLException {
        TaActRoleEntity roleEntity = this.get(TaActRoleEntity.class, (Serializable)((Object)id));
        if (StringUtil.isNotEmpty(roleEntity)) {
            if (Globals.Admin_Name.equalsIgnoreCase(roleEntity.getRoleCode())) {
                return false;
            }
        } else {
            return false;
        }
        super.deleteEntityById(TaActRoleEntity.class, (Serializable)((Object)id));
        return true;
    }

    @Override
    public Map<String, String> updateTmRole(TaActRoleEntity taActRoleEntity) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<TaActRoleEntity> li1 = this.validate(0, taActRoleEntity.getRoleCode());
        if (li1.size() == 0 || li1.get(0).getId().equals(taActRoleEntity.getId())) {
            li1 = this.validate(1, taActRoleEntity.getRoleName());
            if (li1.size() == 0 || li1.get(0).getId().equals(taActRoleEntity.getId())) {
                TaActRoleEntity role = super.get(TaActRoleEntity.class, (Serializable)((Object)taActRoleEntity.getId()));
                role.setRoleCode(taActRoleEntity.getRoleCode());
                role.setRoleName(taActRoleEntity.getRoleName());
                role.setUpdateDate(new Date());
                Client client = ResourceUtil.getClient();
                String name = client.getUser().getUserName();
                role.setUpdateName(name);
                super.updateEntity(role);
                map.put("success", "true");
            } else {
                map.put("success", "false");
                map.put("msg", "\u89d2\u8272\u540d\u79f0\u91cd\u590d");
            }
        } else {
            map.put("success", "false");
            map.put("msg", "\u89d2\u8272\u7f16\u7801\u91cd\u590d");
        }
        return map;
    }

    public List<TaActRoleEntity> validate(int flag, String str) {
        String hql = null;
        Object[] obj = new Object[]{str};
        if (flag == 1) {
            hql = "from TaActRoleEntity t where t.roleName = ?";
        } else if (flag == 0) {
            hql = "from TaActRoleEntity t where t.roleCode = ?";
        }
        return super.findByHql(hql, obj);
    }

    @Override
    public ValidForm validateTmRoleForm(TaActRoleEntity taActRoleEntity) {
        ValidForm validForm = new ValidForm();
        String hql = null;
        if (StringUtil.isEmpty(taActRoleEntity.getId())) {
            if (StringUtil.isNotEmpty((String)taActRoleEntity.getRoleCode())) {
                hql = "from TaActRoleEntity t where t.roleCode = ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, taActRoleEntity.getRoleCode()))) {
                    validForm.setInfo("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
            if (StringUtil.isNotEmpty((String)taActRoleEntity.getRoleName())) {
                hql = "from TaActRoleEntity t where t.roleName = ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, taActRoleEntity.getRoleName()))) {
                    validForm.setInfo("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
        } else {
            if (StringUtil.isNotEmpty((String)taActRoleEntity.getRoleCode())) {
                hql = "from TaActRoleEntity t where t.roleCode = ? and id <> ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, taActRoleEntity.getRoleCode(), taActRoleEntity.getId()))) {
                    validForm.setInfo("\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
            if (StringUtil.isNotEmpty((String)taActRoleEntity.getRoleName())) {
                hql = "from TaActRoleEntity t where t.roleName = ? and id <> ?";
                if (!CollectionUtils.isEmpty(super.findByHql(hql, taActRoleEntity.getRoleName(), taActRoleEntity.getId()))) {
                    validForm.setInfo("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
                    validForm.setStatus("n");
                }
            }
        }
        return validForm;
    }

    @Override
    public List<TmPositionVo> findPositionByRoleCode(TmPositionVo tmPositionVo, String roleCode, Page page) {
        List<TmPositionVo> list = this.taActRoleDao.findPositionByRoleCode(tmPositionVo, roleCode, page);
        return list;
    }

    @Override
    public List<TmActRoleVo> findNoSelfActRoleList(TmActRoleVo tmActRoleVo, String selfActRoleId, Page page) {
        List<TmActRoleVo> voList = this.taActRoleDao.findNoSelfActRoleList(tmActRoleVo, selfActRoleId, page);
        return voList;
    }
}

