/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.customer.transformer;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.generatednum.num.util.TbNumRuleProvider;
import com.biz.eisp.mdm.businessarea.entity.TmBusinessAreaEntity;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBGEntity;
import com.biz.eisp.mdm.customer.entity.TmRCustPosBgDetailEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.customer.service.TmRCustPosBgDetailService;
import com.biz.eisp.mdm.customer.util.ValidateUtil;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.product.entity.TmProductEntity;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TmCustomerVoToTmCustomerEntity
implements Function<TmCustomerVo, TmCustomerEntity> {
    private TmCustomerService tmCustomerService;
    private TmRCustPosBgDetailService tmRCustPosBgDetailService;
    private List<TmBusinessGroupVo> addBusinessGroupVoList;
    private List<TmBusinessGroupVo> deleteBusinessGroupVoList;
    private TbNumRuleProvider tbNumRuleProvider = null;
    private String[] channelCodes;
    private String[] orgIds;
    private String[] productCodes;
    private String[] businessAreaCodes;
    private String[] bgExtChar1s;
    private String[] bgExtChar2s;

    public TmCustomerVoToTmCustomerEntity(TmCustomerService tmCustomerService, TmRCustPosBgDetailService tmRCustPosBgDetailService, List<TmBusinessGroupVo> addBusinessGroupVoList, List<TmBusinessGroupVo> deleteBusinessGroupVoList) {
        this.tmCustomerService = tmCustomerService;
        this.tmRCustPosBgDetailService = tmRCustPosBgDetailService;
        this.tbNumRuleProvider = (TbNumRuleProvider)ApplicationContextUtils.getContext().getBean("tbNumRuleProvider");
        this.addBusinessGroupVoList = addBusinessGroupVoList;
        this.deleteBusinessGroupVoList = deleteBusinessGroupVoList;
    }

    public TmCustomerEntity apply(TmCustomerVo input) {
        TmCustomerEntity tmCustomerEntity = null;
        if (StringUtil.isNotEmpty((String)input.getId())) {
            tmCustomerEntity = this.tmCustomerService.get(TmCustomerEntity.class, (Serializable)((Object)input.getId()));
        } else {
            if (StringUtil.isEmpty(input.getCustomerName())) {
                throw new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a");
            }
            List list = this.tmCustomerService.findByHql("from TmCustomerEntity where customerName=? ", input.getCustomerName());
            if (list != null && list.size() > 0) {
                throw new BusinessException("\u5ba2\u6237\u540d\u79f0" + input.getCustomerName() + "\u5df2\u5b58\u5728");
            }
            tmCustomerEntity = new TmCustomerEntity();
            String customerCode = this.tbNumRuleProvider.getMaxNum("customer");
            tmCustomerEntity.setCustomerCode(customerCode);
            input.setCustomerCode(customerCode);
            tmCustomerEntity.setEnableStatus(Globals.add);
        }
        if (ValidateUtil.validateName(input.getCustomerName(), "[`~!@#$%^&* +=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u2019\u3002\uff0c\u3001\uff1f]")) {
            throw new BusinessException("\u68c0\u6d4b\u5230\u5ba2\u6237\u540d\u79f0[" + input.getCustomerName() + "]\u5305\u542b\u975e\u6cd5\u5b57\u7b26");
        }
        if (StringUtil.isNotEmpty((String)input.getErpCode()) && !ValidateUtil.validateName(input.getErpCode(), "[a-z0-9A-Z]")) {
            throw new BusinessException("\u68c0\u6d4b\u5230\u5ba2\u6237ERP\u7f16\u7801\u5305\u542b\u975e\u6cd5\u5b57\u7b26:" + input.getErpCode() + "\uff0c\u53ea\u80fd\u4e3a\u6570\u5b57\u548c\u5b57\u6bcd");
        }
        try {
            this.copyProperties(input, tmCustomerEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtil.isNotEmpty((String)input.getOrgId())) {
            TmOrgEntity tmOrg = null;
            if (StringUtil.isNotEmpty((String)input.getOrgId())) {
                tmOrg = this.tmCustomerService.get(TmOrgEntity.class, (Serializable)((Object)input.getOrgId()));
            }
            if (tmOrg == null) {
                String org = StringUtil.isNotEmpty((String)input.getOrgId()) ? input.getOrgId() : input.getOrgName();
                throw new BusinessException("\u6240\u5c5e\u7ec4\u7ec7\u4fe1\u606f[" + org + "]\u4e0d\u5b58\u5728");
            }
            tmCustomerEntity.setTmOrg(tmOrg);
        }
        if (StringUtil.isNotEmpty((String)input.getCustomerOrgId())) {
            TmCustomerOrgEntity customerOrg = null;
            if (StringUtil.isNotEmpty((String)input.getCustomerOrgId())) {
                customerOrg = this.tmCustomerService.get(TmCustomerOrgEntity.class, (Serializable)((Object)input.getCustomerOrgId()));
            }
            if (customerOrg == null) {
                String custOrg = StringUtil.isNotEmpty((String)input.getCustomerOrgId()) ? input.getCustomerOrgId() : input.getCustomerOrgName();
                throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u4fe1\u606f[" + custOrg + "]\u4e0d\u5b58\u5728");
            }
            tmCustomerEntity.setTmCustomerOrg(customerOrg);
        }
        tmCustomerEntity.setTmRCustPosBGList(this.getTmRCustPosBGList(tmCustomerEntity, input));
        return tmCustomerEntity;
    }

    private void initBusinessGroupInfo(List<TmRCustPosBGEntity> custPostList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(custPostList)) {
            for (TmRCustPosBGEntity entity : custPostList) {
                List<TmRCustPosBgDetailEntity> detailEntityList = this.tmCustomerService.findByProperty(TmRCustPosBgDetailEntity.class, "businessGroup", entity.getBusinessGroup());
                for (TmRCustPosBgDetailEntity detailEntity : detailEntityList) {
                    TmBusinessGroupVo businessGroupVo = new TmBusinessGroupVo();
                    businessGroupVo.setBusinessGroup(detailEntity.getBusinessGroup());
                    businessGroupVo.setDetailCode(detailEntity.getDetailCode());
                    businessGroupVo.setDetailName(detailEntity.getDetailName());
                    businessGroupVo.setTypeCode(detailEntity.getTypeCode());
                    businessGroupVo.setTypeName(detailEntity.getTypeName());
                    businessGroupVo.setPositionId(entity.getTmPosition() == null ? "" : entity.getTmPosition().getId());
                    businessGroupVo.setOrgId(entity.getOrgId());
                    this.deleteBusinessGroupVoList.add(businessGroupVo);
                }
            }
        }
    }

    private void initBusinessGroupVoInfo(TmCustomerVo input) {
        this.channelCodes = StringUtils.isNotBlank((CharSequence)input.getChannelCode()) ? input.getChannelCode().split(",", -1) : null;
        this.orgIds = StringUtils.isNotBlank((CharSequence)input.getBusinessGroupOrgId()) ? input.getBusinessGroupOrgId().split(",", -1) : null;
        this.productCodes = StringUtils.isNotBlank((CharSequence)input.getProductCode()) ? input.getProductCode().split(",", -1) : null;
        this.businessAreaCodes = StringUtils.isNotBlank((CharSequence)input.getBusinessAreaCode()) ? input.getBusinessAreaCode().split(",", -1) : null;
        this.bgExtChar1s = StringUtils.isNotBlank((CharSequence)input.getBgExtChar1s()) ? input.getBgExtChar1s().split(",") : null;
        this.bgExtChar2s = StringUtils.isNotBlank((CharSequence)input.getBgExtChar2s()) ? input.getBgExtChar2s().split(",") : null;
    }

    public List<TmRCustPosBGEntity> getTmRCustPosBGList(TmCustomerEntity customerEntity, TmCustomerVo input) {
        ArrayList<TmRCustPosBGEntity> custPostList = new ArrayList<TmRCustPosBGEntity>();
        this.initBusinessGroupInfo(customerEntity.getTmRCustPosBGList());
        String relationIndex = input.getRelationIndex();
        String positionIds = input.getPositionIds();
        String[] indexs = new String[]{};
        if (StringUtil.isNotEmpty((String)relationIndex)) {
            indexs = relationIndex.split(",");
        } else if (StringUtil.isNotEmpty((String)positionIds)) {
            indexs = positionIds.split(",");
        }
        this.initBusinessGroupVoInfo(input);
        String[] ids = new String[indexs.length];
        if (StringUtil.isNotEmpty((String)positionIds)) {
            ids = positionIds.split(",");
        }
        String custPost = input.getCustPostId();
        String[] custPostIds = new String[indexs.length];
        if (StringUtil.isNotEmpty((String)custPost)) {
            custPostIds = custPost.split(",");
        }
        for (int i = 0; i < indexs.length; ++i) {
            TmPositionEntity positionEntity;
            TmRCustPosBGEntity tmCustPostEntity = new TmRCustPosBGEntity();
            String positionId = "";
            if (ids.length > i) {
                positionId = ids[i];
            }
            String custPostId = "";
            if (custPostIds.length > i) {
                custPostId = custPostIds[i];
            }
            if (StringUtil.isNotEmpty((String)custPostId)) {
                tmCustPostEntity = this.tmCustomerService.get(TmRCustPosBGEntity.class, (Serializable)((Object)custPostId));
                if (StringUtil.isNotEmpty((String)positionId)) {
                    positionEntity = null;
                    if (StringUtil.isNotEmpty((String)positionId)) {
                        positionEntity = this.tmCustomerService.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                        if (positionEntity == null) {
                            positionEntity = this.tmCustomerService.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionId);
                        }
                        if (positionEntity == null) {
                            throw new BusinessException("\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u4e0d\u5b58\u5728");
                        }
                        tmCustPostEntity.setTmPosition(positionEntity);
                    }
                    if (positionEntity != null) {
                        this.setPositionValue(positionEntity.getId(), tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
                    }
                }
                if (this.orgIds != null && this.orgIds.length > i) {
                    tmCustPostEntity.setOrgId(this.orgIds[i]);
                    this.setOrgValue(this.orgIds[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
                }
                if (this.bgExtChar1s != null && this.bgExtChar1s.length > i) {
                    tmCustPostEntity.setExtChar1(this.bgExtChar1s[i]);
                }
                if (this.bgExtChar2s != null && this.bgExtChar2s.length > i) {
                    tmCustPostEntity.setExtChar2(this.bgExtChar2s[i]);
                }
                this.setChannelValue(this.channelCodes == null ? null : this.channelCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
                this.setProductValue(this.productCodes == null ? null : this.productCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
                this.setBusinessAreaValue(this.businessAreaCodes == null ? null : this.businessAreaCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
                custPostList.add(tmCustPostEntity);
                continue;
            }
            positionEntity = null;
            if (StringUtil.isNotEmpty((String)positionId)) {
                positionEntity = this.tmCustomerService.get(TmPositionEntity.class, (Serializable)((Object)positionId));
                if (positionEntity == null) {
                    for (TmRCustPosBGEntity custPostEntity : custPostList) {
                        if (!custPostEntity.getTmPosition().getPositionCode().equals(positionId)) continue;
                        throw new BusinessException("\u5bf9\u5e94\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u5b58\u5728\u76f8\u540c\u7684\u591a\u4e2a\u7f16\u7801");
                    }
                    positionEntity = this.tmCustomerService.findUniqueByProperty(TmPositionEntity.class, "positionCode", positionId);
                }
                if (positionEntity == null) {
                    throw new BusinessException("\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u4e0d\u5b58\u5728");
                }
                if (Globals.ONE.equals(positionEntity.getEnableStatus())) {
                    throw new BusinessException("\u804c\u4f4d\u4fe1\u606f[" + positionId + "]\u5df2\u505c\u7528");
                }
                tmCustPostEntity.setTmPosition(positionEntity);
            }
            tmCustPostEntity.setBusinessGroup(this.tbNumRuleProvider.getMaxNum("business_group"));
            if (positionEntity != null) {
                this.setPositionValue(positionEntity.getId(), tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
            }
            if (this.orgIds != null && this.orgIds.length > i) {
                tmCustPostEntity.setOrgId(this.orgIds[i]);
                this.setOrgValue(this.orgIds[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
            }
            if (this.bgExtChar1s != null && this.bgExtChar1s.length > i) {
                tmCustPostEntity.setExtChar1(this.bgExtChar1s[i]);
            }
            if (this.bgExtChar2s != null && this.bgExtChar2s.length > i) {
                tmCustPostEntity.setExtChar2(this.bgExtChar2s[i]);
            }
            this.setChannelValue(this.channelCodes == null ? null : this.channelCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
            this.setProductValue(this.productCodes == null ? null : this.productCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
            this.setBusinessAreaValue(this.businessAreaCodes == null ? null : this.businessAreaCodes[i], tmCustPostEntity.getBusinessGroup(), tmCustPostEntity);
            tmCustPostEntity.setTmCustomer(customerEntity);
            custPostList.add(tmCustPostEntity);
        }
        return custPostList;
    }

    private void setBusinessAreaValue(String businessAreaCode, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
        if (StringUtils.isNotBlank((CharSequence)businessAreaCode)) {
            String[] detailCodeArr;
            for (String detail : detailCodeArr = businessAreaCode.split(";")) {
                TmBusinessGroupVo vo = new TmBusinessGroupVo();
                vo.setBusinessGroup(businessGroup);
                vo.setDetailCode(detail);
                TmBusinessAreaEntity businessAreaEntity = this.tmCustomerService.findUniqueByProperty(TmBusinessAreaEntity.class, "businessAreaCode", detail);
                vo.setDetailName(businessAreaEntity.getBusinessAreaName());
                vo.setTypeCode("businessAreaCode");
                vo.setTypeName("\u4e1a\u52a1\u533a\u57df");
                vo.setFlag("add");
                vo.setOrgId(tmCustPostEntity.getOrgId());
                vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
                this.addBusinessGroupVoList.add(vo);
            }
        }
    }

    private void setOrgValue(String orgId, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            TmBusinessGroupVo vo = new TmBusinessGroupVo();
            TmOrgEntity orgEntity = this.tmCustomerService.get(TmOrgEntity.class, (Serializable)((Object)tmCustPostEntity.getOrgId()));
            vo.setBusinessGroup(businessGroup);
            vo.setDetailCode("");
            if (orgEntity != null) {
                vo.setDetailName(orgEntity.getOrgName());
            }
            vo.setTypeCode("orgCode");
            vo.setTypeName("\u6240\u5c5e\u5206\u90e8");
            vo.setFlag("add");
            vo.setOrgId(tmCustPostEntity.getOrgId());
            vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
            this.addBusinessGroupVoList.add(vo);
        }
    }

    private void setPositionValue(String positionId, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
        if (StringUtils.isNotBlank((CharSequence)positionId)) {
            TmBusinessGroupVo vo = new TmBusinessGroupVo();
            vo.setBusinessGroup(businessGroup);
            vo.setDetailCode("");
            vo.setDetailName(tmCustPostEntity.getTmPosition().getPositionName());
            vo.setTypeCode("positionCode");
            vo.setTypeName("\u5bf9\u63a5\u4eba\u804c\u4f4d");
            vo.setFlag("add");
            vo.setOrgId(tmCustPostEntity.getOrgId());
            vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
            this.addBusinessGroupVoList.add(vo);
        }
    }

    private void setChannelValue(String channelCode, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
        if (StringUtils.isNotBlank((CharSequence)channelCode)) {
            String[] detailCodeArr;
            for (String detail : detailCodeArr = channelCode.split(";")) {
                TmBusinessGroupVo vo = new TmBusinessGroupVo();
                vo.setBusinessGroup(businessGroup);
                vo.setDetailCode(detail);
                vo.setDetailName(DictUtil.getDicDataValByCode("channel", detail));
                vo.setTypeCode("channelCode");
                vo.setTypeName("\u6e20\u9053");
                vo.setFlag("add");
                vo.setOrgId(tmCustPostEntity.getOrgId());
                vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
                this.addBusinessGroupVoList.add(vo);
            }
        }
    }

    private void setProductValue(String productCode, String businessGroup, TmRCustPosBGEntity tmCustPostEntity) {
        if (StringUtils.isNotBlank((CharSequence)productCode)) {
            String[] detailCodeArr;
            for (String detail : detailCodeArr = productCode.split(";")) {
                TmBusinessGroupVo vo = new TmBusinessGroupVo();
                vo.setBusinessGroup(businessGroup);
                vo.setDetailCode(detail);
                TmProductEntity productEntity = this.tmCustomerService.findUniqueByProperty(TmProductEntity.class, "productCode", detail);
                vo.setDetailName(productEntity.getProductName());
                vo.setTypeCode("productCode");
                vo.setTypeName("\u4ea7\u54c1");
                vo.setFlag("add");
                vo.setOrgId(tmCustPostEntity.getOrgId());
                vo.setPositionId(tmCustPostEntity.getTmPosition() != null ? tmCustPostEntity.getTmPosition().getId() : "");
                this.addBusinessGroupVoList.add(vo);
            }
        }
    }

    private void copyProperties(TmCustomerVo vo, TmCustomerEntity entity) {
        entity.setAddress(vo.getAddress());
        entity.setArea(vo.getArea());
        entity.setChannelType(vo.getChannelType());
        entity.setCity(vo.getCity());
        entity.setCooperative(vo.getCooperative());
        entity.setCustomerCode(vo.getCustomerCode());
        entity.setCustomerName(vo.getCustomerName());
        entity.setCustomerType(vo.getCustomerType());
        if (StringUtils.isNotBlank((CharSequence)vo.getEnableStatus())) {
            entity.setEnableStatus(vo.getEnableStatus());
        }
        entity.setErpCode(vo.getErpCode());
        entity.setExtChar1(vo.getExtChar1());
        entity.setExtChar2(vo.getExtChar2());
        entity.setExtChar3(vo.getExtChar3());
        entity.setExtChar4(vo.getExtChar4());
        entity.setExtChar5(vo.getExtChar5());
        entity.setExtChar6(vo.getExtChar6());
        entity.setExtChar7(vo.getExtChar7());
        entity.setExtChar8(vo.getExtChar8());
        entity.setExtChar9(vo.getExtChar9());
        entity.setExtChar10(vo.getExtChar10());
        entity.setExtChar11(vo.getExtChar11());
        entity.setExtChar12(vo.getExtChar12());
        entity.setExtChar13(vo.getExtChar13());
        entity.setExtChar14(vo.getExtChar14());
        entity.setExtChar15(vo.getExtChar15());
        entity.setExtChar16(vo.getExtChar16());
        entity.setExtChar17(vo.getExtChar17());
        entity.setExtChar18(vo.getExtChar18());
        entity.setExtChar19(vo.getExtChar19());
        entity.setExtChar20(vo.getExtChar20());
        entity.setExtChar21(vo.getExtChar21());
        entity.setExtChar22(vo.getExtChar22());
        entity.setExtChar23(vo.getExtChar23());
        entity.setExtChar24(vo.getExtChar24());
        entity.setExtChar25(vo.getExtChar25());
        entity.setExtChar26(vo.getExtChar26());
        entity.setExtChar27(vo.getExtChar27());
        entity.setExtChar28(vo.getExtChar28());
        entity.setExtChar29(vo.getExtChar29());
        entity.setExtChar30(vo.getExtChar30());
        entity.setExtChar31(vo.getExtChar31());
        entity.setExtChar32(vo.getExtChar32());
        entity.setExtChar33(vo.getExtChar33());
        entity.setExtChar34(vo.getExtChar34());
        entity.setExtChar35(vo.getExtChar35());
        entity.setExtChar36(vo.getExtChar36());
        entity.setExtChar37(vo.getExtChar37());
        entity.setExtChar38(vo.getExtChar38());
        entity.setExtChar39(vo.getExtChar39());
        entity.setExtChar40(vo.getExtChar40());
        entity.setExtChar41(vo.getExtChar41());
        entity.setExtChar42(vo.getExtChar42());
        entity.setExtChar43(vo.getExtChar43());
        entity.setExtChar44(vo.getExtChar44());
        entity.setExtChar45(vo.getExtChar45());
        entity.setExtNumber1(vo.getExtNumber1());
        entity.setExtNumber2(vo.getExtNumber2());
        entity.setExtNumber3(vo.getExtNumber3());
        entity.setExtNumber4(vo.getExtNumber4());
        entity.setExtNumber5(vo.getExtNumber5());
        entity.setLinkman(vo.getLinkman());
        entity.setLinkmanPhone(vo.getLinkmanPhone());
        entity.setProvince(vo.getProvince());
    }
}

