/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.user.controller;

import com.alibaba.fastjson.JSONArray;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.service.TmUserFormExtendService;
import com.biz.eisp.mdm.user.service.TmUserMainExtendService;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmUserController"})
public class TmUserController
extends BaseController {
    @Autowired
    private TmPositionService tmPositionService;
    @Autowired
    private TmUserService tmUserService;
    @Autowired(required=false)
    private TmUserFormExtendService tmUserFormExtendService;
    @Autowired(required=false)
    private TmUserMainExtendService tmUserMainExtendService;
    @Autowired
    private RedisService redisService;

    @RequestMapping(params={"goTmUserMain"})
    public ModelAndView goTmUserMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_USER);
        if (this.tmUserMainExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmUserMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmUser/tmUserMain");
    }

    @RequestMapping(params={"goTmUserForm"})
    public ModelAndView goTmUserForm(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtil.isNotEmpty((String)tmUserVo.getId())) {
            List<TmUserVo> tmUserVoList = this.tmUserService.findTmUserList(tmUserVo, null);
            if (tmUserVoList != null && tmUserVoList.size() > 0) {
                TmUserVo vo = tmUserVoList.get(0);
                if (StringUtil.isNotEmpty(vo)) {
                    vo.setPassword("******");
                }
                TmPositionVo tmPositionVo = new TmPositionVo();
                tmPositionVo.setUserId(vo.getId());
                List<TmPositionVo> list = this.tmPositionService.findTmPositionList(tmPositionVo, null);
                vo.setPositionJson(JSONArray.toJSONString(list));
                StringBuffer isMains = new StringBuffer();
                StringBuffer posIds = new StringBuffer();
                StringBuffer posNames = new StringBuffer();
                for (TmPositionVo tmPositionVo2 : list) {
                    if (posNames.length() > 0) {
                        posNames.append(",");
                        isMains.append(",");
                        posIds.append(",");
                    }
                    posNames.append(tmPositionVo2.getPositionName());
                    isMains.append(tmPositionVo2.getIsMain());
                    posIds.append(tmPositionVo2.getId());
                }
                vo.setPositionName(posNames.toString());
                vo.setIsMain(isMains.toString());
                vo.setPositionId(posIds.toString());
                request.setAttribute("vo", (Object)vo);
            }
        } else {
            TmUserVo vo = new TmUserVo();
            vo.setPassword("123456");
            request.setAttribute("vo", (Object)vo);
        }
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_USER);
        if (this.tmUserFormExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmUserFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmUser/tmUserForm");
    }

    @RequestMapping(params={"findTmUserList"})
    public void findTmUserList(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmUserVo> tmUserVoList = this.tmUserService.findTmUserList(tmUserVo, page);
        this.datagridReturn(response, tmUserVoList, page);
    }

    @RequestMapping(params={"findTmUserBySearchList"})
    public void findTmUserBySearchList(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        List<TmUserVo> tmUserVoList;
        EuPage page = new EuPage(request);
        tmUserVo.setUserType(Globals.ENTERPRISE_USER);
        if (StringUtil.isNotEmpty((String)tmUserVo.getSearchParam())) {
            tmUserVo.setFullName(tmUserVo.getSearchParam());
        }
        try {
            tmUserVoList = this.tmUserService.findTmUserList(tmUserVo, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25," + e.getMessage());
        }
        this.datagridReturn(response, tmUserVoList, page);
    }

    @RequestMapping(params={"getTmUserBySearch"})
    @ResponseBody
    public AjaxJson getTmUserBySearch(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson json = new AjaxJson();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        EuPage page = new EuPage(request);
        tmUserVo.setUserType(Globals.ENTERPRISE_USER);
        if (StringUtil.isNotEmpty((String)tmUserVo.getSearchParam())) {
            tmUserVo.setFullName(tmUserVo.getSearchParam());
        }
        try {
            List<TmUserVo> tmUserVoList = this.tmUserService.findTmUserList(tmUserVo, page);
            json.setObj(tmUserVoList);
            attributes.put("totle", tmUserVoList.size());
        }
        catch (Exception e) {
            attributes.put("totle", 0);
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u5931\u8d25" + e.getMessage());
        }
        json.setAttributes(attributes);
        return json;
    }

    @RequestMapping(params={"goTmUserSearch"})
    public ModelAndView goTmUserSearch(TmUserVo tmUserVo, String singleSelect, String searchUrl) {
        ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmUser/tmUserSearchMain");
        view.addObject("extendTableName", (Object)Globals.TABLE_USER);
        view.addObject("vo", (Object)tmUserVo);
        if (StringUtil.isEmpty(searchUrl)) {
            searchUrl = "tmUserController.do?findTmUserBySearchList";
        }
        view.addObject("searchUrl", (Object)searchUrl);
        view.addObject("singleSelect", (Object)singleSelect);
        return view;
    }

    @RequestMapping(params={"saveTmUser"})
    @ResponseBody
    public AjaxJson saveTmUser(TmUserVo tmUserVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        EuPage page = new EuPage(request);
        try {
            tmUserVo.setUserType(Globals.ENTERPRISE_USER);
            this.tmUserService.saveTmUser(tmUserVo, page);
            this.redisService.set("NO_OPERATION_VERSION_", UUID.randomUUID().toString().replaceAll("-", ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"deleteTmUser"})
    @ResponseBody
    public AjaxJson deleteTmUser(String ids, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tmUserService.deleteTmUser(ids, this.page);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(params={"deleteLockTmUser"})
    @ResponseBody
    public AjaxJson deleteLockTmUser(String ids, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tmUserService.deleteLockTmUser(ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(params={"valideTmUser"})
    @ResponseBody
    public ValidForm valideTmUser(TmUserVo tmUserVo, HttpServletRequest request) {
        ValidForm validForm = new ValidForm();
        String param = OConvertUtils.getString(request.getParameter("param"));
        try {
            validForm = this.tmUserService.valideTmUser(tmUserVo, param);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u9a8c\u8bc1\u7528\u6237\u5f02\u5e38");
        }
        return validForm;
    }

    @RequestMapping(params={"startOrStopTmuser"})
    @ResponseBody
    public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
        AjaxJson json = new AjaxJson();
        try {
            json = this.tmUserService.startOrStopTmuser(tmUserVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return json;
    }

    @RequestMapping(params={"goChangeTmUserPassword"})
    public ModelAndView goChangeTmUserPassword(HttpServletRequest request) {
        String passwordDataType = ResourceUtil.getSysConfigProperty("passwordDataType");
        String passwordErrorMsg = ResourceUtil.getSysConfigProperty("passwordErrorMsg");
        if (StringUtil.isBlank((String)passwordDataType)) {
            passwordDataType = "/^[a-zA-Z0-9_\\x21-\\x7e]{6,20}$/";
        }
        if (StringUtil.isBlank((String)passwordErrorMsg)) {
            passwordErrorMsg = "\u53ea\u80fd\u586b\u5199\u957f\u5ea6\u4e3a6~20\uff0c\u5b57\u7b26\u7c7b\u578b\uff08\u82f1\u6587\u3001\u6570\u5b57\u3001\u6807\u70b9\u7b26\u53f7\u3001\u7279\u6b8a\u5b57\u7b26\uff09";
        }
        request.setAttribute("passwordDataType", (Object)passwordDataType);
        request.setAttribute("passwordErrorMsg", (Object)passwordErrorMsg);
        return new ModelAndView("com/biz/eisp/mdm/tmUser/changeTmPassword");
    }

    @RequestMapping(params={"goFirstChangeTmUserPassword"})
    public ModelAndView goFirstChangeTmUserPassword(TmUserVo tmUserVo) {
        String passwordDataType = ResourceUtil.getSysConfigProperty("passwordDataType");
        String passwordErrorMsg = ResourceUtil.getSysConfigProperty("passwordErrorMsg");
        if (StringUtil.isBlank((String)passwordDataType)) {
            passwordDataType = "/^[a-zA-Z0-9_\\x21-\\x7e]{6,20}$/";
        }
        if (StringUtil.isBlank((String)passwordErrorMsg)) {
            passwordErrorMsg = "\u53ea\u80fd\u586b\u5199\u957f\u5ea6\u4e3a6~20\uff0c\u5b57\u7b26\u7c7b\u578b\uff08\u82f1\u6587\u3001\u6570\u5b57\u3001\u6807\u70b9\u7b26\u53f7\u3001\u7279\u6b8a\u5b57\u7b26\uff09";
        }
        ModelAndView view = new ModelAndView("login/loginFirstChangeTmPassword");
        view.addObject("tmUserVo", (Object)tmUserVo);
        view.addObject("passwordDataType", (Object)passwordDataType);
        view.addObject("passwordErrorMsg", (Object)passwordErrorMsg);
        return view;
    }

    @RequestMapping(params={"changeTmPassword"})
    @ResponseBody
    public AjaxJson changeTmPassword(HttpServletRequest request, TmUserVo tmUserVo) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmUserService.changeTmuserPassword(tmUserVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"changeFirstTmPassword"})
    @ResponseBody
    public AjaxJson changeFirstTmPassword(HttpServletRequest request, TmUserVo tmUserVo) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmUserService.changeFirstTmPassword(tmUserVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        tmUserVo.setUserType(Globals.ENTERPRISE_USER);
        List<TmUserVo> tmUserVoList = this.tmUserService.findTmUserList(tmUserVo, null);
        this.doExportXls(response, request, tmUserVoList, TmUserVo.class, "\u4f01\u4e1a\u7528\u6237\u5217\u8868");
    }
}

