/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.authobj.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.authobj.entity.TmFunAuthEntity;
import com.biz.eisp.mdm.authobj.entity.TmRoleFuncAuthobjEntity;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.role.entity.TmRoleFunctionEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmFunAuthService")
@Transactional
public class TmFunAuthServiceImpl
extends BaseServiceImpl
implements TmFunAuthService {
    public List<TmFunAuthEntity> getTmFunAuthList(String functionId) {
        return this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", (Object)functionId);
    }

    public List<KnlDictDataEntity> getTmDictData(String dictTypeValue, String authObj) {
        Map dataMap = DictUtil.getDictMap((String)dictTypeValue);
        ArrayList<KnlDictDataEntity> dictDataList = new ArrayList<KnlDictDataEntity>();
        if (dataMap != null && dataMap.size() > 0 && dataMap != null && dataMap.size() > 0) {
            dataMap.forEach((k, v) -> {
                KnlDictDataEntity entity = (KnlDictDataEntity)v;
                dictDataList.add(entity);
            });
        }
        return dictDataList;
    }

    public void saveFunAuth(TmFunctionAuthVo funAuth) {
        String functionId = funAuth.getTmFunction().getId();
        String authobj = funAuth.getAuthobj();
        List authList = this.findByProperty(TmFunAuthEntity.class, "tmFunction.id", (Object)functionId);
        this.deleteAllEntity((Collection)authList);
        if (StringUtil.isNotEmpty((String)authobj)) {
            String[] authObjs = authobj.split(",");
            StringBuffer bufs = new StringBuffer();
            for (String auth : authObjs) {
                String hql;
                TmFunAuthEntity tmFunAuth;
                if (bufs.length() > 0) {
                    bufs.append(",");
                }
                if ((tmFunAuth = (TmFunAuthEntity)this.getUniqueByHql(TmFunAuthEntity.class, hql = "from TmFunAuthEntity where tmFunction.id=? and authobj=?", new Object[]{functionId, auth})) == null || StringUtil.isEmpty((String)tmFunAuth.getId())) {
                    tmFunAuth = new TmFunAuthEntity();
                    tmFunAuth.setAuthobj(auth);
                    tmFunAuth.setTmFunction(funAuth.getTmFunction());
                    this.save((Object)tmFunAuth);
                    continue;
                }
                bufs.append("'").append(auth).append("'");
            }
            String sql = "DELETE FROM TM_R_ROLE_FUNC_AUTHOBJ WHERE ROLE_FUNCTION_ID IN (SELECT TF.ID FROM TM_R_ROLE_FUNCTION TF WHERE TF.FUNCTION_ID=?) AND AUTHOBJ NOT IN(?)";
            this.executeSql(sql, new Object[]{functionId, bufs.toString()});
        }
    }

    public List<TmFunAuthEntity> getTmFunAuthListByRoleFunc(String roleId, String funcId) {
        TmRoleFunctionEntity tmRoleFunctionEntity;
        List Authobjs;
        SimpleExpression funcCrt;
        HashSet<String> authObjCodes = new HashSet<String>();
        ArrayList<TmFunAuthEntity> funAuths = new ArrayList<TmFunAuthEntity>();
        SimpleExpression roleCrt = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        List roleFuncs = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{roleCrt, funcCrt = Restrictions.eq((String)"tmFunction.id", (Object)funcId)});
        if (StringUtil.isNotEmpty((Object)roleFuncs) && roleFuncs.size() > 0 && StringUtil.isNotEmpty((Object)(Authobjs = this.findByProperty(TmRoleFuncAuthobjEntity.class, "tmRoleFunction.id", (Object)(tmRoleFunctionEntity = (TmRoleFunctionEntity)roleFuncs.get(0)).getId()))) && Authobjs.size() > 0) {
            for (TmRoleFuncAuthobjEntity authObj : Authobjs) {
                authObjCodes.add(authObj.getAuthobj());
            }
            Criterion authCrt = Restrictions.in((String)"authobj", (Object[])authObjCodes.toArray());
            funAuths.addAll(this.findByCriteria(TmFunAuthEntity.class, new Criterion[]{authCrt}));
        }
        return funAuths;
    }

    public List<KnlDictDataEntity> getTmFunAuthValueByRoleFunc(String roleId, String funcId, String authObj) {
        TmRoleFunctionEntity functionEntity = null;
        ArrayList<KnlDictDataEntity> dictDatas = new ArrayList();
        List dictDatasParent = DictUtil.getDictList((String)"authobj");
        String parentId = "";
        if (CollectionUtil.listNotEmptyNotSizeZero((List)dictDatasParent)) {
            for (KnlDictDataEntity entity : dictDatasParent) {
                if (!StringUtil.equals((String)entity.getDictCode(), (String)authObj)) continue;
                parentId = entity.getId();
                break;
            }
        }
        if (StringUtil.isNotEmpty((String)parentId)) {
            dictDatas = DictUtil.getDictByParentId((String)parentId);
        }
        SimpleExpression cr1 = Restrictions.eq((String)"tmRole.id", (Object)roleId);
        SimpleExpression cr2 = Restrictions.eq((String)"tmFunction.id", (Object)funcId);
        List functionEntitys = this.findByCriteria(TmRoleFunctionEntity.class, new Criterion[]{cr1, cr2});
        if (!CollectionUtils.isEmpty((Collection)functionEntitys)) {
            functionEntity = (TmRoleFunctionEntity)functionEntitys.get(0);
        }
        String hql = "from TmRoleFuncAuthobjEntity where tmRoleFunction.id=? and authobj=?";
        List authobjVlues = this.findByHql(hql, new Object[]{functionEntity.getId(), authObj});
        Map<Object, Object> auMap = new HashMap();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjVlues)) {
            auMap = authobjVlues.stream().filter(dd -> StringUtil.isNotEmpty((String)dd.getAuthobjValue())).collect(Collectors.groupingBy(TmRoleFuncAuthobjEntity::getAuthobjValue));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
            HashMap finalAuMap = auMap;
            dictDatas.stream().filter(dt -> finalAuMap.containsKey(dt.getDictCode())).forEach(authobjEntity -> authobjEntity.setStatus(Globals.ZERO));
        }
        return dictDatas;
    }

    public void saveFunAuthValue(String roleId, String funcId, String authObj, String authCodes) {
        String hql = "from TmRoleFunctionEntity where tmRole.id=? and tmFunction.id=?";
        List roleFuncs = this.findByHql(hql, new Object[]{roleId, funcId});
        if (!CollectionUtils.isEmpty((Collection)roleFuncs) && roleFuncs.size() > 0) {
            TmRoleFunctionEntity roleFunctionEntity = (TmRoleFunctionEntity)roleFuncs.get(0);
            String sql = "delete from tm_r_role_func_authobj where role_function_id=? and authobj=?";
            this.executeSql(sql, new Object[]{roleFunctionEntity.getId(), authObj});
            TmRoleFuncAuthobjEntity authobjEntity = null;
            if (StringUtil.isNotEmpty((String)authCodes)) {
                for (String authCode : authCodes.split(",")) {
                    authobjEntity = new TmRoleFuncAuthobjEntity();
                    authobjEntity.setTmRoleFunction(roleFunctionEntity);
                    authobjEntity.setAuthobj(authObj);
                    authobjEntity.setAuthobjValue(authCode);
                    this.save((Object)authobjEntity);
                }
            }
        }
    }
}

