/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.timeTask.service;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.mdm.timeTask.util.QuartzManagerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.quartz.CronTrigger;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="dynamicTask")
public class DynamicTask {
    private static final Logger logger = LoggerFactory.getLogger(DynamicTask.class);
    @Resource
    private StdScheduler schedulerFactory;

    public boolean startOrStop(String triggerName, boolean start) {
        try {
            CronTrigger trigger = (CronTrigger)this.getTrigger(triggerName, "DEFAULT");
            if (start) {
                this.schedulerFactory.resumeTrigger(trigger.getKey());
                logger.info("trigger the start successfully!!");
            } else {
                this.schedulerFactory.pauseTrigger(trigger.getKey());
                logger.info("trigger the pause successfully!!");
            }
            return true;
        }
        catch (SchedulerException e) {
            logger.error("Fail to reschedule. " + (Object)((Object)e));
            return false;
        }
    }

    public boolean updateCronExpression(String triggerName, String cronExpression) {
        try {
            CronTrigger trigger = (CronTrigger)this.getTrigger(triggerName, "DEFAULT");
            if (trigger == null) {
                return false;
            }
            if (StringUtils.equals((String)trigger.getCronExpression(), (String)cronExpression)) {
                logger.info("\u4e0e\u5f53\u524d\u8fd0\u884c\u4efb\u52a1\u7684\u89e6\u53d1\u5668\u8868\u8fbe\u5f0f\u4e00\u81f4\uff0c\u65e0\u9700\u4fee\u6539.");
                return true;
            }
            QuartzManagerUtil.changeCronExpByName((String)triggerName, (String)cronExpression);
            DynamicTask.updateSpringMvcTaskXML((CronTrigger)trigger, (String)cronExpression);
            logger.info("\u4fee\u6539\u89e6\u53d1\u5668\u8868\u8fbe\u5f0f\u6210\u529f!!");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u89e6\u53d1\u5668\u8868\u8fbe\u5f0f\u4fee\u6539\u5931\u8d25. " + e);
            return false;
        }
    }

    private Trigger getTrigger(String triggerName, String groupName) {
        Trigger trigger;
        block6: {
            trigger = null;
            if (StringUtils.isBlank((String)groupName)) {
                logger.warn("Schedule Job Group is empty!");
                return null;
            }
            if (StringUtils.isBlank((String)triggerName)) {
                logger.warn("Schedule trigger Name is empty!");
                return null;
            }
            try {
                Set triggerKeys = this.schedulerFactory.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)groupName));
                if (triggerKeys == null || triggerKeys.size() <= 0) break block6;
                for (TriggerKey triggerKey : triggerKeys) {
                    if (!StringUtil.isNotBlank((String)triggerKey.getName()) || !triggerKey.getName().equals(triggerName)) continue;
                    trigger = this.schedulerFactory.getTrigger(triggerKey);
                    break;
                }
            }
            catch (SchedulerException e) {
                logger.warn("Fail to get the trigger (triggerName: " + triggerName + ", groupName : " + groupName + ")");
                return null;
            }
        }
        if (trigger == null) {
            logger.warn("Can not found the trigger of triggerName: " + triggerName + ", groupName : " + groupName);
        }
        return trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void updateSpringMvcTaskXML(CronTrigger trigger, String cronExpression) {
        Document document = null;
        File file = null;
        SAXReader saxReader = new SAXReader();
        try {
            URI url = DynamicTask.class.getClassLoader().getResource("spring/spring-quartz.xml").toURI();
            file = new File(url.getPath());
            document = saxReader.read((InputStream)new FileInputStream(file));
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u7cfb\u7edf\u4e2d\u7528\u5230\u7684SQL \u8bed\u53e5XML\u51fa\u9519");
            throw new RuntimeException("---------\u8bfb\u53d6spring-quartz.xml\u6587\u4ef6\u51fa\u9519:" + e.getMessage());
        }
        Element root = document.getRootElement();
        List beans = root.elements();
        block13: for (Element bean : beans) {
            if (bean.attribute("id") == null || !bean.attribute("id").getValue().equals(trigger.getKey().getName())) continue;
            beans = bean.elements();
            for (Element temp : beans) {
                if (temp.attribute("name") == null || !temp.attribute("name").getValue().equals("cronExpression")) continue;
                temp.attribute("value").setValue(cronExpression);
                break block13;
            }
        }
        XMLWriter fileWriter = null;
        try {
            OutputFormat xmlFormat = OutputFormat.createPrettyPrint();
            xmlFormat.setEncoding("utf-8");
            fileWriter = new XMLWriter((OutputStream)new FileOutputStream(file), xmlFormat);
            fileWriter.write(document);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

