/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.web.system.service.impl;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.web.system.dao.MutiLangDao;
import com.biz.eisp.mdm.web.system.entity.MutiLangEntity;
import com.biz.eisp.mdm.web.system.service.MutiLangServiceI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mutiLangService")
@Transactional
public class MutiLangServiceImpl
extends BaseServiceImpl
implements MutiLangServiceI {
    @Autowired(required=false)
    private HttpServletRequest request;
    @Autowired
    private MutiLangDao mutiLangDao;

    public void initAllMutiLang() {
        List mutiLangList = this.loadAll(MutiLangEntity.class);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)mutiLangList)) {
            RedisService redisService = RedisUtils.getRedisService();
            for (MutiLangEntity mutiLang : mutiLangList) {
                String key = "MUTI_LANG_" + mutiLang.getLangCode() + "_" + mutiLang.getLangKey();
                String value = mutiLang.getLangContext();
                if (redisService.hasKey(key)) {
                    redisService.del(new String[]{key});
                }
                try {
                    redisService.setDays(key, (Object)value, 365L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getLang(String langKey) {
        if (StringUtil.isEmpty((String)langKey)) {
            return "";
        }
        String langContext = this.getLang(langKey, null);
        if (StringUtil.isEmpty((String)langContext)) {
            langContext = langKey;
        }
        return langContext;
    }

    public String getLang(String lanKey, String language) {
        String key;
        RedisService redisService;
        Object object;
        String langContext;
        if (StringUtil.isEmpty((String)lanKey)) {
            return lanKey;
        }
        if (StringUtil.isEmpty((String)language)) {
            HttpSession session = ContextHolderUtils.getSession();
            if (null != session) {
                String key2;
                String sessionId = session.getId();
                RedisService redisService2 = RedisUtils.getRedisService();
                if (redisService2.hasKey(key2 = "LANG_CODE_" + sessionId)) {
                    language = redisService2.get(key2).toString();
                } else {
                    language = ResourceUtil.getSysConfigProperty((String)"defaultMutiLang");
                    redisService2.setDays(key2, (Object)language, 30L);
                }
            } else {
                language = ResourceUtil.getSysConfigProperty((String)"defaultMutiLang");
            }
        }
        String string = langContext = (object = (redisService = RedisUtils.getRedisService()).get(key = "MUTI_LANG_" + language + "_" + lanKey)) == null ? "" : object.toString();
        if (StringUtil.isEmpty((String)langContext)) {
            MutiLangEntity mutiLang = new MutiLangEntity();
            mutiLang.setLangCode(language);
            mutiLang.setLangKey(lanKey);
            List mutiLangEntities = this.findMutiLangList(mutiLang);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)mutiLangEntities)) {
                langContext = ((MutiLangEntity)mutiLangEntities.get(0)).getLangContext();
                this.setLang(lanKey, language, langContext);
            }
        }
        if (StringUtil.isEmpty((String)langContext)) {
            langContext = lanKey;
        }
        return langContext;
    }

    public void setLang(String langKey, String langCode, String langContext) {
        if (StringUtil.isNotEmpty((String)langKey) && StringUtil.isNotEmpty((String)langCode) && StringUtil.isNotEmpty((String)langContext)) {
            RedisService redisService = RedisUtils.getRedisService();
            String key = "MUTI_LANG_" + langCode + "_" + langKey;
            String value = langContext;
            try {
                redisService.setDays(key, (Object)value, 365L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setLangCode(String langCode) {
        HttpSession session = ContextHolderUtils.getSession();
        if (null != session) {
            String key;
            String sessionId = session.getId();
            RedisService redisService = RedisUtils.getRedisService();
            if (redisService.hasKey(key = "LANG_CODE_" + sessionId)) {
                redisService.del(new String[]{key});
            }
            if (StringUtil.isEmpty((String)langCode)) {
                langCode = ResourceUtil.getSysConfigProperty((String)"defaultMutiLang");
            }
            redisService.setDays(key, (Object)langCode, 365L);
        }
    }

    public void refleshMutiLangCach() {
        this.initAllMutiLang();
    }

    public List<MutiLangEntity> findDatagridPage(MutiLangEntity mutiLang, Page page) {
        return this.mutiLangDao.findDatagridPage(mutiLang, page);
    }

    public List<MutiLangEntity> findMutiLangList(MutiLangEntity mutiLang) {
        return this.mutiLangDao.findMutiLangList(mutiLang);
    }
}

