<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="system_role_roleList" class="easyui-layout" fit="true">
<div region="center">
    <t:datagrid name="roleList"  actionUrl="taActivitiRoleController.do?findActRoleList"
    				 idField="id" fit="true"  fitColumns="false" queryMode="group">
        <t:dgCol title="主键" field="id" hidden="true"></t:dgCol>
        <t:dgCol title="角色编码" field="roleCode"  width="120" query="true"></t:dgCol>
        <t:dgCol title="角色名称" field="roleName"  width="120" query="true"></t:dgCol>
        <t:dgToolBar title="新增" operationCode="add" icon="icon-add" url="taActivitiRoleController.do?goTaActivitiRoleForm" funname="addRole"></t:dgToolBar>
        <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" url="taActivitiRoleController.do?goTaActivitiRoleForm" funname="updateRole"></t:dgToolBar> 
        <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove"  url="taActivitiRoleController.do?deleteTaActivitiRoleById" funname="deleteById"></t:dgToolBar> 
        <t:dgToolBar title="查看职位" operationCode="previewPos" icon="icon-preview"  url="" funname="findTmPositionByRole"></t:dgToolBar> 
        <t:dgToolBar title="查看流程" operationCode="previewFlow" icon="icon-preview"  url="" funname="findProcessInstance"></t:dgToolBar>
        <t:dgToolBar title="角色-职位关系维护" operationCode="previewMaintain"  icon="icon-preview"  url="" funname="maintainTmPositionByRole"></t:dgToolBar>
        <t:dgToolBar title="角色-职位关系导入" operationCode="actRolePositionImp" icon="icon-dataIn" onclick="importDataByXml({impName:'tmActRolePositionRel', gridName:'actRoleSelectList'})"></t:dgToolBar>
        <t:dgToolBar title="日志" operationCode="log" icon="icon-log" url="tmLogController.do?goTmLogDetailMain" funname="detailLog" width="1200" height ="460"></t:dgToolBar>
    </t:datagrid>
</div>
</div>

<script type="text/javascript">
$(function() {
	var li_east = 0;
});
//删除
function deleteById(){
	var roleTarget = $("#roleList").datagrid('getSelected');
	if(roleTarget==null){
		tip("请至少选择一条数据");
		return;
	}
	$.messager.confirm('操作提示',"确定删除数据吗?",function(r){ 
	    if (r){
	    	$.ajax({
	        	type : "POST",
	        	url : "taActivitiRoleController.do?deleteTaActivitiRoleById",
	        	data : {
	            	"id" : roleTarget.id,
	        	},
	        	dataType : "json",
	        	success : function(data) {
	        		tip(data.msg);
	        		$("#roleList").datagrid('reload');
	        	},
	        	error:function(){
	        		tip("服务器异常，请稍后再试");
	        	}
		   });
	    }
	});
}

function addRole(title,url, id) {
	add(title,url,'roleList');
}

function updateRole(title,url, id) {
	var rowData = $('#'+id).datagrid('getSelected');
	if (rowData) {
		url += '&id='+rowData.id;
	}
	add(title,url,'roleList');
}

//查询职位
function findTmPositionByRole(){
	var rowData = $("#roleList").datagrid('getSelected');
	if (rowData=="" || rowData==null) {
		tip("请选择一条角色数据");
		return false;
	}
	var roleCode = rowData.roleCode;
	openwindow("相关职位", "taActivitiRoleController.do?goTmPositionByRoleMain&roleCode="+roleCode, "tmPositionByRole", 1000, 500);
}
//查看流程
function findProcessInstance(){
	var rowData = $("#roleList").datagrid('getSelected');
	if (rowData=="" || rowData==null) {
		tip("请选择一条角色数据");
		return false;
	}
	var roleId = rowData.id;
	openwindow("查看流程", "taActivitiRoleController.do?goTaProcessDefinitionMain&id="+roleId, "taProcessDefinition", 1000, 500);
}

//角色-职位关系维护
function maintainTmPositionByRole(){
    var rowData = $("#roleList").datagrid('getSelected');
    if (rowData=="" || rowData==null) {
        tip("请选择一条角色数据");
        return false;
    }
    var roleId = rowData.id;
    openwindow("角色-职位关系维护", "tmPositionController.do?goTmMaintainPositionByActRoleMain&roleIds="+roleId, "roleList", 900, 600);
}
</script>

