<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<t:datagrid actionUrl="tmProductPriceController.do?findProductPriceMainGrid" name="productPriceList" queryMode="group">
    <t:dgCol field="id" title="主键" sortable="false" hidden="true"></t:dgCol>
    <t:dgCol field="priceType" title="价格类型" sortable="true" query="true" dictionary="price_type"></t:dgCol>
    <t:dgCol field="priceDimension" title="价格维度" sortable="true" query="true" dictionary="price_dimension"></t:dgCol>
    <t:dgCol field="pricePriority" title="价格优先级" sortable="true" ></t:dgCol>
    <t:dgCol field="productInfoCode" title="产品编码" sortable="true" query="true"></t:dgCol>
    <t:dgCol field="productInfoName" title="产品名称" sortable="true" query="true"></t:dgCol>
    <t:dgCol field="saleCompany" title="销售公司" sortable="true" dictionary="company_code"></t:dgCol>
    <t:dgCol field="priceGroup" title="价格组"  sortable="true" dictionary="price_group"></t:dgCol>
    <t:dgCol field="customerName" title="客户"  sortable="true" ></t:dgCol>
    <t:dgCol field="terminalName" title="门店"  sortable="true" ></t:dgCol>
    <t:dgCol field="saleUnit" title="销售单位"  sortable="true" dictionary="sale_unit"></t:dgCol>
    <t:dgCol field="unitPrice" title="单价"  sortable="true" ></t:dgCol>
    <t:dgCol field="priceCurrency" title="价格币种"  sortable="true" dictionary="price_currency"></t:dgCol>
    <t:dgCol field="beginTime" title="有效期开始"  sortable="true" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
    <t:dgCol field="endTime" title="有效期结束"  sortable="true" formatter="yyyy-MM-dd hh:mm:ss"></t:dgCol>
    <t:dgCol field="deleteStatus" title="删除标记"  sortable="true" dictionary = "is_no"></t:dgCol>
    <t:dgToolBar title="新增" operationCode="add" url="tmProductPriceController.do?goSaveOrUpdateForm" icon="icon-add" funname="add" width="380" height="400"></t:dgToolBar>
    <t:dgToolBar title="编辑" operationCode="edit" url="tmProductPriceController.do?goSaveOrUpdateForm" icon="icon-edit" funname="update" width="380" height="400"></t:dgToolBar>
    <t:dgToolBar title="查看" operationCode="look" url="tmProductPriceController.do?goSaveOrUpdateForm" icon="icon-edit" funname="detail"></t:dgToolBar>
    <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmProductPrice', gridName:'productPriceList'})" ></t:dgToolBar>
    <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmProductPriceController.do?delProductPrice" funname="deleteALLSelect3"></t:dgToolBar>
</t:datagrid>
<script>

    //删除
    function deleteALLSelect3(title, url){
        var rowsData = $('#productPriceList').datagrid('getSelections');
        var rowData = $('#productPriceList').datagrid('getSelected');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择产品价格');
            return;
        }
        if (rowsData.length > 1) {
            tip('请选择一条记录再编辑');
            return;
        }
        var ids = [];
        var rows = $('#productPriceList').datagrid('getSelections');
        if(rows.length > 0){
            $.dialog.confirm('是否删除选中数据？',function(r){
                if(r){
                    for(var i = 0; i < rows.length; i++){
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url:url,
                        type:'post',
                        data:{
                            ids:ids.join(',')
                        },
                        cache:false,
                        success:function(data){
                            var d = data;
                            var msg = d.msg;
                            if(d.success){
                                tip(msg);
                                for(var i = 0;i<rows.length ;i++){
                                    var index = $('#productPriceList').datagrid('getRowIndex',rows[i]);
                                    $("#productPriceList").datagrid('deleteRow',index);
                                }
                                ids='';
                            }else{
                                tip(msg);
                                return;
                            }
                        }
                    });
                }
            });
        }else{
            tip("请选择要删除的数据！");
        }
    }
</script>