<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<!DOCTYPE html >
<html>
<head>
    <title>${maintitle}</title>
    <t:base type="jquery,easyui,tools,DatePicker,autocomplete"></t:base>
    <link rel="shortcut icon" href="resources/fc/images/icon/favicon.png">
    <style>
        .biz-menu-collapse{
            position: absolute;
            left: 163px;
            top: 21px;
        }
        .biz-menu-collapse span{
            color: #ffffff;
        }
    </style>
</head>
<body class="easyui-layout" style="overflow-y: hidden" scroll="no">
<!-- 顶部-->
<div region="north" split="false" border="false" class="biz-header">
    <div class="header-logo">
        <img alt="" src="resources/login/images/logo.png">
        <div class="biz-menu-collapse" onclick="collapseMenu(this)">
            <span class="fa fa-reorder"></span>
        </div>
    </div>
</div>
<!-- 左侧-->
<div region="west" split="false" border="false" class="biz-menu">
    <div id="center_border_add" class="easyui-layout" style="height: 100%;" scroll="no">
        <div id="asideMenu" region="center" split="false" border="false" href="loginController.do?left">

        </div>
    </div>
</div>
<!-- 中间-->
<div region="center" split="false" border="false" class="biz-container">
    <div id="maintabs" class="main-tabs" fit="true" border="false">
        <div class="easyui-tab" title="首页" href="loginController.do?home" style="overflow: hidden;"></div>
    </div>
</div>


<div class="mainExit">
    <div class="biz-sys-toolbar">
        <a href="javascript:void(0);" class="easyui-menubutton" menu="#layout_north_userMenu" plain="true">
            <span class="fa fa-user"></span>
        </a>
        <a href="javascript:void(0);" class="easyui-menubutton" menu="#layout_north_kzmbMenu" plain="true">
            <span class="fa fa-cog"></span>
        </a>
        <a class="separatoor-line"></a>
        <a href="javascript:void(0);" class="easyui-menubutton" menu=""
           onclick="exit('loginController.do?logout','确认退出系统吗？',1);">
            <span class="fa fa-power-off"></span>
        </a>
    </div>

    <div id="layout_north_userMenu" style="width: 200px; display: none;">
        <div>用户名:${userVo.fullName }</div>
        <div>登录账号:${userVo.userName }</div>
        <c:if test="${userVo.userType eq 0}">
            <div class="menu-sep"></div>
            <div>组织:${userVo.orgName }</div>
            <div class="menu-sep"></div>
            <div>当前职位:${userVo.positionName }</div>
        </c:if>
        <c:if test="${userVo.userType eq 1}">
            <div class="menu-sep"></div>
            <div>关联客户:${userVo.custName }</div>
        </c:if>
    </div>
    <div id="layout_north_kzmbMenu" style="width: 100px; display: none;">
        <div id="changePassWordDiv" onclick="add('修改密码','tmUserController.do?goChangeTmUserPassword')">修改密码</div>
        <div class="menu-sep"></div>
        <div id="changePosWordDiv" onclick="add('切换职位','tmPositionController.do?goChangeTmPosition')">切换职位</div>
    </div>
</div>

<div id="mm" class="easyui-menu" style="width: 150px;">
    <div id="mm-tabupdate">刷新</div>
    <div id="mm-tabclose">关闭</div>
    <div id="mm-tabcloseall">关闭所有</div>
    <div id="mm-tabcloseother">关闭除此之外的选项</div>
    <div class="menu-sep"></div>
    <div id="mm-tabcloseright">关闭右边</div>
    <div id="mm-tabcloseleft">关闭左边</div>
</div>
<script type="text/javascript" src="resources/newLeftStyle/js/fenster.js"></script>

<script type="text/javascript">

    $(function () {
        //折叠菜单hover显示
        $("#asideMenu").on('mouseover', 'li', function () {
            var collapseStatus = $("#asideMenu").attr("collapse");
            if (collapseStatus === "collapsed") {
                console.dir($(this)[0])
                var top = $(this)[0].offsetTop+60;
                var left = $(this)[0].offsetWidth;
                var ulHtml = $(this).find("ul").html();
                var hoverCollapseMenu = $("<ul>").addClass("hover-collapse-menu").css({
                    display:"block",
                    position: "absolute",
                    left: "40px",
                    top: top,
                    zIndex: 999,
                    width:"150px",
                    "min-height":"40px",
                    "max-height":"240px",
                    overflow:"auto"
                }).append(ulHtml);
                if($("body").find(".hover-collapse-menu").length>0){
                    $("body").find(".hover-collapse-menu").remove();
                }
                $("body").append(hoverCollapseMenu.prop("outerHTML"));
                $(".hover-collapse-menu").mouseleave(function () {
                    $(this).remove();
                })
            }
        });

        $(".biz-menu-collapse").mouseenter(function () {
            $("body").find(".hover-collapse-menu").remove();
        });

        setInterval("exitBtn()", 500);
        setTimeout(function () {
            setContainerStyle()
        }, 50);
        $(window).resize(function () {
            setTimeout(function () {
                setContainerStyle()
            }, 500);
        });

        //初始化socket
        var socketOptions = {url: '${userWebsocketUrl}'};
        var socket = BizSocket(socketOptions);
        if (socket) {
            socket.onopen = function (ev) {
            };
            socket.onmessage = function (ev) {
                var data = ev.data;
                tip(data);
            };

            socket.onerror = function (ev) {

            };

            socket.onclose = function (ev) {
                console.log("Closed");
            };
        }
    });

    function collapseMenu(event) {
        if ($(event).hasClass("collapsed")) {
            $(event).removeClass("collapsed");
            $("#asideMenu").attr("collapse", "expand");
            $(".header-logo").find("img").show();
            $(event).css({
                left:'163px'
            });
            $(event).find("span").css("transform",'rotate(0deg)');
            $('body').layout('panel', 'west').panel('resize', {width: 200});
            $('body').layout('resize');
        } else {
            $(event).addClass("collapsed");
            $("#asideMenu").attr("collapse", "collapsed");
            $(".header-logo").find("img").hide();
            $(event).css({
                left:0
            });
            $(event).find("span").css("transform",'rotate(90deg)');
            $('body').layout('panel', 'west').panel('resize', {width: 40});
            $('body').layout('resize');
            //收起菜单
            $(".topnav").accordionAll();
        }
        setContainerStyle()
    }

    function BizSocket(options) {
        var socket = null;
        if (window.location.href.indexOf("http://") > -1) {
            var url = "ws://" + options.url + (options.uuid || '');
            socket = new WebSocket(url);
        } else if (window.location.href.indexOf("https://") > -1) {
            var url = "wss://" + options.url + (options.uuid || '');
            socket = new WebSocket(url);
        }
        return socket;
    }

    function setContainerStyle() {
        var height = document.body.clientHeight;
        $(".biz-menu").find(".panel-body").css("height", $(".biz-menu").height());
        $(".biz-container").find(".panel-body").css("height", height - 80);
        $(".biz-container").find(".tabs-panels").css("height", height - 60);
        $(".biz-container").find(".tabs-container").css("height", height - 10);
        $(".biz-container").css("height", height - 10);
        $(".biz-container").parent().css({
            background: "transparent",
            zIndex: 5,
            top: '10px'
        });
    }

    function exitBtn() {
        if ($("#maintabs").width() == $("#maintabs .tabs-header").width()) {
            $("#maintabs .tabs-header").css("width", ($("#maintabs .tabs-header").width() - 160));
            $(".mainExit").show();
        }
        $(".tabs-wrap").css("width", ($("#maintabs .tabs-header").width() - 40));
    }

    //切换职位之后的回调处理
    function changeBack(data) {
        if (data.success) {
            tip(data.msg);
            window.location.reload();
        } else {
            tip(data.msg);
        }
    }


</script>

</body>
</html>
