/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.xssfilter;

import com.biz.eisp.base.common.util.ResourceUtil;
import com.biz.eisp.base.core.xssfilter.XssHttpServletRequestWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class XssFilter
implements Filter {
    private static boolean IS_INCLUDE_RICH_TEXT = true;
    public List<String> excludes = new ArrayList<String>();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (this.handleExcludeURL(req, resp)) {
            filterChain.doFilter(request, response);
            return;
        }
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request, IS_INCLUDE_RICH_TEXT);
        filterChain.doFilter((ServletRequest)xssRequest, response);
    }

    private boolean handleExcludeURL(HttpServletRequest request, HttpServletResponse response) {
        if (this.excludes == null || this.excludes.isEmpty()) {
            return false;
        }
        String url = request.getServletPath();
        for (String pattern : this.excludes) {
            Pattern p = Pattern.compile("^" + pattern);
            Matcher m = p.matcher(url);
            if (!m.find()) continue;
            return true;
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String temp;
        String isIncludeRichText = ResourceUtil.getSysConfigProperty("xss_isIncludeRichText");
        if (StringUtils.isNotBlank((CharSequence)isIncludeRichText)) {
            IS_INCLUDE_RICH_TEXT = BooleanUtils.toBoolean((String)isIncludeRichText);
        }
        if ((temp = ResourceUtil.getSysConfigProperty("xss_excludes")) != null) {
            String[] url = temp.split(",");
            for (int i = 0; url != null && i < url.length; ++i) {
                this.excludes.add(url[i]);
            }
        }
    }

    public void destroy() {
    }
}

