/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.dic.controller;

import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.mdm.dict.util.DictUtil;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmDictDataController"})
public class TmDictDataController
extends BaseController {
    @RequestMapping(params={"goDictDataGridByTypeMain"}, method={RequestMethod.GET})
    public ModelAndView goDictDataByTypeForm(HttpServletRequest request, String dictTypeCode) {
        request.setAttribute("dictTypeCode", (Object)dictTypeCode);
        return new ModelAndView("com/biz/eisp/mdm/dict/dictGridMain");
    }

    @RequestMapping(params={"findDictDataByType"})
    @ResponseBody
    public DataGrid findDictDataByType(HttpServletRequest request, String dictTypeCode) {
        List<KnlDictDataEntity> voList = DictUtil.getDictList(dictTypeCode);
        if (!CollectionUtils.isEmpty(voList)) {
            voList.forEach(item -> {
                if (StringUtil.isEmpty(item.getId())) {
                    item.setId(UUID.randomUUID().toString());
                }
            });
        }
        DataGrid dataGrid = new DataGrid(voList, null);
        return dataGrid;
    }
}

