/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer;

import com.biz.eisp.base.importer.AbstractHibernateImporter;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.ImpConfigurator;
import com.biz.eisp.base.importer.iterator.DataIterator;
import com.biz.eisp.base.importer.validator.ValidateException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;

public class MultiLevelDataImporter
extends AbstractHibernateImporter {
    private static final String ROW_NUMBER_NAME = "_r_n";
    protected Map<String, Map<String, String>> rowMap = new LinkedHashMap();
    protected Map<String, Map<String, String>> result = new LinkedHashMap();
    protected DataField parentKeyField;
    protected DataField KeyField;
    protected String parentKeyName;
    protected String keyName;
    protected String name;

    public MultiLevelDataImporter(ImpConfigurator conf, Map<String, Object> params) throws Exception {
        super(conf, params);
        this.parentKeyField = conf.getMlParentKey();
        this.KeyField = conf.getMlKey();
        this.parentKeyName = this.parentKeyField.getName();
        this.keyName = this.KeyField.getName();
        if (conf.getEntityClass().getSimpleName().equals("BaseOrg")) {
            this.name = "orgName";
        } else if (conf.getEntityClass().getSimpleName().equals("BaseEmployee")) {
            this.name = "empName";
        } else if (conf.getEntityClass().getSimpleName().equals("BaseDictItem")) {
            this.name = "itemName";
        }
    }

    protected void setIterator(DataIterator iterator) {
        while (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            row.put(ROW_NUMBER_NAME, iterator.getIndex() + "");
            if (iterator.getIndex() >= this.conf.getStartRow()) {
                String key = (String)row.get(this.keyName);
                if (StringUtils.isNotBlank((String)key)) {
                    this.rowMap.put(key, row);
                    continue;
                }
                this.result.put(UUID.randomUUID().toString(), row);
                continue;
            }
            this.result.put(UUID.randomUUID().toString(), row);
        }
        try {
            Iterator iter = this.rowMap.values().iterator();
            while (iter.hasNext()) {
                this.addRow((Map)iter.next(), 0);
            }
        }
        catch (ValidateException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (this.errNum > 0) {
            throw new RuntimeException(this.errors.toString());
        }
        this.iterator = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void addRow(Map<String, String> row, int layer) throws ValidateException {
        if (layer == 10) {
            this.addError("\u4e0a\u7ea7\u5bf9\u8c61\u4e0d\u80fd\u662f\u81ea\u5df1. (\u884c:" + row.get(ROW_NUMBER_NAME) + ")");
            return;
        }
        if (!this.result.containsKey(row.get(this.keyName))) {
            Map parentRow = (Map)this.rowMap.get(row.get(this.parentKeyName));
            if (parentRow != null) {
                this.addRow(parentRow, layer + 1);
            }
            this.result.put(row.get(this.keyName), row);
        }
    }

    protected void save(Object object) {
        if (this.isTest) {
            String key = this.parentKeyField.getCode() + "." + this.eval(new Object[]{object}, "${" + this.KeyField.getCode() + "}");
            this.objcache.put(key, object);
            return;
        }
        if (this.name != null) {
            this.persister.makeSubCode(this.conf.getEntityClass(), object);
            this.persister.save(object);
            this.persister.makeParentInfo(this.conf.getEntityClass(), object, this.name);
        } else {
            super.save(object);
        }
    }
}

