/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.product.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.product.service.TmProductFormExtendService;
import com.biz.eisp.mdm.product.service.TmProductMainExtendService;
import com.biz.eisp.mdm.product.service.TmProductService;
import com.biz.eisp.mdm.product.vo.ProductExcelVo;
import com.biz.eisp.mdm.product.vo.TmProductVo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmProductController"})
public class TmProductController
extends BaseController {
    @Autowired
    TmProductService tmProductService;
    @Autowired(required=false)
    private TmProductFormExtendService tmProductFormExtendService;
    @Autowired(required=false)
    private TmProductMainExtendService tmProductMainExtendService;

    @RequestMapping(params={"goTmProductMain"})
    public ModelAndView goTmProductMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_PRODUCT);
        if (this.tmProductMainExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmProductMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmProduct/tmProductMain");
    }

    @RequestMapping(params={"goProductSearch"})
    public ModelAndView goProductSearch(TmProductVo productVo, String singleSelect, String searchUrl) {
        ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmProduct/tmProductSearchMain");
        view.addObject("extendTableName", (Object)Globals.TABLE_PRODUCT);
        view.addObject("vo", (Object)productVo);
        if (StringUtil.isEmpty((String)searchUrl)) {
            searchUrl = "tmProductController.do?findTmProductDatagridList";
        }
        view.addObject("searchUrl", (Object)searchUrl);
        view.addObject("singleSelect", (Object)singleSelect);
        return view;
    }

    @RequestMapping(params={"goTmProductSelectMain"})
    public ModelAndView goTmProductSelectMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/tmProduct/tmProductSelectMain");
    }

    @RequestMapping(params={"goTmProductAddForm"})
    public ModelAndView goTmProductAddForm(HttpServletRequest request, TmProductVo tmProduct) {
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_PRODUCT);
        if (StringUtil.isNotEmpty((String)tmProduct.getId())) {
            TmProductVo vo = this.tmProductService.getTmProductVo(tmProduct.getId());
            request.setAttribute("pro", (Object)vo);
        }
        if (this.tmProductFormExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmProductFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmProduct/tmProductForm");
    }

    @RequestMapping(params={"findTmProductList"})
    @ResponseBody
    public List<TmProductVo> findTmProductList(HttpServletRequest request, TmProductVo productVo) {
        List voList = this.tmProductService.findTmProductList(productVo);
        return voList;
    }

    @RequestMapping(params={"findTmProductDatagridList"})
    @ResponseBody
    public List<TmProductVo> findTmProductDatagridList(HttpServletRequest request, TmProductVo productVo) {
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((String)productVo.getSearchParam())) {
            productVo.setText(productVo.getSearchParam());
        }
        List voList = this.tmProductService.findTmProductSearchList(productVo, (Page)page);
        return voList;
    }

    @RequestMapping(params={"getProductBySearchList"})
    @ResponseBody
    public AjaxJson getProductBySearchList(HttpServletRequest request, TmProductVo productVo) {
        AjaxJson j = new AjaxJson();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        EuPage page = new EuPage(request);
        try {
            if (StringUtil.isNotEmpty((String)productVo.getSearchParam())) {
                productVo.setText(productVo.getSearchParam());
            }
            List voList = this.tmProductService.findTmProductSearchList(productVo, (Page)page);
            map.put("totle", voList.size());
            j.setObj((Object)voList);
        }
        catch (Exception e) {
            j.setSuccess(false);
            map.put("totle", 0);
            e.printStackTrace();
        }
        j.setAttributes(map);
        return j;
    }

    @RequestMapping(params={"findTmProductComboTree"})
    @ResponseBody
    public List<TmProductVo> findTmProductComboTree(TmProductVo tmProductVo, HttpServletRequest request) {
        List voList = this.tmProductService.findTmProductComboTree(tmProductVo, request.getParameter("selfId"));
        return voList;
    }

    @RequestMapping(params={"findProductSelectGrid"})
    public void findProductSelectGrid(HttpServletRequest request, HttpServletResponse response, ProductExcelVo pro) {
        EuPage page = new EuPage(request);
        List list = this.tmProductService.findProductSelectGrid(request, pro);
        this.datagridReturn(response, list, (Page)page);
    }

    @RequestMapping(params={"getParentProduct"})
    @ResponseBody
    public List<ComboTree> getParentProduct(HttpServletRequest request, ComboTree comboTree, ProductExcelVo pro) {
        String selfId = request.getParameter("selfId");
        return this.tmProductService.getParentProduct(comboTree, pro, selfId);
    }

    @RequestMapping(params={"getParentProducts"})
    @ResponseBody
    public List<ComboTree> getParentProducts(HttpServletRequest request, ComboTree comboTree, ProductExcelVo pro) {
        return this.tmProductService.getParentProducts(comboTree, pro, request);
    }

    @RequestMapping(params={"saveOrUpdateProduct"})
    @ResponseBody
    public AjaxJson saveOrUpdateProduct(HttpServletRequest request, TmProductVo pro) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.tmProductService.saveOrUpdateProduct(pro, (Page)page);
            this.tmProductService.updateIsLeafColumn(Globals.TABLE_PRODUCT);
            HashMap attributes = new HashMap();
            j.setAttributes(attributes);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"delProduct"})
    @ResponseBody
    public AjaxJson delProduct(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmProductService.delProduct(ids);
            this.tmProductService.updateIsLeafColumn(Globals.TABLE_PRODUCT);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        return j;
    }

    @RequestMapping(params={"validateProductName"})
    @ResponseBody
    public ValidForm validateProductName(HttpServletRequest request, ProductExcelVo pro) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        if (StringUtil.isNotEmpty((String)pro.getId())) {
            if (this.tmProductService.validate(pro.getId(), param, "productName")) {
                validForm.setStatus("n");
                validForm.setInfo("\u4ea7\u54c1\u540d\u79f0\u5df2\u5b58\u5728");
            }
        } else if (this.tmProductService.validate(null, param, "productName")) {
            validForm.setStatus("n");
            validForm.setInfo("\u4ea7\u54c1\u540d\u79f0\u5df2\u5b58\u5728");
        }
        return validForm;
    }

    @RequestMapping(params={"validateProductCode"})
    @ResponseBody
    public ValidForm validateProductCode(HttpServletRequest request, ProductExcelVo pro) {
        String param = OConvertUtils.getString((String)request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        if (StringUtil.isNotEmpty((String)pro.getId())) {
            if (this.tmProductService.validate(pro.getId(), param, "productCode")) {
                validForm.setStatus("n");
                validForm.setInfo("\u4ea7\u54c1\u540d\u79f0\u5df2\u5b58\u5728");
            }
        } else if (this.tmProductService.validate(null, param, "productCode")) {
            validForm.setStatus("n");
            validForm.setInfo("\u4ea7\u54c1\u7f16\u7801\u5df2\u5b58\u5728");
        }
        return validForm;
    }

    @RequestMapping(params={"startTmProduct"})
    @ResponseBody
    public AjaxJson startTmProduct(TmProductVo tmProductVo) {
        try {
            tmProductVo.setEnableStatus(Globals.ZERO);
            this.tmProductService.updateProductEnableStatus(tmProductVo);
            return new AjaxJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
    }

    @RequestMapping(params={"stopTmProduct"})
    @ResponseBody
    public AjaxJson stopTmBusinessArea(TmProductVo tmProductVo) {
        try {
            tmProductVo.setEnableStatus(Globals.ONE);
            this.tmProductService.updateProductEnableStatus(tmProductVo);
            return new AjaxJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmProductVo productVo, HttpServletRequest request, HttpServletResponse response) {
        productVo.setExportExcel("true");
        List ProductVoList = this.tmProductService.findTmProductList(productVo);
        this.doExportXls(response, request, (Collection)ProductVoList, TmProductVo.class, "\u4ea7\u54c1\u5c42\u7ea7\u5217\u8868");
    }
}

