<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="system_role_roleList" class="easyui-layout" fit="true">
	<div region="center">
	    <t:datagrid name="roleList"  actionUrl="tMroleController.do?findRoleList" fit="true"
	    			extendTableName="${extendTableName}" idField="id"  fitColumns="false" queryMode="group" onDblClick="onClickExpendPermisson">
	        
	        <t:dgToolBar title="新增" operationCode="add"  icon="icon-add" url="tMroleController.do?goRoleForm&optype=0" funname="addFun"></t:dgToolBar>
	        <t:dgToolBar title="编辑" operationCode="edit"  icon="icon-edit" url="tMroleController.do?goRoleForm&optype=1" funname="update" width="380" height="150"></t:dgToolBar>
	        <t:dgToolBar title="删除" operationCode="remove"  icon="icon-remove"  url="tMroleController.do?delete" funname="deleteById"></t:dgToolBar>
			
			<t:dgToolBar title="启用" operationCode="start"  icon="icon-start" url="tMroleController.do?startOrStopRole" funname="startOrStopRole('009')"></t:dgToolBar>
	        <t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="tMroleController.do?startOrStopRole" funname="startOrStopRole('003')"></t:dgToolBar>
	        <t:dgToolBar title="权限设置" operationCode="setting"  icon="icon-setting"  url="" funname="expendPermisson"></t:dgToolBar>
			<t:dgToolBar title="查询职位" operationCode="preview"  icon="icon-preview"  url="" funname="findTmPositionByRole"></t:dgToolBar>
			<t:dgToolBar title="角色-职位关系维护" operationCode="previewMaintain"  icon="icon-preview"  url="" funname="maintainTmPositionByRole"></t:dgToolBar>
			<t:dgToolBar title="角色-职位关系导入" operationCode="actRolePositionImp" icon="icon-dataIn" onclick="importDataByXml({impName:'tmRolePosition', gridName:'roleList'})"></t:dgToolBar>
			<t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" url="tMroleController.do?exportXls" funname="excelExport"></t:dgToolBar>
			<t:dgToolBar title="日志" operationCode="log"  icon="icon-log" url="tmLogController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
	    </t:datagrid>
	</div>
	<div data-options="region:'east',
		title:'权限列表',
		collapsed:true,
		split:true,
		border:false,
		onExpand : function(){
			li_east = 1;
		},
		onCollapse : function() {
		    li_east = 0;
		}"
		style="width: 600px; overflow: hidden;">
		<div class="easyui-panel" style="padding: 0;" fit="true" border="false" id="PermissonDeatil"></div>
	</div>
</div>

<script type="text/javascript">
$(function() {
	var li_east = 0;
});
//权限列表
function expendPermisson(rowIndex,rowData) {
	var roleTarget = $("#roleList").datagrid('getSelected');
	if(roleTarget==null){
		tip("请选择一条角色数据");
		return;
	}
	if(li_east == 0){
	   $('#system_role_roleList').layout('expand','east'); 
	}
	$('#PermissonDeatil').panel("refresh", "tMroleController.do?goPermSetting&roleId=" +roleTarget.id);
}

function onClickExpendPermisson() {
    var roleTarget = $("#roleList").datagrid('getSelected');
    if(roleTarget==null){
        tip("请选择一条角色数据");
        return;
    }
    if(li_east == 0){
        $('#system_role_roleList').layout('expand','east');
    }
    $('#PermissonDeatil').panel("refresh", "tMroleController.do?goPermSetting&roleId=" +roleTarget.id);
}

//删除
function deleteById(){
	var roleTarget = $("#roleList").datagrid('getSelected');
	if(roleTarget==null){
		tip("请至少选择一条数据");
		return;
	}
	if(roleTarget.roleName=='admin'){
		tip("超级管理员角色不能被删除");
		return false;
	}
	$.messager.confirm('操作提示',"确定删除数据吗?",function(r){ 
	    if (r){
	    	$.ajax({
	        	type : "POST",
	        	url : "tMroleController.do?delete",
	        	data : {
	            	"id" : roleTarget.id,
	        	},
	        	dataType : "json",
	        	success : function(data) {
	        		tip(data.msg);
	        		$("#roleList").datagrid('reload');
	        	},
	        	error:function(){
	        		tip("服务器异常，请稍后再试");
	        	}
		   });
	    }
	});
}

function addFun(title,url, id) {
	var rowData = $('#'+id).datagrid('getSelected');
	if (rowData) {
		url += '&tmFunction.id='+rowData.id;
	}
	add(title,url,'roleList',380,150);
}

//查询职位
function findTmPositionByRole(){
    var rowData = $("#roleList").datagrid('getSelected');
    if (rowData=="" || rowData==null) {
        tip("请选择一条角色数据");
        return false;
    }
    var roleId = rowData.id;
    openwindow("相关职位", "tmPositionController.do?goTmPositionByRoleMain&roleIds="+roleId, "roleList", 700, 500);
}

//角色-职位关系维护
function maintainTmPositionByRole(){
	var rowData = $("#roleList").datagrid('getSelected');
	if (rowData=="" || rowData==null) {
		tip("请选择一条角色数据");
		return false;
	}
	var roleId = rowData.id;
	openwindow("角色-职位关系维护", "tmPositionController.do?goTmMaintainPositionByRoleMain&roleIds="+roleId, "roleList", 900, 600);
}

//停用启用
function startOrStopRole(flag){
	var roleTarget = $("#roleList").datagrid('getSelected');
	if(roleTarget == null){
		tip("请选择一条要操作的数据");
		return;
	}
	var tipmMsg = "";
	if(flag == 0){
		tipmMsg = "确定要启用该数据吗?"
	}else{
		tipmMsg = "确定要停用该数据吗?"
	}
	$.messager.confirm('操作提示',tipmMsg,function(r){ 
	    if (r){
	    	$.ajax({
	        	type : "POST",
	        	url : "tMroleController.do?startOrStopRole",
	        	data : {
	            	"id" : roleTarget.id,
	            	"enableStatus": flag
	        	},
	        	dataType : "json",
	        	success : function(data) {
	        		tip(data.msg);
	        		$("#roleList").datagrid('reload');
	        	},
	        	error:function(){
	        		tip("服务器异常，请稍后再试");
	        	}
		   });
	    }
	});
}
</script>

