<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<t:datagrid actionUrl="tmPositionCategoryRelationController.do?findPositionCategoryRelationMainGrid" name="productInfoList" queryMode="group">
    <t:dgCol field="id" title="主键" sortable="false" hidden="true"></t:dgCol>
    <t:dgCol field="categoriesName" title="活动大类名称" sortable="true" query="true"></t:dgCol>
    <t:dgCol field="categoriesCode" title="活动大类编码" sortable="true"  query="true" ></t:dgCol>
    <t:dgCol field="positionName" title="职位名称" sortable="true" query="true"></t:dgCol>
    <t:dgCol field="positionCode" title="职位编码" sortable="true" query="true"></t:dgCol>
    <t:dgCol title="创建人" field="createName" hidden="true"></t:dgCol>
    <t:dgCol title="创建时间" field="createDate" formatter="yyyy-MM-dd hh:mm:ss" hidden="true"></t:dgCol>
    <t:dgToolBar title="新增" operationCode="add" url="tmPositionCategoryRelationController.do?goSaveOrUpdateForm" icon="icon-add" funname="add" width="380" height="200"></t:dgToolBar>
    <t:dgToolBar title="编辑" operationCode="edit" url="tmPositionCategoryRelationController.do?goSaveOrUpdateForm" icon="icon-edit" funname="update" width="380" height="200"></t:dgToolBar>
    <t:dgToolBar title="查看" operationCode="look" url="tmPositionCategoryRelationController.do?goSaveOrUpdateForm" icon="icon-edit" funname="detail"></t:dgToolBar>
    <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmPositionCategoryRelationController.do?delPositionCategoryRelation" funname="deleteALLSelect3"></t:dgToolBar>
</t:datagrid>

<script>

    //删除
    function deleteALLSelect3(title, url){
        var rowsData = $('#productInfoList').datagrid('getSelections');
        if (rowsData.length > 1) {
            tip('请选择一条记录再编辑');
            return;
        }
        var ids = [];
        var rows = $('#productInfoList').datagrid('getSelections');
        if(rows.length > 0){
            $.dialog.confirm('是否删除选中数据？',function(r){
                if(r){
                    for(var i = 0; i < rows.length; i++){
                        ids.push(rows[i].id);
                    }
                    $.ajax({
                        url:url,
                        type:'post',
                        data:{
                            ids:ids.join(',')
                        },
                        cache:false,
                        success:function(data){
                            var d = data;
                            var msg = d.msg;
                            if(d.success){
                                tip(msg);
                                for(var i = 0;i<rows.length ;i++){
                                    var index = $('#productInfoList').datagrid('getRowIndex',rows[i]);
                                    $("#productInfoList").datagrid('deleteRow',index);
                                }
                                ids='';
                            }else{
                                tip(msg);
                                return;
                            }
                        }
                    });
                }
            });
        }else{
            tip("请选择要删除的数据！");
        }
    }
</script>