/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.util;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.tag.bean.DataGridColumn;
import com.biz.eisp.base.common.tag.params.FormMdmParams;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.bean.JoinTableConfig;
import com.biz.eisp.mdm.config.bean.SelectColumnConfig;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.service.DynamicConditionService;
import com.biz.eisp.mdm.config.service.DynamicDataGridColumnService;
import com.biz.eisp.mdm.config.service.DynamicFormFieldService;
import com.biz.eisp.mdm.config.service.DynamicImportDataFieldService;
import com.biz.eisp.mdm.config.service.DynamicJoinTableService;
import com.biz.eisp.mdm.config.service.DynamicSelectColumnService;
import com.biz.eisp.mdm.config.service.DynamicTableNameService;
import com.biz.eisp.mdm.config.service.TmTableConfigService;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicConditionServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicDataGridColumnServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicFormFieldServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicImportDataFieldServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicJoinTableServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicSelectColumnServiceImpl;
import com.biz.eisp.mdm.config.service.impl.DefaultDynamicTableNameServiceImpl;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang3.StringUtils;

public class DynamicConfigUtil {
    public static final String OrderColumn = "columnOrder";
    public static final String FormOrder = "formOrder";
    private static DynamicConfigUtil dynamicConfigUtil = null;
    public static Map<String, Map<String, TmMdmTableConfigEntity>> allTableConfigEntity = new HashMap<String, Map<String, TmMdmTableConfigEntity>>();
    public static Map<String, Map<String, String>> allTableConfigField = new HashMap<String, Map<String, String>>();
    public static Map<String, Map<String, String>> allTableConfigColumn = new HashMap<String, Map<String, String>>();
    public static Map<String, Map<String, String>> allTableConfigDictColumn = new HashMap<String, Map<String, String>>();
    public static Map<String, TmMdmTableConfigEntity> allTableConfigByField = new HashMap<String, TmMdmTableConfigEntity>();
    public static Map<String, List<TmMdmTableConfigEntity>> allTableConfig = new HashMap<String, List<TmMdmTableConfigEntity>>();
    public static Map<String, List<TmMdmTableConfigEntity>> allTableConfigImpColumn = new HashMap<String, List<TmMdmTableConfigEntity>>();
    private DynamicSelectColumnService dynamicSelectColumnService;
    private DynamicConditionService dynamicConditionService;
    private DynamicTableNameService dynamicTableNameService;
    private DynamicJoinTableService dynamicJoinTableService;
    private DynamicDataGridColumnService dynamicDataGridColumnService;
    private DynamicFormFieldService dynamicFormFieldService;
    private DynamicImportDataFieldService dynamicImportDataFieldService;

    private DynamicConfigUtil() {
    }

    private static synchronized void syncInit() {
        if (dynamicConfigUtil == null) {
            dynamicConfigUtil = new DynamicConfigUtil();
        }
    }

    public static DynamicConfigUtil getInstance() {
        if (dynamicConfigUtil == null) {
            DynamicConfigUtil.syncInit();
        }
        return dynamicConfigUtil;
    }

    public List<TmMdmTableConfigEntity> getTmMdmTableConfigList(String tableName, String orderColumn) {
        List<TmMdmTableConfigEntity> tableConfigList = allTableConfig.get(tableName.toLowerCase());
        if (CollectionUtil.listEmpty(tableConfigList)) {
            TmTableConfigService tmTableConfigService = (TmTableConfigService)ApplicationContextUtils.getContext().getBean("tmTableConfigServiceImpl");
            tableConfigList = tmTableConfigService.getColumnsByTableName(tableName, orderColumn);
        }
        if (CollectionUtil.listEmpty(tableConfigList)) {
            throw new BusinessException("\u672a\u627e\u5230\u8868\uff1a" + tableName + "\u7684\u914d\u7f6e\u4fe1\u606f");
        }
        return tableConfigList;
    }

    public String buildQuerySql(String tableName, Object businessVo) {
        List<SelectColumnConfig> selectColumnConfigList;
        List<TmMdmTableConfigEntity> tableConfigList = this.getTmMdmTableConfigList(tableName, OrderColumn);
        String sqlMain = "SELECT ";
        String sqlWhere = " WHERE 1=1";
        if (this.dynamicSelectColumnService == null) {
            this.dynamicSelectColumnService = new DefaultDynamicSelectColumnServiceImpl();
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(selectColumnConfigList = this.dynamicSelectColumnService.findSelectColumnList(tableConfigList))) {
            for (SelectColumnConfig selectColumn : selectColumnConfigList) {
                sqlMain = sqlMain + selectColumn.getAlias() + "." + selectColumn.getColumnName() + " as " + selectColumn.getPropertyName() + ",";
            }
            sqlMain = sqlMain.substring(0, sqlMain.length() - 1);
        }
        if (this.dynamicTableNameService == null) {
            this.dynamicTableNameService = new DefaultDynamicTableNameServiceImpl();
        }
        tableName = this.dynamicTableNameService.getTableName(tableName, tableConfigList);
        sqlMain = sqlMain + " FROM " + tableName + " t ";
        if (this.dynamicJoinTableService == null) {
            this.dynamicJoinTableService = new DefaultDynamicJoinTableServiceImpl();
        }
        String joinTableSql = " ";
        List<JoinTableConfig> joinTables = this.dynamicJoinTableService.findJoinTableList(tableConfigList);
        if (CollectionUtil.listNotEmptyNotSizeZero(joinTables)) {
            for (JoinTableConfig joinTable : joinTables) {
                String joinTableObj = joinTable.getJoinTable();
                if (joinTableObj.toUpperCase().indexOf("SELECT") != -1) {
                    joinTableObj = "(" + joinTableObj + ")";
                }
                joinTableSql = joinTableSql + joinTable.getJoinType() + joinTableObj + " " + joinTable.getAlias();
                joinTableSql = joinTableSql + " on " + joinTable.getJoinOn() + " ";
            }
        }
        sqlMain = sqlMain + joinTableSql;
        String id = (String)this.getPropertyValue(businessVo, "id");
        if (StringUtil.isNotEmpty((String)id)) {
            sqlWhere = " where t.id='" + id + "'";
        } else {
            if (this.dynamicConditionService == null) {
                this.dynamicConditionService = new DefaultDynamicConditionServiceImpl();
            }
            sqlWhere = sqlWhere + this.dynamicConditionService.findConditionList(businessVo, tableConfigList);
        }
        return sqlMain + sqlWhere;
    }

    public String buildTreeGridQuerySql(String tableName, Object businessVo) {
        List<TmMdmTableConfigEntity> tableConfigList = this.getTmMdmTableConfigList(tableName, OrderColumn);
        String sqlMain = "SELECT DISTINCT ";
        String sqlWhere = " WHERE 1=1";
        if (Globals.TABLE_ORG.equals(tableName)) {
            sqlWhere = sqlWhere + " and t.STATUS = '009' ";
        }
        if (!this.isHaveQuery(tableName, businessVo)) {
            String exportExcel = (String)this.getPropertyValue(businessVo, "exportExcel");
            String id = (String)this.getPropertyValue(businessVo, "id");
            if (StringUtil.isNotEmpty((String)exportExcel) && "false".equals(exportExcel)) {
                sqlWhere = StringUtil.isNotEmpty((String)id) ? sqlWhere + " and t.parent_id = '" + (String)id + "'" : sqlWhere + " and t.parent_id is null";
            }
        }
        if (this.dynamicSelectColumnService == null) {
            this.dynamicSelectColumnService = new DefaultDynamicSelectColumnServiceImpl();
        }
        List<SelectColumnConfig> selectColumnConfigList = this.dynamicSelectColumnService.findSelectColumnList(tableConfigList);
        sqlMain = this.isHaveQuery(tableName, businessVo) ? sqlMain + "'open' as state," : sqlMain + "CASE WHEN t.is_leaf = 1 THEN 'open' ELSE 'closed' END as state,";
        if (CollectionUtil.listNotEmptyNotSizeZero(selectColumnConfigList)) {
            for (SelectColumnConfig selectColumn : selectColumnConfigList) {
                sqlMain = sqlMain + selectColumn.getAlias() + "." + selectColumn.getColumnName() + " as " + selectColumn.getPropertyName() + ",";
            }
            sqlMain = sqlMain.substring(0, sqlMain.length() - 1);
        }
        if (this.dynamicTableNameService == null) {
            this.dynamicTableNameService = new DefaultDynamicTableNameServiceImpl();
        }
        tableName = this.dynamicTableNameService.getTableName(tableName, tableConfigList);
        sqlMain = sqlMain + " FROM " + tableName + " t ";
        if (this.dynamicJoinTableService == null) {
            this.dynamicJoinTableService = new DefaultDynamicJoinTableServiceImpl();
        }
        String joinTableSql = " ";
        List<JoinTableConfig> joinTables = this.dynamicJoinTableService.findJoinTableList(tableConfigList);
        if (CollectionUtil.listNotEmptyNotSizeZero(joinTables)) {
            for (JoinTableConfig joinTable : joinTables) {
                joinTableSql = joinTableSql + joinTable.getJoinType() + joinTable.getJoinTable() + " " + joinTable.getAlias();
                joinTableSql = joinTableSql + " on " + joinTable.getJoinOn() + " ";
            }
        }
        sqlMain = sqlMain + joinTableSql;
        if (this.dynamicConditionService == null) {
            this.dynamicConditionService = new DefaultDynamicConditionServiceImpl();
        }
        sqlWhere = sqlWhere + this.dynamicConditionService.findConditionList(businessVo, tableConfigList);
        return sqlMain + sqlWhere;
    }

    public boolean isHaveQuery(String tableName, Object businessVo) {
        List<TmMdmTableConfigEntity> mdmTableConfigs = allTableConfig.get(tableName.toLowerCase());
        if (CollectionUtil.listNotEmptyNotSizeZero(mdmTableConfigs)) {
            for (TmMdmTableConfigEntity tmMdmTableConfigEntity : mdmTableConfigs) {
                Object queryField;
                if (!Globals.ONE_.equals(tmMdmTableConfigEntity.getQueryStatus()) || !StringUtil.isNotEmpty(queryField = this.getPropertyValue(businessVo, tmMdmTableConfigEntity.getFieldProperty()))) continue;
                return true;
            }
        }
        return false;
    }

    public String appendCustomCondition(String sql, String joinSql, String sqlOn, String sqlWhere, String orderSql) {
        String sqlCondition = "select distinct t.* from (" + sql + ") t ";
        if (StringUtil.isNotEmpty((String)joinSql) && StringUtil.isNotEmpty((String)sqlOn)) {
            sqlCondition = "select distinct t.*,t1.* from (" + sql + ") t ";
            sqlCondition = sqlCondition + "left join (" + joinSql + ") t1 on " + sqlOn;
        }
        if (StringUtil.isNotEmpty((String)sqlWhere)) {
            sqlCondition = sqlCondition + " where 1=1" + sqlWhere;
        }
        return sqlCondition + orderSql;
    }

    public String appendCustomCondition(String sql, String joinSql, String joinType, String sqlOn, String sqlWhere, String orderSql) {
        String sqlCondition = "select distinct t.* from (" + sql + ") t ";
        if (StringUtil.isNotEmpty((String)joinSql) && StringUtil.isNotEmpty((String)sqlOn)) {
            sqlCondition = "select distinct t.*,t1.* from (" + sql + ") t ";
            if (StringUtil.isEmpty(joinType)) {
                joinType = "left join ";
            }
            sqlCondition = sqlCondition + joinType + "(" + joinSql + ") t1 on " + sqlOn;
        }
        if (StringUtil.isNotEmpty((String)sqlWhere)) {
            sqlCondition = sqlCondition + " where 1=1" + sqlWhere;
        }
        return sqlCondition + orderSql;
    }

    public List<DataGridColumn> buildDataGridColumn(String tableName, boolean treegrid) {
        List<TmMdmTableConfigEntity> tableConfigList = this.getTmMdmTableConfigList(tableName, OrderColumn);
        if (this.dynamicDataGridColumnService == null) {
            this.dynamicDataGridColumnService = new DefaultDynamicDataGridColumnServiceImpl();
        }
        return this.dynamicDataGridColumnService.findDataGridColumnList(tableConfigList, treegrid);
    }

    public List<FormMdmParams> buildFormColumn(String tableName, Object businessVo, Integer opttype) {
        List<TmMdmTableConfigEntity> tableConfigList = this.getTmMdmTableConfigList(tableName, FormOrder);
        if (this.dynamicFormFieldService == null) {
            this.dynamicFormFieldService = new DefaultDynamicFormFieldServiceImpl();
        }
        return this.dynamicFormFieldService.findFormFieldList(tableConfigList, businessVo, opttype);
    }

    public List<DataField> buildImportDataFieldList(String tableName) {
        if (this.dynamicImportDataFieldService == null) {
            this.dynamicImportDataFieldService = new DefaultDynamicImportDataFieldServiceImpl();
        }
        List<TmMdmTableConfigEntity> tableConfigList = allTableConfigImpColumn.get(tableName);
        return this.dynamicImportDataFieldService.findImportDataField(tableName, tableConfigList);
    }

    public Object getPropertyValue(Object paramObj, String field) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return null;
        }
        if (paramObj == null) {
            return null;
        }
        Class<?> clazz = paramObj.getClass();
        Field[] fields = paramObj.getClass().getDeclaredFields();
        Object property = null;
        try {
            PropertyDescriptor pd = new PropertyDescriptor(field, clazz);
            Method getMethod = pd.getReadMethod();
            property = getMethod.invoke(paramObj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException(paramObj.getClass().getName() + "\u672a\u627e\u5230\u5c5e\u6027\u5b57\u6bb5\uff1a" + field);
        }
        return property;
    }

    public static void setValueForProperty(Object obj, String field, Object value) {
        Class<?> clazz = obj.getClass();
        Field[] fields = obj.getClass().getDeclaredFields();
        Object property = null;
        try {
            PropertyDescriptor pd = new PropertyDescriptor(field, clazz);
            Class<Object> c = pd.getPropertyType();
            Method setMethod = pd.getWriteMethod();
            if (c.isAssignableFrom(String.class)) {
                value = value.toString();
            }
            if (c.isAssignableFrom(Integer.class)) {
                value = Integer.parseInt((String)value);
            }
            if (c.isAssignableFrom(Date.class)) {
                value = DateUtil.parseDate((String)((String)value));
            }
            setMethod.invoke(obj, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException(obj.getClass().getName() + "\u672a\u627e\u5230\u5c5e\u6027\u5b57\u6bb5\uff1a" + field);
        }
    }

    public void setDynamicSelectColumnService(DynamicSelectColumnService dynamicSelectColumnService) {
        this.dynamicSelectColumnService = dynamicSelectColumnService;
    }

    public void setDynamicConditionService(DynamicConditionService dynamicConditionService) {
        this.dynamicConditionService = dynamicConditionService;
    }

    public void setDynamicTableNameService(DynamicTableNameService dynamicTableNameService) {
        this.dynamicTableNameService = dynamicTableNameService;
    }

    public void setDynamicJoinTableService(DynamicJoinTableService dynamicJoinTableService) {
        this.dynamicJoinTableService = dynamicJoinTableService;
    }

    public void setDynamicDataGridColumnService(DynamicDataGridColumnService dynamicDataGridColumnService) {
        this.dynamicDataGridColumnService = dynamicDataGridColumnService;
    }

    public void setDynamicFormFieldService(DynamicFormFieldService dynamicFormFieldService) {
        this.dynamicFormFieldService = dynamicFormFieldService;
    }

    public void setDynamicImportDataFieldService(DynamicImportDataFieldService dynamicImportDataFieldService) {
        this.dynamicImportDataFieldService = dynamicImportDataFieldService;
    }
}

