/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.position.transformer;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.PinyinUtil;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.entity.TmRPositionActRoleEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.entity.TmRPositionRoleEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.google.common.base.Function;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TmPositionVoToTmPositionEntity
implements Function<TmPositionVo, TmPositionEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    private TmPositionService tmPositionService;

    public TmPositionVoToTmPositionEntity(TmPositionService tmPositionService) {
        this.tmPositionService = tmPositionService;
    }

    public TmPositionEntity apply(TmPositionVo vo) {
        TmPositionEntity entity = new TmPositionEntity();
        if (StringUtil.isNotEmpty((String)vo.getId()) && (entity = (TmPositionEntity)this.tmPositionService.get(TmPositionEntity.class, (Serializable)((Object)vo.getId()))) == null) {
            throw new BusinessException("\u67e5\u8be2\u804c\u4f4d\u4fe1\u606f\u51fa\u9519 ");
        }
        if (StringUtil.isNotEmpty((String)vo.getPositionCode())) {
            entity = (TmPositionEntity)this.tmPositionService.findUniqueByProperty(TmPositionEntity.class, "positionCode", (Object)vo.getPositionCode());
        }
        if (entity == null) {
            entity = new TmPositionEntity();
        }
        if (!StringUtil.isNotEmpty((String)vo.getEnableStatus())) {
            vo.setEnableStatus(Globals.ZERO);
        }
        if (StringUtil.isEmpty((String)vo.getPositionName())) {
            throw new BusinessException("\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        vo.setHeadString(PinyinUtil.getPinYinHeadChar((String)vo.getPositionName()));
        try {
            this.copyProperties(vo, entity);
            if (StringUtils.isNotBlank((CharSequence)vo.getOrgId())) {
                TmOrgEntity tmOrgEntity = (TmOrgEntity)this.tmPositionService.get(TmOrgEntity.class, (Serializable)((Object)vo.getOrgId()));
                if (tmOrgEntity == null && (tmOrgEntity = (TmOrgEntity)this.tmPositionService.findUniqueByProperty(TmOrgEntity.class, "orgCode", (Object)vo.getOrgId())) == null) {
                    throw new BusinessException("\u8f6c\u6362\u804c\u4f4dVo\u5230Po\u65f6\uff0c\u6240\u5c5e\u7ec4\u7ec7\u627e\u4e0d\u5230:" + vo.getOrgId());
                }
                entity.setTmOrg(tmOrgEntity);
            }
            if (StringUtil.isNotEmpty((String)vo.getParentId())) {
                TmPositionEntity positionEntity = (TmPositionEntity)this.tmPositionService.get(TmPositionEntity.class, (Serializable)((Object)vo.getParentId()));
                if (positionEntity == null && (positionEntity = (TmPositionEntity)this.tmPositionService.findUniqueByProperty(TmPositionEntity.class, "positionCode", (Object)vo.getParentId())) == null) {
                    throw new BusinessException("\u8f6c\u6362\u804c\u4f4dVo\u5230Po\u65f6\uff0c\u4e0a\u7ea7\u804c\u4f4d\u627e\u4e0d\u5230:" + vo.getParentId());
                }
                entity.setTmPosition(positionEntity);
            }
            String roleIds = vo.getRoleIds();
            List tmPositionRoleList = this.getTmPositionRoleList(entity, roleIds);
            entity.setTmPositionRoleList(tmPositionRoleList);
            String workFlowRoleIds = vo.getWorkflowRoleIds();
            List tmPositionActRoleList = this.getTmPositionActRoleList(entity, workFlowRoleIds);
            entity.setTmRPositionActRoleList(tmPositionActRoleList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return entity;
    }

    private void copyProperties(TmPositionVo vo, TmPositionEntity entity) {
        entity.setBusinessGroup(vo.getBusinessGroup());
        entity.setEnableStatus(vo.getEnableStatus());
        entity.setExtChar1(vo.getExtChar1());
        entity.setExtChar2(vo.getExtChar2());
        entity.setExtChar3(vo.getExtChar3());
        entity.setExtChar4(vo.getExtChar4());
        entity.setExtChar5(vo.getExtChar5());
        entity.setExtDate1(vo.getExtDate1());
        entity.setExtDate2(vo.getExtDate2());
        entity.setExtNumber1(vo.getExtNumber1());
        entity.setExtNumber2(vo.getExtNumber2());
        entity.setExtNumber3(vo.getExtNumber3());
        entity.setHeadString(vo.getHeadString());
        entity.setPositionCode(vo.getPositionCode());
        entity.setPositionLevel(vo.getPositionLevel());
        entity.setPositionName(vo.getPositionName());
    }

    public List<TmRPositionRoleEntity> getTmPositionRoleList(TmPositionEntity tmPositionEntity, String roleIds) {
        ArrayList<TmRPositionRoleEntity> list = new ArrayList<TmRPositionRoleEntity>();
        if (StringUtil.isNotEmpty((String)roleIds)) {
            String hql = "from TmRPositionRoleEntity WHERE tmPosition.id=? AND tmRole.id=?";
            for (String roleId : roleIds.split(",")) {
                TmRoleEntity tmRoleEntity = (TmRoleEntity)this.tmPositionService.get(TmRoleEntity.class, (Serializable)((Object)roleId));
                if (tmRoleEntity == null && (tmRoleEntity = (TmRoleEntity)this.tmPositionService.findUniqueByProperty(TmRoleEntity.class, "roleCode", (Object)roleId)) == null) {
                    throw new BusinessException("\u89d2\u8272\u4e0d\u5b58\u5728");
                }
                TmRPositionRoleEntity tmRPositionRoleEntity = (TmRPositionRoleEntity)this.tmPositionService.getUniqueByHql(TmRPositionRoleEntity.class, hql, new Object[]{tmPositionEntity.getId(), tmRoleEntity.getId()});
                if (tmRPositionRoleEntity == null) {
                    tmRPositionRoleEntity = new TmRPositionRoleEntity();
                    tmRPositionRoleEntity.setTmPosition(tmPositionEntity);
                    tmRPositionRoleEntity.setTmRole(tmRoleEntity);
                }
                list.add(tmRPositionRoleEntity);
            }
        }
        return list;
    }

    public List<TmRPositionActRoleEntity> getTmPositionActRoleList(TmPositionEntity tmPositionEntity, String workFlowRoleIds) {
        ArrayList<TmRPositionActRoleEntity> list = new ArrayList<TmRPositionActRoleEntity>();
        if (StringUtil.isNotEmpty((String)workFlowRoleIds)) {
            String hql = "from TmRPositionActRoleEntity WHERE tmPosition.id=? AND tmActRole.id=?";
            for (String workFlowRoleId : workFlowRoleIds.split(",")) {
                TmActRoleEntity tmActRoleEntity = (TmActRoleEntity)this.tmPositionService.get(TmActRoleEntity.class, (Serializable)((Object)workFlowRoleId));
                if (tmActRoleEntity == null && (tmActRoleEntity = (TmActRoleEntity)this.tmPositionService.findUniqueByProperty(TmActRoleEntity.class, "roleCode", (Object)workFlowRoleId)) == null) {
                    throw new BusinessException("\u5de5\u4f5c\u6d41\u89d2\u8272\u4e0d\u5b58\u5728");
                }
                TmRPositionActRoleEntity tmRPositionActRoleEntity = (TmRPositionActRoleEntity)this.tmPositionService.getUniqueByHql(TmRPositionActRoleEntity.class, hql, new Object[]{tmPositionEntity.getId(), workFlowRoleId});
                if (tmRPositionActRoleEntity == null) {
                    tmRPositionActRoleEntity = new TmRPositionActRoleEntity();
                    tmRPositionActRoleEntity.setTmPosition(tmPositionEntity);
                    tmRPositionActRoleEntity.setTmActRole(tmActRoleEntity);
                }
                list.add(tmRPositionActRoleEntity);
            }
        }
        return list;
    }
}

