(function ($) {
    /*
        使用方式
        new AreaSelect(el,{
        value:[],
        column:[],
            onChange:function (res) {
            }
        })*/
    const defaultOptions = {};

    function AreaSelect(el, options) {
        this._el = el;
        this._options = $.extend(defaultOptions, options);
        this._result = {};
        this.init();
    }

    AreaSelect.prototype = {
        init: function () {
            let this_ = this;
            $(this_._el).prop("readonly",true);
            $(this_._el).parent().css("position","relative");
            $(this_._el).click(function (e) {
                e.stopPropagation();
                let rect = this.getBoundingClientRect();
                let top = rect.top;
                let left = rect.left;
                let height = rect.height;
                if (document.getElementsByClassName("area-multi-select-container").length > 0) return;
                let container = $("<div>");
                container.addClass("area-multi-select-container");
                let context = $("<div>");
                context.addClass("area-multi-select-context");
                context.css({
                    top: (top + height) + 5,
                    left: left
                });
                this_.renderColumn(context);
                container.html(context);
                $(document.body).append(container)
            });
            $(this_._el).parent().hover(function () {
                $(this_._el).val()&&this_.renderClear();
            },function () {
                $(this_._el).siblings(".area-select-clear").remove();
            });
            $(document).bind('click', function (e) {
                e.stopPropagation();
                $(".area-multi-select-container").remove();
            })
        },
        renderColumn(context) {
            let this_ = this;
            let column = this._options.column;
            let value = this._options.value;
            if (!column) return;
            //如果有省份列
            if (column[0]) {
                if ($(this._el).siblings("input[name='" + column[0] + "']").length === 0) {
                    $(this._el).parent().append("<input type='hidden' value='" + (value[0]||"") + "' name='" + column[0] + "'>")
                }
                this._result.province = $(this._el).siblings("input[name='" + column[0] + "']").val();
            }
            //如果有市列
            if (column[1]) {
                if ($(this._el).siblings("input[name='" + column[1] + "']").length === 0) {
                    $(this._el).parent().append("<input type='hidden' value='" + (value[1]||"") + "' name='" + column[1] + "'>")
                }
                this._result.city = $(this._el).siblings("input[name='" + column[1] + "']").val();
            }
            //如果有区列
            if (column[2]) {
                if ($(this._el).siblings("input[name='" + column[2] + "']").length === 0) {
                    $(this._el).parent().append("<input type='hidden' value='" + (value[2]||"") + "' name='" + column[2] + "'>")
                }
                this._result.area = $(this._el).siblings("input[name='" + column[2] + "']").val();
            }
            this_._result.value = $(this._el).val();
            this.renderProvinceUl({type: "province", code: ""}, context, function () {
                if (this_._result.province) {
                    this_.renderCityUl({type: "city", code: this_._result.province}, context, function () {
                        if (this_._result.city) {
                            this_.renderAreaUl({type: "area", code: this_._result.city}, context);
                        }
                    });
                }
            });

        },
        renderProvinceUl(params, context, cb) {
            let this_ = this;
            if(!this_._options.column[0])return;
            loadData(params, function (data) {
                let ul = $("<ul>");
                ul.addClass("area-multi-select-ul");
                data.forEach(function (item, index) {
                    let li = $("<li>");
                    li.addClass("area-multi-select-li");
                    if (this_._result.province === item.code) {
                        li.addClass("area-multi-selected");
                    }
                    li.attr("code", item.code);
                    li.attr("title", item.name);
                    li.attr("type", params.type);
                    li.text(item.name);
                    li.append("<span class='fa fa-angle-right'></span>");
                    li.on('click', function (e) {
                        e.stopPropagation();
                        $(this).addClass("area-multi-selected").siblings("li").removeClass("area-multi-selected");
                        $(this_._el).val($(this).attr("title"));
                        this_._options.column[0]&&$(this_._el).siblings("input[name='"+this_._options.column[0]+"']").val(item.code);
                        this_._options.column[1]&&$(this_._el).siblings("input[name='"+this_._options.column[1]+"']").val("");
                        this_._options.column[2]&&$(this_._el).siblings("input[name='"+this_._options.column[2]+"']").val("");
                        this_._result = {
                            province: item.code,
                            city: "",
                            area: "",
                            value: $(this).attr("title")
                        };
                        this_._options.onChange(this_._result);
                        !this_._options.column[1]&&$(this).parents(".area-multi-select-container").remove();
                        $(this).parent().nextAll().remove();
                        $(this).parents(".area-multi-select-context").append(this_.renderCityUl({
                            type: "city",
                            code: item.code
                        }, context))
                    });
                    ul.append(li);
                });
                context.append(ul);
                cb && cb();
            });
        },
        renderCityUl(params, context, cb) {
            let this_ = this;
            if(!this_._options.column[1])return;
            loadData(params, function (data) {
                let ul = $("<ul>");
                ul.addClass("area-multi-select-ul");
                data.forEach(function (item, index) {
                    let li = $("<li>");
                    li.addClass("area-multi-select-li");
                    if (this_._result.city === item.code) {
                        li.addClass("area-multi-selected");
                    }
                    li.attr("code", item.code);
                    li.attr("title", item.name);
                    li.attr("type", params.type);
                    li.text(item.name);
                    li.append("<span class='fa fa-angle-right'></span>");
                    li.on('click', function (e) {
                        e.stopPropagation();
                        $(this).addClass("area-multi-selected").siblings("li").removeClass("area-multi-selected")
                        //选择市
                        let value = $(this_._el).val().split("/")[0];
                        let newValue = value + "/" + $(this).attr("title");
                        $(this_._el).val(newValue);
                        this_._options.column[1]&&$(this_._el).siblings("input[name='"+this_._options.column[1]+"']").val(item.code);
                        this_._options.column[2]&&$(this_._el).siblings("input[name='"+this_._options.column[2]+"']").val("");
                        this_._result = $.extend(this_._result, {
                            city: item.code,
                            area: "",
                            value: newValue
                        });
                        this_._options.onChange(this_._result);
                        !this_._options.column[2]&&$(this).parents(".area-multi-select-container").remove();
                        $(this).parent().nextAll().remove();
                        $(this).parents(".area-multi-select-context").append(this_.renderAreaUl({
                            type: "area",
                            code: item.code
                        }, context))
                    });
                    ul.append(li);
                });
                context.append(ul);
                cb && cb();
            });
        },
        renderAreaUl(params, context) {
            let this_ = this;
            if(!this_._options.column[2])return;
            loadData(params, function (data) {
                let ul = $("<ul>");
                ul.addClass("area-multi-select-ul");
                data.forEach(function (item, index) {
                    let li = $("<li>");
                    li.addClass("area-multi-select-li");
                    if (this_._result.area === item.code) {
                        li.addClass("area-multi-selected");
                    }
                    li.attr("code", item.code);
                    li.attr("title", item.name);
                    li.attr("type", params.type);
                    li.text(item.name);
                    li.append("<span class='fa fa-angle-right'></span>");
                    li.on('click', function (e) {
                        e.stopPropagation();
                        $(this).addClass("area-multi-selected").siblings("li").removeClass("area-multi-selected");
                        let value = $(this_._el).val().split("/")[0] + "/" + $(this_._el).val().split("/")[1];
                        let newValue = value + "/" + $(this).attr("title");
                        $(this_._el).val(newValue);
                        this_._options.column[2]&&$(this_._el).siblings("input[name='"+this_._options.column[2]+"']").val(item.code);
                        this_._result = $.extend(this_._result, {
                            area: item.code,
                            value: newValue
                        });
                        $(this).parents(".area-multi-select-container").remove();
                        this_._options.onChange(this_._result)
                    });
                    ul.append(li);
                });
                context.append(ul);
            });
        },
        renderClear(){
            if($(this._el).siblings(".area-select-clear").length===0){
                let this_ = this;
                let clearSpan = $("<span>");
                clearSpan.addClass("area-select-clear");
                clearSpan.addClass("fa fa-times-circle");
                clearSpan.on('click',function (e) {
                    e.stopPropagation();
                    $(this_._el).val("");
                    $(this_._el).siblings("input").val("");
                    this_._result = {
                        province:"",
                        city:"",
                        area:"",
                        value:""
                    };
                    this_._options.onChange(this_._result);
                    $(".area-multi-select-container").remove();
                });
                $(this._el).parent().append(clearSpan);
            }
        },
    };

    /**
     *
     * @param {type:"",code:""} data
     * @param {*} cb
     */
    function loadData(params, cb) {
        let areaLevel = params.type === "area" ? 3 : params.type === "city" ? 2 : 1;
        let data = {areaLevel: areaLevel, code: params.code};
        $.ajax({
            url: "/kernel/busareaController/getBusareaList",
            type: "get",
            data: data,
            dataType: "json",
            contentType: "application/x-www-form-urlencoded",
            success: function (res) {
                cb(res.objList || []);
            }
        })
    }

    window.AreaSelect = AreaSelect;

})(jQuery);