/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer;

import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.dao.HibernatePersister;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.importer.AbstractHibernateImporter;
import com.biz.eisp.base.importer.DataField;
import com.biz.eisp.base.importer.ImpConfigurator;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ImpEventHandler<T> {
    private AbstractHibernateImporter importer;
    private ImpConfigurator conf;
    private HibernatePersister persister;
    private Map<String, Object> params;
    private int index;
    private int rowNumber;
    protected String tableName = null;

    public final void init(ImpConfigurator conf, HibernatePersister persister, Map<String, Object> params, String tableName) {
        this.conf = conf;
        this.persister = persister;
        this.params = params;
        this.tableName = tableName;
    }

    protected void persisterBean(Object bean, boolean isSkip) {
        if (this.importer.errNum == 0 && !isSkip && bean != null) {
            ++this.importer.succNum;
            this.importer.save(bean);
        }
    }

    public final void setImporter(AbstractHibernateImporter imp) {
        this.importer = imp;
    }

    public final void addMessage(String message, String onError) {
        this.importer.addMessage(message, onError);
    }

    public final void addMessage(String message, String onError, Map<String, Object> row, DataField field) {
        this.importer.addMessage(message, onError, row, field);
    }

    public final void addError(String error) throws ValidateException {
        this.importer.addError(error);
    }

    public final void addError(String error, Map<String, Object> row, DataField field) throws ValidateException {
        this.importer.addError(error, row, field);
    }

    public void start() {
    }

    public void startRow(Map<String, Object> row) throws ValidateException {
    }

    public void validate(Map<String, Object> row) throws ValidateException {
        if (StringUtil.isNotEmpty((String)this.tableName)) {
            this.validateDynamicImp(row);
        }
    }

    public void validateDynamicImp(Map<String, Object> row) throws ValidateException {
        List<TmMdmTableConfigEntity> list = DynamicConfigUtil.allTableConfigImpColumn.get(this.tableName.toUpperCase());
        HashMap<String, Object> requiredFieldMap = new HashMap<String, Object>();
        for (TmMdmTableConfigEntity tableConfig : list) {
            Object fieldValue = row.get(tableConfig.getField());
            if (fieldValue instanceof Date) continue;
            String errorMsg = ValidatorFactory.validateDynamicImplData(tableConfig, fieldValue, row);
            if (StringUtil.isNotEmpty((String)errorMsg)) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c:" + errorMsg);
            }
            if (tableConfig.getRequired() == null || tableConfig.getRequired() != 1) continue;
            requiredFieldMap.put(tableConfig.getColumnName(), fieldValue);
        }
        if (!requiredFieldMap.isEmpty()) {
            String sql = "select id from " + this.tableName + " where 1=1";
            for (Map.Entry entry : requiredFieldMap.entrySet()) {
                sql = sql + " and " + (String)entry.getKey() + "='" + entry.getValue() + "'";
            }
            BaseService baseService = (BaseService)ApplicationContextUtils.getContext().getBean("baseService");
            List<Map<String, Object>> mapList = baseService.findForMapList(sql, new Object[0]);
            if (mapList != null && mapList.size() > 0) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c:\u6570\u636e\u5b58\u5728\u91cd\u590d");
            }
        }
    }

    public void endRow(Map<String, Object> row, T bean) throws ValidateException {
    }

    public void error(DataField field, Map<String, Object> row, Exception e) {
    }

    public void fatalError(Exception e) {
    }

    public void end() {
    }

    public final ImpConfigurator getConf() {
        return this.conf;
    }

    public final Map<String, Object> getParams() {
        return this.params;
    }

    public final HibernatePersister getPersister() {
        return this.persister;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int index) {
        this.index = index;
    }

    public final int getRowNumber() {
        return this.rowNumber;
    }

    public final void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getErrNum() {
        return this.importer.errNum;
    }

    public void setSuccNum(int succNum) {
        this.importer.succNum = succNum;
    }

    public int getSuccNum() {
        return this.importer.succNum;
    }

    public String getBatchCode() {
        return this.importer.getBatchCode();
    }

    public String getMessage(int col, String message) {
        List<DataField> list = this.getConf().getFields();
        return "\u7b2c" + col + "\u5217\uff08" + list.get(col - 1).getTitle() + "\uff09--" + message;
    }
}

