/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.custorg.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgFormExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgMainExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgBusinessVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgCustomerVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgTerminalVo;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmCustOrgController"})
public class TmCustOrgController
extends BaseController {
    @Autowired
    private TmCustOrgService tmCustOrgService;
    @Autowired(required=false)
    private TmCustOrgFormExtendService tmCustOrgFormExtendService;
    @Autowired(required=false)
    private TmCustOrgMainExtendService tmCustOrgMainExtendService;

    @RequestMapping(params={"goOrgMain"})
    public ModelAndView goOrgMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_CUSTOMER_ORG);
        if (this.tmCustOrgMainExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmCustOrgMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgMain");
    }

    @RequestMapping(params={"goBusiness"})
    public ModelAndView goBusiness(HttpServletRequest request) {
        String custOrgId = OConvertUtils.getString(request.getParameter("custOrgId"));
        if (StringUtil.isNotEmpty((String)custOrgId)) {
            request.setAttribute("custOrgId", (Object)custOrgId);
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgBusinessMain");
    }

    @RequestMapping(params={"goTmBusinessCheckedMain"})
    public ModelAndView goTmBusinessCheckedMain(TmCustOrgBusinessVo tmCustOrgBusinessVo, HttpServletRequest request) {
        request.setAttribute("custOrgId", (Object)(StringUtil.isNotEmpty((String)tmCustOrgBusinessVo.getCustOrgId()) ? tmCustOrgBusinessVo.getCustOrgId() : "-1"));
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmBusinessCheckedMain");
    }

    @RequestMapping(params={"goCustOrgForm"})
    public ModelAndView goCustOrgForm(HttpServletRequest request, TmCustomerOrgVo tmCustomerOrgVo) {
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_CUSTOMER_ORG);
        if (StringUtil.isNotEmpty((String)tmCustomerOrgVo.getId())) {
            TmCustomerOrgVo vo = this.tmCustOrgService.getTmCustOrg(tmCustomerOrgVo.getId());
            request.setAttribute("custOrg", (Object)vo);
        }
        if (this.tmCustOrgFormExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmCustOrgFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgForm");
    }

    @RequestMapping(params={"goCustOrgTerminal"})
    public ModelAndView goCustOrgTerminal(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("custOrgId", (Object)id);
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgTerminalMain");
    }

    @RequestMapping(params={"goCustOrgCustomer"})
    public ModelAndView goCustOrgCustomer(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("custOrgId", (Object)id);
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgCustomerMain");
    }

    @RequestMapping(params={"findNotRefBusinessGrid"})
    @ResponseBody
    public DataGrid findNotRefBusinessList(TmCustOrgBusinessVo businessVo, HttpServletRequest request) {
        TmOrgEntity tmOrgEntity;
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((String)businessVo.getOrgName()) && StringUtil.isNotEmpty(tmOrgEntity = this.tmCustOrgService.get(TmOrgEntity.class, (Serializable)((Object)businessVo.getOrgName())))) {
            businessVo.setOrgName(tmOrgEntity.getOrgName());
        }
        List<TmCustOrgBusinessVo> businessList = this.tmCustOrgService.findNotRefBusinessGrid(businessVo, page);
        return new DataGrid(businessList, page);
    }

    @RequestMapping(params={"findRefBusinessGrid"})
    @ResponseBody
    public List<TmCustOrgBusinessVo> findRefBusinessList(TmCustOrgBusinessVo businessVo, HttpServletRequest request) {
        List<TmCustOrgBusinessVo> businessList = this.tmCustOrgService.findRefBusinessGrid(businessVo);
        return businessList;
    }

    @RequestMapping(params={"findTmCustomerOrgPageList"})
    @ResponseBody
    public Object findTmCustomerOrgPageList(HttpServletRequest request, TmCustomerOrgVo custOrgVo) {
        EuPage page = new EuPage(request);
        List<TmCustomerOrgVo> voList = this.tmCustOrgService.findTmCustomerOrgPageList(custOrgVo, page);
        if (StringUtil.isNotEmpty((String)custOrgVo.getId())) {
            return voList;
        }
        return new DataGrid(voList, page);
    }

    @RequestMapping(params={"findTmCustomerOrgList"})
    @ResponseBody
    public List<TmCustomerOrgVo> findTmCustomerOrgList(HttpServletRequest request, TmCustomerOrgVo custOrgVo) {
        List<TmCustomerOrgVo> voList = this.tmCustOrgService.findTmCustomerOrgList(custOrgVo);
        return voList;
    }

    @RequestMapping(params={"findCustmerGrid"})
    @ResponseBody
    public DataGrid findCustmerList(TmCustOrgCustomerVo tmCustOrgCustomerVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmCustOrgCustomerVo> customerList = this.tmCustOrgService.findTmCustomerByCustOrg(tmCustOrgCustomerVo, page);
        return new DataGrid(customerList, page);
    }

    @RequestMapping(params={"findTerminalGrid"})
    @ResponseBody
    public DataGrid findTerminalList(TmCustOrgTerminalVo tmCustOrgTerminalVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmCustOrgTerminalVo> terminalList = this.tmCustOrgService.findTmTerminalByCustOrg(tmCustOrgTerminalVo, page);
        return new DataGrid(terminalList, page);
    }

    @RequestMapping(params={"getParentCustOrg"})
    @ResponseBody
    public List<ComboTree> getParentOrg(HttpServletRequest request, ComboTree comboTree, TmCustomerOrgVo custOrgVo) {
        return this.tmCustOrgService.getParentCustOrgs(request, comboTree);
    }

    @RequestMapping(params={"saveOrUpdateCustOrg"})
    @ResponseBody
    public AjaxJson saveOrUpdateOrg(HttpServletRequest request, TmCustomerOrgVo custOrgVo) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.tmCustOrgService.saveOrUpdateCustOrg(custOrgVo, page);
            this.tmCustOrgService.updateIsLeafColumn(Globals.TABLE_CUSTOMER_ORG);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("custOrgCode", custOrgVo.getCustOrgCode());
            attributes.put("customerOrgName", custOrgVo.getCustomerOrgName());
            j.setAttributes(attributes);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"delCustOrg"})
    @ResponseBody
    public AjaxJson delCustOrg(String ids) {
        AjaxJson j = this.tmCustOrgService.delCustOrg(ids);
        return j;
    }

    @RequestMapping(params={"removeCustOrgBusiness"})
    @ResponseBody
    public AjaxJson removeCustOrgBusiness(HttpServletRequest request) {
        String id = request.getParameter("id");
        String custOrgId = request.getParameter("custOrgId");
        return this.tmCustOrgService.removeCustOrgBusiness(id, custOrgId);
    }

    @RequestMapping(params={"addCustOrgBusiness"})
    @ResponseBody
    public AjaxJson addCustOrgBusiness(HttpServletRequest request) {
        String id = request.getParameter("id");
        String custOrgId = request.getParameter("custOrgId");
        return this.tmCustOrgService.addCustOrgBusiness(id, custOrgId);
    }

    @RequestMapping(params={"validateCustOrgCode"})
    @ResponseBody
    public ValidForm validateOrgCode(TmCustomerOrgVo custOrgVo, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        SimpleExpression cr = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)custOrgVo.getId())) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)custOrgVo.getId());
            SimpleExpression cr3 = Restrictions.eq((String)"custOrgCode", (Object)param);
            List<TmCustomerOrgEntity> tmOrgByCodes = this.tmCustOrgService.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr3, cr2});
            if (!CollectionUtils.isEmpty(tmOrgByCodes)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
            }
        } else {
            List<TmCustomerOrgEntity> tmOrgByCodes = this.tmCustOrgService.findByProperty(TmCustomerOrgEntity.class, "custOrgCode", param);
            if (!CollectionUtils.isEmpty(tmOrgByCodes)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }

    @RequestMapping(params={"validateCustOrgName"})
    @ResponseBody
    public ValidForm validateOrgName(TmCustomerOrgVo custOrgVo, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        SimpleExpression cr = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)custOrgVo.getId())) {
            SimpleExpression cr1 = Restrictions.eq((String)"customerOrgName", (Object)param);
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)custOrgVo.getId());
            List<TmCustomerOrgEntity> tmOrgs = this.tmCustOrgService.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr1, cr2});
            if (!CollectionUtils.isEmpty(tmOrgs)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
            }
        } else {
            SimpleExpression cr3 = Restrictions.eq((String)"customerOrgName", (Object)param);
            List<TmCustomerOrgEntity> tmOrgs = this.tmCustOrgService.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr3});
            if (!CollectionUtils.isEmpty(tmOrgs)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }

    @RequestMapping(params={"getParentCustOrgs"})
    @ResponseBody
    public List<ComboTree> getParentOrgs(HttpServletRequest request, ComboTree comboTree, TmCustomerOrgVo custOrgVo) {
        return this.tmCustOrgService.getParentCustOrg(request, comboTree);
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(TmCustomerOrgVo custOrgVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        custOrgVo.setExportExcel("true");
        List<TmCustomerOrgVo> custOrgVoList = this.tmCustOrgService.findTmCustomerOrgList(custOrgVo);
        this.doExportXls(response, request, custOrgVoList, TmCustomerOrgVo.class, "\u5ba2\u6237\u7ec4\u7ec7\u5217\u8868");
    }
}

