/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.generatednum.num.util.TbNumRuleProvider;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.service.TmCustomerService;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;

public class TmTerminalEventHandler
extends ImpEventHandler<TmTerminalVo> {
    private TmTerminalService tmTerminalService;
    private TmCustomerService tmCustomerService;
    private TmBusinessAreaService tmBusinessAreaService;
    private TbNumRuleProvider tbNumRuleProvider;
    private List<TmTerminalEntity> entityList = new ArrayList<TmTerminalEntity>();
    private List<TmBusinessAreaVo> provinceList = new ArrayList<TmBusinessAreaVo>();
    private List<TmBusinessAreaVo> cityList = new ArrayList<TmBusinessAreaVo>();
    private List<TmBusinessAreaVo> areaList = new ArrayList<TmBusinessAreaVo>();
    private Map<String, String> customerMap = new HashMap<String, String>();
    private Map<String, String> businessAreaMap = new HashMap<String, String>();

    public TmTerminalEventHandler() {
        this.tmTerminalService = (TmTerminalService)ApplicationContextUtils.getContext().getBean("tmTerminalService");
        this.tmBusinessAreaService = (TmBusinessAreaService)ApplicationContextUtils.getContext().getBean("tmBusinessAreaService");
        this.tbNumRuleProvider = (TbNumRuleProvider)ApplicationContextUtils.getContext().getBean("tbNumRuleProvider");
        this.tmCustomerService = (TmCustomerService)ApplicationContextUtils.getContext().getBean("tmCustomerService");
    }

    @Override
    public void start() {
        TmBusinessAreaVo provinceSelectVo = new TmBusinessAreaVo();
        provinceSelectVo.setAreaLevel(1);
        this.provinceList = this.tmBusinessAreaService.findTmBusinessAreaSingleLevelList(provinceSelectVo);
        TmBusinessAreaVo citySelectVo = new TmBusinessAreaVo();
        citySelectVo.setAreaLevel(2);
        this.cityList = this.tmBusinessAreaService.findTmBusinessAreaSingleLevelList(citySelectVo);
        TmBusinessAreaVo areaSelectVo = new TmBusinessAreaVo();
        areaSelectVo.setAreaLevel(3);
        this.areaList = this.tmBusinessAreaService.findTmBusinessAreaSingleLevelList(areaSelectVo);
        block0: for (TmBusinessAreaVo area : this.areaList) {
            for (TmBusinessAreaVo city : this.cityList) {
                if (!area.getParentId().equals(city.getId())) continue;
                city.getChildrenList().add(area);
                continue block0;
            }
        }
        block2: for (TmBusinessAreaVo city : this.cityList) {
            for (TmBusinessAreaVo province : this.provinceList) {
                if (!city.getParentId().equals(province.getId())) continue;
                province.getChildrenList().add(city);
                continue block2;
            }
        }
    }

    @Override
    public void startRow(Map<String, Object> row) throws ValidateException {
        super.startRow(row);
    }

    @Override
    public void validate(Map<String, Object> row) throws ValidateException {
        Object customerCode;
        List<TmMdmTableConfigEntity> list = DynamicConfigUtil.allTableConfigImpColumn.get(this.tableName.toUpperCase());
        for (TmMdmTableConfigEntity tableConfig : list) {
            Object fieldValue;
            String errorMsg = ValidatorFactory.validateDynamicImplData(tableConfig, fieldValue = row.get(tableConfig.getField()), row);
            if (!StringUtil.isNotEmpty((String)errorMsg)) continue;
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c:" + errorMsg);
        }
        Object province = row.get("province");
        Object city = row.get("city");
        Object area = row.get("area");
        if (!(province == null || StringUtil.isEmpty(province.toString()) || city == null || StringUtil.isEmpty(city.toString()) || area == null || StringUtil.isEmpty(area.toString()))) {
            this.validateBusinessArea(province.toString(), city.toString(), area.toString());
        }
        if ((customerCode = row.get("customerCode")) != null && !StringUtil.isEmpty(customerCode.toString())) {
            TmCustomerEntity customer = this.tmCustomerService.findUniqueByProperty(TmCustomerEntity.class, "customerCode", customerCode.toString());
            if (StringUtil.isEmpty(customer)) {
                this.addErrorMessage("\u4e0a\u7ea7\u5ba2\u6237\u7f16\u7801\u65e0\u6548");
            } else if (!this.customerMap.containsKey(customer.getCustomerCode())) {
                this.customerMap.put(customer.getCustomerCode(), customer.getId());
            }
        }
    }

    @Override
    public void endRow(Map<String, Object> row, TmTerminalVo bean) throws ValidateException {
        try {
            TmTerminalEntity entity = new TmTerminalEntity();
            BeanUtils.copyProperties((Object)bean, (Object)entity);
            entity.setTerminalCode(this.tbNumRuleProvider.getMaxNum("terminal"));
            entity.setTerminalName(bean.getTerminalName());
            entity.setTerminalType(bean.getTerminalType());
            entity.setChannelType(bean.getChannelType());
            entity.setCooperative(bean.getCooperative());
            entity.setAddress(bean.getAddress());
            entity.setLinkman(bean.getLinkman());
            entity.setLinkmanPhone(bean.getLinkmanPhone());
            entity.setEnableStatus(Globals.add);
            if (StringUtil.isNotBlank((String)bean.getProvince()) && StringUtil.isNotBlank((String)bean.getCity()) && StringUtil.isNotBlank((String)bean.getArea())) {
                String businessAreaStr = this.businessAreaMap.get(bean.getProvince() + "_" + bean.getCity() + "_" + bean.getArea());
                String[] split = businessAreaStr.split("_");
                entity.setProvinceCode(split[0]);
                entity.setProvince(bean.getProvince());
                entity.setCityCode(split[1]);
                entity.setCity(bean.getCity());
                entity.setAreaCode(split[2]);
                entity.setArea(bean.getArea());
            }
            this.entityList.add(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addErrorMessage("\u4fdd\u5b58\u5931\u8d25");
        }
        this.setSuccNum(this.getSuccNum() + 1);
    }

    @Override
    public void end() {
        if (CollectionUtil.listNotEmptyNotSizeZero(this.entityList)) {
            for (TmTerminalEntity item : this.entityList) {
                this.tmTerminalService.save(item);
            }
        }
    }

    private void validateBusinessArea(String provinceName, String cityName, String areaName) throws ValidateException {
        boolean provinceFlag = false;
        for (TmBusinessAreaVo province : this.provinceList) {
            if (!provinceName.equals(province.getBusinessAreaName())) continue;
            boolean cityFlag = false;
            for (TmBusinessAreaVo city : province.getChildrenList()) {
                if (!cityName.equals(city.getBusinessAreaName())) continue;
                boolean areaFlag = false;
                for (TmBusinessAreaVo area : city.getChildrenList()) {
                    if (!areaName.equals(area.getBusinessAreaName())) continue;
                    String key = provinceName + "_" + cityName + "_" + areaName;
                    if (!this.businessAreaMap.containsKey(key)) {
                        this.businessAreaMap.put(key, province.getBusinessAreaCode() + "_" + city.getBusinessAreaCode() + "_" + area.getBusinessAreaCode());
                    }
                    areaFlag = true;
                    break;
                }
                if (!areaFlag) {
                    this.addErrorMessage("\u533a\u540d\u79f0\u65e0\u6548\uff0c\u8be5\u5e02\u4e0b\u4e0d\u5305\u542b\u8be5\u540d\u79f0\u7684\u533a");
                }
                cityFlag = true;
                break;
            }
            if (!cityFlag) {
                this.addErrorMessage("\u5e02\u540d\u79f0\u65e0\u6548\uff0c\u8be5\u7701\u4e0b\u4e0d\u5305\u542b\u8be5\u540d\u79f0\u7684\u5e02");
            }
            provinceFlag = true;
            break;
        }
        if (!provinceFlag) {
            this.addErrorMessage("\u7701\u540d\u79f0\u65e0\u6548\uff0c\u4e0d\u5b58\u5728\u8be5\u540d\u79f0");
        }
    }

    private void addErrorMessage(String message) throws ValidateException {
        this.addError("\u7b2c" + this.getRowNumber() + "\u884c\u9047\u5230\u9519\u8bef:" + message);
    }
}

