/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonUtil {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void object2Json(Class<?> clazz, Object object, List<String> parameters, Boolean flag, PrintWriter pw) {
        pw = null;
        try {
            StringBuffer json = null;
            json = flag != false ? new StringBuffer("{object: [") : new StringBuffer("[");
            if (Collection.class.isAssignableFrom(clazz)) {
                int count = 0;
                for (Object value : (List)object) {
                    if (count++ != 0) {
                        json.append(",");
                    }
                    json.append("{");
                    int num = 0;
                    for (String parameter : parameters) {
                        if (num++ != 0) {
                            json.append(",");
                        }
                        json.append(parameter);
                        Boolean type = Boolean.class.equals(value.getClass().getMethod("get" + parameter.substring(0, 1).toUpperCase() + parameter.substring(1), new Class[0]).getReturnType());
                        if (type.booleanValue()) {
                            json.append(": ");
                        } else {
                            json.append(": '");
                        }
                        json.append(JsonUtil.convert((Object)value.getClass().getMethod("get" + parameter.substring(0, 1).toUpperCase() + parameter.substring(1), new Class[0]).invoke(value, new Object[0])));
                        if (type.booleanValue()) continue;
                        json.append("'");
                    }
                    json.append("}");
                }
            } else {
                json.append("{");
                int num = 0;
                for (String parameter : parameters) {
                    if (num++ != 0) {
                        json.append(",");
                    }
                    json.append(parameter);
                    json.append(": '");
                    json.append(JsonUtil.convert((Object)object.getClass().getMethod("get" + parameter.substring(0, 1).toUpperCase() + parameter.substring(1), new Class[0]).invoke(object, new Object[0])));
                    json.append("'");
                }
                json.append("}");
            }
            if (flag.booleanValue()) {
                json.append("]}");
            } else {
                json.append("]");
            }
            logger.info("json:" + json.toString());
            pw.print(json.toString());
            pw.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
                pw = null;
            }
        }
    }

    private static String convert(Object str) {
        if (str == null) {
            return (String)str;
        }
        return new String(str.toString());
    }

    public static String object2json(Object obj) {
        StringBuilder json = new StringBuilder();
        if (obj == null) {
            json.append("\"\"");
        } else if (obj instanceof String || obj instanceof Integer || obj instanceof Float || obj instanceof Boolean || obj instanceof Short || obj instanceof Double || obj instanceof Long || obj instanceof BigDecimal || obj instanceof BigInteger || obj instanceof Byte) {
            json.append("\"").append(JsonUtil.string2json((String)obj.toString())).append("\"");
        } else if (obj instanceof Object[]) {
            json.append(JsonUtil.array2json((Object[])((Object[])obj)));
        } else if (obj instanceof List) {
            json.append(JsonUtil.list2json((List)((List)obj)));
        } else if (obj instanceof Map) {
            json.append(JsonUtil.map2json((Map)((Map)obj)));
        } else if (obj instanceof Set) {
            json.append(JsonUtil.set2json((Set)((Set)obj)));
        } else {
            json.append(JsonUtil.bean2json((Object)obj));
        }
        return json.toString();
    }

    public static String bean2json(Object bean) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        PropertyDescriptor[] props = null;
        try {
            props = Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                try {
                    String name = JsonUtil.object2json((Object)props[i].getName());
                    String value = JsonUtil.object2json((Object)props[i].getReadMethod().invoke(bean, new Object[0]));
                    json.append(name);
                    json.append(":");
                    json.append(value);
                    json.append(",");
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public static String list2json(List<?> list) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (list != null && list.size() > 0) {
            for (Object obj : list) {
                json.append(JsonUtil.object2json(obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static String array2json(Object[] array) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (array != null && array.length > 0) {
            for (Object obj : array) {
                json.append(JsonUtil.object2json((Object)obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static String map2json(Map<?, ?> map) {
        StringBuilder json = new StringBuilder();
        json.append("{");
        if (map != null && map.size() > 0) {
            for (Object key : map.keySet()) {
                json.append(JsonUtil.object2json(key));
                json.append(":");
                json.append(JsonUtil.object2json(map.get(key)));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, '}');
        } else {
            json.append("}");
        }
        return json.toString();
    }

    public static String set2json(Set<?> set) {
        StringBuilder json = new StringBuilder();
        json.append("[");
        if (set != null && set.size() > 0) {
            for (Object obj : set) {
                json.append(JsonUtil.object2json(obj));
                json.append(",");
            }
            json.setCharAt(json.length() - 1, ']');
        } else {
            json.append("]");
        }
        return json.toString();
    }

    public static String string2json(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static void outPrintJson(HttpServletResponse response, String strJson) {
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        response.setCharacterEncoding("UTF-8");
        try {
            PrintWriter out = response.getWriter();
            out.print(strJson);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

