/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.actrole.service.impl;

import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.actrole.dao.TmActRoleDao;
import com.biz.eisp.mdm.actrole.service.TmActRoleService;
import com.biz.eisp.mdm.actrole.transformer.TmActRoleEntityToTmActRoleVo;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmActRoleService")
@Transactional
public class TmActRoleServiceImpl
extends BaseServiceImpl
implements TmActRoleService {
    @Autowired
    private TmActRoleDao tmActRoleDao;

    public List<TmPositionVo> findCurrOrgPositionList(String actRoleCode, String currOrgId) {
        List voList = this.tmActRoleDao.findCurrOrgPositionList(actRoleCode, currOrgId);
        return voList;
    }

    public List<TmPositionVo> findCurrAndSubOrgPositionList(String actRoleCode, String currOrgId) {
        List voList = this.tmActRoleDao.findCurrAndSubOrgPositionList(actRoleCode, currOrgId);
        return voList;
    }

    public List<TmPositionVo> findCurrAndBelowOrgPositionList(String actRoleCode, String currOrgId) {
        return this.tmActRoleDao.findCurrAndBelowOrgPositionList(actRoleCode, currOrgId);
    }

    public List<TmActRoleVo> findActRoleList(TmActRoleVo tmActRoleVo, Page page) {
        String hql = "from TmActRoleEntity t where 1=1 ";
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)tmActRoleVo.getRoleCode())) {
            hql = hql + " and t.roleCode like ?";
            params.add("%" + tmActRoleVo.getRoleCode() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)tmActRoleVo.getRoleName())) {
            hql = hql + " and t.roleName like ?";
            params.add("%" + tmActRoleVo.getRoleName() + "%");
        }
        List entityList = this.findByHql(hql, page, params.toArray());
        List voList = Lists.transform((List)entityList, (Function)new TmActRoleEntityToTmActRoleVo());
        return voList;
    }

    public List<TmActRoleVo> findActRoleMain(TmActRoleVo tmActRoleVo, Page page) {
        List list = this.tmActRoleDao.findActRoleByConditions(tmActRoleVo, page);
        return list;
    }

    public List<TmActRoleVo> findAllRole() {
        String hql = "from TmActRoleEntity";
        List entityList = this.findByHql(hql, new Object[0]);
        List voList = Lists.transform((List)entityList, (Function)new TmActRoleEntityToTmActRoleVo());
        return voList;
    }

    public List<TmActRoleVo> findActRoleByPositionMain(TmActRoleVo tmActRoleVo, Page page) {
        return this.tmActRoleDao.findActRoleByPosition(tmActRoleVo, page);
    }

    public List<TmPositionVo> findResponsibleArea(String actRoleCode, String currOrgId) {
        List voList = this.tmActRoleDao.findResponsibleArea(actRoleCode, currOrgId);
        return voList;
    }

    public List<TmPositionVo> findParentPositionList(String actRoleCode, String parent) {
        List voList = this.tmActRoleDao.findParentPositionList(actRoleCode, parent);
        return voList;
    }

    public List<TmPositionVo> findParentsPositionList(String actRoleCode, String submitPositionId) {
        List voList = this.tmActRoleDao.findParentsPositionList(actRoleCode, submitPositionId);
        return voList;
    }

    public List<TmPositionVo> findPositionList(String actRoleCode) {
        List voList = this.tmActRoleDao.findPositionList(actRoleCode);
        return voList;
    }
}

