/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.org.service.impl;

import com.biz.eisp.api.TmMqSerivce;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.TreeGrid;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.bean.TreeGridModel;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TreeGridUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.base.utils.SqlUtil;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.org.dao.TmOrgDao;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgExtendService;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.org.transform.TmOrgEntityToTmOrgVo;
import com.biz.eisp.mdm.org.transform.TmOrgVoTransFormPo;
import com.biz.eisp.mdm.org.vo.QueryTmOrgVo;
import com.biz.eisp.mdm.org.vo.TmOrgVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.system.service.InitListenerService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="tmOrgService")
@Transactional
public class TmOrgServiceImpl
extends BaseServiceImpl
implements TmOrgService {
    @Autowired
    private TmOrgDao tmOrgDao;
    @Autowired(required=false)
    private TmOrgExtendService tmOrgExtendService;
    @Autowired
    private InitListenerService initListenerService;
    @Autowired(required=false)
    private TmMqSerivce tmMqSerivce;

    public List<TreeGrid> findOrgMainGrid(HttpServletRequest request, TreeGrid treeGrid, TmOrgVo tmOrgVo) {
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        SimpleExpression cr1 = null;
        SimpleExpression cr2 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        List<TmOrgEntity> orgList = new ArrayList();
        if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgName()) || StringUtil.isNotEmpty((String)tmOrgVo.getOrgCode())) {
            String hql = "select t from TmOrgEntity t where 1 = 1 and t.enableStatus = ? ";
            if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgName())) {
                hql = hql + " and t.orgName like '%" + tmOrgVo.getOrgName() + "%'";
            }
            if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgCode())) {
                hql = hql + " and t.orgCode like '%" + tmOrgVo.getOrgCode() + "%'";
            }
            List temp = this.findByHql(hql, new Object[]{Globals.ZERO});
            for (TmOrgEntity tt : temp) {
                orgList.add(tt);
                this.addParentsEntity(tt, orgList);
            }
        } else {
            if (StringUtil.isNotEmpty((String)treeGrid.getId())) {
                cr1 = Restrictions.eq((String)"tmOrg.id", (Object)treeGrid.getId());
            }
            if (StringUtil.isEmpty((String)treeGrid.getId())) {
                cr1 = Restrictions.isNull((String)"tmOrg");
            }
            orgList = this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2});
        }
        ArrayList<TmOrgVo> orgVoList = new ArrayList<TmOrgVo>();
        TmOrgEntityToTmOrgVo orgTransForm = new TmOrgEntityToTmOrgVo((TmOrgService)this);
        for (TmOrgEntity tto : orgList) {
            orgVoList.add(orgTransForm.apply(tto));
        }
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("orgName");
        treeGridModel.setParentText("tmOrg_orgName");
        treeGridModel.setParentId("tmOrg_id");
        treeGridModel.setSrc("orgDesc");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("tmOrgList");
        treeGridModel.setCode("orgCode");
        HashMap fieldMap = new HashMap();
        this.addField(fieldMap, TmOrgVo.class);
        treeGridModel.setFieldMap(fieldMap);
        treeGrids = this.treegrid(orgVoList, treeGridModel);
        return treeGrids;
    }

    private void addField(Map<String, Object> fieldMap, Class clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            if (StringUtil.equals((String)"tmOrgList", (String)fieldName)) continue;
            fieldMap.put(fieldName, fieldName);
        }
    }

    private void addParentsEntity(TmOrgEntity tt, List<TmOrgEntity> orgList) {
        String parent_id;
        TmOrgEntity tempEntity;
        String sql = "select parent_id from tm_org where id=?";
        Map map = this.findForMap(sql, new Object[]{tt.getId()});
        if (StringUtil.isNotEmpty(map.get("parent_id")) && (tempEntity = (TmOrgEntity)super.get(TmOrgEntity.class, (Serializable)((Object)(parent_id = (String)map.get("parent_id"))))) != null) {
            if (!orgList.contains(tempEntity)) {
                orgList.add(tempEntity);
            }
            this.addParentsEntity(tempEntity, orgList);
        }
    }

    public List<TmOrgVo> findOrgSelectGrid(TmOrgVo tmOrgVo, Page page) {
        return this.tmOrgDao.findTmOrgList(tmOrgVo, page);
    }

    public List<TmCustomerOrgVo> findOrgCustSelectGrid(TmCustomerOrgVo tmOrgVo, Page page) {
        return this.tmOrgDao.findTmOrgCustList(tmOrgVo, page);
    }

    public List<ComboTree> getParentOrg(TmOrgVo orgVo, ComboTree comboTree, HttpServletRequest request) {
        List tmOrgList = new ArrayList();
        SimpleExpression cr1 = null;
        String selfId = request.getParameter("selfId");
        if (StringUtil.isNotEmpty((String)selfId) && StringUtil.isEmpty((String)comboTree.getId())) {
            tmOrgList = this.findByProperty(TmOrgEntity.class, "id", (Object)selfId);
        } else if (StringUtil.isNotEmpty((String)orgVo.getOrgId())) {
            cr1 = Restrictions.ne((String)"id", (Object)orgVo.getOrgId());
        }
        SimpleExpression cr4 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr2 = Restrictions.eq((String)"tmOrg.id", (Object)comboTree.getId());
            if (StringUtil.isNotEmpty((Object)cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2, cr4}));
            } else {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr2, cr4}));
            }
        } else {
            SimpleExpression cr3 = null;
            if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
                cr3 = Restrictions.eq((String)"id", (Object)orgVo.getPid());
            } else if (StringUtil.isEmpty((String)selfId)) {
                cr3 = Restrictions.isNull((String)"tmOrg.id");
            }
            if (StringUtil.isNotEmpty((Object)cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr3, cr4}));
            } else if (StringUtil.isEmpty((String)selfId)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr3, cr4}));
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("id", "orgName", "tmOrgList");
        List comboTrees = this.comboTree(tmOrgList, comboTreeModel, null, true);
        return comboTrees;
    }

    public List<ComboTree> getParentOrgCode(TmOrgVo orgVo, ComboTree comboTree, HttpServletRequest request) {
        List tmOrgList = new ArrayList();
        SimpleExpression cr1 = null;
        String selfId = request.getParameter("selfId");
        if (StringUtil.isNotEmpty((String)selfId) && StringUtil.isEmpty((String)comboTree.getId())) {
            tmOrgList = this.findByProperty(TmOrgEntity.class, "id", (Object)selfId);
        } else if (StringUtil.isNotEmpty((String)orgVo.getOrgId())) {
            cr1 = Restrictions.ne((String)"id", (Object)orgVo.getOrgId());
        }
        SimpleExpression cr4 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)comboTree.getId())) {
            SimpleExpression cr2 = Restrictions.eq((String)"tmOrg.id", (Object)comboTree.getId());
            if (StringUtil.isNotEmpty((Object)cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2, cr4}));
            } else {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr2, cr4}));
            }
        } else {
            SimpleExpression cr3 = null;
            if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
                cr3 = Restrictions.eq((String)"id", (Object)orgVo.getPid());
            } else if (StringUtil.isEmpty((String)selfId)) {
                cr3 = Restrictions.isNull((String)"tmOrg.id");
            }
            if (StringUtil.isNotEmpty((Object)cr1)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr3, cr4}));
            } else if (StringUtil.isEmpty((String)selfId)) {
                tmOrgList.addAll(this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr3, cr4}));
            }
        }
        ComboTreeModel comboTreeModel = new ComboTreeModel("orgCode", "orgName", "tmOrgList");
        List comboTrees = this.comboTree(tmOrgList, comboTreeModel, null, true);
        return comboTrees;
    }

    public void saveOrUpdateOrg(TmOrgVo tmOrgVo, Page page) {
        TmOrgEntity tmOrgEntity = null;
        if (StringUtil.isNotEmpty((Object)this.tmOrgExtendService)) {
            try {
                this.tmOrgExtendService.validate(tmOrgVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            tmOrgEntity = this.tmOrgExtendService.saveBefore(tmOrgVo, page);
        }
        if (StringUtil.isEmpty(tmOrgEntity)) {
            TmOrgVoTransFormPo formPo = new TmOrgVoTransFormPo();
            tmOrgEntity = formPo.apply(tmOrgVo);
        }
        if (StringUtil.isNotEmpty((Object)this.tmOrgExtendService)) {
            tmOrgEntity = this.tmOrgExtendService.saveBefore(tmOrgEntity, tmOrgVo, page);
        }
        tmOrgEntity.setIsLeaf(Integer.valueOf(1));
        this.saveOrUpdate((Object)tmOrgEntity);
        if (StringUtil.isNotEmpty((Object)this.tmMqSerivce)) {
            this.tmMqSerivce.orgCallBack(tmOrgEntity.getId(), tmOrgEntity.getTmOrg().getId(), tmOrgEntity.getOrgName(), 2);
        } else {
            this.initListenerService.refleshDepart(tmOrgEntity.getId(), StringUtil.isNotEmpty((Object)tmOrgEntity.getTmOrg()) ? tmOrgEntity.getTmOrg().getId() : null, tmOrgEntity.getOrgName(), 2);
        }
        if (StringUtil.isNotEmpty((Object)this.tmOrgExtendService)) {
            tmOrgEntity = this.tmOrgExtendService.savePost(tmOrgEntity, tmOrgVo, page);
        }
        if (StringUtil.isNotEmpty((String)tmOrgVo.getId())) {
            String oldParnetId;
            String id = tmOrgEntity.getId();
            TmOrgEntity oldOrgEntity = (TmOrgEntity)this.get(TmOrgEntity.class, (Serializable)((Object)id));
            String string = oldParnetId = StringUtil.isNotEmpty((Object)oldOrgEntity.getTmOrg()) ? oldOrgEntity.getTmOrg().getId() : null;
            if (StringUtil.isEmpty((String)oldParnetId) || !oldParnetId.equals(tmOrgVo.getPid())) {
                String sql = "update tm_position set parent_id = null where org_id = ? ";
                this.executeSql(sql, new Object[]{id});
            }
        }
    }

    public AjaxJson delOrg(String ids) {
        String[] orgIds;
        AjaxJson j = new AjaxJson();
        j.setSuccess(true);
        j.setMsg("\u5220\u9664\u6210\u529f");
        for (String id : orgIds = ids.split(",")) {
            TmOrgEntity orgEntity = (TmOrgEntity)this.get(TmOrgEntity.class, (Serializable)((Object)id));
            if (CollectionUtils.isEmpty((Collection)orgEntity.getTmOrgList())) {
                List positions = this.findByProperty(TmPositionEntity.class, "tmOrg.id", (Object)id);
                if (!CollectionUtils.isEmpty((Collection)positions)) {
                    j.setMsg("\u5220\u9664\u7684\u5f53\u524d\u7ec4\u7ec7\u3010" + orgEntity.getOrgName() + "\u3011\u6709\u5173\u8054\u7684\u804c\u4f4d\u4e0d\u80fd\u5220\u9664\uff01");
                    j.setSuccess(false);
                    return j;
                }
            } else {
                j.setMsg("\u5220\u9664\u7684\u5f53\u524d\u7ec4\u7ec7\u3010" + orgEntity.getOrgName() + "\u3011\u4e0b\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u5220\u9664\uff01");
                j.setSuccess(false);
                return j;
            }
            orgEntity.setEnableStatus(Globals.ONE);
            orgEntity.setStatus(Globals.ONE);
            this.updateEntity((Object)orgEntity);
            this.initListenerService.refleshDepart(orgEntity.getId(), orgEntity.getTmOrg().getId(), orgEntity.getOrgName(), 3);
        }
        return j;
    }

    public AjaxJson startOrStopTmuser(TmOrgVo orgVo) {
        TmOrgEntity orgEntity;
        AjaxJson j = new AjaxJson();
        String mag = "\u505c\u7528";
        if (Globals.ZERO.equals(orgVo.getEnableStatus())) {
            mag = "\u542f\u7528";
        }
        if (null == (orgEntity = (TmOrgEntity)this.get(TmOrgEntity.class, (Serializable)((Object)orgVo.getId())))) {
            j.setSuccess(false);
            j.setMsg("\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u4fe1\u606f.");
        }
        if (Globals.ONE.equals(orgVo.getEnableStatus())) {
            TmOrgEntity tmOrgEntity = (TmOrgEntity)this.get(TmOrgEntity.class, (Serializable)((Object)orgVo.getId()));
            List positions = this.tmOrgDao.findOrgIDComboTreeByPos(tmOrgEntity.getOrgCode());
            if (!CollectionUtils.isEmpty((Collection)positions)) {
                j.setMsg("\u5f53\u524d" + mag + "\u7ec4\u7ec7\u3010" + orgEntity.getOrgName() + "\u3011,\u6216\u4e0b\u7ea7\u7ec4\u7ec7,\u6709\u5173\u8054\u7684\u804c\u4f4d\u4e0d\u80fd" + mag + "\uff01");
                j.setSuccess(false);
                return j;
            }
            this.tmOrgDao.upDateOrderEnableStatus(tmOrgEntity.getOrgCode(), orgVo.getEnableStatus());
        } else {
            orgEntity.setEnableStatus(orgVo.getEnableStatus());
            this.updateEntity((Object)orgEntity);
        }
        j.setMsg(mag + "\u6210\u529f");
        return j;
    }

    public TmOrgVo getTmOrgByPostionId(String postionId) {
        String sql = "select t1.* from tm_org t1 where t1.id = (select t2.org_id from tm_position t2 where t2.id = ?)";
        TmOrgEntity org = (TmOrgEntity)this.getUniqueBySql(TmOrgEntity.class, sql, new Object[]{postionId});
        TmOrgVo result = new TmOrgEntityToTmOrgVo((TmOrgService)this).apply(org);
        return result;
    }

    public void importOrg(TmOrgVo tmOrgVo) {
        TmOrgVoTransFormPo formPo = new TmOrgVoTransFormPo();
        TmOrgEntity tmOrgEntity = formPo.apply(tmOrgVo);
        this.saveOrUpdate((Object)tmOrgEntity);
    }

    public List<TmOrgVo> findTmOrgByAllPossible(QueryTmOrgVo queryTmOrgVo, Page page) {
        return this.tmOrgDao.findTmOrgByAllPossible(queryTmOrgVo, page);
    }

    public List<TmOrgVo> findAllOrg() {
        List orgs = super.findByCriteria(TmOrgEntity.class, new Criterion[0]);
        return Lists.transform((List)orgs, (Function)new TmOrgEntityToTmOrgVo((TmOrgService)this));
    }

    public List<TmOrgVo> findOrgMainList(TmOrgVo tmOrgVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_ORG, (Object)tmOrgVo);
        List tmOrgList = this.findBySql(TmOrgVo.class, sql, new Object[0]);
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_ORG, (Object)tmOrgVo)) {
            tmOrgList = this.findQueryCustomerOrgList(tmOrgVo, tmOrgList);
        }
        return tmOrgList;
    }

    private List<TmOrgVo> findQueryCustomerOrgList(TmOrgVo tmOrgVo, List<TmOrgVo> voList) {
        if (tmOrgVo.getExportExcel().equals("true")) {
            return voList;
        }
        List allQueryVolist = TreeGridUtil.buildTreeGrid(voList);
        return allQueryVolist;
    }

    private boolean hasQueryValue(TmOrgVo tmOrgVo) {
        return !StringUtil.isEmpty((String)tmOrgVo.getOrgCode()) || !StringUtil.isEmpty((String)tmOrgVo.getOrgName()) || !StringUtil.isEmpty((String)tmOrgVo.getOrgDesc()) || !StringUtil.isEmpty((String)tmOrgVo.getOrgType()) || !StringUtil.isEmpty((String)tmOrgVo.getHeadString()) || !StringUtil.isEmpty((String)tmOrgVo.getExtChar1()) || !StringUtil.isEmpty((String)tmOrgVo.getExtChar2()) || !StringUtil.isEmpty((String)tmOrgVo.getExtChar3()) || !StringUtil.isEmpty((String)tmOrgVo.getExtChar4()) || !StringUtil.isEmpty((String)tmOrgVo.getExtChar5()) || tmOrgVo.getExtDate1() != null || tmOrgVo.getExtDate2() != null || tmOrgVo.getExtNumber1() != null || tmOrgVo.getExtNumber2() != null || tmOrgVo.getExtNumber3() != null || tmOrgVo.getEnableStatus() != null;
    }

    public List<ComboBox> getSalesArae(TmOrgVo orgVo) {
        String sql = "select id value,org_name text from tm_org where 1=1";
        if (StringUtil.isNotEmpty((String)orgVo.getOrgType())) {
            sql = sql + " and org_type=" + orgVo.getOrgType();
        }
        if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
            sql = sql + " and parent_id ='" + orgVo.getPid() + "'";
        }
        return this.findBySql(ComboBox.class, sql, new Object[0]);
    }

    public List<TmOrgVo> getOrgByOrgLevel(TmOrgVo orgVo) {
        String sql = "select org_code as orgCode,org_name as orgName from tm_org where 1=1";
        if (StringUtil.isNotEmpty((String)orgVo.getOrgType())) {
            sql = sql + " and org_type=" + orgVo.getOrgType();
        }
        return this.findBySql(TmOrgVo.class, sql, new Object[0]);
    }

    public boolean validate(String id, String param, String fieldName) {
        SimpleExpression cr1 = Restrictions.eq((String)fieldName, (Object)param);
        SimpleExpression cr3 = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        List tmtbas = new ArrayList();
        if (StringUtil.isNotEmpty((String)id)) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)id);
            tmtbas = this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr2, cr3});
        } else {
            tmtbas = this.findByCriteria(TmOrgEntity.class, new Criterion[]{cr1, cr3});
        }
        return !CollectionUtils.isEmpty(tmtbas);
    }

    public List<ComboBox> getSalesAraeOrgCode(TmOrgVo orgVo) {
        String sql = "select org_code value,org_name text from tm_org where 1=1";
        if (StringUtil.isNotEmpty((String)orgVo.getOrgType())) {
            sql = sql + " and org_type=" + orgVo.getOrgType();
        }
        if (StringUtil.isNotEmpty((String)orgVo.getPid())) {
            sql = sql + " and parent_id ='" + orgVo.getPid() + "'";
        }
        return this.findBySql(ComboBox.class, sql, new Object[0]);
    }

    public List<TmOrgVo> findOptionalOrgSelectList(TmOrgVo tmOrgVo, Page page) {
        return this.tmOrgDao.findOptionalOrgSelectList(tmOrgVo, page);
    }

    public List<TmOrgVo> findOptionalOrgAlreadyList(TmOrgVo tmOrgVo) {
        if (StringUtil.isNotEmpty((String)tmOrgVo.getOrgCodes())) {
            String codes = "";
            for (String orgCode : tmOrgVo.getOrgCodes().split(",")) {
                if (StringUtil.isNotEmpty((String)codes)) {
                    codes = codes + ",";
                }
                codes = codes + "'" + orgCode + "'";
            }
            tmOrgVo.setOrgCodes(codes);
        } else {
            tmOrgVo.setOrgCodes("'-1'");
        }
        return this.tmOrgDao.findOptionalOrgAlreadyList(tmOrgVo);
    }

    public List<TmOrgEntity> findBelowOrgByOrgCode(String orgCode) {
        return this.tmOrgDao.findBelowOrgByOrgCode(orgCode);
    }

    public List<TmOrgVo> findOrgExportList(TmOrgVo tmOrgVo) {
        String sql = DynamicConfigUtil.getInstance().buildTreeGridQuerySql(Globals.TABLE_ORG, (Object)tmOrgVo);
        List tmOrgList = Lists.newArrayList();
        if (DynamicConfigUtil.getInstance().isHaveQuery(Globals.TABLE_ORG, (Object)tmOrgVo)) {
            tmOrgList = this.findBySql(TmOrgVo.class, sql, new Object[0]);
            tmOrgList.forEach(e -> e.setOrgName(e.getText()));
        } else {
            tmOrgList = this.tmOrgDao.findAllList();
        }
        return tmOrgList;
    }

    public List<ComboBox> findOrgCodeCombobox() {
        String sql = "SELECT DISTINCT CUST_ORG_CODE value,CUST_ORG_CODE text  FROM tm_customer_org";
        return this.findBySql(ComboBox.class, sql, new Object[0]);
    }

    public List<String> findOrgListDowm(String orgId) {
        String sql = " select id,parent_id from tm_org where id=? ";
        List orgVos = this.findBySql(TmOrgVo.class, sql, new Object[]{orgId});
        ArrayList<String> parentIds = new ArrayList<String>();
        parentIds.add(((TmOrgVo)orgVos.get(0)).getId());
        this.getOrgListChirld(parentIds, orgVos);
        return parentIds;
    }

    public void getOrgListChirld(List<String> parentIds, List<TmOrgVo> orgEntities) {
        if (CollectionUtil.listEmpty(orgEntities)) {
            return;
        }
        List<String> list = orgEntities.stream().map(TmOrgVo::getId).collect(Collectors.toList());
        String sql = " select id,parent_id from tm_org where 1=1 ";
        String sqls = SqlUtil.setSqlIn((String[])list.toArray(new String[list.size()]), (String)"parent_id", (boolean)true, null);
        List orgVos = this.findBySql(TmOrgVo.class, sql = sql + sqls, new Object[0]);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)orgVos)) {
            List listTemp = orgVos.stream().map(TmOrgVo::getId).collect(Collectors.toList());
            parentIds.addAll(listTemp);
            this.getOrgListChirld(parentIds, orgVos);
        }
    }
}

