/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.terminal.dao.TmTerminalDao;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGDetailEntity;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTerminalDelExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalSearchExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.transformer.TmTerminalVoToTmTerminalEntity;
import com.biz.eisp.mdm.terminal.util.TerminalLogMsgUtil;
import com.biz.eisp.mdm.terminal.vo.QueryTmTerminalVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmTerminalService")
@Transactional
public class TmTerminalServiceImpl
extends BaseServiceImpl
implements TmTerminalService {
    @Autowired
    private TmTerminalDao tmTerminalDao;
    @Autowired(required=false)
    private TmTerminalExtendService terminalExtendService;
    @Autowired(required=false)
    private TmTerminalSearchExtendService tmTerminalSearchExtendService;
    @Autowired(required=false)
    private TmTerminalDelExtendService tmTerminalDelExtendService;

    public List<TmTerminalVo> findTmTerminalList(TmTerminalVo tmTerminalVo, Page page) {
        String sql = "";
        if (this.tmTerminalSearchExtendService != null) {
            sql = this.tmTerminalSearchExtendService.buildSearchSql(tmTerminalVo);
            if (StringUtil.isEmpty((String)sql)) {
                sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_TERMINAL, (Object)tmTerminalVo);
                sql = this.tmTerminalSearchExtendService.extendSearchSql(tmTerminalVo, sql);
            }
            return this.tmTerminalDao.findTerminalList(tmTerminalVo, page, sql);
        }
        sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_TERMINAL, (Object)tmTerminalVo);
        List terminalVos = this.tmTerminalDao.findTerminalList(tmTerminalVo, page, sql = this.appendTerminalCondition(sql, tmTerminalVo));
        if (CollectionUtil.listNotEmptyNotSizeZero((List)terminalVos)) {
            int len = terminalVos.size();
            for (int i = 0; i < len; ++i) {
                TmTerminalVo vo = (TmTerminalVo)terminalVos.get(i);
                List vos = this.tmTerminalDao.findTerminalListChildren(vo.getId(), this.appendTerminalConditionSplit());
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)vos)) continue;
                TmTerminalVo voo = (TmTerminalVo)vos.get(0);
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)voo, (Object)vo);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return terminalVos;
    }

    public String appendTerminalCondition(String sql, TmTerminalVo terminalVo) {
        String joinSql = "";
        String sqlOn = " ";
        String sqlWhere = "";
        if (StringUtil.isNotEmpty((String)terminalVo.getId())) {
            sqlWhere = " and (t.id='" + terminalVo.getId() + "'";
        }
        if (StringUtil.isEmpty((String)terminalVo.getId()) || StringUtil.isNotEmpty((String)terminalVo.getDockUserName()) || StringUtil.isNotEmpty((String)terminalVo.getDockPosition()) || StringUtil.isNotEmpty((String)terminalVo.getBusinessGroup()) || StringUtil.isNotEmpty((String)terminalVo.getCustomerName())) {
            sqlWhere = " and exists(select 1 from tm_terminal t2 left join TM_R_TERM_CUST_POS_BG t3 on t3.terminal_id=t2.id left join tm_r_user_position up on up.position_id=t3.position_id left join tm_user tu on tu.id=up.user_id left join tm_position t4 on t4.id = t3.position_id  left join tm_customer tc on tc.id=t3.customer_id  where t2.id=t.id ";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getDockUserName())) {
            sqlWhere = sqlWhere + " and  (tu.fullname like '%" + terminalVo.getDockUserName() + "%'  or tu.fullname like '%" + terminalVo.getDockUserName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getDockPosition())) {
            sqlWhere = sqlWhere + "and (t4.position_name like '%" + terminalVo.getDockPosition() + "%'or t4.position_code like '%" + terminalVo.getDockPosition() + "%')";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getBusinessGroup())) {
            sqlWhere = sqlWhere + " and t3.businessGroup like '%" + terminalVo.getBusinessGroup() + "%'";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getCustomerName())) {
            sqlWhere = sqlWhere + "and (tc.customer_name like '%" + terminalVo.getCustomerName() + "%' or tc.customer_code like '%" + terminalVo.getCustomerCode() + "%')";
        }
        sqlWhere = sqlWhere + ")";
        if (StringUtil.isEmpty((String)terminalVo.getId()) && StringUtil.isEmpty((String)terminalVo.getDockUserName()) && StringUtil.isEmpty((String)terminalVo.getDockPosition()) && StringUtil.isEmpty((String)terminalVo.getCustomerName()) && StringUtil.isEmpty((String)terminalVo.getBusinessGroup())) {
            sqlWhere = "";
        }
        String orderSql = " order by t.terminalCode desc";
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, sqlOn, sqlWhere, orderSql);
    }

    public String appendTerminalConditionSplit() {
        String sql = "select distinct t1.terminal_id terminalId,to_char(listagg(t1.customer_id,',') within GROUP (order by t1.customer_id)) customerId,to_char(listagg(tc.customer_name,',') within GROUP (order by tc.customer_name)) customerName,to_char(listagg(tc.customer_code,',') within GROUP (order by tc.customer_code)) customerCode ,to_char(listagg(t1.position_id,',') within GROUP (order by  t2.position_name))  positionId,to_char(listagg(t1.business_group,',') within GROUP (order by  t2.position_name)) businessGroup ,to_char(listagg(t2.position_name,',') within GROUP (order by t2.position_name)) dockPosition,to_char(listagg(t2.position_code,',') within GROUP (order by t2.position_name)) position_code,to_char(listagg(tu.username,',') within GROUP (order by t2.position_name)) username,to_char(listagg(tu.fullname,',') within GROUP (order by t2.position_name)) dockUserName from TM_R_TERM_CUST_POS_BG t1 left join tm_customer tc on tc.id=t1.customer_id  left join tm_position t2 on t2.id = t1.position_id  left join tm_r_user_position up on up.position_id=t1.position_id left join tm_user tu on tu.id=up.user_id  where  t1.terminal_Id=:terminalId group by t1.terminal_id";
        return sql;
    }

    public void saveTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
        ArrayList addBusinessGroupVoList = new ArrayList();
        ArrayList deleteBusinessGroupVoList = new ArrayList();
        TmTerminalEntity terminalEntity = null;
        if (StringUtil.isNotEmpty((Object)this.terminalExtendService)) {
            try {
                this.terminalExtendService.validate(tmTerminalVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            terminalEntity = this.terminalExtendService.saveBefore(tmTerminalVo, page);
        }
        if (StringUtil.isEmpty(terminalEntity)) {
            terminalEntity = new TmTerminalVoToTmTerminalEntity((TmTerminalService)this, addBusinessGroupVoList, deleteBusinessGroupVoList).apply(tmTerminalVo);
        }
        if (StringUtil.isNotEmpty((Object)this.terminalExtendService)) {
            terminalEntity = this.terminalExtendService.saveBefore(terminalEntity, tmTerminalVo, page);
        }
        this.saveOrUpdate(terminalEntity);
        this.executeSql("DELETE FROM TM_R_TERM_CUST_POS_BG WHERE TERMINAL_ID IS NULL", new Object[0]);
        this.getSession().flush();
        this.saveBusinessGroupInfo(terminalEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
        if (StringUtil.isNotEmpty((Object)this.terminalExtendService)) {
            terminalEntity = this.terminalExtendService.savePost(terminalEntity, tmTerminalVo, page);
        }
    }

    private void saveBusinessGroupInfo(TmTerminalEntity tmTerminalEntity, List<TmBusinessGroupVo> addBusinessGroupVoList, List<TmBusinessGroupVo> deleteBusinessGroupVoList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteBusinessGroupVoList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (TmBusinessGroupVo vo : deleteBusinessGroupVoList) {
                map.put(vo.getBusinessGroup(), vo.getBusinessGroup());
            }
            String deleteSql = "delete from tm_r_term_cust_pos_bg_detail where business_group = ?";
            Set keyset = map.keySet();
            for (String key : keyset) {
                this.executeSql(deleteSql, new Object[]{key});
            }
        }
        this.getSession().flush();
        if (CollectionUtil.listNotEmptyNotSizeZero(addBusinessGroupVoList)) {
            for (TmBusinessGroupVo vo : addBusinessGroupVoList) {
                if (vo.getTypeCode() == "orgCode" || vo.getTypeCode() == "positionCode" || vo.getTypeCode() == "customerCode") continue;
                TmRTermCustPosBGDetailEntity entity = new TmRTermCustPosBGDetailEntity();
                entity.setBusinessGroup(vo.getBusinessGroup());
                entity.setDetailCode(vo.getDetailCode());
                entity.setDetailName(vo.getDetailName());
                entity.setTypeCode(vo.getTypeCode());
                entity.setTypeName(vo.getTypeName());
                this.save((Object)entity);
            }
        }
        this.getSession().flush();
        this.saveBusinessGroupLog(tmTerminalEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
    }

    private void saveBusinessGroupLog(TmTerminalEntity tmTerminalEntity, List<TmBusinessGroupVo> newBusinessGroupVoList, List<TmBusinessGroupVo> oldBusinessGroupVoList) {
        Map oldMap = this.buildMapByBusinessGroup(oldBusinessGroupVoList);
        Map newMap = this.buildMapByBusinessGroup(newBusinessGroupVoList);
        Set oldKeySet = oldMap.keySet();
        String updateMsg = "";
        String deleteMsg = "";
        String addMsg = "";
        for (String oldKey : oldKeySet) {
            if (newMap.containsKey(oldKey)) {
                updateMsg = updateMsg + TerminalLogMsgUtil.buildUpdateMsg((List)((List)newMap.get(oldKey)), (List)((List)oldMap.get(oldKey))) + "<hr>";
                newMap.remove(oldKey);
                continue;
            }
            deleteMsg = deleteMsg + TerminalLogMsgUtil.buildDeleteMsg((List)((List)oldMap.get(oldKey))) + "<hr>";
        }
        if (StringUtils.isNotBlank((CharSequence)(addMsg = addMsg + this.buildAddMsg(tmTerminalEntity, newMap)))) {
            this.addLog(OperationType.INSERT, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmTerminalEntity.getId(), addMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)deleteMsg)) {
            this.addLog(OperationType.DELETE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmTerminalEntity.getId(), deleteMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)updateMsg)) {
            this.addLog(OperationType.UPDATE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmTerminalEntity.getId(), updateMsg);
        }
    }

    private Map<String, List<TmBusinessGroupVo>> buildMapByBusinessGroup(List<TmBusinessGroupVo> voList) {
        HashMap<String, List<TmBusinessGroupVo>> map = new HashMap<String, List<TmBusinessGroupVo>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
            for (TmBusinessGroupVo oldBusinessGroupVo : voList) {
                if (map.containsKey(oldBusinessGroupVo.getBusinessGroup())) {
                    ((List)map.get(oldBusinessGroupVo.getBusinessGroup())).add(oldBusinessGroupVo);
                    continue;
                }
                ArrayList<TmBusinessGroupVo> list = new ArrayList<TmBusinessGroupVo>();
                list.add(oldBusinessGroupVo);
                map.put(oldBusinessGroupVo.getBusinessGroup(), list);
            }
        }
        return map;
    }

    private String buildAddMsg(TmTerminalEntity tmTerminalEntity, Map<String, List<TmBusinessGroupVo>> newMap) {
        Set<String> keySet = newMap.keySet();
        String msg = "";
        for (String key : keySet) {
            msg = msg + TerminalLogMsgUtil.buildAddMsg(newMap.get(key));
            msg = msg + "<hr>";
        }
        return msg;
    }

    public void deleteTmTerminal(String ids, Page page) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] terminalIds;
            for (String terminalId : terminalIds = ids.split(",")) {
                TmTerminalEntity terminalEntity = (TmTerminalEntity)this.get(TmTerminalEntity.class, (Serializable)((Object)terminalId));
                if (this.tmTerminalDelExtendService != null) {
                    this.tmTerminalDelExtendService.validate(terminalEntity, page);
                    this.tmTerminalDelExtendService.delBefore(terminalEntity, page);
                }
                if (terminalEntity == null || !StringUtil.isNotEmpty((String)terminalEntity.getId())) continue;
                this.delete((Object)terminalEntity);
                if (this.tmTerminalDelExtendService == null) continue;
                this.tmTerminalDelExtendService.delPost(terminalEntity, page);
            }
        }
    }

    public TmTerminalVo getTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
        List list = this.findTmTerminalList(tmTerminalVo, page);
        return list.size() > 0 ? (TmTerminalVo)list.get(0) : new TmTerminalVo();
    }

    public List<TmTerminalVo> findTmTerminalByPosList(TmTerminalVo terminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalByPosList(terminalVo, page);
    }

    public List<TmTerminalVo> findTmTerminalByAllPossible(QueryTmTerminalVo queryTmTerminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalByAllPossible(queryTmTerminalVo, page);
    }

    public List<TmLogVo> findTerminalLogList(TmLogVo tmLogVo, Page page) {
        return this.tmTerminalDao.findTerminalLogList(tmLogVo, page);
    }

    public List<QueryTmTerminalVo> findTmTerminalAndCustByterminalType(QueryTmTerminalVo queryTmTerminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalAndCustByterminalType(queryTmTerminalVo, page);
    }

    public AjaxJson startOrStop(TmTerminalVo tmTerminalVo) {
        AjaxJson j = new AjaxJson();
        TmTerminalEntity tmTerminalEntity = (TmTerminalEntity)this.get(TmTerminalEntity.class, (Serializable)((Object)tmTerminalVo.getId()));
        if (StringUtil.isNotEmpty((Object)tmTerminalEntity)) {
            if (tmTerminalEntity.getEnableStatus().toString().equals(tmTerminalVo.getEnableStatus().toString())) {
                j.setSuccess(false);
                String fg = Globals.ZERO.equals(tmTerminalVo.getEnableStatus()) ? "\u542f\u7528" : "\u505c\u7528";
                j.setMsg("\u8be5\u6570\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a" + fg + "\uff0c\u65e0\u9700\u518d\u6b21\u64cd\u4f5c");
            } else {
                tmTerminalEntity.setEnableStatus(tmTerminalVo.getEnableStatus());
                this.updateEntity((Object)tmTerminalEntity);
            }
        } else {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u7eaa\u5f55");
        }
        return j;
    }
}

