<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<!DOCTYPE html>
<html>
<body>
<table id="dg" class="easyui-datagrid" title="权限配置"
	   data-options="toolbar:'#tb',fit:true,fitColumns:true,singleSelect:true,url:'taProcessNodeAuthController.do?findProcessNodeAuthList&taProcessId=${taProcessId}',method: 'get',onClickCell: onClickCell">
	<thead>
	<tr>
		<th data-options="field:'id',width:80,hidden:true">id</th>
		<th data-options="field:'processNodeName',align:'right'">节点名称</th>
		<th data-options="field:'processNodeCode',align:'right'">节点代码</th>
		<c:forEach items="${btnList}" var="item">
			<th data-options="field:'${item.dictCode}',align:'center',editor:{type:'checkbox',options:{on:'Y',off:'N'}},formatter:formatterCheckBox">${item.dictDesc}</th>
		</c:forEach>
	</tr>
	</thead>
</table>

<div id="tb" style="height:auto">
	<a href="javascript:void(0)" class="easyui-linkbutton" data-options="iconCls:'icon-save',plain:true" onclick="saveConfig()">保存</a>
</div>

<script type="text/javascript">
    var editIndex = undefined;
    function endEditing(){
        if (editIndex == undefined){return true}
        if ($('#dg').datagrid('validateRow', editIndex)){
            $('#dg').datagrid('endEdit', editIndex);
            editIndex = undefined;
            return true;
        } else {
            return false;
        }
    }
    function onClickCell(index, field){
        if (editIndex != index){
            if (endEditing()){
                $('#dg').datagrid('selectRow', index)
                    .datagrid('beginEdit', index);
                var ed = $('#dg').datagrid('getEditor', {index:index,field:field});
                if (ed){
                    ($(ed.target).data('textbox') ? $(ed.target).textbox('textbox') : $(ed.target)).focus();
                }
                editIndex = index;
            } else {
                setTimeout(function(){
                    $('#dg').datagrid('selectRow', editIndex);
                },0);
            }
        }
    }

    function formatterCheckBox(val,row,index) {
        if(val == "Y") {
            return "是";
		} else {
            return "否";
		}
    }

    function saveConfig() {
        if (endEditing()){
            var rows = $("#dg").datagrid("getRows");

            $.ajax({
                url : "taProcessNodeAuthController.do?saveConfig",
                type : "post",
                data : {
                    jsonStr:JSON.stringify(rows)
                },async:false,
                success : function(data) {
                    var d = data;
                    if (d.success) {
                       tip(d.msg);
                        $('#dg').datagrid('reload');
                    }
                }
            });

        }
    }
</script>
</body>
</html>