<%@ page language="java" import="java.util.*" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<!DOCTYPE html>
<html>
<head>
<title>客户用户信息</title>
<t:base type="jquery,easyui,tools"></t:base>
</head>
<body style="overflow-y: hidden" scroll="no">
<t:formvalid formid="formobj" layout="div" dialog="true" refresh="true" action="tmCustUserController.do?saveTmUser"
	beforeSubmit="setRole();">

    <div class="form">
        <label class="Validform_label">用户类型:</label>
        <select id="userType" name="userType">
            <c:forEach items="${userTypeList}" var="item">
                <c:if test="${item.dictCode == 1 || item.dictCode == 3}">
                    <option value="${item.dictCode}"
                            <c:if test="${item.dictCode == vo.userType}">selected</c:if> >${item.dictValue}</option>
                </c:if>
            </c:forEach>
        </select>
    </div>

	<!--动态表单加载  -->
	<t:formmdm extendTableName="${extendTableName}" optype="${optype}"
					objName="vo"></t:formmdm>
	
	<div class="form">
        <label class="Validform_label">关联客户:</label>
        <input name="custName" id="custName" class="inputxt" value="${vo.custName}" readonly = readonly>
          <span style="color: red">*</span>
        <a href="#" class="easyui-linkbutton" plain="true" icon="icon-search" onClick="popCust();"></a>
        <input name="custId" id="custId" type="hidden" datatype="*"  value="${vo.custId}">
    </div>
	<div class="form">
        <label class="Validform_label">权限角色:</label>
        <input name="roleNames" id="roleNames" class="inputxt" value="${vo.roleNames }">
        <a href="#" class="easyui-linkbutton" plain="true" icon="icon-search" onClick="popRole();"></a>
        <input name="roleIds" id="roleIds" type="hidden" value="${vo.roleIds }">
        <input name="roleJson" id="roleJson" type="hidden">
    </div>
    <div class="form">
        <label class="Validform_label">密码:</label>
        <c:if test="${empty vo.id }" >
            <input name="password" class="inputxt" type="password" value="${vo.password}" datatype= "/^[a-zA-Z0-9_\x21-\x7e]{6,20}$/" errormsg="只能填写长度为6~30，字符类型（英文、数字、标点符号、特殊字符）">
            <span style="color: red">*</span>
        </c:if>
        <c:if test="${not empty vo.id }" >
            <input type="text" name="password" autocomplete="off"   class="input-text" onfocus="this.type='password'" placeholder="请输入密码" datatype= "/^$|^[a-zA-Z0-9_\x21-\x7e]{6,20}$/" errormsg="只能填写长度为6~30，字符类型（英文、数字、标点符号、特殊字符）"/>
        </c:if>

    </div>
</t:formvalid> 
<c:if test="${not empty includeJsp}">
	<jsp:include page="${includeJsp }" flush="true"/>
</c:if>
<script type="text/javascript">
$(function () {
    $("#extChar1").parent().remove();
});

//客户
function popCust(){

    var url = "tmTermCustPostController.do?goSelectNewCustomer&custUser=&singleSelect=false";
    var userType = $("#userType").val();
    if (userType == "1") {
        var userName = $("#userName").val();
        if (userName == null || userName == "") {
            tip("请先填写登录账号");
            return;
        }
        url += "&customerCode=" + userName;
    }
	popClickSingle("custList","custId,custName", "id,customerName", url, 500,400,true);
}

$("#userType").change(function () {
    checkCustUserSelect();
});

$("#userName").change(function () {
    checkCustUserSelect();
});

function checkCustUserSelect() {
    var userType = $("#userType").val();
    if (userType == "1") {
        $("#custName").val("");
        $("#custId").val("");
    }
}

//权限角色
function popRole(){
	popSelectClick("roleJson", "roleNames","roleName","tmPositionController.do?goSelectRole&userId=${vo.id}&accessEntry="+accessEntry,"roleCheckedList",null,1000,450);
}
//提交前验证
function setRole(){
	//权限角色
	var roleJson = $("#roleJson").val();
	var roleIds = $("#roleIds").val();
	if(roleJson != null && roleJson != ""){
		roleJson = JSON.parse(roleJson);
		roleIds = "";
		$.each(roleJson,function(i,v){
			if(roleIds != ""){
				roleIds+=",";
			}
			roleIds+=v.id;
		});
	}
	$("#roleIds").val(roleIds);
	return true;
}
</script>
</body>
</html>
