<%@ page language="java" import="java.util.*" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<!DOCTYPE html>
<html>
<head>
    <title>客户主数据</title>
    <t:base type="jquery,easyui,tools"></t:base>
    <style>
        html {
            background: #fff;
        }
        .part-title-div {
            /*width: 100%;*/
            height: auto;
            clear: both;
            background: #B3CFE5
        }

        .part-title-div div {
            padding: 5px;
            border:none!important;
        }

        .line-div {
            width: 100%;
            height: auto;
        }

        .table-div {
            margin: 0 auto;
            width: 100%;
            height: auto;
            text-align: center
        }

        .table-style {
            width: 100%;
            height: auto;
            border-collapse: collapse
        }

        .table-td-left-title {
            text-align: right;
            width: 20%;
        }

        .table-td-right-text {
            text-align: left;
            width: 30%;
        }

        table tr td {
            text-align: center;
            margin: 0 auto;
            padding: 5px 0 5px 5px;
        }
    </style>
</head>
<body>


<div class="part-title-div">
    <div>基本属性</div>
</div>

<div class="line-div">
    <div class="table-div">
        <table border="0" cellspacing="2px"
               class="table-style">
            <tr>
                <td class="table-td-left-title">客户SAP编码：</td>
                <td class="table-td-right-text">${vo.erpCode}</td>
                <td class="table-td-left-title">客户名称：</td>
                <td class="table-td-right-text">${vo.customerName}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">客户负责人姓名：</td>
                <td class="table-td-right-text">${vo.linkman}</td>
                <td class="table-td-left-title">客户负责人电话：</td>
                <td class="table-td-right-text">${vo.linkmanPhone}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">国家：</td>
                <td class="table-td-right-text">${vo.extChar1}</td>
                <td class="table-td-left-title">语言：</td>
                <td class="table-td-right-text">${vo.extChar2}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">省：</td>
                <td class="table-td-right-text">${vo.province}</td>
                <td class="table-td-left-title">市：</td>
                <td class="table-td-right-text">${vo.city}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">区：</td>
                <td class="table-td-right-text">${vo.area}</td>
                <td class="table-td-left-title">街道：</td>
                <td class="table-td-right-text">${vo.address}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">客户状态：</td>
                <td class="table-td-right-text">${vo.cooperativeName}</td>
                <td class="table-td-left-title"></td>
                <td class="table-td-right-text"></td>
            </tr>

        </table>
    </div>

</div>


<div class="part-title-div">
    <div>公司信息</div>
</div>


<div class="line-div">
    <div class="table-div">
        <table border="0" cellspacing="2px"
               class="table-style">
            <tr>
                <td class="table-td-left-title">公司代码：</td>
                <td class="table-td-right-text">${vo.companyCode}</td>
                <td class="table-td-left-title">公司名称：</td>
                <td class="table-td-right-text">${vo.companyName}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">货币：</td>
                <td class="table-td-right-text">${vo.currency}</td>
                <td class="table-td-left-title">所属大区：</td>
                <td class="table-td-right-text">${vo.largeArea}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">价格清单：</td>
                <td class="table-td-right-text">${vo.pltyp}</td>
                <td class="table-td-left-title">渠道：</td>
                <td class="table-td-right-text">${vo.channelTypeName}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">合伙人：</td>
                <td class="table-td-right-text">${vo.partnerName}</td>
                <td class="table-td-left-title">合伙人编码：</td>
                <td class="table-td-right-text">${vo.partnerCode}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">固定费比：</td>
                <td class="table-td-right-text">${vo.feeRatio}</td>
                <td class="table-td-left-title">合作状态：</td>
                <td class="table-td-right-text">${vo.itemCooperativeName}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">发货工厂：</td>
                <td class="table-td-right-text">${vo.vwerk}</td>
                <td class="table-td-left-title">装运条件：</td>
                <td class="table-td-right-text">${vo.vsbed}</td>
            </tr>
        </table>
    </div>

</div>


<div class="part-title-div">
    <div>财务开票信息</div>
</div>


<div class="line-div">
    <div class="table-div">
        <table border="0" cellspacing="2px"
               class="table-style">
            <tr>
                <td class="table-td-left-title">发票类型：</td>
                <td class="table-td-right-text">
                    <c:if test="${not empty vo.extChar3}">
                        <c:forEach items="${invoiceTypeMap}" var="map">
                            <c:if test="${vo.extChar3 == map.key}">
                                ${map.value}
                            </c:if>
                        </c:forEach>
                    </c:if>
                </td>
                <td class="table-td-left-title">开票抬头：</td>
                <td class="table-td-right-text">${vo.extChar4}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">纳税人识别号：</td>
                <td class="table-td-right-text">${vo.extChar5}</td>
                <td class="table-td-left-title">开户地址：</td>
                <td class="table-td-right-text">${vo.extChar6}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">开票电话（座机）：</td>
                <td class="table-td-right-text">${vo.extChar7}</td>
                <td class="table-td-left-title">开户银行：</td>
                <td class="table-td-right-text">${vo.extChar8}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">银行行号：</td>
                <td class="table-td-right-text">${vo.extChar9}</td>
                <td class="table-td-left-title">账号：</td>
                <td class="table-td-right-text">${vo.extChar10}</td>
            </tr>
        </table>
    </div>

</div>


<div class="part-title-div">
    <div>发票接收人信息</div>
</div>


<div class="line-div">
    <div class="table-div">
        <table border="0" cellspacing="2px"
               class="table-style">
            <tr>
                <td class="table-td-left-title">发票接收人姓名：</td>
                <td class="table-td-right-text">${vo.extChar12}</td>
                <td class="table-td-left-title">发票接收人电话：</td>
                <td class="table-td-right-text">${vo.extChar13}</td>
            </tr>
            <tr>
                <td class="table-td-left-title">发票邮寄地址：</td>
                <td class="table-td-right-text">${vo.extChar14}</td>
                <td class="table-td-left-title">电子发票接收邮箱：</td>
                <td class="table-td-right-text">${vo.extChar11}</td>
            </tr>

        </table>
    </div>

</div>


<div class="part-title-div">
    <div>收货地址</div>
</div>

<div class="line-div" style="padding:10px 0 10px 0;text-align: center">
    <div style="margin: 0 auto;width: 90%;height: auto;text-align: center">
        <table border="1" cellspacing="0px"
               style="width: 100%;height:auto;border-collapse:collapse">
            <tr>
                <td>送达方编码</td>
                <td>收货地址</td>
                <td>收货人</td>
                <td>收货人电话</td>
            </tr>
            <c:forEach items="${vo.itemDetailList}" var="item">
                <tr>
                    <td>${item.deliverCode}</td>
                    <td>${item.addressDetail}</td>
                    <td>${item.consignee}</td>
                    <td>${item.consigneeCall}</td>
                </tr>
            </c:forEach>
        </table>
    </div>
</div>

</body>
</html>

<script>

    $(function () {
        init();
    });

    function init() {
        $("td").attr("valign", "top");
    }

</script>
