<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/context/mytags.jsp"%>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<style>
	.combo {
		border: 1px solid #D2D2D2;
		background-color: #ffffff;
		border-radius: 4px;
		box-sizing: border-box;
		width: 96pt !important;
		height: 24px !important;
	}

	.combo-arrow {
		height: 22px !important;
		overflow: hidden;
		display: inline-block;
		cursor: pointer;
		background: none;
		background-color: #e7e7e7;
		position: relative;
	}

	.combo-arrow:after {
		content: "";
		position: absolute;
		top: 9px;
		left: 5px;
		width: 0;
		height: 0;
		border-style: solid;
		border-width: 4px;
		border-color: #b0a4a4 transparent transparent transparent;
	}
</style>
<div id="customer" class="easyui-layout" fit="true">
	<div region="center">
	
	    <t:datagrid name="customerList"  extendTableName="${extendTableName}" idField="id"  fit="true"
	                actionUrl="tmCustomerController.do?findTmCustomerList" queryMode="group"   fitColumns="false" pagination="true">
	      
	      	<!--自定义非显示的查询条件 begin -->
	      	<t:dgCol title="对接人职位" field="dockPosition"  columnOrder="16" query="true"  hidden="false"  ></t:dgCol>
	     	<t:dgCol title="对接人" field="dockUserName"  columnOrder="17" query="true"  hidden="false"  ></t:dgCol>
	      	<t:dgCol title="业务组" field="businessGroup" columnOrder="18"   dictionary="business_group"  hidden="true"  ></t:dgCol>
	      	<!--自定义非显示的查询条件 end -->
	      	
	        <!-- 工具栏操作  begin -->
	        <t:dgToolBar title="新增" operationCode="add"  icon="icon-add" url="tmCustomerController.do?goTmCustomer&optype=0" funname="add"  width="1300" height="400"></t:dgToolBar>
	        <t:dgToolBar title="编辑" operationCode="edit" icon="icon-edit" url="tmCustomerController.do?goTmCustomer&optype=1" funname="update" width="1300" height="400"></t:dgToolBar>
	        <t:dgToolBar title="删除" operationCode="remove" icon="icon-remove" url="tmCustomerController.do?deleteTmCustomer" funname="deleteALLSelect"></t:dgToolBar>
			<t:dgToolBar title="启用" operationCode="start" icon="icon-start" url="tmCustomerController.do?startOrStop" funname="startOrStop('009')"></t:dgToolBar>
			<t:dgToolBar title="停用" operationCode="stop" icon="icon-stop" url="tmCustomerController.do?startOrStop" funname="startOrStop('003')"></t:dgToolBar>
			<t:dgToolBar title="查看" operationCode="look" icon="icon-look" url="tmCustomerController.do?goTmCustomer&optype=2" funname="detail" width="1300" height="400"></t:dgToolBar>
	        <t:dgToolBar title="导入" operationCode="dataIn" icon="icon-dataIn" onclick="importDataByXml({impName:'tmCustomer', gridName:'customerList'})"></t:dgToolBar> 
	        <t:dgToolBar title="导出" operationCode="dataOut" icon="icon-dataOut" url="tmCustomerController.do?exportXls" funname="excelExport" ></t:dgToolBar>
			<t:dgToolBar title="关联终端" operationCode="terminalRel" icon="icon-stores_group" url="tmTermCustPostController.do?goTermPosCustMain" funname="detailTmCustPos"></t:dgToolBar>
			<t:dgToolBar title="客户-终端关系维护" operationCode="terminalCustRel" icon="icon-stores_group" onclick="showTerminals()" ></t:dgToolBar>
	        <t:dgToolBar title="日志" operationCode="log" icon="icon-log"   url="tmCustomerController.do?goTmLogDetailMain" funname="detailLog" width="1200" height="460"></t:dgToolBar>
			<t:dgToolBar title="收货地址维护" operationCode="fixAddress"  icon="icon-add" url="tmAddressController.do?goTmAddressMain" funname="openAddress"  width="1300" height="400"></t:dgToolBar>
	          <!-- 工具栏操作  end -->
	            
	    </t:datagrid>
	</div>
</div>

<c:if test="${not empty includeJSP}">
	<jsp:include page="${includeJSP}" flush="true"></jsp:include>
</c:if>

<script type="text/javascript">

    //关联终端查看
    function detailTmCustPos(title, url, gridname, width, height) {
        var rowsData = $('#customerList').datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择要操作的数据');
            return;
        }
        if (rowsData.length > 1) {
            tip('请选择一条数据再操作');
            return;
        }
        openwindow(title, url+"&customerId="+rowsData[0].id, gridname,600, 500);
    }

	//关联终端按钮触发事件
	function showTerminals(){
		    var rowsData = $('#customerList').datagrid('getSelections');
		    if (!rowsData || rowsData.length == 0) {
		        tip('请选择要操作的数据');
		        return;
		    }
		    if (rowsData.length > 1) {
		        tip('请选择一条数据再操作');
		        return;
		    }
		   var  url = 'tmTermCustPostController.do?goMaintainCustAndTerminalMain&customerId=' + rowsData[0].id;
			openwindow("客户-终端关系维护", url,"customerList", 1000, 700);
	}

    function update(title, url, id, width, height) {
        gridname = id;
        var rowsData = $('#' + id).datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择编辑项目');
            return;
        }
        if (rowsData.length > 1) {
            tip('请选择一条记录再编辑');
            return;
        }

        url += '&id=' + rowsData[0].id;
        if (!width || width=="" || width=='null' || !height || height=="" || height=='null')
            createwindowSmall(title, url, width, height);
        else
            createwindow(title, url, width, height);
    }

    //关联终端查看
    function openAddress(title, url, gridname, width, height) {
        var rowsData = $('#customerList').datagrid('getSelections');
        if (!rowsData || rowsData.length == 0) {
            tip('请选择要操作的数据');
            return;
        }
        if (rowsData.length > 1) {
            tip('请选择一条数据再操作');
            return;
        }
        openwindow(title, url+"&customerId="+rowsData[0].id, gridname,800, 700);
    }

    //启用停用
	function startOrStop(flag){
		var target = $("#customerList").datagrid('getSelected');
		if(target == null){
			tip("请选择一条要操作的数据");
			return;
		}
		var tipmMsg = "";
		if(flag == "009"){
			tipmMsg = "确定要启用该数据吗?"
		}else{
			tipmMsg = "确定要停用该数据吗?"
		}
		$.messager.confirm('操作提示',tipmMsg,function(r){
			if (r){
				$.ajax({
					type : "POST",
					url : "tmCustomerController.do?startOrStop",
					data : {
						"id" : target.id,
						"enableStatus": flag
					},
					dataType : "json",
					success : function(data) {
						tip(data.msg);
						$("#customerList").datagrid('reload');
					},
					error:function(){
						tip("服务器异常，请稍后再试");
					}
				});
			}
		});
	}
</script>

