create or replace PROCEDURE PT_ACT_PROCESS_PRO (
procDefId in varchar2,
processKey in varchar2
)as
processId  varchar2(32);
begin
      for tmp in (select id from ta_process where process_Key=processKey)
      loop
       processId:=tmp.id;
      end loop;
   --1 合并ta_process_pro  流程实体
    merge into ta_process_pro pro USING (select
        ID,
        TYPE_ID ,
        USER_ID ,
        PROCESS_NAME,
        PROCESS_STATE ,
        PROCESS_XMLPATH,
        PROCESS_XML,
        PROCESS_KEY,
        NOTE,
        LISTENER_CLASS,
        TABLE_NAME,
        REDIRECT_URL
        from ta_process ts where ts.ID=processId) ps on
    (ps.id=pro.id and pro.proc_def_id=procDefId)
    when not matched then
     INSERT(
        ID,
        TYPE_ID ,
        USER_ID ,
        PROCESS_NAME,
        PROCESS_STATE ,
        PROCESS_XMLPATH,
        PROCESS_XML,
        PROCESS_KEY,
        NOTE,
        LISTENER_CLASS,
        TABLE_NAME,
        REDIRECT_URL,
        PROC_DEF_ID)
        values(
        ps.ID,
        ps.TYPE_ID ,
        ps.USER_ID ,
        ps.PROCESS_NAME,
        ps.PROCESS_STATE ,
        ps.PROCESS_XMLPATH,
        ps.PROCESS_XML,
        ps.PROCESS_KEY,
        ps.NOTE,
        ps.LISTENER_CLASS,
        ps.TABLE_NAME,
        ps.REDIRECT_URL,
        procDefId
        );


        --2合并 ta_process_node_pro 流程节点
        merge into ta_process_node_pro pro USING (select
         ID,
        FORM_ID,
        PROCESS_ID,
        PROCESS_NODE_NAME,
        PROCESS_NODE_CODE,
        MODELANDVIEW,
        ROLE_CODE,
        SIGN,
        SORT,
        FILTER,
        POSITION_CODE,
        NULL_JUMP_NODE,
        DUPLICATE_JUMP_NODE,
        PROCESS_DEFINITION_ID
        from ta_process_node ts where ts.PROCESS_ID=processId) ps on
    (ps.id=pro.id and pro.proc_def_id=procDefId)
    when not matched then
     INSERT(
        ID,
        FORM_ID,
        PROCESS_ID,
        PROCESS_NODE_NAME,
        PROCESS_NODE_CODE,
        MODELANDVIEW,
        ROLE_CODE,
        SIGN,
        SORT,
        FILTER,
        POSITION_CODE,
        NULL_JUMP_NODE,
        DUPLICATE_JUMP_NODE,
        PROCESS_DEFINITION_ID,
        PROC_DEF_ID)
        values(
        ps.ID,
        ps.FORM_ID,
        ps.PROCESS_ID,
        ps.PROCESS_NODE_NAME,
        ps.PROCESS_NODE_CODE,
        ps.MODELANDVIEW,
        ps.ROLE_CODE,
        ps.SIGN,
        ps.SORT,
        ps.FILTER,
        ps.POSITION_CODE,
        ps.NULL_JUMP_NODE,
        ps.DUPLICATE_JUMP_NODE,
        ps.PROCESS_DEFINITION_ID,
        procDefId
        );
         --3合并 ta_process_variable_pro 流程节点参数
         merge into ta_process_variable_pro pro USING (select
        ID,
        PROCESS_ID,
        PROCESS_VARIABLE_KEY,
        PROCESS_VARIBALE_NAME,
        PROCESS_VARIABLE_TYPE,
        PROCESS_NODE_ID
            from ta_process_variable ts where ts.PROCESS_ID=processId) ps on
        (ps.id=pro.id and pro.proc_def_id=procDefId)
        when not matched then
         INSERT(
        ID,
        PROCESS_ID,
        PROCESS_VARIABLE_KEY,
        PROCESS_VARIBALE_NAME,
        PROCESS_VARIABLE_TYPE,
        PROCESS_NODE_ID,
        PROC_DEF_ID)
        values(
        ps.ID,
        ps.PROCESS_ID,
        ps.PROCESS_VARIABLE_KEY,
        ps.PROCESS_VARIBALE_NAME,
        ps.PROCESS_VARIABLE_TYPE,
        ps.PROCESS_NODE_ID,
        procDefId
        );
          --4 合并 ta_process_node_auth_pro 流程节点权限
         merge into ta_process_node_auth_pro pro USING (select
        ID,
        PROCESS_NODE_ID,
        PROCESS_ID,
        BTN1,
        BTN2,
        BTN3,
        BTN4,
        BTN5,
        BTN6,
        BTN7,
        BTN8,
        BTN9,
        BTN10 from ta_process_node_auth ts where ts.PROCESS_ID=processId) ps on
        (ps.id=pro.id and pro.proc_def_id=procDefId)
        when not matched then
         INSERT(
        ID,
        PROCESS_NODE_ID,
        PROCESS_ID,
        BTN1,
        BTN2,
        BTN3,
        BTN4,
        BTN5,
        BTN6,
        BTN7,
        BTN8,
        BTN9,
        BTN10,
        PROC_DEF_ID)
        values(
        ps.ID,
        ps.PROCESS_NODE_ID,
        ps.PROCESS_ID,
        ps.BTN1,
        ps.BTN2,
        ps.BTN3,
        ps.BTN4,
        ps.BTN5,
        ps.BTN6,
        ps.BTN7,
        ps.BTN8,
        ps.BTN9,
        ps.BTN10,
        procDefId
        );
   commit;
end;



-- 初始化历史版本数据
create or replace PROCEDURE PT_ACT_PROCESS_PRO_test
as
begin
   for cur in (select id_,substr(id_,0,instr(id_,':')-1) val from act_re_procdef ) loop
    PT_ACT_PROCESS_PRO (cur.id_,cur.val);
   end loop;


end;
