﻿//﻿var jq = jQuery.noConflict();
/**
 * 增删改工具栏
 */
/*
 * window.onerror = function() { return true; };
 */
var iframe;// iframe操作对象
var win;// 窗口对象
var gridname = "";// 操作datagrid对象名称
var windowapi = frameElement ? frameElement.api : undefined;
if (typeof (windowapi) != 'undefined') {
    var W = windowapi.opener;// 内容页中调用窗口实例对象接口
}

$(function () {
    top.$("iframe").each(function (k, v) {
        if (location.href.indexOf($(v).attr("src")) > -1) {
            $(v).siblings(".ui_loading").remove();
        }
    })
});

/*function upload(curform) {
    upload();
}*/

/**
 * 获取可以在嵌套的对话框页面中安全使用无需要担心其中的lhgDialog插件重入问题的jquery实例
 * @returns
 */
function getSafeJq() {
    if (typeof(windowapi) === 'undefined') {
        return $;
    } else {
        return W.$;
    }
}

function safeShowDialog(option) {
    var width = option.width;
    var height = option.height;
    var offsetW = window.top.document.body.offsetWidth;
    var offsetH = window.top.document.body.offsetHeight;
    width = (width && width != 'null') ? width : 700;
    height = (height && height != 'null') ? height : 400;
    if (width == "100%" || width > offsetW) {
        width = offsetW;
    }
    if (height == "100%" || height > (offsetH - 100)) {
        height = offsetH - 100;
    }
    $.extend(option, {width: width, height: height});
    if (typeof(windowapi) === 'undefined') {
        return $.dialog(option).zindex();
    } else {
        return W.$.dialog($.extend(option, {parent: windowapi})).zindex();
    }
}

/**
 * 添加事件打开窗口
 *
 * @param title
 *            编辑框标题
 * @param addurl//目标页面地址
 */
function add(title, addurl, gname, width, height, params) {
    gridname = gname;
    //width = (width&&width!='null') ? width : 700;
    //height = (height&&height!='null') ? height : 400;


    if (typeof(gridname) != "undefined") {
        var rowData = $('#' + gridname).datagrid('getSelected');
        if (params != null && params != '') {
            var paramsArr = params.split(",");
            for (var i = 0; i < paramsArr.length; i++) {
                var _char = "&";
                if (i == 0) {
                    if (addurl.indexOf("?") == -1) {
                        _char = "?";
                    }
                }
                addurl += _char + paramsArr[i] + "=" + rowData[paramsArr[i]];
            }
        }
    }

    if (!width || width == "" || width == 'null' || !height || height == "" || height == 'null')
        createwindowSmall(title, addurl, width, height);
    else
        createwindow(title, addurl, width, height);
}

/**
 * 树列表添加事件打开窗口
 *
 * @param title
 *            编辑框标题
 * @param addurl//目标页面地址
 */
function addTreeNode(title, addurl, gname) {
    if (rowid != '') {
        var _char = "&";

        if (addurl.indexOf("?") == -1) {
            _char = "?";
        }

        addurl += _char + 'id=' + rowid;
    }
    gridname = gname;
    createwindow(title, addurl);
}

/**
 * 更新事件打开窗口
 *
 * @param title
 *            编辑框标题
 * @param addurl//目标页面地址
 * @param id//主键字段
 */
function update(title, url, id, width, height, params) {
    gridname = id;
    var rowsData = $('#' + id).datagrid('getSelections');
    if (!rowsData || rowsData.length == 0) {
        tip('请选择编辑项目');
        return;
    }
    if (rowsData.length > 1) {
        tip('请选择一条记录再编辑');
        return;
    }
    if (!checkAndExecallBack_before(params, rowsData)) {
        return;
    }
    var _char = "&";
    if (url.indexOf("?") == -1) {
        _char = "?";
    }

    url += _char + 'id=' + rowsData[0].id;
    if (!width || width == "" || width == 'null' || !height || height == "" || height == 'null')
        createwindowSmall(title, url, width, height);
    else
        createwindow(title, url, width, height);
}

/**
 * 更新事件打开窗口
 *
 * @param title
 *            编辑框标题
 * @param addurl//目标页面地址
 * @param id//主键字段
 */
function updateParamNull(title, url, id, width, height, params) {
    gridname = id;
    var rowsData = $('#' + id).datagrid('getSelections');
    var _char = "&";
    if (url.indexOf("?") == -1) {
        _char = "?";
    }
    if (!rowsData || rowsData.length == 0) {
        url += _char + 'id=';
    } else {
        if (rowsData.length > 1) {
            tip('请选择一条记录再编辑');
            return;
        }
        if (!checkAndExecallBack_before(params, rowsData)) {
            return;
        }
        url += _char + 'id=' + rowsData[0].id;
    }
    if (!width || width == "" || width == 'null' || !height || height == "" || height == 'null')
        createwindowSmall(title, url, width, height);
    else
        createwindow(title, url, width, height);
}


function updateParamCouldNull(title, url, id, width, height, params) {
    gridname = id;
    var rowsData = $('#' + id).datagrid('getSelections');
    if (rowsData.length > 1) {
        tip('只能最多选择一条记录');
        return;
    } else if (rowsData.length == 1) {
        var _char = "&";

        if (url.indexOf("?") == -1) {
            _char = "?";
        }

        url += _char + 'id=' + rowsData[0].id;
    }
    if (!checkAndExecallBack_before(params, rowsData)) {
        return;
    }

    if (!width || width == "" || width == 'null' || !height || height == "" || height == 'null')
        createwindowSmall(title, url, width, height);
    else
        createwindow(title, url, width, height);
}

/**
 * 如果页面是详细查看页面，无效化所有表单元素，只能进行查看
 */
$(function () {
    detailExec();
});

function detailExec() {
    if (location.href.indexOf("load=detail") != -1) {
        $("#attachList").find("span.attach-remove").css("display","none");
        $(":input").attr("disabled", "true");
        $(":input").css({"border": "0", "border-bottom": "1px solid #efefef", "background": "none", "color": "black"});
        $(":input").each(function () {
            $(this).closest(".form").find(".combo").css({
                "border": "0",
                "border-bottom": "1px solid #efefef",
                "background": "none",
                "color": "black"
            });
            $(this).closest(".form").find(".combo input").css({"border": "0"});
            $(this).closest(".form").find(".combo-arrow").remove();
            $(this).closest(".form").find(".easyui-linkbutton").remove();
        });
        $(":input:not([type='radio'],[type='checkbox'])").css({"appearance": "none"});//select::-ms-expand{display:none;}
        $(".biz-tag-toolbar").css("display", "none");
        $(".biz-tag-close").css("display", "none");
    }
    if (parent.location.href.indexOf("load=detail") != -1) {
        $(".removebtn").css('display', "none");
    }
}

/**
 * 查看详细事件打开窗口
 *
 * @param title
 *            查看框标题
 * @param addurl//目标页面地址
 * @param id//主键字段
 */
function detail(title, url, id, width, height) {
    var rowsData = $('#' + id).datagrid('getSelections');
    // if (rowData.id == '') {
    // tip('请选择查看项目');
    // return;
    // }

    if (!rowsData || rowsData.length == 0) {
        tip('请选择查看项目');
        return;
    }
    if (rowsData.length > 1) {
        tip('请选择一条记录再查看');
        return;
    }
    var _char = "&";

    if (url.indexOf("?") == -1) {
        _char = "?";
    }

    url += _char + 'load=detail&id=' + rowsData[0].id;
    createdetailwindow(title, url, width, height);
}

/**
 * 查看日志事件打开窗口
 * @param title  查看框标题
 * @param url 请求url
 * @param id dataGrid id
 * @param width 宽度
 * @param height 高度
 * @returns
 */
function detailLog(title, url, id, width, height) {
    var rowsData = $('#' + id).datagrid('getSelections');


    if (!rowsData || rowsData.length == 0) {
        tip('请选择查看项目');
        return;
    }
    if (rowsData.length > 1) {
        tip('请选择一条记录再查看');
        return;
    }
    var _char = "&";

    if (url.indexOf("?") == -1) {
        _char = "?";
    }

    url += _char + 'load=detail&id=' + rowsData[0].id;
    openwindow(title, url, id, width, height);
}

/**
 * 多记录刪除請求
 *
 * @param title
 * @param url
 * @param gname
 * @return
 */
function deleteALLSelect(title, url, gname, deleteCallback) {
    gridname = gname;
    var ids = [];
    var rows = $("#" + gname).datagrid('getSelections');
    if (rows.length > 0) {
        getSafeJq().dialog.confirm("你确定永久删除该数据吗?", function (r) {
            if (r) {
                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].id);
                }
                $.ajax({
                    url: url,
                    type: 'post',
                    dataType: 'json',
                    data: {
                        ids: ids.join(',')
                    },
                    cache: false,
                    success: function (data) {
                        var msg = data.msg;
                        if (data.success) {
                            tip(msg, 'info');
                            reloadTable();
                            if (deleteCallback) {
                                deleteCallback();
                            }
                            $("#" + gname).datagrid('unselectAll');
                            ids = '';
                        } else {
                            tip(msg, 'error');

                        }
                    },
                    error: function () {
                        tip("客户端请求错误", 'error');
                        return false;
                    }
                });
            }
        });
    } else {
        tip("请选择需要删除的数据");
    }
}

function deleteALLSelectList(title, url, gname, params) {
    gridname = gname;
    var ids = [];
    var rows = $("#" + gname).datagrid('getSelections');
    if (rows.length > 0) {

        if (!checkAndExecallBack_before(params, rows)) {
            return;
        }

        getSafeJq().dialog.confirm("你确定永久删除该数据吗?", function (r) {
            if (r) {
                startDoALLSelectList(gname, url, rows, params);
            }
        });
    } else {
        tip("请选择需要删除的数据");
    }
}

/** 停用 */
function stopALLSelectList(title, url, gname, params) {
    gridname = gname;
    var ids = [];
    var rows = $("#" + gname).datagrid('getSelections');
    if (rows.length > 0) {

        if (!checkAndExecallBack_before(params, rows)) {
            return;
        }

        getSafeJq().dialog.confirm("你确定停用选择的数据吗?", function (r) {
            if (r) {
                startDoALLSelectList(gname, url, rows, params);
            }
        });
    } else {
        tip("请选择需要操作的数据");
    }
}

/** 启用 */
function startALLSelectList(title, url, gname, params) {
    gridname = gname;
    var ids = [];
    var rows = $("#" + gname).datagrid('getSelections');
    if (rows.length > 0) {

        if (!checkAndExecallBack_before(params, rows)) {
            return;
        }

        getSafeJq().dialog.confirm("你确定启用选择的数据吗?", function (r) {
            if (r) {
                startDoALLSelectList(gname, url, rows, params);
            }
        });
    } else {
        tip("请选择需要操作的数据");
    }
}


//操作所有选择的数据
function optALLSelectList(title, url, gname, params) {
    gridname = gname;
    var rows = $("#" + gname).datagrid('getSelections');
    if (rows.length <= 0) {
        tip("请选择需要操作的数据");
        return;
    }

    if (!checkAndExecallBack_before(params, rows)) {
        return;
    }

    getSafeJq().dialog.confirm("你确定对当前数据进行" + title + "操作?", function (r) {
        if (r) {
            startDoALLSelectList(gname, url, rows, params);
        }
    });

}

function startDoALLSelectList(gname, url, rows, params) {
    var ids = [];
    for (var i = 0; i < rows.length; i++) {
        ids.push(rows[i].id);
    }
    ids = JSON.stringify(ids);
    $.ajax({
        url: url,
        type: 'post',
        dataType: 'json',
        data: ids,
        cache: false,
        contentType: "application/json",
        success: function (data) {
            var msg = data.msg;
            if (data.success) {
                tip(msg, 'info');
                reloadTable();
                checkAndExecallBack(data);
                $("#" + gname).datagrid('unselectAll');
                ids = '';
            } else {
                tip(msg, 'error');

            }
        },
        error: function () {
            tip("客户端请求错误", 'error');
            return false;
        }
    });
}

function checkAndExecallBack_before(params, rows) {
    if (params != '' && params != undefined) {
        if (params.callBackBefor != '' && params.callBackBefor != undefined) {
            return params.callBackBefor(rows);
        }
    }
    return true;
}

function checkAndExecallBack(params, data) {
    if (params != '' && params != undefined) {
        if (params.callback != '' && params.callback != undefined) {
            return params.callback(data);
        }
    }
    return true;
}


/**
 * 查看时的弹出窗口
 *
 * @param title
 * @param addurl
 * @param saveurl
 */
function createdetailwindow(title, addurl, width, height) {
    createwindowExt(title, addurl, width, height, {
        ok: false,
        cancelVal: '关闭',
        cancel: true
    });
}

/**
 * Excel 导出 代入查询条件
 */
function excelExport(url, datagridId) {
    var queryParams = $('#' + datagridId).datagrid('options').queryParams;
    $('#' + datagridId + 'tb_r').find('*').each(function () {
        queryParams[$(this).attr('name')] = $(this).val();
    });
    var params = '&';
    $.each(queryParams, function (key, val) {
        params += '&' + key + '=' + val;
    });


    var fields = '&field=';
    $.each($('#' + datagridId).datagrid('options').columns[0], function (i, val) {
        if (val.field != 'opt') {
            fields += val.field + ',';
        }
    });
    var tagetUrl = url;
    //菜单id
    var _char = "&";

    if (url.indexOf("?") == -1) {
        _char = "?";
    }
    tagetUrl = tagetUrl + _char + "1=1";
    window.location.href = tagetUrl + encodeURI(fields + params);
    // window.open(  tagetUrl + encodeURI(fields + params)) ;
}

/**
 * 全屏编辑
 *
 * @param title
 *            编辑框标题
 * @param addurl//目标页面地址
 * @param id//主键字段
 */
function editfs(title, url) {
    var name = gridname;
    if (rowid == '') {
        tip('请选择编辑项目');
        return;
    }
    url += '&id=' + rowid;
    openwindow(title, url, name, 800, 500);
}

// 删除调用函数
function delObj(url, name) {
    gridname = name;
    createdialog('删除确认 ', '确定删除该记录吗 ?', url, name);
}

function delTreeNode(title, url, gridname, width, height, params) {
    var rowData = $('#' + gridname).datagrid('getSelected');
    if (rowData == null) {
        tip('请选择数据');
        return;
    }

    if (params != null || params != '') {
        var _char = "&";
        if (url.indexOf("?") == -1) {
            _char = "?";
        }
        var paramsArr = params.split(",");
        for (var i = 0; i < paramsArr.length; i++) {
            if (i == 0) {
                url += _char + paramsArr[i] + "=" + rowData[paramsArr[i]];
            } else {
                url += "&" + paramsArr[i] + "=" + rowData[paramsArr[i]];
            }
        }
    }
    createDelTreeNodeDialog('提示', '确认要操作？', url, gridname, rowData);
}

function optTreeNode(title, url, gridname, width, height, params) {
    var rowData = $('#' + gridname).datagrid('getSelected');
    if (rowData == null) {
        tip('请选择数据');
        return;
    }

    if (params != null || params != '') {
        var _char = "&";
        if (url.indexOf("?") == -1) {
            _char = "?";
        }
        var paramsArr = params.split(",");
        for (var i = 0; i < paramsArr.length; i++) {
            if (i == 0) {
                url += _char + paramsArr[i] + "=" + rowData[paramsArr[i]];
            } else {
                url += "&" + paramsArr[i] + "=" + rowData[paramsArr[i]];
            }
        }
    }
    createOptTreeNodeDialog('提示', '确认要操作？', url, gridname, rowData);
}

// 删除调用函数
function confuploadify(url, id) {
    getSafeJq().dialog.confirm('确定删除吗', function () {
        deluploadify(url, id);
    }, function () {
    }).zindex();
}

/**
 * 执行删除附件
 *
 * @param url
 * @param index
 */
function deluploadify(url, id) {
    $.ajax({
        async: false,
        cache: false,
        type: 'POST',
        dataType: 'json',
        url: url,// 请求的action路径
        error: function () {// 请求失败处理函数
        },
        success: function (data) {
            if (data.success) {
                $("#" + id).remove();// 移除SPAN
                m.remove(id);// 移除MAP对象内字符串
            }

        }
    });
}

// 普通询问操作调用函数
function confirm(url, content, name) {
    createdialog('提示信息 ', content, url, name);
}

/**
 * 提示信息
 */
function tip_old(msg) {
    //$.dialog.setting.zIndex = 1980;
    getSafeJq().dialog.tips(msg, 1);
}

/**
 * 提示信息, 在整个屏幕的右下角弹出
 */
function newTip(msg, icon) {
    //$.dialog.setting.zIndex = 1980;
    getSafeJq().messager.show({
        title: '提示信息',
        msg: msg,
        timeout: 1000 * 6
    }, icon);
}

/**
 * 提示信息: 在当前的对话框右下角弹出
 * 右下角弹框
 * tip("警告","warning");
 * tip("错误","error");
 * tip("提示","info");
 * @param msg
 */
function tip(msg, icon) {
    if (icon == null || icon == undefined) {
        icon = "info";
    }
    if (parent.$ != $ && !windowapi) {
        var JQ = parent.$;
    } else {
        var JQ = $;
    }
    var options = {};
    if (Object.prototype.toString.call(msg) === "[object Object]") {
        options = msg;
    } else {
        options["msg"] = msg;
    }
    var defaultOptions = {
        title: '提示信息',
        msg: msg,
        timeout: 1000 * 6,
        width: 350
    }
    JQ.messager.show($.extend({}, defaultOptions, options), icon);
}

/**
 * 提示信息像alert一样
 */
function alertTip(title, msg, icon, fn) {
    //$.dialog.setting.zIndex = 1980;
    $.messager.alert(title, msg, icon, fn);
}

/**
 * 创建添加或编辑窗口
 *
 * @param title
 * @param addurl
 * @param saveurl
 */
function createwindow(title, addurl, width, height) {
    createwindowExt(title, addurl, width, height, {});
}

/**
 * 创建添加或编辑窗口
 *
 * @param title
 * @param addurl
 * @param saveurl
 */
function createwindowSmall(title, addurl, width, height) {
    createwindowExt(title, addurl, 500, 400, {});
}

/**
 * 创建添加或编辑窗口
 *
 * @param title
 * @param addurl
 * @param saveurl
 */
function createwindowBig(title, addurl, width, height) {
    createwindowExt(title, addurl, 1000, 500, {});
}

/**
 * 创建上传页面窗口
 *
 * @param title
 * @param addurl
 * @param saveurl
 */
function openuploadwin(title, url, name, width, height) {
    gridname = name;
    safeShowDialog({
        content: 'url:' + url,
        lock: true,
        cache: false,
        button: [{
            name: "开始上传",
            callback: function () {
                iframe = this.iframe.contentWindow;
                iframe.upload();
                return false;
            },
            focus: true
        }, {
            name: "取消上传",
            callback: function () {
                iframe = this.iframe.contentWindow;
                iframe.cancel();
            }
        }]
    });
}

/**
 * 创建查询页面窗口
 *
 * @param title
 * @param addurl
 * @param saveurl
 */
function opensearchdwin(title, url, width, height) {
    safeShowDialog({
        content: 'url:' + url,
        title: title,
        lock: true,
        height: height,
        cache: false,
        width: width,
        opacity: 0.3,
        button: [{
            name: '查询',
            callback: function () {
                iframe = this.iframe.contentWindow;
                iframe.searchs();
            },
            focus: true
        }, {
            name: '取消',
            callback: function () {

            }
        }]
    });
}

/**
 * 创建不带按钮的窗口
 *
 * @param title
 * @param addurl
 * @param saveurl
 */
function openwindow(title, url, name, width, height) {
    gridname = name;
    width = width || 'auto';
    height = height || 'auto';

    safeShowDialog({
        content: 'url:' + url,
        title: title,
        cache: false,
        lock: true,
        width: width,
        height: height
    });
}

function view(title, url, name, width, height, params) {
    gridname = name;
    width = width || '1500';
    height = height || '600';
    var rowData = $('#' + gridname).datagrid('getSelected');
    if (rowData == null) {
        tip('请选择数据');
        return;
    }

    if (params != null || params != '') {
        var paramsArr = params.split(",");
        for (var i = 0; i < paramsArr.length; i++) {
            url += "&" + paramsArr[i] + "=" + rowData[paramsArr[i]];
        }
    }

    safeShowDialog({
        content: 'url:' + url,
        title: title,
        cache: false,
        lock: true,
        width: width,
        height: height
    });
}

function systemConfirm(title, url, gridname, width, height, params) {
    var rowData = $('#' + gridname).datagrid('getSelected');
    if (rowData == null) {
        tip('请选择数据');
        return;
    }

    if (params != null || params != '') {
        var paramsArr = params.split(",");
        var _char = "&";
        if (url.indexOf("?") == -1) {
            _char = "?";
        }
        for (var i = 0; i < paramsArr.length; i++) {
            if (i == 0) {
                url += _char + paramsArr[i] + "=" + rowData[paramsArr[i]];
            } else {
                url += "&" + paramsArr[i] + "=" + rowData[paramsArr[i]];
            }
        }
    }
    createdialog('提示', '确认要操作？', url, gridname);
}

/**
 * 创建询问窗口
 *
 * @param title
 * @param content
 * @param url
 */
function createdialog(title, content, url, name) {
    getSafeJq().dialog.confirm(content, function () {
        doSubmit(url, name);
        rowid = '';
    }, function () {
    }).zindex();
}

function createDelTreeNodeDialog(title, content, url, name, data) {
    getSafeJq().dialog.confirm(content, function () {
        doDelTreeNodeSubmit(url, name, data);
        rowid = '';
    }, function () {
    }).zindex();
}

function createOptTreeNodeDialog(title, content, url, name, data) {
    getSafeJq().dialog.confirm(content, function () {
        doOptTreeNodeSubmit(url, name, data);
        rowid = '';
    }, function () {
    }).zindex();
}

/**
 * 执行保存
 *
 * @param url
 * @param gridname
 */
function saveObj() {
    $('#btn_sub', iframe.document).click();
}

/**
 * 执行AJAX提交FORM
 *
 * @param url
 * @param gridname
 */
function ajaxSubForm(url) {
    $('#myform', iframe.document).form('submit', {
        url: url,
        onSubmit: function () {
            iframe.editor.sync();
        },
        success: function (r) {
            tip('操作成功', 'info');
            reloadTable();
        }
    });
}

/**
 * 执行查询
 *
 * @param url
 * @param gridname
 */
function search() {

    $('#btn_sub', iframe.document).click();
    iframe.search();
}

/**
 * 执行操作
 *
 * @param url
 * @param index
 */
function doSubmit(url, name, data) {
    gridname = name;
    // --author：JueYue
    // ---------date：20140227---------for：把URL转换成POST参数防止URL参数超出范围的问题
    var paramsData = data;
    if (!paramsData) {
        paramsData = {};
        if (url.indexOf("?") != -1) {
            var str = url.substr(url.indexOf("?") + 1);
            var strs = str.split("&");
            var s = 0;
            if (url.indexOf(".do") != -1) {
                url = url.substr(0, url.indexOf("?") + 1) + strs[0];
                s = 1
            } else {
                url = url.substr(0, url.indexOf("?"));
            }
            for (var i = s; i < strs.length; i++) {
                paramsData[strs[i].split("=")[0]] = (strs[i].split("=")[1]);
            }
        }
    }
    // --author：JueYue
    // ---------date：20140227---------for：把URL转换成POST参数防止URL参数超出范围的问题
    $.ajax({
        async: false,
        cache: false,
        type: 'POST',
        data: paramsData,
        dataType: 'json',
        url: url,// 请求的action路径
        error: function () {// 请求失败处理函数
        },
        success: function (data) {
            // var d = data
            var msg = data.msg;
            if (data.success) {
                tip(msg, 'info');
                reloadTable();
            } else {
                tip(msg, 'error');

            }
        }
    });

}

function doDelTreeNodeSubmit(url, name, rowData) {
    gridname = name;
    $.ajax({
        async: false,
        cache: false,
        type: 'POST',
        url: url,// 请求的action路径
        dataType: 'json',
        error: function () {// 请求失败处理函数
        },
        success: function (data) {
            // var d = data
            var msg = data.msg;
            if (data.success) {
                tip(msg, 'info');
                $("#" + name).treegrid('remove', rowData.id);
            } else {
                tip(msg, 'error');

            }
        }
    });

}

function doOptTreeNodeSubmit(url, name, rowData) {
    gridname = name;
    $.ajax({
        async: false,
        cache: false,
        type: 'POST',
        url: url,// 请求的action路径
        dataType: 'json',
        error: function () {// 请求失败处理函数
        },
        success: function (data) {
            var msg = data.msg;
            if (data.success) {
                tip(msg, 'info');

                var hasQueryParams = false;
                var queryParams = $("#" + name).treegrid('options').queryParams;
                for (var param in queryParams) {
                    if (param != "id" && (queryParams[param] != "" || queryParams[param] != "undefined")) {
                        hasQueryParams = true;
                        break;
                    }
                }
                if (hasQueryParams == true) {
                    eval(name + "search()");
                } else {
                    $("#" + name).treegrid('reload', rowData.parentId);
                }
            } else {
                tip(msg, 'error');

            }
        }
    });

}

/**
 * 退出确认框
 *
 * @param url
 * @param content
 * @param index
 */
function exit(url, content) {
    getSafeJq().dialog.confirm(content, function () {
        window.location = url;
    }, function () {
    }).zindex();
}

/**
 * 模板页面ajax提交
 *
 * @param url
 * @param gridname
 */
function ajaxdoSub(url, formname) {
    $('#' + formname).form('submit', {
        url: url,
        onSubmit: function () {
            editor.sync();
        },
        success: function (r) {
            tip('操作成功', 'info');
        }
    });
}

/**
 * ajax提交FORM
 *
 * @param url
 * @param gridname
 */
function ajaxdoForm(url, formname) {
    $('#' + formname).form('submit', {
        url: url,
        onSubmit: function () {
        },
        success: function (r) {
            tip('操作成功', 'info');
        }
    });
}

/**
 * 打开一个子窗体. (预期子窗体中包含一个t:formValid标签)
 * @param title
 * @param url
 * @param okbutton
 * @param closebutton
 */
function opensinglewin(title, id, url, width, height) {
    var myOptions = {
        content: 'url:' + url,
        lock: true,
        width: width,
        height: height,
        title: title,
        opacity: 0.3,
        cache: false,
        cancelVal: '确定',
        cancel: function () {
            $("#" + id).datagrid('reload');
        }
    };
    safeShowDialog(myOptions);
}

function reloadTable() {
    $('#' + gridname).datagrid('reload');
}

function opensubwin(title, url, saveurl, okbutton, closebutton) {
    safeShowDialog({
        content: 'url:' + url,
        title: title,
        lock: true,
        opacity: 0.3,
        button: [{
            name: okbutton,
            callback: function () {
                iframe = this.iframe.contentWindow;
                win = frameElement.api.opener;// 来源页面
                $('#btn_sub', iframe.document).click();
                return false;
            }
        }, {
            name: closebutton,
            callback: function () {
            }
        }]

    });
}

function openauditwin(title, url, saveurl, okbutton, backbutton, closebutton) {
    safeShowDialog({
        content: 'url:' + url,
        title: title,
        lock: true,
        opacity: 0.3,
        button: [{
            name: okbutton,
            callback: function () {
                iframe = this.iframe.contentWindow;
                win = $.dialog.open.origin;// 来源页面
                $('#btn_sub', iframe.document).click();
                return false;
            }
        }, {
            name: backbutton,
            callback: function () {
                var _char = "&";
                if (url.indexOf("?") == -1) {
                    _char = "?";
                }
                iframe = this.iframe.contentWindow;
                win = frameElement.api.opener;// 来源页面

                $('#formobj', iframe.document).form('submit', {
                    url: saveurl + _char + "code=exit",
                    onSubmit: function () {
                        $('#code').val('exit');
                    },
                    success: function (r) {
                        $.dialog.tips('操作成功', 2);
                        win.location.reload();
                    }
                });

            }
        }, {
            name: closebutton,
            callback: function () {
            }
        }]

    });
}

/* 获取Cookie值 */
function getCookie(c_name) {
    if (document.cookie.length > 0) {
        c_start = document.cookie.indexOf(c_name + "=");
        if (c_start != -1) {
            c_start = c_start + c_name.length + 1;
            c_end = document.cookie.indexOf(";", c_start);
            if (c_end == -1)
                c_end = document.cookie.length;
            return unescape(document.cookie.substring(c_start, c_end));
        }
    }
    return "";
}

function systemAddOneTab(title, url, gridname, width, height, params) {
    var rowData = $('#' + gridname).datagrid('getSelected');
    if (rowData == null) {
        tip('请选择数据');
        return;
    }

    if (params != null || params != '') {
        var paramsArr = params.split(",");
        var _char = "&";
        if (url.indexOf("?") == -1) {
            _char = "?";
        }
        for (var i = 0; i < paramsArr.length; i++) {

            if (i == 0) {
                url += _char + paramsArr[i] + "=" + rowData[paramsArr[i]];
            } else {
                url += "&" + paramsArr[i] + "=" + rowData[paramsArr[i]];
            }
        }
    }
    addOneTab(title, url);
}

// 添加标签
function addOneTab(subtitle, url, icon) {
    var indexStyle = getCookie("EISPINDEXSTYLE");
    if (indexStyle == 'sliding' || indexStyle == 'bootstrap') {
        // shortcut和bootstrap风格的tab跳转改为直接跳转
        window.location.href = url;
    } else {
        if (icon == '') {
            icon = 'icon folder';
        }
        window.top.$.messager.progress({
            text: '页面加载中....',
            interval: 300
        });
        window.top.$('#maintabs').tabs({
            onClose: function (subtitle, index) {
                window.top.$.messager.progress('close');
            }
        });
        if (window.top.$('#maintabs').tabs('exists', subtitle)) {
            window.top.$('#maintabs').tabs('select', subtitle);
            if (url.indexOf('isHref') != -1) {
                window.top.$('#maintabs').tabs('update', {
                    tab: window.top.$('#maintabs').tabs('getSelected'),
                    options: {
                        title: subtitle,
                        href: url,
                        // content : '<iframe src="' + url + '" frameborder="0"
                        // style="border:0;width:100%;height:99.4%;"></iframe>',
                        closable: true,
                        icon: icon
                    }
                });
            } else {
                window.top.$('#maintabs').tabs(
                    'update',
                    {
                        tab: window.top.$('#maintabs').tabs('getSelected'),
                        options: {
                            title: subtitle,
                            content: '<iframe src="' + url
                            + '" frameborder="0" style="border:0;width:100%;height:99.4%;"></iframe>',
                            // content : '<iframe src="' + url + '"
                            // frameborder="0"
                            // style="border:0;width:100%;height:99.4%;"></iframe>',
                            closable: true,
                            icon: icon
                        }
                    });
            }
        } else {
            if (url.indexOf('isHref') != -1) {
                window.top.$('#maintabs').tabs('add', {
                    title: subtitle,
                    href: url,
                    closable: true,
                    icon: icon
                });
            } else {
                window.top.$('#maintabs').tabs(
                    'add',
                    {
                        title: subtitle,
                        content: '<iframe src="' + url
                        + '" frameborder="0" style="border:0;width:100%;height:99.4%;"></iframe>',
                        closable: true,
                        icon: icon
                    });
            }
        }
    }
}

// 关闭自身TAB刷新父TABgrid
function closetab(title) {
    // 暂时先不刷新
    // window.top.document.getElementById('tabiframe').contentWindow.reloadTable();
    // window.top.document.getElementById('maintabs').contentWindow.reloadTable();
    window.top.$('#maintabs').tabs('close', title);
    // tip("添加成功");
}

// popup
// object: this name:需要选择的列表的字段 code:动态报表的code
function inputClick(obj, name, code) {
    $.dialog.setting.zIndex = 2000;
    if (name == "" || code == "") {
        alert("popup参数配置不全");
        return;
    }
    safeShowDialog({
        content: "url:cgReportController.do?popup&id=" + code,
        lock: true,
        title: "选择",
        width: 800,
        height: 400,
        cache: false,
        ok: function () {
            iframe = this.iframe.contentWindow;
            var selected = iframe.getSelectRows();
            if (selected == '' || selected == null) {
                alert("请选择");
                return false;
            } else {
                var str = "";
                $.each(selected, function (i, n) {
                    if (i == 0)
                        str += n[name];
                    else
                        str += "," + n[name];
                });
                $(obj).val("");
                // $('#myText').searchbox('setValue', str);
                $(obj).val(str);
                return true;
            }

        },
        cancelVal: '关闭',
        cancel: true
        /* 为true等价于function(){} */
    });
}

function inputClickCheckbox(obj, name, code) {
    $.dialog.setting.zIndex = 2000;
    if (name == "" || code == "") {
        alert("popup参数配置不全");
        return;
    }
    safeShowDialog({
        content: "url:cgReportController/popup?id=" + code,
        lock: true,
        title: "选择",
        width: 800,
        height: 400,
        cache: false,
        ok: function () {
            iframe = this.iframe.contentWindow;
            var selected = iframe.getSelectRows();
            if (selected == '' || selected == null) {
                alert("请选择");
                return false;
            } else {
                var str = "";
                var find = "td[field=\"" + name + "\"]";
                $(iframe.document).find('input[type="checkbox"][name="ck"]:checked').each(function (i) {
                    var val = $(this).parent().parent().parent().find(find).text();
                    if (i == 0) {
                        str += val;
                    } else {
                        str += "," + val;
                    }
                });

                $(obj).val(str);
                return true;
            }

        },
        cancelVal: '关闭',
        cancel: true
        /* 为true等价于function(){} */
    });
}

/*
 * 自定义url的弹出 obj:要填充的控件,可以为多个，以逗号分隔 name:列表中对应的字段,可以为多个，以逗号分隔（与obj要对应）
 * url：弹出页面的Url
 */
function popClick(obj, name, url, width, height) {
//    $.dialog.setting.zIndex = 2001;
    var names = name.split(",");
    var objs = obj.split(",");
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width == null ? 700 : width,
        height: height == null ? 400 : height,
        left: '85%',
        cache: false,
        ok: function () {
            iframe = this.iframe.contentWindow;
            var selected = iframe.getSelectRows();
            if (selected == '' || selected == null) {
                iframe.$.messager.alert('错误', "请至少选择一条数据", "error");
                return false;
            } else {
                for (var i1 = 0; i1 < names.length; i1++) {
                    var str = "";
                    $.each(selected, function (i, n) {
                        if (i == 0) {
                            str += n[names[i1]];
                        } else {
                            str += ",";
                            str += n[names[i1]];
                        }
                    });
                    if ($("#" + objs[i1]).length >= 1) {
                        $("#" + objs[i1]).val("");
                        $("#" + objs[i1]).val(str);
                    } else {
                        $("input[name='" + objs[i1] + "']").val("");
                        $("input[name='" + objs[i1] + "']").val(str);
                    }
                }
                return true;
            }
        },
        cancelVal: '关闭',
        cancel: true
        /* 为true等价于function(){} */
    });
}


/**
 * 自定义url的弹出 单选
 *
 * obj:要填充的控件,可以为多个，以逗号分隔
 * name:列表中对应的字段,可以为多个，以逗号分隔（与obj要对应）
 * url：弹出页面的Url
 * isSingleSelect:true 多选；false单选  默认单选
 */
function popClickSingle(datagrid, obj, name, url, width, height, isSingleSelect) {
    //    $.dialog.setting.zIndex = 2001;
    var names = name.split(",");
    var objs = obj.split(",");
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width == null ? 700 : width,
        height: height == null ? 400 : height,
        left: '85%',
        cache: false,
        ok: function () {
            debugger;
            iframe = this.iframe.contentWindow;
            var selected = iframe.$("#" + datagrid).datagrid("getSelections");
            if (null==isSingleSelect||''==isSingleSelect||isSingleSelect.length==0){
                isSingleSelect = false;
            }
            if(!isSingleSelect){
                if (selected == '' || selected == null || selected.length != 1) {
                    iframe.tip("请选择一条数据");
                    return false;
                }
            }
            for (var i1 = 0; i1 < names.length; i1++) {
                var str = "";
                $.each(selected,
                    function (i, n) {
                        if (i == 0) {
                            str += n[names[i1]];
                        } else {
                            str += ",";
                            str += n[names[i1]];
                        }
                    });
                if ($("#" + objs[i1]).length >= 1) {
                    $("#" + objs[i1]).val("");
                    $("#" + objs[i1]).val(str);
                } else {
                    $("input[name='" + objs[i1] + "']").val("");
                    $("input[name='" + objs[i1] + "']").val(str);
                }
            }
            return true;
        },
        cancelVal: '关闭',
        cancel: true
        /* 为true等价于function(){} */
    });
}


/**
 * 弹出列表提交
 * @param obj 要添加的控件id或者name值  多值以，号隔开
 * @param name 弹出框目标的值 多值以，号隔开
 * @param url 弹出框的url
 * @param optFunction 闭包 相当于callback
 * @param width
 * @param height
 * @param title
 */
function popOptClick(obj, name, url, optFunction, width, height, title) {
    var names = name.split(",");
    var objs = obj.split(",");
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: (title == null || title == "" || title == undefined) ? "选择" : title,
        width: width == null ? 700 : width,
        height: height == null ? 400 : height,
        left: '85%',
        cache: false,
        ok: function () {
            iframe = this.iframe.contentWindow;
            var selected = iframe.getSelectRows();
            if (selected == '' || selected == null) {
                iframe.$.messager.alert('错误', '请至少选择一条数据', 'error');
                return false;
            } else {
                for (var i1 = 0; i1 < names.length; i1++) {
                    var str = "";
                    $.each(selected, function (i, n) {
                        if (i == 0) {
                            str += n[names[i1]];
                        } else {
                            str += ",";
                            str += n[names[i1]];
                        }
                    });
                    if ($("#" + objs[i1]).length >= 1) {
                        $("#" + objs[i1]).val("");
                        $("#" + objs[i1]).val(str);
                    } else {
                        $("input[name='" + objs[i1] + "']").val("");
                        $("input[name='" + objs[i1] + "']").val(str);
                    }
                }

                if (optFunction != null && optFunction != undefined) {
                    return optFunction(selected);
                }
                return true;
            }
        },
        cancelVal: '关闭',
        cancel: true
    });
}

/**
 *
 * @param triggerId 触发框ID值
 * @param triggerName 触发框显示值
 * @param valueField 显示要取的值
 * @param url url地址
 * @param id
 * @param validFunction
 * @param width
 * @param height
 */
function popSelectClick(triggerId, triggerName, valueField, url, id, validFunction, width, height, notRequired, hiddenId) {
    gridname = id;
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width == null ? 700 : width,
        height: height == null ? 400 : height,
        left: '85%',
        cache: false,
        ok: function () {
            iframe = this.iframe.contentWindow;
            var rowsData = iframe.$('#' + id).datagrid('getRows');
            if ((rowsData == '' || rowsData == null) && validFunction == null && (notRequired == undefined || notRequired == false)) {
                if (notRequired) {
                    $("#" + triggerName).val("");
                    $("#" + hiddenId).val("");
                    return true;
                } else {
                    iframe.tip("请至少选择一条数据");
                    return false;
                }

            } else {
                if (validFunction != null && validFunction != "undefined") {
                    if (!validFunction(rowsData)) {
                        return false;
                    }
                }
                $("#" + triggerId).val(JSON.stringify(rowsData));
                var str = "";
                $.each(rowsData, function (i, n) {
                    if (i == 0) {
                        str += n[valueField];
                    } else {
                        str += ",";
                        str += n[valueField];
                    }
                });
                $("#" + triggerName).val(str);
                return true;
            }
        },
        cancelVal: '关闭',
        cancel: true
    });
}

/**
 * 通过自定义函数控制窗口
 * @param url url地址
 * @param id
 * @param validFunction
 * @param width
 * @param height
 * @param title
 */
function popHandlerClick(url, id, validFunction, width, height, title) {
    gridname = id;
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: (title != null && title != "" && title != undefined) ? title : "选择",
        width: width == null ? 700 : width,
        height: height == null ? 400 : height,
        left: '85%',
        cache: false,
        ok: function () {
            iframe = this.iframe.contentWindow;
            var rowsData = iframe.$('#' + id).datagrid('getRows');
            if ((rowsData == '' || rowsData == null) && validFunction == null) {
                iframe.tip("请至少选择一条数据");
                return false;
            } else {
                if (validFunction != null && validFunction != "undefined") {
                    return validFunction(rowsData);
                }
                var str = "";
                $.each(rowsData, function (i, n) {
                    if (i == 0) {
                        str += n[valueField];
                    } else {
                        str += ",";
                        str += n[valueField];
                    }
                });
                $("#" + triggerName).val(str);
                return true;
            }
        },
        cancelVal: '关闭',
        cancel: true
    });
}

/*
 * 自定义弹出列表 target: 要填充的控件ID，可以多个，以逗号分隔，与name要一一对应 src:列表中对应的字段,可以为多个，以逗号分隔
 * url：弹出页面的Url
 */
function popGridZJH(title, url, width, height) {
    //$.dialog.setting.zIndex = 2009;
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: title,
        width: width,
        height: height,
        cache: false,
        ok: function () {
            iframe = this.iframe.contentWindow;
            saveObj();
            return false;
        },
        cancelVal: '关闭',
        cancel: true
    });
}

/*
 * 自定义弹出列表 target: 要填充的控件ID，可以多个，以逗号分隔，与name要一一对应 src:列表中对应的字段,可以为多个，以逗号分隔
 * url：弹出页面的Url
 */
function popGrid(target, src, url, width, height) {
//    $.dialog.setting.zIndex = 2009;
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width,
        height: height,
        cache: false,
        init: function () {
            var hiddenField = '<input type="hidden" id="targetField" name="targetField" value="' + target
                + '">' + '<input type="hidden" id="srcField" name="srcField" value="' + src + '">';
            iframe = this.iframe.contentWindow;
            iframe.$("body").append(hiddenField);
        }
    });
}

/*
 * 自定义弹出树 name:列表中对应的字段,可以为多个，以逗号分隔 url：弹出页面的Url
 */
function popTree(name, url, width, height) {
//    $.dialog.setting.zIndex = 2001;
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width,
        height: height,
        cache: false,
        init: function () {
            var hiddenField = '<input type="hidden" id="targetField" name="targetField" value="' + name + '">';
            iframe = this.iframe.contentWindow;
            iframe.$("body").append(hiddenField);
        }
    });
}

/**
 * eisp Excel 导出 代入查询条件
 */
function EispExcelExport(url, datagridId) {
    var queryParams = $('#' + datagridId).datagrid('options').queryParams;
    $('#' + datagridId + 'tb_r').find('*').each(function () {
        queryParams[$(this).attr('name')] = $(this).val();
    });
    var params = '&';
    $.each(queryParams, function (key, val) {
        params += '&' + key + '=' + val;
    });
    var fields = '&field=';
    $.each($('#' + datagridId).datagrid('options').columns[0], function (i, val) {
        if (val.field != 'opt') {
            fields += val.field + ',';
        }
    });
    var _char = "&";
    if (url.indexOf("?") == -1) {
        _char = "?";
    }
    window.location.href = url + _char + "1=1" + encodeURI(fields + params);
    // window.open( url + encodeURI(fields + params) ) ;
}

/**
 * 自动完成的解析函数
 *
 * @param data
 * @returns {Array}
 */
function eispAutoParse(data) {
    var parsed = [];
    $.each(data.rows, function (index, row) {
        parsed.push({
            data: row,
            result: row,
            value: row.id
        });
    });
    return parsed;
}

/**
 *
 * @param tips提示信息
 * @param url
 *            请求地址
 * @param params
 *            请求参数
 * @param callbackfunc
 *            callback函数设置
 * @param async
 *            是否同步
 * @param timout
 *            超时设置
 */
function ajaxRequest(jsonconfig) {
    var tips = jsonconfig.tips;
    var param = jsonconfig.data;
    if (tips == "" || tips == null) {
        tips = "确认执行?";
    }
    var timout = jsonconfig.timout;
    if (timout == null || timout == "") {
        timout = 9000;
    }
    getSafeJq().dialog.confirm(tips, function () {
        window.top.$.messager.progress({
            text: '操作执行中....',
            interval: 300
        });
        $.ajax({
            type: "post",
            url: jsonconfig.url,
            data: jsonconfig.params || '',
            timeout: timout,
            success: function (r) {
                var callMethod = function (method) {
                    method(r);
                };
                callMethod(jsonconfig.callbackfun);// 提交成功回调
                window.top.$.messager.progress('close');
            },
            error: function () {
                window.top.$.messager.progress('close');
                $.dialog.tips('服务器繁忙，请稍后再试');
            }
        });
    })
}

// 允许指定扩展选项的创建窗体方法
function createwindowExt(title, addurl, width, height, options) {
    var offsetW = window.top.document.body.offsetWidth;
    var offsetH = window.top.document.body.offsetHeight;
    width = (width && width != 'null') ? width : 700;
    height = (height && height != 'null') ? height : 400;
    if (width == "100%" || width > offsetW) {
        width = offsetW;
    }
    if (height == "100%" || height > (offsetH - 100)) {
        height = offsetH - 100;
    }
    var myOptions = {
        content: 'url:' + addurl,
        lock: true,
        width: parseInt(width),
        height: parseInt(height),
        title: title,
        opacity: 0.3,
        cache: false,
        /* 为true等价于function(){} */
    };
    if (typeof(options) == "undefined" || typeof(options.button) == "undefined") {
        $.extend(myOptions, {
            ok: function () {
                iframe = this.iframe.contentWindow;
                saveObj();
                return false;
            },
            cancelVal: '关闭',
            cancel: true
        });
    }
    $.extend(myOptions, options);
    safeShowDialog(myOptions);
}

/**
 * 提交前弹出提示语
 */
function createwindowExtAct(title, addurl, width, height, options, actId) {
    debugger;
    width = width ? width : 700;
    height = height ? height : 400;
    if (width == "100%") {
        width = window.top.document.body.offsetWidth;
    }
    if (height == "100%") {
        height = window.top.document.body.offsetHeight - 100;
    }
    var myOptions = {
        content: 'url:' + addurl,
        lock: true,
        width: width,
        height: height,
        title: title,
        opacity: 0.3,
        cache: false,
        ok: function () {
            iframe = this.iframe.contentWindow;
            $.ajax({
                type: "post",
                url: 'xpsActController/getActItem?actId=' + actId,
                dataType: "json",
                async: false,
                success: function (data) {
                    if (data.type > 0) {
                        $.dialog.confirm("分配的门店将重置！你是否要更改?", function () {
                            saveObj();
                            return true;
                        });
                        return false;
                    } else {
                        saveObj();
                    }
                },
                error: function () {
                    $.ligerDialog.error('提交失败');
                }
            });
            return false;
        },
        cancelVal: '关闭',
        cancel: true
    };
    $.extend(myOptions, options);
    safeShowDialog(myOptions);
}

/**
 * 创建无按钮窗口
 *
 * @param title
 * @param addurl
 * @param saveurl
 */
function createwindownobutton(title, addurl, width, height) {
    createwindowExt(title, addurl, width, height, {ok: false, cancel: false});
}

//创建选择弹窗， 要求打开的页面实现getSelections方法
function createselectwindow(title, addurl, width, height, onSelect) {
    createwindowExt(title, addurl, width, height, {
        ok: function () {
            iframe = this.iframe.contentWindow;
            if (typeof (iframe.getSelections) === 'function') {
                var selected = iframe.getSelections();
                if (typeof (onSelect) === 'function') {
                    onSelect(selected);
                }
            }
            this.iframe.api.close();
            return false;
        }
    });
}


//金额数字转中文大写
function Arabia_to_Chinese(Num) {
    debugger;
    for (i = Num.length - 1; i >= 0; i--) {
        Num = Num.replace(",", "");//替换tomoney()中的“,”
        Num = Num.replace(" ", "")//替换tomoney()中的空格
    }
    Num = Num.replace("￥", "");//替换掉可能出现的￥字符
    if (isNaN(Num)) { //验证输入的字符是否为数字
        return;
    }
    //---字符处理完毕，开始转换，转换采用前后两部分分别转换---//
    part = String(Num).split(".");
    newchar = "";
    //小数点前进行转化
    for (i = part[0].length - 1; i >= 0; i--) {
        if (part[0].length > 10) {
            alert("位数过大，无法计算");
            return "";
        } //若数量超过拾亿单位，提示
        tmpnewchar = "";
        perchar = part[0].charAt(i);
        switch (perchar) {
            case "0":
                tmpnewchar = "零" + tmpnewchar;
                break;
            case "1":
                tmpnewchar = "一" + tmpnewchar;
                break;
            case "2":
                tmpnewchar = "二" + tmpnewchar;
                break;
            case "3":
                tmpnewchar = "三" + tmpnewchar;
                break;
            case "4":
                tmpnewchar = "四" + tmpnewchar;
                break;
            case "5":
                tmpnewchar = "五" + tmpnewchar;
                break;
            case "6":
                tmpnewchar = "六" + tmpnewchar;
                break;
            case "7":
                tmpnewchar = "七" + tmpnewchar;
                break;
            case "8":
                tmpnewchar = "八" + tmpnewchar;
                break;
            case "9":
                tmpnewchar = "九" + tmpnewchar;
                break;
        }
        switch (part[0].length - i - 1) {
            case 0:
                tmpnewchar = tmpnewchar + "元";
                break;
            case 1:
                if (perchar != 0)
                    tmpnewchar = tmpnewchar + "十";
                break;
            case 2:
                if (perchar != 0)
                    tmpnewchar = tmpnewchar + "百";
                break;
            case 3:
                if (perchar != 0)
                    tmpnewchar = tmpnewchar + "千";
                break;
            case 4:
                tmpnewchar = tmpnewchar + "万";
                break;
            case 5:
                if (perchar != 0)
                    tmpnewchar = tmpnewchar + "十";
                break;
            case 6:
                if (perchar != 0)
                    tmpnewchar = tmpnewchar + "百";
                break;
            case 7:
                if (perchar != 0)
                    tmpnewchar = tmpnewchar + "千";
                break;
            case 8:
                tmpnewchar = tmpnewchar + "亿";
                break;
            case 9:
                tmpnewchar = tmpnewchar + "十";
                break;
        }
        newchar = tmpnewchar + newchar;
    }
    //小数点之后进行转化
    if (Num.indexOf(".") != -1) {
        if (part[1].length > 2) {
            tip("小数点之后只能保留两位,系统将自动截段");
            part[1] = part[1].substr(0, 2)
        }
        for (i = 0; i < part[1].length; i++) {
            tmpnewchar = "";
            perchar = part[1].charAt(i);
            switch (perchar) {
                case "0":
                    tmpnewchar = "零" + tmpnewchar;
                    break;
                case "1":
                    tmpnewchar = "一" + tmpnewchar;
                    break;
                case "2":
                    tmpnewchar = "二" + tmpnewchar;
                    break;
                case "3":
                    tmpnewchar = "三" + tmpnewchar;
                    break;
                case "4":
                    tmpnewchar = "四" + tmpnewchar;
                    break;
                case "5":
                    tmpnewchar = "五" + tmpnewchar;
                    break;
                case "6":
                    tmpnewchar = "六" + tmpnewchar;
                    break;
                case "7":
                    tmpnewchar = "七 " + tmpnewchar;
                    break;
                case "8":
                    tmpnewchar = "八" + tmpnewchar;
                    break;
                case "9":
                    tmpnewchar = "九" + tmpnewchar;
                    break;
            }
            if (i == 0)
                tmpnewchar = tmpnewchar + "角";
            if (i == 1)
                tmpnewchar = tmpnewchar + "分";
            newchar = newchar + tmpnewchar;
        }
    }
    //替换所有无用汉字
    while (newchar.search("零零") != -1)
        newchar = newchar.replace("零零", "零");
    newchar = newchar.replace("零亿", "亿");
    newchar = newchar.replace("亿万", "亿");
    newchar = newchar.replace("零万", "万");
    newchar = newchar.replace("零元", "元");
    newchar = newchar.replace("零角", "");
    newchar = newchar.replace("零分", "");
    if (newchar.charAt(newchar.length - 1) == "元"
        || newchar.charAt(newchar.length - 1) == "角")
        newchar = newchar + "整";
    //  document.write(newchar);
    return newchar;
}

/**
 * 获取select所选择的项文本
 *
 */
function selectGetValueToSetname(sourceId, targetId) {
    $("#" + sourceId).change(function () {
        setTheTextValue(targetId, $(this).val(), $(this).find("option:selected").text());
    });
}

function selectGetValueToSetnameHasBack(sourceId, targetId, callBack) {
    $("#" + sourceId).change(function () {
        setTheTextValue(targetId, $(this).val(), $(this).find("option:selected").text());
        callBack($(this));
    });
}

function setTheTextValue(targetId, val, text) {
    if (val == '') {
        text = '';
    }
    $('#' + targetId).val(text);
}

function addTab(subtitle, url, icon) {
    var progress = $("div.messager-progress");
    if (progress.length) {
        return;
    }
    rowid = "";

    var maintabsId = parent.$('#maintabs');
    if (!maintabsId.tabs('exists', subtitle)) {
        //判断是否进行href方式打开tab，默认为iframe方式
        if (url.indexOf('isHref') != -1) {
            maintabsId.tabs('add', {
                title: subtitle,
                href: url,
                closable: true,
                icon: icon
            });
        } else {
            maintabsId.tabs('add', {
                title: subtitle,
                content: '<iframe src="' + url + '" frameborder="0" style="border:0;width:100%;height:99.4%;"></iframe>',
                closable: true,
                icon: icon
            });
        }
    } else {
        maintabsId.tabs('select', subtitle);
        $.messager.progress('close');
    }
    parent.tabClose();
}

//公用验证form表单
var ValidformCallbackFun = "";

function pubValidForm(para) {
    //$.Tipmsg.r=null;
    ValidformCallbackFun = (typeof(para["callback"]) == "undefined" ? "" : para["callback"]);
    $("#" + para['formId'] + "").Validform({
        tiptype: 4,
        tipSweep: true,
        ajaxPost: true,
        beforeSubmit: function () {
            if (ValidformCallbackFun != "") {
                eval(ValidformCallbackFun);
            }
            return false;
        },
        callback: "",
        datatype: {
            "float": function (gets, obj, curform, regxp) {
                var num = typeof(obj.attr("datatype-float-num")) == "undefined" ? 2 : Number(obj.attr("datatype-float-num"));
                var negative = (typeof(obj.attr("datatype-float-negative")) == "undefined" || obj.attr("datatype-float-negative") != "y" ? "" : "(|-)");
                var patt1 = new RegExp("^" + negative + "([1-9][\\d]{0,9}|0)(\\.[\\d]{1," + num + "})?$");
                if (patt1.exec(gets) != null && patt1.exec(gets)[0] == gets)
                    return true;
                else
                    return false;
            }
        }
    });
}

//新增多个TAB
function addTabMore(subtitle, url, icon) {
    var progress = $("div.messager-progress");
    //if(progress.length){return;}
    rowid = "";
    $.messager.progress({
        text: loading,
        interval: 200
    });
    if (!$('#maintabs').tabs('exists', subtitle)) {
        //判断是否进行href方式打开tab，默认为iframe方式
        if (url.indexOf('isHref') != -1) {
            $('#maintabs').tabs('add', {
                title: subtitle,
                href: url,
                closable: true,
                icon: icon
            });
        } else {

            $('#maintabs').tabs('add', {
                title: subtitle,
                content: '<iframe src="' + url + '" frameborder="0" style="border:0;width:100%;height:99.4%;"></iframe>',
                closable: true,
                icon: icon
            });

        }

    } else {
        $('#maintabs').tabs('select', subtitle);
        $.messager.progress('close');
    }

    // $('#maintabs').tabs('select',subtitle);
    tabClose();

}


//获取 任意 日期
function GetDateStr(AddYear, AddMonth, AddDay, datestr) {
    AddYear ? AddYear : AddYear = 0;
    AddMonth ? AddMonth : AddMonth = 0;
    AddDay ? AddDay : AddDay = 0;
    var dd = datestr ? new Date(datestr) : new Date();
    dd.setFullYear(dd.getFullYear() + AddYear);
    dd.setMonth(dd.getMonth() + AddMonth);
    dd.setDate(dd.getDate() + AddDay);
    var y = dd.getFullYear();
    var m = dd.getMonth() + 1;
    var d = dd.getDate();
    m = checkTime(m);
    d = checkTime(d);
    return y + "-" + m + "-" + d;
}

function checkTime(i) {
    if (i < 10) {
        i = "0" + i
    }
    return i
}

/**
 * 避免NaN
 * @param value
 * @returns {Number}
 */
function numberIsNull(value) {
    if (value == '') {
        value = 0;
    }
    return value;
}

/**
 *  打开遮罩
 */
function openProgress() {
    $.messager.progress({
        title: "提示",
        msg: '数据加载中,请稍后...'
    });
}

/**
 * 关闭遮罩
 */
function closeProgress() {
    $.messager.progress('close');
}

/**
 * 自动加载数据
 */
function autoLoadData(obj) {
    var key, value, tagName, type, arr;
    for (x in obj) {
        key = x;
        value = obj[x];
        $("[name='" + key + "'],[name='" + key + "[]']").each(function () {
            tagName = $(this)[0].tagName;
            type = $(this).attr('type');
            if (tagName == 'INPUT') {
                if (type == 'radio') {
                    $(this).attr('checked', $(this).val() == value);
                } else if (type == 'checkbox') {
                    arr = value.split(',');
                    for (var i = 0; i < arr.length; i++) {
                        if ($(this).val() == arr[i]) {
                            $(this).attr('checked', true);
                            break;
                        }
                    }
                } else {
                    $(this).val(value);
                }
            } else if (tagName == 'SELECT' || tagName == 'TEXTAREA') {
                $(this).val(value);
            }
        });
    }
}

/**
 * 给keyuptype属性的输入框添加keyup事件验证正则
 */
$(function () {
    $("body").on("keyup", "[keyuptype]", function () {
        var reg = new RegExp($(this).attr("keyuptype"));
        reg.test($(this).val()) ? "" : $(this).val("");
    })
});

// 将输入的数字金额转换成对应的中文大写金额
// idNumber输入的数字金额，idCHN输出的中文大写金额
function TransformNumberIntoCHN(idNumber, idCHN) {
    var number = document.getElementById(idNumber).value;
    if (!/^(0|[1-9]\d*)(\.\d{0,2})?$/.test(number)) {
        $("#" + idCHN).html("");
        document.getElementById(idNumber).value = "";
        return false;
    }
    var unit = "仟佰拾亿仟佰拾万仟佰拾元角分", str = "";
    number += "00";
    var point = number.indexOf('.');
    if (point >= 0) {
        number = number.substring(0, point) + number.substr(point + 1, 2);
    }
    unit = unit.substr(unit.length - number.length);
    for (var i = 0; i < number.length; i++) {
        str += '零壹贰叁肆伍陆柒捌玖'.charAt(number.charAt(i)) + unit.charAt(i);
    }
    if (str.replace(/零(仟|佰|拾|角)/g, "零").replace(/(零)+/g, "零").replace(/零(万|亿|元)/g, "$1").replace(/(亿)万|(拾)/g, "$1$2").replace(/^元零?|零分/g, "").replace(/元$/g, "元整") == "分") {
        $("#" + idCHN).html("零元整");
    } else {
        var val = str.replace(/零(仟|佰|拾|角)/g, "零").replace(/(零)+/g, "零").replace(/零(万|亿|元)/g, "$1").replace(/(亿)万|(拾)/g, "$1$2").replace(/^元零?|零分/g, "").replace(/元$/g, "元整");
        $("#" + idCHN).html(val);
    }
}

//动态添加删除cell editor编辑器
$.extend($.fn.datagrid.methods, {
    addEditor: function (jq, param) {
        if (param instanceof Array) {
            $.each(param, function (index, item) {
                var e = $(jq).datagrid('getColumnOption', item.field);
                e.editor = item.editor;
            });
        } else {
            var e = $(jq).datagrid('getColumnOption', param.field);
            e.editor = param.editor;
        }
    },
    removeEditor: function (jq, param) {
        if (param instanceof Array) {
            $.each(param, function (index, item) {
                var e = $(jq).datagrid('getColumnOption', item);
                e.editor = {};
            });
        } else {
            var e = $(jq).datagrid('getColumnOption', param);
            e.editor = {};
        }
    }
});


/**
 * 动态操作行
 * @param title
 * @param url
 * @param gname
 * @param othertip
 */
function opSelect(title, url, gname, othertip, type) {
    gridname = gname;
    var ids = [];
    var rows = $("#" + gname).datagrid('getSelections');
    if (rows.length > 0) {
        if (!type) {//false表示 只允许选择一条操作
            if (rows.length > 1) {
                tip(othertip);
                return;
            }
        }
        getSafeJq().dialog.confirm(title, function (r) {
            if (r) {
                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].id);
                }
                $.ajax({
                    url: url,
                    type: 'post',
                    dataType: 'json',
                    data: {
                        ids: ids.join(',')
                    },
                    cache: false,
                    success: function (data) {
                        var msg = data.msg;
                        tip(msg, 'info');
                        if (data.success) {
                            reloadTable();
                            $("#" + gname).datagrid('unselectAll');
                            ids = '';
                        }
                    }
                });
            }
        });
    } else {
        tip(othertip);
    }
}

function exporterrorForImport(url) {
    window.location.href = url;
}


/*--------------------------共用--new--2019-05--------------------------*/

//将obj转换为urlData
function changeDataToUrlData(data) {
    var urlData = '';
    if (typeof(data) != 'undefined' && data != '' && data != null) {
        for (var name in data) {
            urlData += '&' + name + '=' + data[name];
        }
    }
    return urlData;
}

//处理键值对
function HashKey() {
    var data = {};
    this.set = function (key, value) {   //set方法
        data[key] = value;
    };
    this.unset = function (key) {     //unset方法
        delete data[key];
    };
    this.get = function (key) {     //get方法
        return data[key] || "";
    };
    this.returnKey = function () {
        //获得对象所有属性的数组
        return Object.getOwnPropertyNames(data);
    }
}

//检查是否为未定义或为空不为undefined
function checkIsNotUndefinedAndNull(value) {
    return (typeof(value) != 'undefined' && $.trim(value).length > 0)
}

//检查是否为未定义或为空不为undefined和不为空值（'null'）
function checkIsNotUndefinedAndNullAndNullValue(value) {
    return (checkIsNotUndefinedAndNull(value) && value != 'null');
}

/**
 * 通用ajax post 方法
 * @param json 传入参数json
 * @param url  调用url
 */
function ajaxPost(json, url) {
    var json;
    $.ajax({
        url: url,
        data: json,
        dataType: 'json',
        async: false,
        success: function (data) {
            ajaxCloseTheProgress();
            json = data;
        },
        error: function (error) {
            ajaxCloseTheProgress();
            json = {"sucess": false, "msg": "服务器错误!"};
        }
    });
    return json;
}

function ajaxCloseTheProgress() {
    $.messager.progress('close');
}

/** 添加数据到多选框 */
function renderTag(containerId, array) {
    if (Object.prototype.toString.call(array) === "[object Array]") {
        if (array.length > 0) {
            //获取已有tag
            $.each(array, function (index, item) {
                //判断是否已经存在
                debugger
                var $tag = $("#" + containerId).find(".biz-tags-content").find('span.biz-tag[code="' + item.code + '"]');
                if ($tag.length === 0) {
                    var tag = "";
                    tag += '<span class="biz-tag" code="' + item.code + '" name="' + item.name + '">' + item.name;
                    tag += '<i class="biz-tag-close fa fa-close"></i>';
                    tag += '</span>';
                    $("#" + containerId).find(".biz-tags-content").append(tag);
                }
            })
        }
    }
}

/** 得到复选框值 */
function getTags(id) {
    var tags = [];
    $("#" + id).find("span.biz-tag").each(function () {
        var obj = {};
        var name = $(this).attr("name");
        var code = $(this).attr("code");
        obj["name"] = name;
        obj["code"] = code;
        tags.push(obj);
    });
    return tags;
}

/** 清空tags */

function clearTags(event) {
    $(event).parents(".biz-tags-box").find(".biz-tags-content").html("");
}

function safeShowDialogParent(option) {
    var width = option.width;
    var height = option.height;
    var offsetW = window.top.document.body.offsetWidth;
    var offsetH = window.top.document.body.offsetHeight;
    width = (width && width != 'null') ? width : 700;
    height = (height && height != 'null') ? height : 400;
    if (width == "100%" || width > offsetW) {
        width = offsetW;
    }
    if (height == "100%" || height > (offsetH - 100)) {
        height = offsetH - 100;
    }
    var windowapi = window.parent.frameElement.api;
    $.extend(option, {width: width, height: height, parent: windowapi});
    return windowapi.opener.$.dialog(option).zindex();
}

function importDataByXml(cfg) {
    if (!cfg.impName) {
        alert("未配置impName参数！");
        return;
    }
    gridname = cfg.gridName;
    $.dialog({
        content: "url:importController.do?importData&impName=" + cfg.impName + "&hiddenTemplete=" + cfg.hiddenTemplete,
        lock: true,
        title: "导入",
        max: false,
        width: 400,
        height: 400,
        button: [
            {
                name: "开始上传",
                callback: function () {
                    iframe = this.iframe.contentWindow;
                    iframe.upload();
                    return false;
                }
            },
            {
                name: "模板下载",
                callback: function () {
                    iframe = this.iframe.contentWindow;
                    iframe.downTemplete();
                    return false;
                }
            },
            {
                name: "取消",
                callback: function () {
                    return true;
                }
            }
        ]
    }).zindex();
}

//穿梭框选择
function addSelect(title, url, gname, width, height, params) {
    safeShowDialog({
        content: "url:" + url,
        lock: true,
        title: "选择",
        width: width == null ? 700 : width,
        height: height == null ? 400 : height,
        left: '85%',
        cache: false,
        ok: function () {
            iframe = this.iframe.contentWindow;
            iframe.save(calback);
            return false;

        },
        cancelVal: '关闭',
        cancel: true
    });
}

function calback() {
    window.location.reload();
}

/*
* 导入Excel
*  cb 导入成功的回调
*  @param  Object{
*     uploadUrl,//上传地址
*     downloadUrl,//下载模板地址
*     queryUrl,//轮询地址
*     other:{}其它请求参数
*   }
* */
function importExcel(options, cb) {
    if (!options) options = {};
    $.dialog({
        content: "url:importController.do?importDataWebsocket",
        lock: true,
        title: "导入",
        max: false,
        width: 400,
        height: 400,
        button: [
            {
                name: "开始上传",
                callback: function () {
                    iframe = this.iframe.contentWindow;
                    iframe.startUpload();
                    return false;
                }
            },
            /*{
                name: "测试导入",
                callback: function(){
                    iframe = this.iframe.contentWindow;
                    iframe.testUpload();
                    return false;
                }
            },*/
            {
                name: "模板下载",
                callback: function () {
                    downloadTemplate(options);
                    return false;
                }
            },
            {
                name: "取消",
                callback: function () {
                    return true;
                }
            }
        ],
        init: function () {
            iframe = this.iframe.contentWindow;
            iframe.initWebUploader(options, function (res) {
                console.log(res)
            })
        },
        close: function () {

        }
    }).zindex();
};

/*
* 导出/下载模板
* @param url
* */
function downloadTemplate(options) {
    if (options.hasOwnProperty("function")) {
        var returnObj = eval(options.function + '()');
        options = $.extend({}, options, returnObj)
    }
    var urlString = options.downUrl + "?" + toQueryString(options)
    var iframe = $('#download_tpl');
    if (iframe.length > 0) {
        iframe.attr("src", urlString);
    } else {
        var dom = $("<iframe>");
        dom.attr("src", urlString);
        dom.css({"display": "none"});
        dom.attr("id", "download_tpl");
        $('body').append(dom);
    }
};

// JSON参数序列化
function toQueryString(obj) {
    let result = [];
    for (let key in obj) {
        key = encodeURIComponent(key);
        let values = obj[key];
        if (values && values.constructor === Array) {
            let queryValues = [];
            for (let i = 0, len = values.length, value; i < len; i++) {
                value = values[i];
                queryValues.push(this.toQueryPair(key, value));
            }
            result = result.concat(queryValues);
        } else {
            result.push(this.toQueryPair(key, values));
        }
    }
    return result.join('&');
}

function toQueryPair(key, value) {
    if (typeof value === 'undefined') {
        return key;
    }
    return key + '=' + encodeURIComponent(value === null ? '' : String(value));
}


//上传附件
function importAttach(options, cb) {
    if (!options) options = {};
    window.top.$.dialog({
        content: "url:importController.do?importAttach",
        lock: true,
        title: "附件上传",
        max: false,
        width: 400,
        height: 400,
        button: [
            {
                name: "开始上传",
                callback: function () {
                    iframe = this.iframe.contentWindow;
                    iframe.startUpload();
                    return false;
                }
            },
            {
                name: "取消",
                callback: function () {
                    return true;
                }
            }
        ],
        init: function () {
            iframe = this.iframe.contentWindow;
            iframe.initWebUploader(options, function (res) {
                console.log(res)
            })
        },
        close: function () {

        }
    }).zindex();
}

//socket
/**
 * params options Object
 * params options.url
 * params options.protocol
 * */
function BizSocket(options) {
    var socket = null;
    if (window.location.href.indexOf("http://") > -1) {
        var url = "ws://" + options.url + (options.uuid || '');
        socket = new WebSocket(url);
    } else if (window.location.href.indexOf("https://") > -1) {
        var url = "wss://" + options.url + (options.uuid || '');
        socket = new WebSocket(url);
    }
    return socket;
}