/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.exporter;

import com.biz.eisp.base.exporter.ExcelPublicUtil;
import com.biz.eisp.base.exporter.annotation.Excel;
import com.biz.eisp.base.exporter.annotation.ExcelCollection;
import com.biz.eisp.base.exporter.annotation.ExcelTarget;
import com.biz.eisp.base.exporter.entity.ComparatorExcelField;
import com.biz.eisp.base.exporter.entity.ExcelExportEntity;
import com.biz.eisp.base.exporter.entity.TemplateExportParams;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public final class ExcelExportOfTemplateUtil {
    public static Workbook exportExcel(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        return ExcelExportOfTemplateUtil.createSheetInUserModel2FileByTemplate(params, pojoClass, dataSet, map);
    }

    public static Workbook exportExcel(TemplateExportParams params, Map<String, Object> map) {
        return ExcelExportOfTemplateUtil.createSheetInUserModel2FileByTemplate(params, null, null, map);
    }

    private static Workbook createSheetInUserModel2FileByTemplate(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)params.getTemplateUrl())) {
            return null;
        }
        Workbook wb = null;
        try {
            wb = ExcelExportOfTemplateUtil.getCloneWorkBook(params);
            for (int i = wb.getNumberOfSheets() - 1; i >= 0; --i) {
                if (i == params.getSheetNum()) continue;
                wb.removeSheetAt(i);
            }
            if (StringUtils.isNotEmpty((String)params.getSheetName())) {
                wb.setSheetName(0, params.getSheetName());
            }
            ExcelExportOfTemplateUtil.parseTemplate(wb.getSheetAt(0), map);
            if (dataSet != null) {
                ExcelExportOfTemplateUtil.addDataToSheet(params, pojoClass, dataSet, wb.getSheetAt(0), wb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return wb;
    }

    private static Workbook getCloneWorkBook(TemplateExportParams params) throws Exception {
        int len;
        Workbook wb = null;
        String path = Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath();
        path = path.replace("WEB-INF/classes/", "");
        path = path.replace("file:/", "") + params.getTemplateUrl();
        FileInputStream fileis = new FileInputStream(path);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = fileis.read(buffer)) > -1) {
            baos.write(buffer, 0, len);
        }
        baos.flush();
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        wb = WorkbookFactory.create((InputStream)is);
        baos.close();
        fileis.close();
        ((InputStream)is).close();
        return wb;
    }

    private static void addDataToSheet(TemplateExportParams params, Class<?> pojoClass, Collection<?> dataSet, Sheet sheet, Workbook workbook) throws Exception {
        Drawing patriarch = sheet.createDrawingPatriarch();
        ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
        Field[] fileds = ExcelPublicUtil.getClassFields(pojoClass);
        ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
        String targetId = null;
        if (etarget != null) {
            targetId = etarget.id();
        }
        ExcelExportOfTemplateUtil.getAllExcelField(targetId, fileds, excelParams, pojoClass, null);
        ExcelExportOfTemplateUtil.sortAllParams(excelParams);
        Iterator<?> its = dataSet.iterator();
        int index = sheet.getLastRowNum();
        while (its.hasNext()) {
            Object t = its.next();
            index += ExcelExportOfTemplateUtil.createCells(patriarch, index, t, excelParams, sheet, workbook);
        }
    }

    private static void parseTemplate(Sheet sheet, Map<String, Object> map) throws Exception {
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            for (int i = row.getFirstCellNum(); i < row.getLastCellNum(); ++i) {
                ExcelExportOfTemplateUtil.setValueForCellByMap(row.getCell(i), map);
            }
        }
    }

    private static void setValueForCellByMap(Cell cell, Map<String, Object> map) throws Exception {
        String oldString;
        try {
            oldString = cell.getStringCellValue();
        }
        catch (Exception e) {
            return;
        }
        if (oldString != null && oldString.indexOf("{{") != -1) {
            while (oldString.indexOf("{{") != -1) {
                String params = oldString.substring(oldString.indexOf("{{") + 2, oldString.indexOf("}}"));
                oldString = oldString.replace("{{" + params + "}}", ExcelExportOfTemplateUtil.getParamsValue(params.trim(), map));
            }
            cell.setCellValue(oldString);
        }
    }

    private static String getParamsValue(String params, Map<String, Object> map) throws Exception {
        if (params.indexOf(".") != -1) {
            String[] paramsArr = params.split("\\.");
            return ExcelExportOfTemplateUtil.getValueDoWhile(map.get(paramsArr[0]), paramsArr, 1);
        }
        return map.containsKey(params) ? map.get(params).toString() : "";
    }

    private static String getValueDoWhile(Object object, String[] paramsArr, int index) throws Exception {
        if (object == null) {
            return "";
        }
        object = object instanceof Map ? ((Map)object).get(paramsArr[index]) : ExcelPublicUtil.getMethod(paramsArr[index], object.getClass()).invoke(object, new Object[0]);
        return index == paramsArr.length - 1 ? (object == null ? "" : object.toString()) : ExcelExportOfTemplateUtil.getValueDoWhile(object, paramsArr, ++index);
    }

    private static void sortAllParams(List<ExcelExportEntity> excelParams) {
        Collections.sort(excelParams, new ComparatorExcelField());
        for (ExcelExportEntity entity : excelParams) {
            if (entity.getList() == null) continue;
            Collections.sort(entity.getList(), new ComparatorExcelField());
        }
    }

    private static int createCells(Drawing patriarch, int index, Object t, List<ExcelExportEntity> excelParams, Sheet sheet, Workbook workbook) throws Exception {
        ExcelExportEntity entity;
        int k;
        Row row = sheet.createRow(index);
        row.setHeight((short)350);
        int maxHeight = 1;
        int cellNum = 0;
        int paramSize = excelParams.size();
        for (k = 0; k < paramSize; ++k) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                Collection list = (Collection)entity.getGetMethod().invoke(t, new Object[0]);
                int listC = 0;
                for (Object obj : list) {
                    ExcelExportOfTemplateUtil.createListCells(patriarch, index + listC, cellNum, obj, entity.getList(), sheet, workbook);
                    ++listC;
                }
                cellNum += entity.getList().size();
                if (list == null || list.size() <= maxHeight) continue;
                maxHeight = list.size();
                continue;
            }
            Object value = ExcelExportOfTemplateUtil.getCellValue(entity, t);
            if (entity.getType() != 2) {
                ExcelExportOfTemplateUtil.createStringCell(row, cellNum++, value.toString(), entity, workbook);
                continue;
            }
            ExcelExportOfTemplateUtil.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), t, workbook);
        }
        cellNum = 0;
        paramSize = excelParams.size();
        for (k = 0; k < paramSize; ++k) {
            entity = excelParams.get(k);
            if (entity.getList() != null) {
                cellNum += entity.getList().size();
                continue;
            }
            if (!entity.isNeedMerge()) continue;
            sheet.addMergedRegion(new CellRangeAddress(index, index + maxHeight - 1, cellNum, cellNum));
            ++cellNum;
        }
        return maxHeight;
    }

    private static Object getCellValue(ExcelExportEntity entity, Object obj) throws Exception {
        Object value;
        Object object = value = entity.getGetMethods() != null ? ExcelExportOfTemplateUtil.getFieldBySomeMethod(entity.getGetMethods(), obj) : entity.getGetMethod().invoke(obj, new Object[0]);
        if (StringUtils.isNotEmpty((String)entity.getExportFormat()) && StringUtils.isNotEmpty((String)entity.getDatabaseFormat())) {
            SimpleDateFormat format;
            Date temp = null;
            if (value instanceof String) {
                format = new SimpleDateFormat(entity.getDatabaseFormat());
                temp = format.parse(value.toString());
            } else if (value instanceof Date) {
                temp = (Date)value;
            }
            if (temp != null) {
                format = new SimpleDateFormat(entity.getExportFormat());
                value = format.format(temp);
            }
        }
        return value == null ? "" : value.toString();
    }

    private static void createListCells(Drawing patriarch, int index, int cellNum, Object obj, List<ExcelExportEntity> excelParams, Sheet sheet, Workbook workbook) throws Exception {
        Row row;
        if (sheet.getRow(index) == null) {
            row = sheet.createRow(index);
            row.setHeight((short)350);
        } else {
            row = sheet.getRow(index);
        }
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = ExcelExportOfTemplateUtil.getCellValue(entity, obj);
            if (entity.getType() != 2) {
                ExcelExportOfTemplateUtil.createStringCell(row, cellNum++, value == null ? "" : value.toString(), entity, workbook);
                continue;
            }
            ExcelExportOfTemplateUtil.createImageCell(patriarch, entity, row, cellNum++, value == null ? "" : value.toString(), obj, workbook);
        }
    }

    private static Object getFieldBySomeMethod(List<Method> list, Object t) throws Exception {
        for (Method m : list) {
            if (t == null) {
                t = "";
                break;
            }
            t = m.invoke(t, new Object[0]);
        }
        return t;
    }

    private static void createStringCell(Row row, int index, String text, ExcelExportEntity entity, Workbook workbook) {
        Cell cell = row.createCell(index);
        switch (entity.getType()) {
            case 1: {
                HSSFRichTextString Rtext = workbook instanceof HSSFWorkbook ? new HSSFRichTextString(text) : new XSSFRichTextString(text);
                cell.setCellValue((RichTextString)Rtext);
                break;
            }
            case 2: {
                cell.setCellType(2);
                cell.setCellFormula(entity.getCellFormula());
            }
        }
    }

    private static void createImageCell(Drawing patriarch, ExcelExportEntity entity, Row row, int i, String field, Object obj, Workbook workbook) throws Exception {
        HSSFClientAnchor anchor;
        if (StringUtils.isEmpty((String)field)) {
            return;
        }
        row.setHeight((short)(50 * entity.getHeight()));
        row.createCell(i);
        Object object = anchor = workbook instanceof HSSFWorkbook ? new HSSFClientAnchor(0, 0, 0, 0, (short)i, row.getRowNum(), (short)(i + 1), row.getRowNum() + 1) : new XSSFClientAnchor(0, 0, 0, 0, (int)((short)i), row.getRowNum(), (int)((short)(i + 1)), row.getRowNum() + 1);
        if (entity.getExportImageType() == 1) {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            try {
                String path = ExcelExportOfTemplateUtil.class.getClassLoader().getResource("") + field;
                path = path.replace("WEB-INF/classes/", "");
                path = path.replace("file:/", "");
                BufferedImage bufferImg = ImageIO.read(new File(path));
                ImageIO.write((RenderedImage)bufferImg, field.substring(field.indexOf(".") + 1, field.length()), byteArrayOut);
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(byteArrayOut.toByteArray(), 5));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            byte[] value = (byte[])(entity.getGetMethods() != null ? ExcelExportOfTemplateUtil.getFieldBySomeMethod(entity.getGetMethods(), obj) : entity.getGetMethod().invoke(obj, new Object[0]));
            if (value != null) {
                patriarch.createPicture((ClientAnchor)anchor, row.getSheet().getWorkbook().addPicture(value, 5));
            }
        }
    }

    private static void getAllExcelField(String targetId, Field[] fields, List<ExcelExportEntity> excelParams, Class<?> pojoClass, List<Method> getMethods) throws Exception {
        for (int i = 0; i < fields.length; ++i) {
            ExcelExportEntity excelEntity;
            Annotation excel;
            Field field = fields[i];
            if (ExcelPublicUtil.isNotUserExcelUserThis(field, targetId)) continue;
            if (ExcelPublicUtil.isCollection(field.getType())) {
                excel = field.getAnnotation(ExcelCollection.class);
                ParameterizedType pt = (ParameterizedType)field.getGenericType();
                Class clz = (Class)pt.getActualTypeArguments()[0];
                ArrayList<ExcelExportEntity> list = new ArrayList<ExcelExportEntity>();
                ExcelExportOfTemplateUtil.getExcelFieldList(targetId, ExcelPublicUtil.getClassFields(clz), clz, list, null);
                excelEntity = new ExcelExportEntity();
                excelEntity.setName(ExcelExportOfTemplateUtil.getExcelName(excel.exportName(), targetId));
                excelEntity.setOrderNum(ExcelExportOfTemplateUtil.getCellOrder(excel.orderNum(), targetId));
                excelEntity.setGetMethod(ExcelPublicUtil.getMethod(field.getName(), pojoClass));
                excelEntity.setList(list);
                excelParams.add(excelEntity);
                continue;
            }
            if (ExcelPublicUtil.isJavaClass(field)) {
                excel = field.getAnnotation(Excel.class);
                excelEntity = new ExcelExportEntity();
                excelEntity.setType(excel.exportType());
                ExcelExportOfTemplateUtil.getExcelField(targetId, field, excelEntity, (Excel)excel, pojoClass);
                if (getMethods != null) {
                    ArrayList<Method> newMethods = new ArrayList<Method>();
                    newMethods.addAll(getMethods);
                    newMethods.add(excelEntity.getGetMethod());
                    excelEntity.setGetMethods(newMethods);
                }
                excelParams.add(excelEntity);
                continue;
            }
            ArrayList<Method> newMethods = new ArrayList<Method>();
            if (getMethods != null) {
                newMethods.addAll(getMethods);
            }
            newMethods.add(ExcelPublicUtil.getMethod(field.getName(), pojoClass));
            ExcelExportOfTemplateUtil.getAllExcelField(targetId, ExcelPublicUtil.getClassFields(field.getType()), excelParams, field.getType(), newMethods);
        }
    }

    private static String getExcelName(String exportName, String targetId) {
        String[] arr;
        if (exportName.indexOf(",") < 0) {
            return exportName;
        }
        for (String str : arr = exportName.split(",")) {
            if (str.indexOf(targetId) == -1) continue;
            return str.split("_")[0];
        }
        return null;
    }

    private static int getCellOrder(String orderNum, String targetId) {
        String[] arr;
        if (ExcelExportOfTemplateUtil.isInteger(orderNum) || targetId == null) {
            return Integer.valueOf(orderNum);
        }
        for (String str : arr = orderNum.split(",")) {
            if (str.indexOf(targetId) == -1) continue;
            return Integer.valueOf(str.split("_")[0]);
        }
        return 0;
    }

    private static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static void getExcelFieldList(String targetId, Field[] fields, Class<?> pojoClass, List<ExcelExportEntity> list, List<Method> getMethods) throws Exception {
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (ExcelPublicUtil.isNotUserExcelUserThis(field, targetId)) continue;
            if (ExcelPublicUtil.isJavaClass(field)) {
                Excel excel = field.getAnnotation(Excel.class);
                ExcelExportEntity excelEntity = new ExcelExportEntity();
                ExcelExportOfTemplateUtil.getExcelField(targetId, field, excelEntity, excel, pojoClass);
                if (getMethods != null) {
                    ArrayList<Method> newMethods = new ArrayList<Method>();
                    newMethods.addAll(getMethods);
                    newMethods.add(excelEntity.getGetMethod());
                    excelEntity.setGetMethods(newMethods);
                }
                list.add(excelEntity);
                continue;
            }
            ArrayList<Method> newMethods = new ArrayList<Method>();
            if (getMethods != null) {
                newMethods.addAll(getMethods);
            }
            newMethods.add(ExcelPublicUtil.getMethod(field.getName(), pojoClass));
            ExcelExportOfTemplateUtil.getExcelFieldList(targetId, ExcelPublicUtil.getClassFields(field.getType()), field.getType(), list, newMethods);
        }
    }

    private static void getExcelField(String targetId, Field field, ExcelExportEntity excelEntity, Excel excel, Class<?> pojoClass) throws Exception {
        excelEntity.setName(ExcelExportOfTemplateUtil.getExcelName(excel.exportName(), targetId));
        excelEntity.setWidth(excel.exportFieldWidth());
        excelEntity.setHeight(excel.exportFieldHeight());
        excelEntity.setNeedMerge(excel.needMerge());
        excelEntity.setOrderNum(ExcelExportOfTemplateUtil.getCellOrder(excel.orderNum(), targetId));
        excelEntity.setWrap(excel.isWrap());
        excelEntity.setExportImageType(excel.imageType());
        excelEntity.setType(excel.exportType());
        excelEntity.setCellFormula(excel.cellFormula());
        String fieldname = field.getName();
        excelEntity.setGetMethod(ExcelPublicUtil.getMethod(fieldname, pojoClass));
        if (excel.exportConvertSign() == 1 || excel.imExConvert() == 1) {
            StringBuffer getConvertMethodName = new StringBuffer("convertGet");
            getConvertMethodName.append(fieldname.substring(0, 1).toUpperCase());
            getConvertMethodName.append(fieldname.substring(1));
            Method getConvertMethod = pojoClass.getMethod(getConvertMethodName.toString(), new Class[0]);
            excelEntity.setGetMethod(getConvertMethod);
        }
    }
}

