/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.controller;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.FreemarkerParseUtils;
import com.biz.eisp.mdm.config.service.TmCgDynamicService;
import com.biz.eisp.mdm.config.util.CgReportQueryParamUtil;
import com.biz.eisp.mdm.config.util.QueryParamUtil;
import com.biz.eisp.mdm.dict.entity.TmDictTypeEntity;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/cgDynamicListController"})
public class CgDynamicListController
extends BaseController {
    @Autowired
    private TmCgDynamicService tmCgDynamicService;

    @RequestMapping(params={"popup"})
    public void popup(String id, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = this.tmCgDynamicService.queryCgReportConfig(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
        }
        FreemarkerParseUtils freemarkerParseUtils = new FreemarkerParseUtils();
        this.loadVars(cgReportMap);
        String html = freemarkerParseUtils.parseTemplate("com/biz/eisp/base/common/cg/cgpublistpopup.ftl", cgReportMap);
        try {
            response.setContentType("text/html");
            response.setHeader("Cache-Control", "no-store");
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(String configId, String page, String field, String rows, HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> cgReportMap = null;
        try {
            cgReportMap = this.tmCgDynamicService.queryCgReportConfig(configId);
            if (cgReportMap.size() <= 0) {
                throw new RuntimeException("\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u4e0d\u5b58\u5728!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u67e5\u627e\u52a8\u6001\u62a5\u8868\u914d\u7f6e\u5931\u8d25!" + e.getMessage());
        }
        Map configM = (Map)cgReportMap.get("main");
        String querySql = (String)configM.get("cgreport_sql");
        List items = (List)cgReportMap.get("items");
        LinkedHashMap queryparams = new LinkedHashMap();
        for (Map item : items) {
            String isQuery = (String)item.get("search_flag");
            if (!"Y".equalsIgnoreCase(isQuery)) continue;
            CgReportQueryParamUtil.loadQueryParams(request, item, queryparams);
        }
        int p = page == null ? 1 : Integer.parseInt(page);
        int r = rows == null ? 99999 : Integer.parseInt(rows);
        List<Map<String, Object>> result = this.tmCgDynamicService.queryByCgReportSql(querySql, queryparams, p, r);
        long size = this.tmCgDynamicService.countQueryByCgReportSql(querySql, queryparams);
        this.dealDic(result, items);
        this.dealReplace(result, items);
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            writer.println(QueryParamUtil.getJson(result, size));
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadVars(Map<String, Object> cgReportMap) {
        Map mainM = (Map)cgReportMap.get("main");
        List fieldList = (List)cgReportMap.get("items");
        ArrayList<Map> queryList = new ArrayList<Map>(0);
        for (Map fl : fieldList) {
            fl.put("field_name".toUpperCase(), ((String)fl.get("field_name")).toLowerCase());
            String isQuery = (String)fl.get("search_flag".toUpperCase());
            if (!StringUtil.isNotEmpty((String)isQuery)) continue;
            this.loadDic(fl, fl);
            queryList.add(fl);
        }
        cgReportMap.put("config_id", mainM.get("code"));
        cgReportMap.put("config_name", mainM.get("name"));
        cgReportMap.put("config_fieldList", fieldList);
        cgReportMap.put("config_queryList", queryList);
    }

    private void loadDic(Map m, Map<String, Object> cgReportMap) {
        String dict_code = (String)cgReportMap.get("dict_code");
        if (jodd.util.StringUtil.isEmpty((String)dict_code)) {
            m.put("field_dictlist", new ArrayList(0));
            return;
        }
        List<Map<String, Object>> dicDatas = this.queryDic(dict_code);
        m.put("field_dictlist", dicDatas);
    }

    private List<Map<String, Object>> queryDic(String diccode) {
        String typeHql = "from TmDictTypeEntity where dictTypeCode = ?";
        List list = this.tmCgDynamicService.findByHql(typeHql, diccode);
        List dicDatas = null;
        if (CollectionUtil.listNotEmpty(list)) {
            TmDictTypeEntity typeEntity = (TmDictTypeEntity)list.get(0);
            String dataHql = "from TmDictDataEntity where dictTypeCode = ?";
            dicDatas = this.tmCgDynamicService.findByHql(dataHql, typeEntity.getDictTypeCode());
        }
        return dicDatas;
    }

    private void dealDic(List<Map<String, Object>> result, List<Map<String, Object>> beans) {
        for (Map<String, Object> bean : beans) {
            String dict_code = (String)bean.get("dict_code");
            if (jodd.util.StringUtil.isEmpty((String)dict_code)) continue;
            List<Map<String, Object>> dicDatas = this.queryDic(dict_code);
            for (Map<String, Object> r : result) {
                String value = String.valueOf(r.get(bean.get("field_name")));
                for (Map<String, Object> m : dicDatas) {
                    String typecode = String.valueOf(m.get("typecode"));
                    String typename = String.valueOf(m.get("typename"));
                    if (!value.equalsIgnoreCase(typecode)) continue;
                    r.put((String)bean.get("field_name"), typename);
                }
            }
        }
    }

    private void dealReplace(List<Map<String, Object>> result, List<Map<String, Object>> beans) {
        for (Map<String, Object> bean : beans) {
            try {
                String[] groups;
                String replace = (String)bean.get("replace_value");
                if (jodd.util.StringUtil.isEmpty((String)replace)) continue;
                for (String g : groups = replace.split(",")) {
                    String[] items = g.split("_");
                    String v = items[0];
                    String txt = items[1];
                    for (Map<String, Object> r : result) {
                        String value = String.valueOf(r.get(bean.get("field_name")));
                        if (!value.equalsIgnoreCase(v)) continue;
                        r.put((String)bean.get("field_name"), txt);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u53d6\u503c\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e");
            }
        }
    }
}

