/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.log.vo.TmLogVo;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.vo.TmBusinessGroupVo;
import com.biz.eisp.mdm.terminal.dao.TmTerminalDao;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGDetailEntity;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTerminalExtendService;
import com.biz.eisp.mdm.terminal.service.TmTerminalService;
import com.biz.eisp.mdm.terminal.transformer.TmTerminalVoToTmTerminalEntity;
import com.biz.eisp.mdm.terminal.util.TerminalLogMsgUtil;
import com.biz.eisp.mdm.terminal.vo.QueryTmTerminalVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmTerminalService")
@Transactional
public class TmTerminalServiceImpl
extends BaseServiceImpl
implements TmTerminalService {
    @Autowired
    private TmTerminalDao tmTerminalDao;
    @Autowired(required=false)
    private TmTerminalExtendService terminalExtendService;

    @Override
    public List<TmTerminalVo> findTmTerminalList(TmTerminalVo tmTerminalVo, Page page) {
        String sql = DynamicConfigUtil.getInstance().buildQuerySql(Globals.TABLE_TERMINAL, tmTerminalVo);
        sql = this.appendTerminalCondition(sql, tmTerminalVo);
        return this.tmTerminalDao.findTerminalList(tmTerminalVo, page, sql);
    }

    public String appendTerminalCondition(String sql, TmTerminalVo terminalVo) {
        String joinSql = "select distinct t1.terminal_id terminalId,to_char(listagg(t1.customer_id,',') within GROUP (order by t1.customer_id)) customerId,to_char(listagg(tc.customer_name,',') within GROUP (order by tc.customer_name)) customerName,to_char(listagg(tc.customer_code,',') within GROUP (order by tc.customer_code)) customerCode ,to_char(listagg(t1.position_id,',') within GROUP (order by  t2.position_name))  positionId,to_char(listagg(t1.business_group,',') within GROUP (order by  t2.position_name)) businessGroup ,to_char(listagg(t2.position_name,',') within GROUP (order by t2.position_name)) dockPosition,to_char(listagg(t2.position_code,',') within GROUP (order by t2.position_name)) position_code,to_char(listagg(tu.username,',') within GROUP (order by t2.position_name)) username,to_char(listagg(tu.fullname,',') within GROUP (order by t2.position_name)) dockUserName from TM_R_TERM_CUST_POS_BG t1 left join tm_customer tc on tc.id=t1.customer_id  left join tm_position t2 on t2.id = t1.position_id  left join tm_r_user_position up on up.position_id=t1.position_id left join tm_user tu on tu.id=up.user_id group by t1.terminal_id";
        String sqlOn = " t1.terminalId=t.id ";
        String sqlWhere = "";
        sqlWhere = StringUtil.isNotEmpty((String)terminalVo.getId()) ? " and (t.id='" + terminalVo.getId() + "'" : "and exists(select 1 from tm_terminal t2 left join TM_R_TERM_CUST_POS_BG t3 on t3.terminal_id=t2.id where t2.id=to_char(t1.terminalId) ";
        if (StringUtil.isNotEmpty((String)terminalVo.getDockUserName())) {
            sqlWhere = sqlWhere + " and  (to_char(t1.dockUserName) like '%" + terminalVo.getDockUserName() + "%' or to_char(t1.dockUserName) like '%" + terminalVo.getDockUserName() + "%')";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getDockPosition())) {
            sqlWhere = sqlWhere + "and (to_char(t1.dockPosition) like '%" + terminalVo.getDockPosition() + "%' or to_char(t1.dockPosition) like '%" + terminalVo.getDockPosition() + "%')";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getBusinessGroup())) {
            sqlWhere = sqlWhere + " and to_char(t1.businessGroup) like '%" + terminalVo.getBusinessGroup() + "%'";
        }
        if (StringUtil.isNotEmpty((String)terminalVo.getCustomerName())) {
            sqlWhere = sqlWhere + "and (to_char(t1.customerName) like '%" + terminalVo.getCustomerName() + "%' or to_char(t1.customerCode) like '%" + terminalVo.getCustomerName() + "%')";
        }
        sqlWhere = sqlWhere + ")";
        if (StringUtil.isEmpty(terminalVo.getId()) && StringUtil.isEmpty(terminalVo.getDockUserName()) && StringUtil.isEmpty(terminalVo.getDockPosition()) && StringUtil.isEmpty(terminalVo.getCustomerName()) && StringUtil.isEmpty(terminalVo.getBusinessGroup())) {
            sqlWhere = "";
        }
        String orderSql = " order by t.terminalCode asc";
        return DynamicConfigUtil.getInstance().appendCustomCondition(sql, joinSql, sqlOn, sqlWhere, orderSql);
    }

    @Override
    public void saveTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
        ArrayList<TmBusinessGroupVo> addBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>();
        ArrayList<TmBusinessGroupVo> deleteBusinessGroupVoList = new ArrayList<TmBusinessGroupVo>();
        TmTerminalEntity terminalEntity = null;
        if (StringUtil.isNotEmpty(this.terminalExtendService)) {
            try {
                this.terminalExtendService.validate(tmTerminalVo, page);
            }
            catch (Exception e) {
                throw new BusinessException("\u9a8c\u8bc1\u6570\u636e\u5931\u8d25:" + e.getMessage());
            }
            terminalEntity = this.terminalExtendService.saveBefore(tmTerminalVo, page);
        }
        if (StringUtil.isEmpty(terminalEntity)) {
            terminalEntity = new TmTerminalVoToTmTerminalEntity(this, addBusinessGroupVoList, deleteBusinessGroupVoList).apply(tmTerminalVo);
        }
        if (StringUtil.isNotEmpty(this.terminalExtendService)) {
            terminalEntity = this.terminalExtendService.saveBefore(terminalEntity, tmTerminalVo, page);
        }
        this.saveOrUpdate(terminalEntity);
        this.executeSql("DELETE FROM TM_R_TERM_CUST_POS_BG WHERE TERMINAL_ID IS NULL", new Object[0]);
        this.getSession().flush();
        this.saveBusinessGroupInfo(terminalEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
        if (StringUtil.isNotEmpty(this.terminalExtendService)) {
            terminalEntity = this.terminalExtendService.savePost(terminalEntity, tmTerminalVo, page);
        }
    }

    private void saveBusinessGroupInfo(TmTerminalEntity tmTerminalEntity, List<TmBusinessGroupVo> addBusinessGroupVoList, List<TmBusinessGroupVo> deleteBusinessGroupVoList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteBusinessGroupVoList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (TmBusinessGroupVo vo : deleteBusinessGroupVoList) {
                map.put(vo.getBusinessGroup(), vo.getBusinessGroup());
            }
            String deleteSql = "delete from tm_r_term_cust_pos_bg_detail where business_group = ?";
            Set keyset = map.keySet();
            for (String key : keyset) {
                this.executeSql(deleteSql, key);
            }
        }
        this.getSession().flush();
        if (CollectionUtil.listNotEmptyNotSizeZero(addBusinessGroupVoList)) {
            for (TmBusinessGroupVo vo : addBusinessGroupVoList) {
                if (vo.getTypeCode() == "orgCode" || vo.getTypeCode() == "positionCode" || vo.getTypeCode() == "customerCode") continue;
                TmRTermCustPosBGDetailEntity entity = new TmRTermCustPosBGDetailEntity();
                entity.setBusinessGroup(vo.getBusinessGroup());
                entity.setDetailCode(vo.getDetailCode());
                entity.setDetailName(vo.getDetailName());
                entity.setTypeCode(vo.getTypeCode());
                entity.setTypeName(vo.getTypeName());
                this.save(entity);
            }
        }
        this.getSession().flush();
        this.saveBusinessGroupLog(tmTerminalEntity, addBusinessGroupVoList, deleteBusinessGroupVoList);
    }

    private void saveBusinessGroupLog(TmTerminalEntity tmTerminalEntity, List<TmBusinessGroupVo> newBusinessGroupVoList, List<TmBusinessGroupVo> oldBusinessGroupVoList) {
        Map<String, List<TmBusinessGroupVo>> oldMap = this.buildMapByBusinessGroup(oldBusinessGroupVoList);
        Map<String, List<TmBusinessGroupVo>> newMap = this.buildMapByBusinessGroup(newBusinessGroupVoList);
        Set<String> oldKeySet = oldMap.keySet();
        String updateMsg = "";
        String deleteMsg = "";
        String addMsg = "";
        for (String oldKey : oldKeySet) {
            if (newMap.containsKey(oldKey)) {
                updateMsg = updateMsg + TerminalLogMsgUtil.buildUpdateMsg(newMap.get(oldKey), oldMap.get(oldKey)) + "<hr>";
                newMap.remove(oldKey);
                continue;
            }
            deleteMsg = deleteMsg + TerminalLogMsgUtil.buildDeleteMsg(oldMap.get(oldKey)) + "<hr>";
        }
        if (StringUtils.isNotBlank((CharSequence)(addMsg = addMsg + this.buildAddMsg(tmTerminalEntity, newMap)))) {
            this.addLog(OperationType.INSERT, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmTerminalEntity.getId(), addMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)deleteMsg)) {
            this.addLog(OperationType.DELETE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmTerminalEntity.getId(), deleteMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)updateMsg)) {
            this.addLog(OperationType.UPDATE, "\u4e1a\u52a1\u7ec4\u5173\u7cfb", tmTerminalEntity.getId(), updateMsg);
        }
    }

    private Map<String, List<TmBusinessGroupVo>> buildMapByBusinessGroup(List<TmBusinessGroupVo> voList) {
        HashMap<String, List<TmBusinessGroupVo>> map = new HashMap<String, List<TmBusinessGroupVo>>();
        if (CollectionUtil.listNotEmptyNotSizeZero(voList)) {
            for (TmBusinessGroupVo oldBusinessGroupVo : voList) {
                if (map.containsKey(oldBusinessGroupVo.getBusinessGroup())) {
                    ((List)map.get(oldBusinessGroupVo.getBusinessGroup())).add(oldBusinessGroupVo);
                    continue;
                }
                ArrayList<TmBusinessGroupVo> list = new ArrayList<TmBusinessGroupVo>();
                list.add(oldBusinessGroupVo);
                map.put(oldBusinessGroupVo.getBusinessGroup(), list);
            }
        }
        return map;
    }

    private String buildAddMsg(TmTerminalEntity tmTerminalEntity, Map<String, List<TmBusinessGroupVo>> newMap) {
        Set<String> keySet = newMap.keySet();
        String msg = "";
        for (String key : keySet) {
            msg = msg + TerminalLogMsgUtil.buildAddMsg(newMap.get(key));
            msg = msg + "<hr>";
        }
        return msg;
    }

    @Override
    public void deleteTmTerminal(String ids) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] terminalIds;
            for (String terminalId : terminalIds = ids.split(",")) {
                TmTerminalEntity terminalEntity = this.get(TmTerminalEntity.class, (Serializable)((Object)terminalId));
                if (terminalEntity == null || !StringUtil.isNotEmpty((String)terminalEntity.getId())) continue;
                this.delete(terminalEntity);
            }
        }
    }

    @Override
    public TmTerminalVo getTmTerminal(TmTerminalVo tmTerminalVo, Page page) {
        List<TmTerminalVo> list = this.findTmTerminalList(tmTerminalVo, page);
        return list.size() > 0 ? list.get(0) : new TmTerminalVo();
    }

    @Override
    public List<TmTerminalVo> findTmTerminalByPosList(TmTerminalVo terminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalByPosList(terminalVo, page);
    }

    @Override
    public List<TmTerminalVo> findTmTerminalByAllPossible(QueryTmTerminalVo queryTmTerminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalByAllPossible(queryTmTerminalVo, page);
    }

    @Override
    public List<TmLogVo> findTerminalLogList(TmLogVo tmLogVo, Page page) {
        return this.tmTerminalDao.findTerminalLogList(tmLogVo, page);
    }

    @Override
    public List<QueryTmTerminalVo> findTmTerminalAndCustByterminalType(QueryTmTerminalVo queryTmTerminalVo, Page page) {
        return this.tmTerminalDao.findTmTerminalAndCustByterminalType(queryTmTerminalVo, page);
    }
}

