SELECT
  hpi.id_ AS ID,
  hpi.proc_def_id_ AS processDefinitionId,
  pd.key_ AS processDefinitionKey,
  pd.name_ AS processDefinitionName,
  hpi.proc_inst_id_ AS processInstanceId,
  bo.process_title AS processTitle,
  bo.full_name AS startFullName,
  t.name_ AS activityName,
  t.assignee_ AS activityUser,
  t.id_ AS taskId,
  hpi.start_time_ AS startTime,
  hpi.end_time_ AS endTime,
  CASE WHEN re.suspension_state_ IS NULL THEN 'finished' WHEN re.suspension_state_ = 1 THEN 'false' ELSE 'true' END AS isSuspended
FROM
  act_hi_procinst hpi    
  LEFT JOIN act_re_procdef pd ON pd.id_ = hpi.proc_def_id_ 
  LEFT JOIN ta_base_business_obj bo ON bo.id = hpi.business_key_
  LEFT JOIN act_ru_task t ON t.proc_inst_id_ = hpi.proc_inst_id_
  LEFT JOIN act_ru_execution re ON re.proc_inst_id_ = hpi.proc_inst_id_
WHERE
 1=1
<#if processInstanceVo.id ?exists && processInstanceVo.id ?length gt 0>
	AND hpi.id_ LIKE '%${processInstanceVo.id}%'
</#if>
<#if processInstanceVo.processDefinitionKey ?exists && processInstanceVo.processDefinitionKey ?length gt 0>
	AND pd.key_ LIKE '%${processInstanceVo.processDefinitionKey}%'
</#if>
<#if processInstanceVo.processDefinitionName ?exists && processInstanceVo.processDefinitionName ?length gt 0>
	AND pd.name_ LIKE '%${processInstanceVo.processDefinitionName}%'
</#if>
<#if processInstanceVo.processTitle ?exists && processInstanceVo.processTitle ?length gt 0>
	AND bo.process_title LIKE '%${processInstanceVo.processTitle}%'
</#if>
ORDER BY hpi.start_time_ DESC 